// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {moonshotShowRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var moonshotShowRoutes = ( function() {

        var CONTAINER = '#hpsum-moonshot-page .hp-details-show-view';

        function moonshotShowRoutes() {

            var registered = false;
            var activityView = null;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('moonshot show overview',
                    '/moonshot/show/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/moonshot/moonshotOverview.html',
                            'hpsum/view/moonshot/moonshotOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });

                    }
                });

                router.map(' moonshot show overview multi',
                   '/moonshot/show/(unknown|host|windows|linux|vmware|hpux|ilo|ilo2|ilo3|ilo4| \
                     integrityilo2|integrityilo3|moonshot|switch|fc_switch|sas_switch|oa|sd2|virtual_connect|ilo_federation)/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        }
                    });
                
               /* 
				router.map('moonshot moonshot overview', '/moonshot/show/moonshot/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/moonshot/moonshotOverview.html',
						'hpsum/view/moonshot/moonshotOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				*/

                router.filter('moonshot show default redirector',
                    '/moonshot/show' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });

                router.map('moonshot show no route', '/moonshot/show/.*', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new moonshotShowRoutes();
    }());

    return moonshotShowRoutes;
});
