// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type {NodesRoutes}
 * This is used to provide route map for each Nodes action.
 * This also provides default redirector and shows default error page if no matching URI identified.
 * Provide route for add, edit and show actions.
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var NodeRoutes = ( function() {

        var CONTAINER = '#hpsum-nodes-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var DIALOG_CONTAINER = '#hp-dialog-container';

        function NodeRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('node show',
                    '/node/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/show.html',
                            'hpsum/view/node/NodeShowView',
                            'hpsum/model/node/NodeShowRoutes'],
                        function (page, view,routes) {
                        	routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
				
				router.map('node install', '/node/install' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/results.html',
						'hpsum/view/node/NodeShowDeployView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                
                router.map('node server show',
                    '/node/server/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/server/show.html',
                            'hpsum/view/server/ServerShowView',
                            'hpsum/model/server/ServerShowRoutes'],
                        function (page, view,routes) {
                        	routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
				router.map('node add',
                    '/node/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/add.html',
                            'hpsum/view/node/NodeAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
				router.map('node find',
                    '/node/find' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/find.html',
						'hpsum/view/node/NodeFind'],
                        function (page, view) {
                        	//routes.register();
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('node inventory', '/node/inventory' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/doinventory.html',
						'hpsum/view/node/NodeInventoryDView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});


                router.map('node stage', '/node/stage' +
                urlFragment.viewSinglePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/stage.html',
                        'hpsum/view/node/NodeInventoryDView'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });

                
                router.map('node edit',
                    '/node/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/edit.html',
                            'hpsum/view/node/NodeEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
				router.map('node deploy',
                    '/node/deploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/deploy.html',
                            'hpsum/view/node/NodeDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                router.map('node sd2 deploy',
                    '/node/sd2/deploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/sd2oa/sd2oaDeploy.html',
                            'hpsum/view/sd2oa/sd2oaDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                 router.map('node ilofed offline deploy',
                    '/node/offlinedeploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ilofederation/offlinedeploy.html',
                            'hpsum/view/ilofederation/iloOfflineDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('node ilofed online deploy',
                    '/node/onlinedeploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ilofederation/onlinedeploy.html',
                            'hpsum/view/ilofederation/iloOnlineDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('node integrityilo activatepending',
                    '/node/integrityilo/activatepending' + urlFragment.pagePatternTerminal, {
                    container: DIALOG_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/integrityilo/activatepending.html',
                            'hpsum/view/integrityilo/activatePendingView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('node integrityilo deploydomain',
                    '/node/integrityilo/deploydomain' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/integrityilo/deploydomain.html',
                            'hpsum/view/integrityilo/deploydomainView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('node associateddetails',
                    '/node/associated' + urlFragment.pagePatternTerminal, {
                    container: DIALOG_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/associated_node.html',
                            'hpsum/view/node/NodeAssociatedNodeDetails'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
				
				
				router.map('node reports', '/node/reports' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeReportsView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});

                router.map('node deploy-results', '/node/deploy-results' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/install_results.html',
                        'hpsum/view/node/NodeDeployResults'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });

	            			
                router.map('node schedule', '/node/schedule' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/schedule.html',
						'hpsum/view/node/NodeScheduleView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                
                router.filter('node default redirector',
                    '/node' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('node no route', '/node/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new NodeRoutes();
    }());

    return NodeRoutes;
});
