// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {OneTouchUpdateRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var OneTouchUpdateRoutes = ( function() {
		
        var CONTAINER = '#hp-page-container'; 
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var CONFIRM_CONTAINER = '#hp-dialog-container';
        
        function OneTouchUpdateRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;
        		
        		        
                router.map('guided-update',
                    '/guided-update/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                    	
                    	require(['text!hpsumpages/one-touch-update/index.html',
                            'hpsum/view/one-touch-update/OneTouchUpdateView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        
                        //result.noAction();
                    }
                });
                

                router.map('guided-update advoptions',
                    '/guided-update/advoptions' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/one-touch-update/advoptions.html',
                            'hpsum/view/one-touch-update/OneTouchUpdateAdvOptionsView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('guided-update reports',
                    '/guided-update/reports' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        //require(['text!hpsumpages/one-touch-update/reports.html',
                          //  'hpsum/view/one-touch-update/OneTouchUpdateReportsView'],
                          require(['text!hpsumpages/node/reports.html',
                          'hpsum/view/node/NodeReportsView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.filter('guided-update default redirector',
                    '/guided-update' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                }); 

                router.map('guided-update no route', '/guided-update/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new OneTouchUpdateRoutes();
    }());

    return OneTouchUpdateRoutes;
});
