// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * The main function to initialize Application object, loads the main routes and starts the application.
 * This also initializes Mock object which needs to be used to simulate the data for UI. This is only for testing purpose
 * The Mock object needs to be removed from here, once HPSUM is integrated with HAPI REST API.
 */
require({
    baseUrl : './',
    paths : {
        //If you changed something here, you should change it in src/main/build/app.build.js
        //as well as src/test/js/require-base.js
        //and consider if changes need to be made to src/tour/js/tour/tour-require.js
        text : 'js/lib/text',
        jquery : 'js/lib/jquery',
        jqueryUI : 'js/lib/jquery-ui',
        modernizr : 'js/lib/modernizr',
        hpsum : 'js/hpsum',
        lang : 'js/hpsum/lang',
        cic : 'js/cic',
        lib : 'js/lib',
        hpPages : 'pages',
        fsPages : 'pages/fs',
        hpsumpages : 'pages/hpsum',
        hp : 'js/hp',
        fs: 'js/fs',
        //To provide index service functionality for HPSUM
        'hp/services/IndexService' : 'js/hpsum/services/HpsumIndexService',
        'hp/model/Resource': 'js/hpsum/model/HpsumResource',
        'hp/model/Session': 'js/hpsum/model/HpsumSession',
        'hp/core/HelpMenu': 'js/hpsum/overwrite/HelpMenu',
	'hp/view/login/LoginView' : 'js/hpsum/overwrite/LoginView',
        'hp/core/Language': 'js/hpsum/overwrite/Language',
        //To provide authorization and authentication mechanism for HPSUM
        'hp/services/authn' : 'js/hpsum/services/hpsumAuthn',
        'hp/services/authz' : 'js/hpsum/services/hpsumAuthz',
        'hp/services/REST' : 'js/hpsum/services/HpsumREST',
	     // javascript to provide support for download of text/xml content
	    'hp/services/RESTXml': 'js/hpsum/services/HpsumRESTXml',
	    'hp/services/SessionService' : 'js/hpsum/services/HpsumSessionService',
	    'hp/core/Banner' : 'js/hpsum/overwrite/Banner',
		'hpPages/core/master_header':'js/hpsum/overwrite/master_header',
	    'hpPages/core/banner' : 'pages/hpsum/common/banner',
		// To provide notification in the hpsum pages
		'hp/model/NotificationResource' : 'js/hpsum/overwrite/NotificationResource',
		'hp/view/NotificationsView' : 'js/hpsum/overwrite/NotificationsView',
		'hp/presenter/MasterPanePresenter' : 'js/hpsum/overwrite/MasterPanePresenter',
    },
    urlArgs: "BMN=" +  (new Date()).getTime(),
    priority : ['modernizr', 'jquery'],
    waitSeconds : 20 // make VPN more resilient
}, ['hp/Application', 'hp/core/Localizer', 'hp/model/Session', 'hpsum/model/HpsumMock', 'hpsum/shell/MainPageRoutes', 'hp/core/HelpMenu',
    'hp/core/UrlFragment', 'hp/core/Language', 'jquery', 'jqueryUI', 'modernizr', 'lib/json2', 'lib/shBrushXml', 'lib/shBrushJScript', 'lib/jquery.dateFormat',
    'hp/lib/date', 'hpsum/hpsum-version'],
function(application, localizer, session, mock, routes, help, urlFragment , lang) { "use strict";

    $.ajaxSetup({
        // Disable caching of AJAX responses for development
        cache : false
    });

    $(document).ready(function() {
		//Ensures there will be no 'console is undefined' errors
		window.console = window.console || (function(){
    			var c = {}; c.log = c.warn = function(){};
    			return c;
		})();
	
		//check for sessionid in the URL. This is to avoid login page in case if user running on same system or offline mode
		//if user is connecting to remote hpsum server, then we will show login page
		var bRedirect=false;
		var location = document.location.href;
        var parameters = urlFragment.getParameters(location);
        //find if session id is available in the URL
        $.each(parameters, function (name, value) {
            if (name.match('session_id')) {
                session.saveToken(value);
             	bRedirect=true;   
            }
            if (name.match('mode')) {
            	//global variable. This can be accessed through out the application
                //window.global_guimode = value;
                session.setProperty("gui_mode", value, false);
            }

			if (name.match('express_location')) {
            	//global variable. This can be accessed through out the application
                session.setProperty("express_location", value, false);
            }

            if(name.match('lang')){
                session.saveSesionLanguage(value);
            }
        });
		
        //get the guimode property from cookie
		var guimode = session.getProperty("gui_mode");
        
        if(guimode === "offline_automatic" || guimode === "offline_interactive" || guimode === "express")
			//redirect to one touch update screen
        	document.location.href = "index.html#/guided-update";
        else if(bRedirect)
			//redirect to index screen to remove session id from URL
        	document.location.href = "/index.html";
			
    	//create a dummy session just for debugging, so that no need to login everytime.
		//session.saveToken('session1');

	    // hpsumShortVersionStr comes from hpsum/hpsum_version.js and is
	    // auto-built by the hpsum build scripts.  It contains one line
	    // that looks like: var hpsumShortVersionStr = '4.5.6';

        var startFunction = function(){
           application.init(localizer.getString('hpsum.title')+hpsumShortVersionStr);
        
           //This is just mockup the data required to test the individual pages.
           //This should be replaced later with actual data population from HAPI REST APIs
           //mock.init();


           // This will second time or the first time when the language is set
       

           routes.load();
           help.init();

           // add confidential to banner
           $('#hp-body-div').prepend($('<div class="hp-confidential">Copyright &copy 2006, 2015 Hewlett-Packard Development Company, L.P.</div>'));
        
           application.start();
        }

        if(session.getSessionLanguage() != null)
        {
            lang.loadLanguage(session.getSessionLanguage() , startFunction);
        }
        else
        {
            startFunction.call();
        }

        

	});
});
