// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (BaselineShowView)
 * This is a view class for Baseline.
 * Provides functions to show details pane for a baseline item
 */
define(['hpsum/presenter/baseline/BaselinePresenter',
    'hp/view/DetailsShowView',
    'hp/view/NotificationsView',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/core/Localizer',
    'hp/view/DialogView',
    'hp/model/Session',
	'hp/services/IndexService',
	'hp/core/HashManager',
    'text!hpsumpages/baseline/component_info_dialog.html',  
    'jquery',
    //These two modules required to show table for contents section in details pane
    'lib/jquery.dataTables',
    'lib/jquery.dateFormat',
    'hp/lib/jquery.hpToggle',
    'lib/jquery.dataTables.rowReordering',
    //
	'hpsum/common/jquery.hpsumBrowse',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpSelect',
    'hp/lib/jquery.hpStackedPanels'],
function(presenter, DetailsShowView, NotificationsView, router, urlFragment, notifications, localizer, DialogView, session, indexService, hashManager, componentDialogHtml) { "use strict";

    var BaselineShowView = (function() {
      
        var VIEW = '#hpsum-baselines-show',
            HEADER = '#hpsum-baselines-show .hp-details-header',
            TITLE = '#hpsum-baselines-details-title',
            RELEASE_DATE = '#hpsum-baseline-release-date',
            LANGUAGES = '#hpsum-baseline-languages',
            ENHANCEMENTS = '#hpsum-baseline-enhancements',
            PANEL_SELECTOR = '#hpsum-baselines-show-panel-selector',
            PANELS = '#hpsum-baselines-show-panels',
            REPORTS_ACTION = '#hpsum-baseline-action-reports',
            VALIDATE_ACTION = '#hpsum-baseline-action-validate',
            ABORT_ACTION = '#hpsum-baselines-abort-action',
            DELETE_ACTION = '#hpsum-baselines-delete-action',
            DELETE_DIALOG = '#hpsum-baselines-delete-confirm',
			DELETE_IN_PROGRESS_SPAN = '#hpsum-delete-baseline-in-progress-span',
			DELETE_BUTTON_NAME = '#hpsum-baseline-delete-ok',
			CLOSE_BUTTON_NAME = '#hpsum-baseline-delete-cancel',
            DELETE_NAME = '#hpsum-baselines-delete-name',
            DELETE_TITLE = '#hpsum-baseline-delete-title',
            ABORT_DIALOG = '#hpsum-baseline-abort-confirm',
            ABORT_TITLE = '#hpsum-baseline-abort-title',
            COMPONENT_DIALOG = '#hpsum-component-dialog',
	    COMPONENT_CONFIG_DIALOG = '#hpsum-component-config-dialog',
            COMPONENT_TABLE = '#baselines-contents-table',
			MISSINGCOMPONENT_TABLE='#baselines-missingcontents-table',
            ROUTE_PREFIX = '/baseline/show',
			SPLASH_DIALOG = '#hpsum-abort-wait-dialog',
			SPLASH_SPINNER = '#hpsum-abort-spinner';
      		var SCHEDULE_DIALOG = '#hpsum-baseline-schedule-information';
      		var PAGE = '#hpsum-baseline-page';
      		var scheduleDialogContents;
			var SCHEDULE_DATE_AND_TIME = "#hpsum-baseline-schedule-date-time",
				SCHEDULE_TYPE = "#hpsum-baseline-schedule-type",
				SCHEDULE_RECURS = "#hpsum-baseline-schedule-recurring";
		var CANCEL = '#hpsum-component-config-cancel';
		var DELETE_DIALOG_ERROR = '#hpsum-baseline-delete-information';
		var DELETE_BASELINE_NODES_TABLE = '#hpsum-delete-baseline-nodes-table';
		var EXPORT_CONFIG = "#hpsum-comp-cfg-export",
			IMPORT_CONFIG = "#hpsum-comp-cfg-import",
			SAVE_CONFIG = "#hpsum-comp-cfg-save",
			EXPORT_CONFIG_DIALOG = "#hpsum-component-config-export-dialog",
			IMPORT_CONFIG_DIALOG = "#hpsum-component-config-import-dialog",
			IMPORT_CONFIRM_DIALOG = "#hpsum-import-config-confirm",
			IMPORT_CONFIG_ERROR = "#hpsum-import-config-error",
			EXPORT_CONFIG_ERROR = "#hpsum-export-config-error",
			EXPORT_CREDENTIALS_CHKBOX = "#hpsum-export-credentials-chkbox",
			IMPORT_OK_BUTTON = "#hpsum-import-ok",
			EXPORT_OK_BUTTON = "#hpsum-export-ok",
			IMPORT_CANCEL = "#hpsum-import-cancel",
			EXPORT_CANCEL = "#hpsum-export-cancel",
			EXPORT_WARNING = "#hpsum-export-config-warning",
			EXPORT_ERROR_MSG = "#hpsum-export-config-errorMsg",
			IMPORT_ERROR_MSG = "#hpsum-import-config-errorMsg",
			CONFIG_DIALOG_MSG = "#hpsum-comp-msg",
			EXPORT_CONFIG_BROWSE = "#hpsum-compconfig-export-browse",
			IMPORT_CONFIG_BROWSE = "#hpsum-compconfig-import-browse",
			BASELINE_WARNING_IMG = "#hpsum-baselines-warning-image";
		var deleteInfoDialog;
		var abortInfoDialog;
		var canbedeleted = false;
		var abortBaselineItem;
		var browserType = 0;
		var compData;
		var GETSTATUS_TIMER = 15000;
        /**
         * Constructor
         */
        function BaselineShowView() {
          
            var detailsShowView = new DetailsShowView(),
                notificationsView = new NotificationsView(),
                deleteInProgress = false,
                abortInProgress = false,
                errorMessage = null,
                componentDialogContents,
                componentConfigDialogContents,
				exportConfigDialogContents,
				importConfigDialogContents,
				instExportConfigBrowse,
				instImportConfigBrowse,
				importConfirmDialogContents,
                timer = null,
                baselineItem = null,
                prevBaselineuri = null,
                deleteDialogContents,
				export_Config = false,
                aborttimer = null;
			var abortWaitDialog;
            var baselinedetails =   {location_id : "",
					        		 baseline_id : "",
									 baseline_url : "",
									 baseline_isWritable : false
				        			};    
            function onItemChange(item) {
			if(timer) {
		            clearInterval(timer);
		            timer = null;
		    }
			notificationsView.clear();
			$(COMPONENT_TABLE).dataTable().fnClearTable();

                if (item && item.hasOwnProperty("hapi")) {
                    var hapi = item.hapi;
                    baselineItem = hapi;   
		            //Changes done as part of HFS requirement changes dated 07/25/2014                    
                    //For Custom Baseline -- Ex: item.hapi.baseline_name --> Testing this-ok 2014 08 11,item.hapi.baseline_version --> 2014.08.11.A
                    var appendingVersion=item.hapi.baseline_version.substr(0,item.hapi.baseline_version.lastIndexOf(".")).replace(/\./g," ");                                   
                                     //For Additional Baseline
                    if(item.hapi.baseline_version.toUpperCase().match("N/A") || item.hapi.baseline_name.match(/^Additional Package/i)){
					 
					var urlstr=item.hapi.baseline_url;
					if(urlstr.length>30)
					  urlstr=urlstr.substr(0,urlstr.indexOf("/")+1)+"..."+urlstr.substr(urlstr.length-25);
                      $(TITLE).html(item.hapi.baseline_name+" "+ "<span style='font-size:18px;color:grey' >" + localizer.getString('hpsum.common.locationStr') + " " + urlstr + "</span>");
					 
					}

                    //For Custom Baseline
                    //For SPP Baseline
                    else{
                      $(TITLE).html(item.hapi.baseline_name+" "+ "<span style='font-size:18px;color:grey' >" + localizer.getString('hpsum.common.version') + " " + item.hapi.baseline_version + "</span>");                      
                    }
                    $(DELETE_NAME).html(item.hapi.baseline_name);
                    $(RELEASE_DATE).html(item.hapi.baseline_release_date);
                    $(LANGUAGES).html(item.hapi.baseline_languages);
                    var i,html;
                    html="";
                    
					baselinedetails.location_id = item.hapi.location_id;
					baselinedetails.baseline_id = item.hapi.baseline_id;
					baselinedetails.baseline_url = item.hapi.baseline_url;
					baselinedetails.baseline_isWritable = item.hapi.baseline_isWritable;
							
                    if(hapi.baseline_uri != prevBaselineuri) {
						if (!hapi.location_type.match(/http|https/i)) {
							prevBaselineuri = hapi.baseline_uri;
						}
    					//populate os details
                        $('#os ol').html(localizer.getString('hpsum.common.loading'));
    					presenter.getOsInfo(hapi.baseline_uri, {
    							success : function(data) {
    								if (data.hapi.hasOwnProperty("baseline_os")) {
										data.hapi.baseline_os.os.sort();
    									for ( i = 0; i < data.hapi.baseline_os.os.length; i++) {
    										html = html + '<li>' + data.hapi.baseline_os.os[i] + '</li>';
    									}
    
    									$('#os ol').html(html);
    								}
    							},
    							error : function(data) {
    							}
    					}); 

                        var get_revision_enhancement_data = function(revision_enhancement) {
                            function get_by_lang(language) {
                                for (var idx = 0; idx < revision_enhancement.length; idx++) {
                                    var revEnhancement = revision_enhancement[idx];
                                    if (revEnhancement && 
                                        revEnhancement.hasOwnProperty('language_enhancement') && 
                                        revEnhancement.hasOwnProperty('lang') &&
                                        revEnhancement.lang == language) {
                                            return revEnhancement.language_enhancement; 
                                    }
                                }
                                return null;
                            }
                            // Try to retrieve by current language.
                            var result = get_by_lang(hp.getLang());
                            if (result === null) {
                                // Otherwise default to english
                                result = get_by_lang('en');
                            }
                            return result;
                        };

    					//populate enhacements
    					$(ENHANCEMENTS).html(localizer.getString('hpsum.common.loading'));
    					presenter.getEnhancements(hapi.baseline_uri, {
    							success : function(data) {
    								if (data.hapi.hasOwnProperty("baseline_enhancements")) {
    									var htmlContent = '<ol>';
    									for ( i = 0; i < data.hapi.baseline_enhancements.length; i++) {
    										var baselineEnhancement = data.hapi.baseline_enhancements[i];
    										if (baselineEnhancement.hasOwnProperty('revision_enhancement') && 
											   (get_revision_enhancement_data(baselineEnhancement.revision_enhancement))) {
                                                htmlContent += '<li>' + get_revision_enhancement_data(baselineEnhancement.revision_enhancement) + '</li>';
    										}
											else {
												htmlContent += '';
											}
    									}
    									htmlContent += '</ol>';
    									$(ENHANCEMENTS).html(htmlContent);
    									//open hyperlinks in the new tab
    									$(ENHANCEMENTS + " a[href]").off("click").on("click", function(event){
											window.open($(this).attr("href")); 
											event.preventDefault(); 
										});
    								}
    							},
    							error : function(data) {
    							}
    						}); 
    					changeLocation('/baseline/show/release');
                    }	
	                
    	            //populate components table
    	            //populateComponentTable(item);
    	            presenter.getComponents(hapi.baseline_uri, {
    	                success : function (data) {
    					var dataItem = {hapi:{location_id:item.hapi.location_id,baseline_id:item.hapi.baseline_id, components:data.hapi.components}};
    	                	populateComponentTable(dataItem);
							populateMissingComponentTable(dataItem);
    	                },
    	                error : function (data) {
    	                }
    	            });
    	            
    

	          
					if (hapi.baseline_state === "inventory_needed") {					
						notificationsView.clear();
							
						if (hapi.location_type.match(/ftp|http|https/i)) {
							currprogress = 0.1;
	                		$(ABORT_ACTION).removeClass('hp-disabled').attr('style', '');
							var bState = "hpsum.baseline.compDownloadInProgress";
							
							//Because of some delay between the add click for baseline and downloading of components starting point , below notification is added.
							if (hapi.location_type.match(/http|https/i)) {
							notificationsView.add({
								status : 'info',
								//summary : "Component download in progress",
								summary: localizer.getString(bState),
								timestamp : (new Date().toISOString()),
								changing : true,
								progress : currprogress
							}); 
							}
							
							var uri = {
								location_id: item.hapi.location_id,
					        	baseline_id: item.hapi.baseline_id
					        };
					    
							//To show the progress for downloading of components and inventory progress in every 3 seconds.
							showInventoryProgress(uri);	
	                	}
						else
						{
							$(ABORT_ACTION).addClass('hp-disabled');
						}
							
					
							//$(ABORT_ACTION).addClass('hp-disabled');
							if (hapi.location_type.match(/local|Unc|ftp|http/i)) {
								presenter.startInventory({uri: hapi.baseline_uri + '/getBaselineData'}, {
								success : function (data) {
	                			 
								 /*
								  var currComps = hapi.baseline_state_detail.current_progress,
	                		totalComps = hapi.baseline_state_detail.total_no_component;
	                		currprogress = 0.1;
	                		
	                		if (0 != totalComps) {
	                			currprogress = (currComps/totalComps) * 100;
	                		} 
	                		
							//show notification details
							notificationsView.add({
									status : 'running',
									summary : localizer.getString(bState),
									timestamp : (new Date().toISOString()),
									changing : true,
									progress : currprogress,
									step : hapi.baseline_state_detail.detail,
								
							});  
								*/
	                			},
	                			error : function (data) {
	                			}});
							}
						}

	                //if(hapi.baseline_state === "inventory_in_progress") {
	                if(hapi.baseline_state === "inventory_in_progress" || 
	                   hapi.baseline_state === "comp_download_in_progress" ||
			   hapi.baseline_state === "reading_web_catalog" ||
			   hapi.baseline_state === "reading_manifest_xml" ||
			   hapi.baseline_state === "manifest_component_processing") {

	                	if (hapi.location_type.match(/ftp|http/i) && hapi.baseline_state === "comp_download_in_progress") {
	                		$(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
	                	}
						$(DELETE_ACTION).addClass('hp-disabled').attr('style', 'color: rgb(128, 128, 128);');
                    // Disable the Reports and Validate option in Actions menu
                    $(REPORTS_ACTION).addClass('hp-disabled').attr('style', 'color: rgb(128, 128, 128);');
					$(REPORTS_ACTION).bind('click',false);
                    $(VALIDATE_ACTION).addClass('hp-disabled').attr('style', 'color: rgb(128, 128, 128);');
					$(VALIDATE_ACTION).bind('click',false);

	                	var bState = "hpsum.baseline.show.inventoryInProgress";
	                	if (hapi.baseline_state === "comp_download_in_progress")
	                		bState = "hpsum.baseline.compDownloadInProgress";
	                		
	                		 var currComps = hapi.baseline_state_detail.current_progress,
	                		totalComps = hapi.baseline_state_detail.total_no_component,
	                		currprogress = 0.1;
	                		
	                		if (0 != totalComps) {
	                			currprogress = (currComps/totalComps) * 100;
	                		} 
	                		
							//show notification details
							notificationsView.add({
									status : 'running',
									summary : localizer.getString(bState),
									timestamp : (new Date().toISOString()),
									changing : true,
									progress : currprogress,
									step : hapi.baseline_state_detail.detail,
									
							});
							
	                	var uri = 	{
	                					location_id: item.hapi.location_id,
					        			baseline_id: item.hapi.baseline_id
					        		};
					    
	                	showInventoryProgress(uri);
	                }
	               	else if(hapi.baseline_state === "inventory_completed") {
	               		
	               		$(ABORT_ACTION).addClass('hp-disabled');
                    // Enable the reports, validate and delete option in action menu
                    $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
					$(REPORTS_ACTION).unbind('click');
                    $(VALIDATE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
					$(VALIDATE_ACTION).unbind('click');
                    $(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                   
				   if(item.hapi.baseline_version.toUpperCase().match("N/A") || item.hapi.baseline_name.match(/^Additional Package/i)){
						$(VALIDATE_ACTION).addClass('hp-disabled').attr('style', 'color: rgb(128, 128, 128);');
						$(VALIDATE_ACTION).bind('click',false); 
						}
	               		if(timer)
	               			clearInterval(timer);
	               			               		var details='';
	                	var compAdded;
	                	if(hapi.hasOwnProperty("components")) {
	                		compAdded = hapi.components.component.length;
	                		details = localizer.getString("hpsum.baseline.show.totalComponents") + " " + compAdded;
	                	}
						var status = 'info',
						detail = hapi.baseline_state_detail.detail,
						summary= localizer.getString("hpsum.baseline.show.inventoryCompleted");
						$(BASELINE_WARNING_IMG).hide();
						
	                	//show notification details
						var comp_missing = hapi.baseline_missing_comp_count;
						if(comp_missing > 0)
						{	
							$(BASELINE_WARNING_IMG).show();
							detail = '<p>' + localizer.getString("hpsum.baseline.show.baselineComponentWarnings")+ '<a class="hp-anchor-uri" data-panel-id="hpsum-baselines-show-missingfixes"'+'href="#/baseline/show/missingfixes"> '+localizer.getString("hpsum.baseline.show.seeComponentWarnings")+'</a></p>';
							status='warning';
						}
						
		                notificationsView.add({
							status: status,
							summary:summary,
							timestamp: (new Date().toISOString()),
							step: hapi.baseline_state_detail.detail,
							details: detail
						});	               	
	               	}
					else if(hapi.baseline_state === "inventory_Failed") {
	               		
	               		if(timer)
	               			clearInterval(timer);
															
						var details = '</br><a id="hpsum-start-failed-inventory">' + localizer.getString("hpsum.baseline.show.reinventory") + '</a>';
						
	                	//show notification details
		                notificationsView.add({
	                            status: 'Failed',
	                            summary: localizer.getString("hpsum.baseline.show.inventoryFailed"),
	                            sourceName: item.hapi.baseline_name,
	                            sourceUri: item.hapi.baseline_url,
	                            details: hapi.baseline_state_detail.detail + details
	                   	});
	               	}
	               	else if (hapi.baseline_state === "inventory_needed") {
					
					
					$(ABORT_ACTION).addClass('hp-disabled').attr('style', 'color: rgb(128, 128, 128);');
					$(ABORT_ACTION).bind('click',false);
	               		//show notification details
	               		// In case of PFW we need to show the Start Inventory Link
	            /*   		if (hapi.location_type == "FTP") {
	               			//var detailed = '<a id="hpsum-schedule-pfw-inventory" href="javascript:void(0);">' + localizer.getString("hpsum.baseline.schedule_download") + '</a>';
	               			var detailsfornow = '<a id="hpsum-schedule-pfw-inventory-now" href="javascript:void(0);">' + localizer.getString("hpsum.baseline.download_now") + '</a>';
		            		notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString("hpsum.baseline.show.downloadNeeded"),
	                        sourceName: item.hapi.baseline_name,
	                        sourceUri: item.hapi.baseline_url,
	                        //details:  detailed + " or " + detailsfornow
	                        details:  detailsfornow
	                   	});
	                   	$('#hpsum-schedule-pfw-inventory').click(function (e) {	                   		
	                   		showScheduleDialog(item);	                   		
	                   	});
	                   	$('#hpsum-schedule-pfw-inventory-now').click(function (e) {	  
	                   		presenter.startPFWInventory({
                    		scheduled: "Off",
                    		scheduleDate: "",
                    		scheduleTime: "",
                    		scheduleType: "",
                    		scheduleRecurs: "",
                    		uri: item.hapi.baseline_uri
                    	});
                    	notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString("hpsum.baseline.starting_download")	                        
	                   	});	                   		
	                   	});
	                  }*/
	              }
				  //Added to show proper notification while abort is in abort_in_progress or abort_completed status. 
				  else if (hapi.baseline_state === "abort_in_progress"){ 
				            notificationsView.clear();
							notificationsView.add({
									status : 'running',
									summary : "Abort is in progress",
									timestamp : (new Date().toISOString()),
									changing : true
							}); 
				  }
				  else if (hapi.baseline_state === "abort_completed"){ 
				            notificationsView.clear();
							notificationsView.add({
									status : 'running',
									summary : "Abort is successful",
									timestamp : (new Date().toISOString()),
									changing : true
							}); 
				  }
                } else {
                    $(TITLE).html('');
                }
            }
            $('#hpsum-start-failed-inventory').live('click', function(ev) {
				 presenter.startInventory({uri: baselineItem.baseline_uri + '/getBaselineData'}, {
								success : function (data) {
	                			 
								 
								  var currComps = baselineItem.baseline_state_detail.current_progress,
	                		totalComps = baselineItem.baseline_state_detail.total_no_component;
	                		currprogress = 0.1;
	                		
	                		if (0 != totalComps) {
	                			currprogress = (currComps/totalComps) * 100;
	                		} 
	                		
							//show notification details
							notificationsView.add({
									status : 'running',
									summary : localizer.getString(bState),
									timestamp : (new Date().toISOString()),
									changing : true,
									progress : currprogress,
									step : baselineItem.baseline_state_detail.detail,
									
							});
							
	                			},
	                			error : function (data) {
	                			}});
				});
            /*function showScheduleDialog(item){
		 var timer_uri = 	{
	                		location_id: item.hapi.location_id,
					baseline_id: item.hapi.baseline_id
				};

				$(SCHEDULE_TYPE, scheduleDialogContents).hpSelect().on('change',function(){
					if ($(SCHEDULE_TYPE).val() == 'daily')
						$('#rec-every-for-schedule',scheduleDialogContents).text('Day(s)');
					else if ($(SCHEDULE_TYPE).val() == 'weekly')
						$('#rec-every-for-schedule',scheduleDialogContents).text('Week(s)');
					else if ($(SCHEDULE_TYPE).val() == 'monthly')
						$('#rec-every-for-schedule',scheduleDialogContents).text('Month(s)');
					else if ($(SCHEDULE_TYPE).val() == 'onetime')
						$('#rec-every-for-schedule',scheduleDialogContents).text('Once');
					else
						$('#rec-every-for-schedule',scheduleDialogContents).text('');
				});

            	var dialogView = new DialogView();
            	dialogView.init({contents: scheduleDialogContents,	
                	position : "center",
                    ok: function (elem) {
                    	var schedule_date = $(SCHEDULE_DATE_AND_TIME).datetimepicker("getDate");
                    	presenter.startPFWInventory({
                    		scheduled: "On",
                    		scheduleDate: $.format.date(schedule_date, "yyyy-MM-dd"),
                    		scheduleTime: $.format.date(schedule_date, "hh:mm:ss"),
                    		scheduleType: $(SCHEDULE_TYPE).val(),
                    		scheduleRecurs: $(SCHEDULE_RECURS).val(),
                    		uri: item.hapi.baseline_uri
                    	});
                    	notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString("hpsum.baseline.starting_download")	                        
	                   	});

            		showInventoryProgress(timer_uri);
                    },
                    cancel: function () {   
                    	$(SCHEDULE_RECURS).val('1');
                    	$(SCHEDULE_DATE_AND_TIME).val('');
                    }
                });
            } */
            
            //Populate component/fixes table
            function populateComponentTable(item){
	                var oTable = $(COMPONENT_TABLE).dataTable();
					if(oTable.length>0)
	                oTable.fnClearTable();
	                if(item.hapi.hasOwnProperty("components")) {
	                   oTable.fnAddData(item.hapi.components.component_available);
	                   //select first record
	                   $(COMPONENT_TABLE + ' tbody tr').first().addClass('hp-selected');
	                   //to enable click event for a row
	                   $(COMPONENT_TABLE + " tbody tr").click( function( e ) {
							var data = oTable.fnGetData( this );
					        if ( $(this).hasClass('hp-selected') ) {
					            $(this).removeClass('hp-selected');
					        }
					        else {
					        	$(COMPONENT_TABLE + ' tr.hp-selected').removeClass('hp-selected');
					            $(this).addClass('hp-selected');
					        }
					        //call REST API to get component data and show it to user in a dialog
					        var uri = {location_id: item.hapi.location_id,
					        			baseline_id: item.hapi.baseline_id,
					        			component_id: data.component_id,
						 				filter: "compInfo"
					        			};
							
							var srcElem, browserType = 0;
                            var bPopulateConfigUI=false;
							//Check if firefox or (chrome and IE)
							if(e.srcElement)
							{
								srcElem = e.srcElement;//Chrome and IE
                                if((!srcElem.cellIndex) && srcElem.parentElement.cellIndex !=0)
                                    bPopulateConfigUI=true;
							}
							else
							{
								srcElem = e.target;//Firefox
								browserType = 1;
								if((!srcElem.cellIndex) && srcElem.parentElement.cellIndex !=0)
                                    bPopulateConfigUI=true;
							}
                            
							 if(bPopulateConfigUI === true)
							 {
								
					        	presenter.getCompConfDetail(uri, 
								{
									success : function(compdata) {
									onComponentConfigDataSuccess(uri, compdata, browserType);
									},
									error : function(errorInfo) {
									onComponentDataError(errorInfo);
									}
								});
							 }
							 else
							 {
								presenter.getComponentData(uri, {
									success : function(compdata) {
										onComponentDataSuccess(compdata);
									},
									error : function(errorInfo) {
										onComponentDataError(errorInfo);
									}
								});
							}
					    });
	                
                }
            }
            
			/*populating missingcomponents table*/
			function populateMissingComponentTable(item){
	                var oTable = $(MISSINGCOMPONENT_TABLE).dataTable();
	                oTable.fnClearTable();
					var rowId=0;
	                if(item.hapi.components.hasOwnProperty("component_missing") || item.hapi.components.hasOwnProperty("component_downloadfailed")) {
						$('#hpsum-baselines-retryall').attr('disabled',false);
					if(item.hapi.components.hasOwnProperty("component_missing"))
					{
	                   var tabledata=item.hapi.components.component_missing;
					   for(var i=0;i<tabledata.length;i++)
						{
							var dataitem = [{
							component_file_name: tabledata[i].component_file_name,
							package_name: tabledata[i].package_name,
							product_typeInString : tabledata[i].product_typeInString,
							criticality : tabledata[i].criticality,
							component_version : tabledata[i].component_version,
							reboot_required : tabledata[i].reboot_required,
							status : 'Missing',
							retry :''
							}];
							oTable.fnAddData(dataitem);
						}
					}
					if(item.hapi.components.hasOwnProperty("component_downloadfailed"))
					{
					   tabledata=item.hapi.components.component_downloadfailed;
					   for(var i=0;i<tabledata.length;i++)
						{
							var dataitem = [{
							component_file_name: tabledata[i].component_file_name,
							package_name: tabledata[i].package_name,
							product_typeInString : tabledata[i].product_typeInString,
							criticality : tabledata[i].criticality,
							component_version : tabledata[i].component_version,
							reboot_required : tabledata[i].reboot_required,
							status : 'Download Failed',
							retry :''
							//ICM Feature Hiding
							//retry : '<a id="retry-'+rowId+'" href="#/baseline/retry">'+localizer.getString("hpsum.baseline.add.retry")+'</a>'
							}];
							oTable.fnAddData(dataitem);
							 $('#retry-' + rowId).bind('click',retryClicked);
							rowId++;
						}
	                }
					   $(MISSINGCOMPONENT_TABLE + " tbody tr").click( function( e ) {
							var data = oTable.fnGetData( this );
					        if ( $(this).hasClass('hp-selected') ) {
					            $(this).removeClass('hp-selected');
					        }
					        else {
					        	$(MISSINGCOMPONENT_TABLE + ' tr.hp-selected').removeClass('hp-selected');
					            $(this).addClass('hp-selected');
					        }
					    });

						$('#hpsum-baselines-retryall').click(function(e){
							var rowdata=oTable.fnGetData();
							var data=new Array();
							var index=0;
							for(var row=0;row<rowdata.length;row++)
							{
							 if(rowdata[row].retry)
							 {
								data[index]=rowdata[row];
								index++;
							 }
							}
							compData=data;
							router.go('/baseline/retry');
						});
	                
                }
				else
				{
					$('#hpsum-baselines-retryall').attr('disabled',true);
					if(item.hapi.components.hasOwnProperty("componentinfo_missing"))
					{
						var data=item.hapi.components.componentinfo_missing;
						for(var i=0;i<data.length;i++)
						{
							var dataitem = [{
							component_file_name: data[i],
							status : 'Missing',
							}];
							oTable.fnAddData(dataitem);
						}
					}
					if(item.hapi.components.hasOwnProperty("componentProcessing_failed")) 
					{
						tabledata=item.hapi.components.componentProcessing_failed;
					    for(var i=0;i<tabledata.length;i++)
						{
							var dataitem = [{
							component_file_name: tabledata[i].missing_component_name,
							status: tabledata[i].error_message,
							}];
							oTable.fnAddData(dataitem);
						}
					}
					else
						oTable.fnSettings().oLanguage.sEmptyTable = localizer.getString("hpsum.baseline.show.noMissingComponents");
				}
            }
			
			function retryClicked(){
			var oTable = $(MISSINGCOMPONENT_TABLE).dataTable();
			var row=$(this).closest('tr');
							var rowdata = oTable.fnGetData(row[0]);
							compData=rowdata;
			}
            
            //get baseline inventory progress/status every 3 seconds and update UI 
            function showInventoryProgress(uri){
            	if(timer)
		        {
		            clearInterval(timer);
		            timer = null;
		        }
            	
            	timer = setInterval(function () {
            		var bStopTimer = false;
            		presenter.getBaselineStatus(uri, {
            					item: uri,
                				success : function(data) {
                    				onBaselineStatusSuccess(data, this.item);
                    				if(data.hapi.baseline_state === "inventory_completed") {
                    					bStopTimer = true;
										
									//To Clear the previous message from info panel.
									notificationsView.clear();
									
									var status = 'info',
										detail = '',
										summary= localizer.getString("hpsum.baseline.show.inventoryCompleted");;
 										
									//show notification details
									var comp_missing = data.hapi.baseline_missing_comp_count;
									if(comp_missing > 0)
									{	
										$(BASELINE_WARNING_IMG).show();
										detail = '<p>' + localizer.getString("hpsum.baseline.show.baselineComponentWarnings") + '<a class="hp-anchor-uri" data-panel-id="hpsum-baselines-show-missingfixes"'+'href="#/baseline/show/missingfixes"> '+localizer.getString("hpsum.baseline.show.seeComponentWarnings")+'</a></p>';
										status='warning';
									}
									
									notificationsView.add({
										status: status,
										//summary: localizer.getString("hpsum.baseline.show.inventoryCompleted"),
										summary:summary,
									timestamp: (new Date().toISOString()),
									step: data.hapi.baseline_state_detail.detail,
										//details: '' 
										details:detail
									});	
                    				}
                    		 	},
                    			error : function(errorInfo) {
                        			onBaselineStatusError(errorInfo);
                    			}
                			});
                	
                	if(bStopTimer){
	                	if(timer)
		                {
		                	clearInterval(timer);
		                	timer = null;
		                }
		          	}
                			
                }, GETSTATUS_TIMER);
            }
            
            function onBaselineStatusSuccess(data, item) {
            	//show inventory progress
            	//if(data.hapi.baseline_state === "inventory_in_progress" || data.hapi.baseline_state === "manifest_component_processing") {
            	if(data.hapi.baseline_state === "inventory_in_progress" || data.hapi.baseline_state === "manifest_component_processing" ||
            	   data.hapi.baseline_state === "comp_download_in_progress" || data.hapi.baseline_state === "reading_manifest_xml" ||
		   data.hapi.baseline_state === "reading_web_catalog" ||  data.hapi.baseline_state === "inventory_web_catalog_downloading") {	
            		//currently finding the progress by extracting the total components and current components processed data
            		//baseline_state_detail need to be changed to object format, so that we can handle this in proper manner.
            		var totalComps, currComps;
            		currComps = data.hapi.baseline_state_detail.current_progress;
            		totalComps = data.hapi.baseline_state_detail.total_no_component;
            		var currprogress = 0.1;
            		if (0 != totalComps) {
            			currprogress = (currComps/totalComps) * 100;
            		}
            		var bState = "hpsum.baseline.show.inventoryInProgress";
            		if (data.hapi.baseline_state === "comp_download_in_progress")
            			bState = "hpsum.baseline.compDownloadInProgress";
            			
            		var bStep = data.hapi.baseline_state_detail.detail;
            		
					//To Clear the previous message from info panel.
					notificationsView.clear();
	                //show notification details
	                notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString(bState),
	                        //summary: localizer.getString("hpsum.baseline.show.inventoryInProgress"),
	                        timestamp: (new Date().toISOString()),
	                        changing: 1,
	                        progress: currprogress,
	                        step: bStep,
	                        details: '' 
	               });
	           	}
	           	else if(data.hapi.baseline_state === "inventory_completed") {
	                //show notification details
					
					var comp_missing = data.hapi.baseline_missing_comp_count;
									if(comp_missing > 0)
									{
										$(BASELINE_WARNING_IMG).show();
										var detail = '<p>' + localizer.getString("hpsum.baseline.show.baselineComponentWarnings") + '<a class="hp-anchor-uri" data-panel-id="hpsum-baselines-show-missingfixes"'+'href="#/baseline/show/missingfixes"> '+localizer.getString("hpsum.baseline.show.seeComponentWarnings")+'</a>' + '</p>';			
                                        var status='warning';
									}
									else
									{
										$(BASELINE_WARNING_IMG).hide();
										var summary= localizer.getString("hpsum.baseline.show.inventoryCompleted");
										var status='info';
										var detail='';
									}
	                notificationsView.add({
										status: status,
										//summary: localizer.getString("hpsum.baseline.show.inventoryCompleted"),
										summary:summary,
										timestamp: (new Date().toISOString()),
										step: data.hapi.baseline_state_detail.detail,
										//details: '' 
										details:detail
									});
	                /*notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString("hpsum.baseline.show.inventoryCompleted"),
	                        timestamp: (new Date().toISOString()),
	                        step: data.hapi.baseline_state_detail.detail,
	                        details: '' 
	               });*/
                 
                 // Enable the reports, validate and delete options in action menu
                 $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
				 $(REPORTS_ACTION).unbind('click');
                 $(VALIDATE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
				 $(VALIDATE_ACTION).unbind('click');
                 $(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
	               
	               //populate fixes/components table
	               //presenter.getBundleIndexData(item, {
				    var loc_id=data.hapi.location_id;
	                var base_id=data.hapi.baseline_id; 
	               	presenter.getComponents(baselineItem.baseline_uri, {
        					success : function(data) {
							    var dataItem = {hapi:{location_id:loc_id,baseline_id:base_id, components:data.hapi.components}};
                				populateComponentTable(dataItem);
								populateMissingComponentTable(dataItem);
                		 	},
                			error : function(errorInfo) {
                    			
                			}
                	});
					
					presenter.getOsInfo(baselineItem.baseline_uri, {
    							success : function(data) {
									var idx, html ="";
    								if (data.hapi.hasOwnProperty("baseline_os")) {
										data.hapi.baseline_os.os.sort();
    									for ( idx = 0; idx < data.hapi.baseline_os.os.length; idx++) {
    										html = html + '<li>' + data.hapi.baseline_os.os[idx] + '</li>';
    									}
    
    									$('#os ol').html(html);
    								}
    							},
    							error : function(data) {
    						}
    				}); 
                	
                	if(timer)
	                {
	                	clearInterval(timer);
	                	timer = null;
	                }
                }
            }
            
            function onBaselineStatusError(errorInfo) {
            }
            
            function onComponentDataSuccess(data) {
				var componentDialogContents  =$(componentDialogHtml);
            	localizer.localizeDom(componentDialogContents);
            	//show component dialog
            	var dialog = new DialogView();
            	dialog.init({contents: componentDialogContents,
                    ok: function (elem) {
                        return true;
                    },
                    cancel: function () {
                    }
                });
                var component= data.hapi.component_data;
                $('#component_title',componentDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.componentDetailsFor", [component.component_file_name]));
                $('#hpsum-component-name',componentDialogContents).html(component.package_name);
	            $('#hpsum-comp-inst-notes',componentDialogContents).show();
	            $('#hpsum-comp-prerequisite',componentDialogContents).show();
	            if(component.hasOwnProperty('compInfo')){
	            				$('#hpsum-comp-description',componentDialogContents).html(component.compInfo.componentInfo.description);
	            		}
				$('#hpsum-component-id',componentDialogContents).html(component.component_file_name);
				if(component.hasOwnProperty('compInfo'))
				{
					var component_version= component.compInfo.componentInfo;
					var htmlContents='';
					var version = component_version.version;
					if(component_version.revision != '')
						version += '('+ component_version.revision + ')';
					htmlContents+='<div><b><u>Version</u></b></br>'+ version+ '</br>';
					var enhancement, fixes;
					enhancement = component_version.enhancement;
					fixes = component_version.fixes;
					if(enhancement == '' || enhancement == undefined)
						enhancement =  'None';
					if(fixes == '' || fixes == undefined)
						fixes ='None';
								
							
					htmlContents+='<div><b><u>Enhancements</u></b></br>'+enhancement+ '</br>'+
									'<b><u>Fixes</u></b></br>' + fixes+ '</br></div></div>';
					
					//creating anchor links for the normal text URLs
					var regex = /(https?:\/\/([-\w\.]+)+(:\d+)?(\/([\w\/_\.]*(\?\S+)?)?)?)/ig; 
					htmlContents = htmlContents.replace(/\<p>/ig, ' <p>');
    				htmlContents = htmlContents.replace(regex, "<a href='$1' target='_blank'>$1</a>");
    
					$('#hpsum-component-installation-notes').html(htmlContents);

					var prerequisiteContents= '';
					//'<div><b><u>Applicable OS</u></b></br>'+ version+ '</br>';
					component_version.prerequisite.sort();
					for(var i=0; i<component_version.prerequisite.length; i++){
						prerequisiteContents += 	component_version.prerequisite[i] + '</br>';
					}
					var prerequisiteContentsHtml = '<div><b><u>Applicable OS</u></b></br>'+ prerequisiteContents;
					$('#hpsum-comp-prerequisite').html(prerequisiteContentsHtml);
				}

				}
			
			function onComponentConfigDataSuccess(item, compdata, browserType) {
				if(compdata && compdata.hapi && compdata.hapi.component_config_data && compdata.hapi.component_config_data.config_file_data)
				{
					var data = compdata.hapi.component_config_data.config_file_data;
					
					data = data.replace(/&quot;/g,'"'); //Replace all &quot; with '"'.
					data = data.replace(/[\r\n]+(?=[^\r\n])/g,''); //Replace all new line and carriage returns
					data = data.replace(/\s{2,}/g, '');//Remove all Tabs
					
					data = JSON.parse(data);
					
					//show component config dialog
					var dialog = new DialogView();
					dialog.init({contents: componentConfigDialogContents,
						ok: function (elem) {
						//build the saveconfig hapi request
						var outData,k=0,strJSON, saveRequired = true;
						outData = data;
						if(!data.parameter.length)
						{
							if(elem.form[0].type == "radio")
							{								
								if(elem.form[0].checked == true)
								{									
									strJSON = "{\"param\":{\"value__attr\":\"" + elem.form[0].value + "\", \"name__attr\":\"" + data.parameter.name__attr +"\"}}";
									outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strJSON }};
								}
							}
							else
							{
								elem.form[0].value = elem.form[0].value.replace(/\\/g, '\\\\');
								strJSON = "{\"param\":{\"value__attr\":\"" + elem.form[0].value + "\", \"name__attr\":\"" + data.parameter.name__attr +"\"}}";
								outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strJSON }};
							}							
						}
						else
						{
							var keys = new Array();
							var values = new Array();
							var savedParamValues = {};
							var formInputCount = 0;
							while(k<data.parameter.length)
							{
						
								if(data.parameter[k].requirements.input_requirements.user_visible.value__attr == "no")
								{
									k++;
									continue;
								}
								else 
								{								
									if(!(elem.form[formInputCount].type == "radio"))
									{
										if((outData.parameter[k].requirements.required_for_installation.value__attr.toLowerCase() == "yes" || outData.parameter[k].requirements.required_for_installation.value__attr.toLowerCase() == "y") && (!elem.form[formInputCount].value || elem.form[formInputCount].value == ""))
										{
											$('<p style="color: red">'+localizer.getString('hpsum.common.fieldRequired')+'</p>').appendTo($('#'+outData.parameter[k].name__attr));
											return false;
										}
										values[formInputCount]=elem.form[formInputCount].value;
										values[formInputCount] = values[formInputCount].replace(/\\/g, '\\\\');
										keys[formInputCount]=outData.parameter[k].name__attr;
										savedParamValues[outData.parameter[k].name__attr]=outData.parameter[k].output.value__attr;
										formInputCount++;
										k++;
									}
									else
									{
										while(elem.form[formInputCount].type == "radio")
										{
											if(elem.form[formInputCount].checked == true)
											{
												values[formInputCount]=elem.form[formInputCount].value;
												keys[formInputCount]=outData.parameter[k].name__attr;
												savedParamValues[outData.parameter[k].name__attr]=outData.parameter[k].output.value__attr;
												k++;
											}
											formInputCount++;
										}
									}
								}
							}
							var strObj = "{\"param\":[";
							saveRequired = false;
							for(var i=0; i<keys.length; i++){
							if(keys[i] !== undefined && values[i] !== undefined && savedParamValues[keys[i]].toLowerCase() != values[i].toLowerCase()){						
								strObj = strObj + "{\"value__attr\":\""+values[i]+"\", \"name__attr\":\""+keys[i]+"\"},";
								saveRequired = true;
								}
							}
							if(saveRequired)
							{
								strObj = strObj.substr(0,strObj.length - 1);
								strObj = strObj + "]}";
								outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strObj}};
							}
							else//Send atleast one key value pair so that engine marks the component as configured
							{
								for(var i=0; i<keys.length; i++){
									if(keys[i] && values[i]){
									strObj = strObj + "{\"value__attr\":\""+values[i]+"\", \"name__attr\":\""+keys[i]+"\"}]}";
									break;
									}
								}
								outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strObj}};
							}
						}
						presenter.saveComponentConfig(item, outData, {
										success : function(compdatareturn) {
										if(compdatareturn.hapi.hcode==0)
										{
 										var compId=item.component_id;
 										compId = compId.replace(/(:|\.)/g,'');
 										$('#hpsum-NC-'+compId).hide();
 										$('#hpsum-C-'+compId).show();
 										$(CANCEL).trigger('click');
											return true;											
										}
										else{
											$('#hpsum-component-config-error').show();
											return false;
										}
										},
										error : function(errorInfo) {
											onComponentDataError(errorInfo);
										}}
										);
								return false;
						},
						cancel: function () {
						}
					});                
					var valueField,i,defaultValue;
					//Clear all the entries and add the header
					$('#hpsum-component-config-param tr').html('<thead><tr><td>' + localizer.getString('hpsum.baseline.show.parDesc') + '</td><td>' + localizer.getString('hpsum.baseline.show.value') + '</td><td>' + localizer.getString('hpsum.baseline.show.parName') + '</td></tr></thead>');
					var title = localizer.getString('hpsum.baseline.show.componentConfigFor', [item.component_id]);
					$('#component_config_title').html(title);
					var radioValue;
					$('#hpsum-component-config-error').hide();
					$(SAVE_CONFIG).unbind('click').bind('click', function(ev) {
						saveConfig.call(this, item, data, compdata);
					});
					$(EXPORT_CONFIG).unbind('click').bind('click', function(ev) {
						export_Config = true;
						saveConfig.call(this, item, data, compdata);
						//$(CANCEL).trigger('click');
					});

					$(IMPORT_CONFIG).unbind('click').bind('click', function(ev) {
						importConfig.call(this, item.component_id);
					});
					$(CONFIG_DIALOG_MSG).hide();
					if(!data.parameter.length)
					{
						var values = data.parameter["default"].value__attr;
						var valuesArray;
						if(values != "")
						{
							valuesArray = values.split(";");
						}
						var maxLen = data.parameter.requirements.input_requirements.maximum_length;
						var minLen = data.parameter.requirements.input_requirements.minimum_length;
						
						if(data.parameter.requirements.input_requirements.user_visible.value__attr == "no")
						{
							//Invisible
							//So ignore
						}
						else if(values == "" && (($.trim(data.parameter.requirements.input_requirements.required_format)).toLowerCase() == "y" || ($.trim(data.parameter.requirements.input_requirements.required_format)).toLowerCase() == "n"))
						{
							//Radio button
							radioValue = $.trim(data.parameter.output.value__attr).toLowerCase();
							if(radioValue == "yes")
							{
								valueField = "<table border=0><tr><td><label>" + localizer.getString('hpsum.common.yes') + "</label></td><td><input type=\"radio\" name=\"group\" value=\"Yes\" checked></td></tr><tr><td><label>" + localizer.getString('hpsum.common.no') + "</label></td><td><input type=\"radio\" name=\"group\" value=\"No\"></td></tr></table>";
							}
							else if(radioValue == "no" || radioValue == "")
							{
								valueField = "<table><tr><td><label>" + localizer.getString('hpsum.common.yes') + "</label></td><td><input type=\"radio\" name=\"group\" value=\"Yes\" ></td></tr><tr><td><label>" + localizer.getString('hpsum.common.no') + "</label></td><td><input type=\"radio\" name=\"group\" value=\"No\" checked></td></tr></table>";
							}
						}
						else if(values == "" && maxLen < 26)
						{
							//input type text
							//check for password field
							if(data.parameter.requirements.input_requirements.password_field.value__attr == "yes")
							{
								valueField = "<input type=\"password\" value=\"" + data.parameter.output.value__attr + "\">";							
								//password field
							}
							else
							{
								valueField = "<input type=\"text\" value=\"" + data.parameter.output.value__attr + "\">";
							}						
						}
						else if(values == "" && maxLen > 24)
						{
							//text area
							valueField = "<textarea rows=\"4\" cols=\"50\">" + data.parameter.output.value__attr + "<\/textarea>";								
						}
						else if(valuesArray.length > 1)
						{
							//Combo box
							var j, comboField = "<select value=\"" + data.parameter.output.value__attr + "\">" ;
							for(j=0;j<valuesArray.length;j++)
							{
								if(valuesArray[j]==data.parameter.output.value__attr)
								{
									comboField = comboField + "<option selected>" + valuesArray[j] + "</option>";
								}
								else
								{
									comboField = comboField + "<option>" + valuesArray[j] + "</option>";
								}
							}
							valueField = comboField + "</select>";
						}
						
						$('#hpsum-component-config-param tr:last').after('<tr><td>' + data.parameter.user_prompt + '</td><td>'+valueField+'</td><td>' + data.parameter.name__attr + '</td></tr>');
					}
					else
					{
						var tdid,rYesId,rNoId;
						//Determine the value of valufield for each parameter
						for(i=0;i<data.parameter.length;i++)
						{
							var values = data.parameter[i]["default"].value__attr;
							var valuesArray, isMultiValueField = false;
							tdid = data.parameter[i].name__attr;
							
							if (values)
							{
								if(values.indexOf(";") >= 0)
								{
									valuesArray = values.split(";");
									isMultiValueField = true;
								}
								else if(values.indexOf(":") >= 0)
								{
									valuesArray = values.split(":");
									isMultiValueField = true;
								}
							}
							var maxLen = data.parameter[i].requirements.input_requirements.maximum_length;
							var minLen = data.parameter[i].requirements.input_requirements.minimum_length;
							
							if(data.parameter[i].requirements.input_requirements.user_visible.value__attr == "no")
							{
								//Invisible
								//So ignore
								continue;
							}
							else if(!isMultiValueField && (($.trim(data.parameter[i].requirements.input_requirements.required_format)).toLowerCase() == "y" || ($.trim(data.parameter[i].requirements.input_requirements.required_format)).toLowerCase() == "n"))
							{
								//Radio button
								rYesId = tdid + 'y';
								rNoId = tdid + "n";
								radioValue = $.trim(data.parameter[i].output.value__attr).toLowerCase();
								if(radioValue == "yes")
								{
									valueField = "<label>" + localizer.getString('hpsum.common.yes') + "</label><input id = \""+rYesId+"\" type=\"radio\" name=\""+data.parameter[i].name__attr+"\" value=\"Yes\" checked>&nbsp;&nbsp;&nbsp;&nbsp;<label>" + localizer.getString('hpsum.common.no') + "</label><input id = \""+rNoId+"\" type=\"radio\" name=\""+data.parameter[i].name__attr+"\" value=\"No\">";
								}
								else if (radioValue == "no" || radioValue == "")
								{
									valueField = "<label>" + localizer.getString('hpsum.common.yes') + "</label><input id = \""+rYesId+"\" type=\"radio\" name=\""+data.parameter[i].name__attr+ "\" value=\"Yes\">&nbsp;&nbsp;&nbsp;&nbsp;<label>" + localizer.getString('hpsum.common.no') + "</label><input id = \""+rNoId+"\" type=\"radio\" name=\""+data.parameter[i].name__attr+"\" value=\"No\" checked>";
								}
							}
							else if(!isMultiValueField && maxLen < 26)
							{
								//input type text
								//check for password field
								if(data.parameter[i].requirements.input_requirements.password_field.value__attr == "yes")
								{
									valueField = "<input type=\"password\" value=\"" + data.parameter[i].output.value__attr + "\">";							
									//password field
								}
								else
								{
									valueField = "<input type=\"text\" value=\"" + data.parameter[i].output.value__attr + "\">";
								}						
							}
							else if(!isMultiValueField && maxLen > 24)
							{
								//text area
								//check for password field
								if(data.parameter[i].requirements.input_requirements.password_field.value__attr == "yes")
								{
									valueField = "<input type=\"password\" value=\" size=\"" +maxLen+ "\"" + data.parameter[i].output.value__attr + "\">";
									//password field
								}
								else
								{
									valueField = "<textarea rows=\"4\" cols=\"50\">" + data.parameter[i].output.value__attr + "<\/textarea>";
								}
							}
							else if(isMultiValueField)
							{
								if(valuesArray.length > 1)
								{
									//Combo box
									var j, comboField = "<select value=\"" + data.parameter[i].output.value__attr + "\">" ;
									for(j=0;j<valuesArray.length;j++)
									{
										if(valuesArray[j]==data.parameter[i].output.value__attr)
										{
											comboField = comboField + "<option selected>" + valuesArray[j] + "</option>";
										}
										else
										{
											comboField = comboField + "<option>" + valuesArray[j] + "</option>";
										}
									}
									valueField = comboField + "</select>";
								}
							}
							//Add the row to config table
							$('#hpsum-component-config-param tr:last').after('<tr><td>' + data.parameter[i].user_prompt + '</td><td id="'+tdid+'">'+valueField+'</td><td>' + data.parameter[i].name__attr + '</td></tr>');
						}
					
						//Handle dependencies
						var tdid, temp = {};
						for(i=0;i<data.parameter.length;i++)
						{
							if(data.parameter[i].depends)
							{
								if($.trim(data.parameter[i].depends.dependent.name__attr) != "")
								{
									// disable the td of dependent param
									$('#' + $.trim(data.parameter[i].name__attr)).find(':input').prop("disabled", true);
									
									// add onclick event param to enable/disable the dependent param
									var values = data.parameter[i]["default"].value__attr;
									var inputType, srcElem;
									
									//If the field on which other field depends is a radio button
									if(!(values.indexOf(';')>0)&& (($.trim(data.parameter[i].requirements.input_requirements.required_format)).toLowerCase() == "y" || ($.trim(data.parameter[i].requirements.input_requirements.required_format)).toLowerCase() == "n"))
									{
										tdid = $.trim(data.parameter[i].depends.dependent.name__attr) + data.parameter[i].depends.dependent.value__attr.toLowerCase();
										inputType="radio";
									}
									else if(!(values.indexOf(';')>0))
									{
										tdid = $.trim(data.parameter[i].depends.dependent.name__attr);
										inputType="text";
									}
									else
									{
										tdid = $.trim(data.parameter[i].depends.dependent.name__attr);
										inputType="combo";
									}
									
									//Maintaining dictionary of params and dependent params
									temp[tdid] = $.trim(data.parameter[i].name__attr);
									
									if(inputType == "radio")
									{
										$("#"+ tdid).live('change',function(e){
										srcElem = getSrcElem(browserType, e);
										$('#' + temp[srcElem.id]).find(':input').prop("disabled", false);
										});
										
										//This logic holds good when dependent params are radio buttons (Most likely in configurable component)
										if(data.parameter[i].depends.dependent.value__attr.toLowerCase() == "y")
										{
											tdid = $.trim(data.parameter[i].depends.dependent.name__attr) + "n";
											if(!temp[tdid])
											{
												temp[tdid] = $.trim(data.parameter[i].name__attr);
											}
											$("#"+ tdid).live('change',function(e){
											srcElem = getSrcElem(browserType, e);
											$('#' + temp[srcElem.id]).find(':input').prop("disabled", true);
											});
										}
										else if(data.parameter[i].depends.dependent.value__attr.toLowerCase() == "n")
										{
											tdid = $.trim(data.parameter[i].depends.dependent.name__attr) + "y";
											if(!temp[tdid])
											{
												temp[tdid] = $.trim(data.parameter[i].name__attr);
											}
											$("#"+ tdid).live('change',function(e){
											srcElem = getSrcElem(browserType, e);
											$('#' + temp[srcElem.id]).find(':input').prop("disabled", false);
											});
										}
									}
									else if(inputType=="combo")
									{
										var depValue = data.parameter[i].depends.dependent.value__attr.toLowerCase();
										var defaultVal = data.parameter[i].output.value__attr;
										$("#"+ tdid).live('change',function(e){
										srcElem = getSrcElem(browserType, e);
										if(srcElem.value.toLowerCase() == depValue)
										{
											$('#' + temp[e.currentTarget.id]).find(':input').prop("disabled", false);
										}
										else
										{
											$('#' + temp[e.currentTarget.id]).find(':input').prop("disabled", true);
										}
										});
									}
									else
									{
										//According to dependency the enabling/disabling of dependent param has to be made
										if($('#' + $.trim(data.parameter[i].depends.dependent.name__attr)).html != '')
										{
											$('#' + $.trim(data.parameter[i].name__attr)).find(':input').prop("disabled", false);
										}
										
										$("#"+ tdid).live('change',function(e){
										srcElem = getSrcElem(browserType, e);
										if(srcElem.value.toLowerCase() != "")
										{
											$('#' + temp[e.currentTarget.id]).find(':input').prop("disabled", false);
										}
										else
										{
											$('#' + temp[e.currentTarget.id]).find(':input').prop("disabled", true);
										}
										});
									}
								}
							}
						}
					}
				}
				else
				{
					var errorInfo = "Configure Information Unavailable";
					onComponentDataError(errorInfo);
				}
            }
			function saveConfig(item, data, compdata)
			{
				//build the saveconfig hapi request
				var outData,k=0,strJSON, saveRequired = true;
				outData = data;
				var  elem = this;
				if(!data.parameter.length)
				{
					if(elem.form[0].type == "radio")
					{								
						if(elem.form[0].checked == true)
						{									
							strJSON = "{\"param\":{\"value__attr\":\"" + elem.form[0].value + "\", \"name__attr\":\"" + data.parameter.name__attr +"\"}}";
							outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strJSON }};
						}
					}
					else
					{
						elem.form[0].value = elem.form[0].value.replace(/\\/g, '\\\\');
						strJSON = "{\"param\":{\"value__attr\":\"" + elem.form[0].value + "\", \"name__attr\":\"" + data.parameter.name__attr +"\"}}";
						outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strJSON }};
					}							
				}
				else
				{
					var keys = new Array();
					var values = new Array();
					var savedParamValues = {};
					var formInputCount = 0;
					while(k<data.parameter.length)
					{
						
						if(data.parameter[k].requirements.input_requirements.user_visible.value__attr == "no")
						{
							k++;
							continue;
						}
						else 
						{								
							if(!(elem.form[formInputCount].type == "radio"))
							{
								if((outData.parameter[k].requirements.required_for_installation.value__attr.toLowerCase() == "yes" || outData.parameter[k].requirements.required_for_installation.value__attr.toLowerCase() == "y") && (!elem.form[formInputCount].value || elem.form[formInputCount].value == ""))
								{
									$('<p style="color: red">'+localizer.getString('hpsum.common.fieldRequired')+'</p>').appendTo($('#'+outData.parameter[k].name__attr));
									return false;
								}
								values[formInputCount]=elem.form[formInputCount].value;
								values[formInputCount] = values[formInputCount].replace(/\\/g, '\\\\');
								keys[formInputCount]=outData.parameter[k].name__attr;
								savedParamValues[outData.parameter[k].name__attr]=outData.parameter[k].output.value__attr;
								formInputCount++;
								k++;
							}
							else
							{
								while(elem.form[formInputCount].type == "radio")
								{
									if(elem.form[formInputCount].checked == true)
									{
										values[formInputCount]=elem.form[formInputCount].value;
										keys[formInputCount]=outData.parameter[k].name__attr;
										savedParamValues[outData.parameter[k].name__attr]=outData.parameter[k].output.value__attr;
										k++;
									}
									formInputCount++;
								}
							}
						}
					}
					var strObj = "{\"param\":[";
					saveRequired = false;
					for(var i=0; i<keys.length; i++){
						if(keys[i] !== undefined && values[i] !== undefined && savedParamValues[keys[i]].toLowerCase() != values[i].toLowerCase()){						
							strObj = strObj + "{\"value__attr\":\""+values[i]+"\", \"name__attr\":\""+keys[i]+"\"},";
							saveRequired = true;
						}
					}
					if(saveRequired)
					{
						strObj = strObj.substr(0,strObj.length - 1);
						strObj = strObj + "]}";
						outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strObj}};
					}
					else//Send atleast one key value pair so that engine marks the component as configured
					{
						for(var i=0; i<keys.length; i++){
							if(keys[i] && values[i]){
								strObj = strObj + "{\"value__attr\":\""+values[i]+"\", \"name__attr\":\""+keys[i]+"\"}]}";
								break;
							}
						}
						outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strObj}};
					}
				}

				presenter.saveComponentConfig(item, outData, {
					success : function(compdatareturn) {
						if(compdatareturn.hapi.hcode==0)
						{
							var compId=item.component_id;
 							compId = compId.replace(/(:|\.)/g,'');
 							$('#hpsum-NC-'+compId).hide();
 							$('#hpsum-C-'+compId).show();
							$(CONFIG_DIALOG_MSG).show();
							$("#hpsum-comp-cfg-msg").html(localizer.getString('hpsum.baseline.show.componentConfigSaved'));
							if(export_Config){
								exportConfig.call(this, item.component_id);
								export_Config = false;
							}
							return true;											
						}
						else{
							$('#hpsum-component-config-error').show();
							return false;
						}
					},
					error : function(errorInfo) {
						onComponentDataError(errorInfo);
					}
				});
			}
			
			function onExportLocationChange() {
				$(EXPORT_CONFIG_ERROR).hide();
				$(EXPORT_ERROR_MSG).hide();
				if(instExportConfigBrowse.getLocation() == "")
				{
					instExportConfigBrowse.setPanelText(baselinedetails.baseline_url)
					if(baselinedetails.baseline_isWritable == false)
						{
							$(EXPORT_CONFIG_ERROR).show();
							$(EXPORT_OK_BUTTON).attr('disabled',true);
						}
						else
						{
							$(EXPORT_CONFIG_ERROR).hide();
							$(EXPORT_OK_BUTTON).attr('disabled',false);
						}
				}
				else
					$(EXPORT_OK_BUTTON).attr('disabled',false);
			}
				
			function exportConfig(compId){
				var exportdialog = new DialogView();
				exportdialog.init({contents: exportConfigDialogContents,
					ok: function (elem) {
					},
					cancel: function() {
					}
				});
				
				if(baselinedetails.baseline_isWritable == false)
				{
					$(EXPORT_CONFIG_ERROR).show();
					$(EXPORT_OK_BUTTON).attr('disabled',true);
				}
				else
				{
					$(EXPORT_CONFIG_ERROR).hide();
					$(EXPORT_OK_BUTTON).attr('disabled',false);
				}
				$(EXPORT_ERROR_MSG).hide();
				
	           var options = 	{
									command : 'init',
									panelLabel: "hpsum.baseline.show.folderpath",
									panelLabelStyle: "text-align:left;",
						            panelHelp: "",
						            panelBrowseText: "hpsum.common.browse"
						        };
				$(EXPORT_CONFIG_BROWSE).hpsumBrowse(options);
				instExportConfigBrowse = $(EXPORT_CONFIG_BROWSE).data('plugin_hpsumBrowse');
				
				instExportConfigBrowse.setInputEvent("onchange", onExportLocationChange);
				
				instExportConfigBrowse.setPanelText(baselinedetails.baseline_url);
				
				$(EXPORT_CREDENTIALS_CHKBOX).unbind('click').bind('click', function() {
					if($(EXPORT_CREDENTIALS_CHKBOX).is(':checked'))
						$(EXPORT_WARNING).show();
					else
						$(EXPORT_WARNING).hide();
					$(EXPORT_ERROR_MSG).hide();
				});
				$(EXPORT_OK_BUTTON).unbind('click').bind('click', function() {
					var configFolder = instExportConfigBrowse.getLocation(); 
					if(configFolder == "")
					{
						$(EXPORT_CONFIG_ERROR).show();
					}
					else 
					{
						var configData = {
								hapi: {
									compId : compId,
									location_id : baselinedetails.location_id,
									baseline_id : baselinedetails.baseline_id,
									folderPath : configFolder,
									includeCredentials : $(EXPORT_CREDENTIALS_CHKBOX).is(':checked')
								}
							};
						presenter.exportCompConfig(configData,{
							success : function(data) {
								var message = data.hapi.baselines.baseline[0].components.component.status;
								notifications.show(message, 'ok');
								notificationsView.add({
									status : 'info',
									timestamp : (new Date().toISOString()),
									details: message
								}); 
								$(CONFIG_DIALOG_MSG).show();
								$("#hpsum-comp-cfg-msg").html(message);
								$(EXPORT_CANCEL).trigger('click');
							},
							error : function(data) {
							var message = data.hapi.baselines.baseline[0].components.component.status;
								notifications.show(message, 'error');
								$(EXPORT_ERROR_MSG).show();
								$(EXPORT_ERROR_MSG).text(message);
								$(EXPORT_ERROR_MSG).addClass("hp-error");
							}}
						);
					}
				});
			}
			
			function onImportLocationChange()
			{
				$(IMPORT_CONFIG_ERROR).hide();
				$(IMPORT_ERROR_MSG).hide();
			}

			function importConfig(compId){
				var importdialog = new DialogView();
				importdialog.init({contents: importConfigDialogContents,
					ok: function (elem) {
					},
					cancel: function() {
					}
				});
				$(IMPORT_CONFIG_ERROR).hide();
				$(IMPORT_ERROR_MSG).hide();
				
	           var options = 	{
									command : 'init',
									panelLabel: "hpsum.baseline.show.folderpath",
									panelLabelStyle: "text-align:left;",
						            panelHelp: "",
						            panelBrowseText: "hpsum.common.browse"
						        };
				$(IMPORT_CONFIG_BROWSE).hpsumBrowse(options);
				instImportConfigBrowse = $(IMPORT_CONFIG_BROWSE).data('plugin_hpsumBrowse');
				instImportConfigBrowse.setPanelText(baselinedetails.baseline_url);
				instImportConfigBrowse.setInputEvent('onchange', onImportLocationChange);
				
				$(IMPORT_OK_BUTTON).unbind('click').bind('click', function() {
					var configFolder = instImportConfigBrowse.getLocation(); 
					if(configFolder == "")
					{
						$(IMPORT_CONFIG_ERROR).show();
					}
					else 
					{
						var configData = {
							hapi: {
								compId : compId,
								location_id : baselinedetails.location_id,
								baseline_id : baselinedetails.baseline_id,
								folderPath : configFolder,
							}
						};
						presenter.importCompConfig(configData,{
							success : function(data) {
							var compId=configData.hapi.compId;
								compId = compId.replace(/(:|\.)/g,'');
								$('#hpsum-NC-'+compId).hide();
								$('#hpsum-C-'+compId).show();
								var uri = {location_id: configData.hapi.location_id,
					        			baseline_id: configData.hapi.baseline_id,
					        			component_id: configData.hapi.compId,
						 				filter: "compInfo"
					        			};
								
								presenter.getCompConfDetail(uri, 
								{
									success : function(compdata) {
									onComponentConfigDataSuccess(uri, compdata, browserType);
									var message = data.hapi.baselines.baseline[0].components.component.status;
									notifications.show(message, 'ok');
									notificationsView.add({
										status : 'info',
										timestamp : (new Date().toISOString()),
										details: message
									});
								
								$(CONFIG_DIALOG_MSG).show();
								$("#hpsum-comp-cfg-msg").html(message);
								$(IMPORT_CANCEL).trigger('click');
									},
									error : function(errorInfo) {
									}
								});
							},
							error : function(data) {
								var message = data.hapi.baselines.baseline[0].components.component.status;
								notifications.show(message, 'error');
								$(IMPORT_ERROR_MSG).show();
								$(IMPORT_ERROR_MSG).text(message);
								$(IMPORT_ERROR_MSG).addClass("hp-error");
							}
						});
					}
				});
			}
			
		
			
			function getSrcElem(browserType, e){
				var srcElem;
				if(browserType==1){
				srcElem = e.target;//Firefox
				}
				else{
				srcElem = e.srcElement;//Chrome and IE
				}
				return srcElem;
			}
            function onComponentDataError(errorInfo) {
            }

            function onItemError(errorMessage) {
            }
            
            function onSelectionChange(selection) {
                //urlFragment.replaceHrefUris(HEADER + ', ' + PANEL_SELECTOR, selection.uris);
				urlFragment.replaceHrefUris(HEADER,
                    selection.uris, selection.multiSelectId);
                if ($(HEADER).hasClass('hp-show-init')) {
                    $(HEADER).removeClass('hp-show-init');
                } else {
                    $(HEADER).addClass('hp-show-changing');
                    //$(ACTIONS).addClass('hp-disabled');
                }
            }
            
           /* function onChange() {            	
            	var selection = $(SCHEDULE_TYPE).hpSelect('get');
            	$('#rec-every-for-schedule').text = selection;            	
            }
            */
            function onItemDeleteSuccess(item_name) {
                //notifications.show("Deleted " + item_name);
                deleteInProgress = false;
                
                var locations = indexService.getLocations();
				if(locations.length == 1) {
					var html = '<li data-id="all" class="hp-selected">' + localizer.getString("hpsum.common.all") + '</li>';
					$('#locations', PAGE).html(html);
                }
                
                deleteInfoDialog.dialog("close");
                deleteInProgress = false;
            }

            /**
             * @private
             */
            function onItemDeleteError(data) {
               notifications.show(errorMessage);
                // real product code should also ensure hp-details-notify
                // is populated via item state
                deleteInProgress = false;
			}

            /**
             * @private
             */
            function onDeleteItem(ev) {
			$('#hpsum-baseline-delete-title-message').show();								
			$(DELETE_IN_PROGRESS_SPAN).hide();
			if($(DELETE_ACTION).hasClass("hp-disabled")) 
				{
                    ev.preventDefault();
                    return;
                }
			$(DELETE_BASELINE_NODES_TABLE).dataTable().fnClearTable();
			$('#hpsum-delete-baseline-nodes-span').show ();
				canbedeleted = false;
				var text, textMessage, noofnodes;
				if (! deleteInProgress) {
                    deleteInProgress = true;
					presenter.getAssociatedNodes(baselineItem, {
                        		success : function(data) {
									var tableNodes = [];
									var l_nodelist = data.hapi.nodes.node;
									noofnodes = l_nodelist.length;
									if (data.hapi.nodes.actively_using_nodes == 0) {
										canbedeleted = true;
									}
									else {
										canbedeleted = false;
									}
									for (var idx = 0; idx < noofnodes; ++idx) {
									tableNodes.push({
									nodeurl: '<a id="hpsum-delete-baseline-node-click" href="#/node' + '/show/r' + l_nodelist[idx].node_uri + '/getdata">' + l_nodelist[idx].node_name + '</a>',
									type : l_nodelist[idx].type,
									status : l_nodelist[idx].node_status
								});
								
								}
								deleteInfoDialog.dialog({
								modal : true,
								dialogClass : 'hp-simple-dialog',
								position : "center",
								draggable : false,
								resizable : false,
								width : 700	
							});
								$(DELETE_BASELINE_NODES_TABLE).dataTable().fnAddData(tableNodes);
								$(DELETE_BUTTON_NAME).removeAttr("disabled");
								$(CLOSE_BUTTON_NAME).removeAttr("disabled");
								if (canbedeleted == true) {
									$('#hpsum-baseline-delete-ok').show();
									if (noofnodes != 0) {
										text = localizer.getString("hpsum.baseline.remove.baseline") + baselineItem.baseline_url + localizer.getString("hpsum.baseline.remove.association") + noofnodes + localizer.getString("hpsum.baseline.remove.nodes") + localizer.getString("hpsum.baseline.remove.continueDel");
										textMessage = localizer.getString("hpsum.baseline.remove.deleteMessage");
									}
									else	{
										text = localizer.getString("hpsum.baseline.remove.delWarningNoNode");
										textMessage = "";
										$('#hpsum-delete-baseline-nodes-span').hide ();
									}
									$(DELETE_TITLE).text (text);
									$('#hpsum-baseline-delete-title-message').text (textMessage);
									deleteInfoDialog.dialog("open");
								}
								else {
										$('#hpsum-baseline-delete-ok').hide();
										text = localizer.getString("hpsum.baseline.remove.baseline") +baselineItem.baseline_url + localizer.getString("hpsum.baseline.remove.currentlyAssign") +noofnodes + localizer.getString("hpsum.baseline.remove.assignNodes");
										textMessage = localizer.getString("hpsum.baseline.remove.delWarning") + data.hapi.nodes.actively_using_nodes + localizer.getString("hpsum.baseline.remove.activelyUse");
										$(DELETE_TITLE).text (text);
										$('#hpsum-baseline-delete-title-message').text (textMessage);
										deleteInfoDialog.dialog("open");
									}
								},
								
                       			 error : function(data) {
								 }
                    			});				
                }
				deleteInProgress = false;
			}
               //eleteInProgress = false;
              //ev.preventDefault();
            //}


            /**
             * @private
             */
            function onAbortItem(ev) {
				if($(ABORT_ACTION).hasClass("hp-disabled")) 
				{
                    ev.preventDefault();
                    return;
                }
            	//var textMessage;
            	abortInfoDialog.dialog({
								modal : true,
								dialogClass : 'hp-simple-dialog',
								position : "center",
								draggable : false,
								resizable : false,
								width : 700	
							});
            	
            	$(ABORT_TITLE).text (localizer.getString("hpsum.common.abortMessage"));
            	$('#hpsum-baseline-abort-ok').show();
            	$('#hpsum-baseline-abort-title-message').text (localizer.getString("hpsum.common.abortWarning"));
            	abortInfoDialog.dialog("open");
			}

			function onItemAbortSuccess(item_name) {
                abortInProgress = false;

                notificationsView.clear();
                notificationsView.add({
									status : 'running',
									//summary : "Abort is successful",
									summary : "Abort is accepted and is in progress..",
									timestamp : (new Date().toISOString()),
									changing : true
							}); 
				showAbortWait();
            }

            function onItemAbortError(data) {
               //notifications.show(errorMessage);
                // real product code should also ensure hp-details-notify
                // is populated via item state
                 notificationsView.clear();
                notificationsView.add({
									status : 'running',
									summary : "Abort is unsuccessful",
									timestamp : (new Date().toISOString()),
									changing : true
							}); 
                abortInProgress = false;
			}

			function showAbortWait() {
					if(aborttimer)
					{
						clearInterval(aborttimer);
						aborttimer = null;
					}
					if (!abortWaitDialog) {
						abortWaitDialog = $(SPLASH_DIALOG);
						abortWaitDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							width : 260,
							height : 180
						});
					}
					
					$(SPLASH_SPINNER).show();
					
					abortWaitDialog.dialog('open');
					var abortItem = 	{
	                					location_id: abortBaselineItem.location_id,
					        			baseline_id: abortBaselineItem.baseline_id
					        		};
					aborttimer = setInterval(function () {
            		var bStopTimer = false;
            		presenter.getBaselineStatus(abortItem, {
                				success : function(data) {
                    				if(data.hapi.baseline_state === "abort_completed") {
                    					closeAbortWait();
                    					clearInterval(aborttimer);
										aborttimer = null;
                    				}
                    		 	},
                    			error : function(errorInfo) {
                        			onBaselineStatusError(errorInfo);
                    			}
                			});
                }, 3000);				
				}

			function closeAbortWait() {
				
				$(SPLASH_SPINNER).hide();

				if (abortWaitDialog) {
					abortWaitDialog.dialog('destroy');
				}
				
				if (aborttimer)
				{
					clearInterval(aborttimer);
					aborttimer = null;
				}
				hashManager.replaceHash('/baseline/show');
			}

            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            
            /**
             * @public
             */
             
            this.pause = function () {
            	$(COMPONENT_TABLE).dataTable().fnClearTable();
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                if(timer)
                	clearInterval(timer);
            };
            
            this.resume = function () {
            	$(ABORT_ACTION).addClass('hp-disabled');
				$(DELETE_BUTTON_NAME).removeAttr("disabled");
				$(CLOSE_BUTTON_NAME).removeAttr("disabled");
				$('#hpsum-delete-baseline-nodes-span').show ();
				$(CONFIG_DIALOG_MSG).hide();
				$(BASELINE_WARNING_IMG).hide();
            	$(COMPONENT_TABLE).dataTable().fnClearTable();
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                if(timer)
                {
                	clearInterval(timer);
                	timer = null;
                }
            };
            
            this.init = function() {
			
            	$(SCHEDULE_DATE_AND_TIME).datetimepicker({ dateFormat: "yy-mm-dd"});
            	scheduleDialogContents = $(SCHEDULE_DIALOG).detach().show();
            	deleteDialogContents = $(DELETE_DIALOG).detach().show();

                detailsShowView.init();
                $('.hp-details-actions').hpDropMenu();
                notificationsView.init($(VIEW), '#/baseline/show/alerts');
                
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                
                $(ABORT_ACTION).addClass('hp-disabled');
                $(DELETE_ACTION).bind('click', onDeleteItem);
                $(ABORT_ACTION).bind('click', onAbortItem);
                $(DELETE_BUTTON_NAME).removeAttr("disabled");
				$(CLOSE_BUTTON_NAME).removeAttr("disabled");
                $(DELETE_IN_PROGRESS_SPAN).hide();
				
                $(COMPONENT_TABLE + ' tbody td').click( function () {
				    // Get the position of the current data from the node
				    var aPos = $(COMPONENT_TABLE).dataTable().fnGetPosition( this );
				     
				    // Get the data array for this row
				    var aData = $(COMPONENT_TABLE).dataTable().fnGetData( aPos[0] );
				     
				    
				});
                
                //Sample data added here to show contents section in the Details pane
                /*
                var data = [{component_file_name: "1", package_name: "HP System Management Home page for Windows", component_version: "6.10.002"},
				    {component_file_name: "2", package_name: "Headless Server Registry update for Windows", component_version: "4.2.021"}];
				*/
				var compId;    
				var oTab = $(COMPONENT_TABLE).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString("hpsum.baseline.show.noComponentsFound"),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : true,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [				        
                        {mDataProp: 'component_file_name',
                fnRender: function (oObj) {
                    return '<a href="javascript:void(0);">'+ oObj.aData.component_file_name + '</a>';
                }},

				        {mDataProp: 'package_name'},
				        {
				            mDataProp: 'product_typeInString',
				            fnRender: function (oObj) {
				                switch(oObj.aData.product_typeInString.toUpperCase()){
                                case 'FIRMWARE':
                                return localizer.getString("hpsum.common.firmware");
                                 case 'DRIVER':
                                return localizer.getString("hpsum.common.driver");
                                 case 'PCI':
                                return localizer.getString("hpsum.common.pci");
                                 case 'UTILITY':
                                return localizer.getString("hpsum.common.utility");
                                 case 'SOFTWARE':
                                return localizer.getString("hpsum.common.software");
                                default:
                                return oObj.aData.product_typeInString;
                                }
				            }
				        },
				        {
				            mDataProp: 'criticality',
				            fnRender: function (oObj) {
                             switch(oObj.aData.criticality.toUpperCase()){
                                case 'OPTIONAL':
                                return localizer.getString("hpsum.common.optional");
                                 case 'RECOMMENDED':
                                return localizer.getString("hpsum.common.recommended");
                                 case 'CRITICAL':
                                return localizer.getString("hpsum.common.critical");
                                 case 'UNKNOWN':
                                return localizer.getString("hpsum.common.unknown");                            
                                default:
                                return oObj.aData.criticality;
                                }				              
				            }
				        },
				        {mDataProp: 'component_version'},
						{mDataProp: 'reboot_required',
						fnRender: function (oObj) {
							if(oObj.aData.reboot_required == true)
								return localizer.getString("hpsum.common.yes");
							else if(oObj.aData.reboot_required == false)
								return localizer.getString("hpsum.common.no");
						}},
						{mDataProp: 'config_required', sDefaultContent: "",
                        fnRender: function (oObj) {
						if(oObj.aData.config_required == true) {
						compId = oObj.aData.component_id;
						compId = compId.replace(/(:|\.)/g,'');
							if(oObj.aData.is_configured == false)
							{
							    return '<a id="hpsum-NC-' + compId + '" style="white-space:nowrap" href="javascript:void(0);">' + localizer.getString('hpsum.baseline.show.needConfig') + '</a><a id="hpsum-C-' + compId + '" href="javascript:void(0);" style="display: none; white-space:nowrap">' + localizer.getString('hpsum.baseline.addBaseline.configured') + '</a>';
							}
							else
							{
								return '<a id="hpsum-C-'+compId+'" href="javascript:void(0);" style="white-space:nowrap">' + localizer.getString('hpsum.baseline.addBaseline.configured') +'</a>';
							}
						}
							return '<div align="center" class=""></div>'; },
                        sWidth: 15}],
				    	aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
				 
				 
				var oMissingTab = $(MISSINGCOMPONENT_TABLE).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString("hpsum.baseline.show.noComponentsFound"),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : true,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [	
						{mDataProp: 'component_file_name',
						fnRender: function (oObj) {
						return oObj.aData.component_file_name;
						}},
						{mDataProp: 'status',
						fnRender: function (oObj) {
						return oObj.aData.status;
					}, sWidth: '180px'},
						
                        

				        {mDataProp: 'package_name', sDefaultContent:'NA'},
				        {mDataProp: 'product_typeInString', sDefaultContent:'NA'},
				        {mDataProp: 'criticality', sDefaultContent:'NA'},
				        {mDataProp: 'component_version', sDefaultContent:'NA'},
						{mDataProp: 'reboot_required', sDefaultContent:'NA',
						fnRender: function (oObj) {
							if(oObj.aData.reboot_required == true)
								return localizer.getString("hpsum.common.yes");
							else if(oObj.aData.reboot_required == false)
								return localizer.getString("hpsum.common.no");
						}},
						{mDataProp: 'retry', sDefaultContent:''}],
				    	aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
				
				 
				$(COMPONENT_TABLE + ' tbody tr').first().addClass('hp-selected');
				
				componentDialogContents = $(COMPONENT_DIALOG).detach().show();
				componentConfigDialogContents = $(COMPONENT_CONFIG_DIALOG).detach().show();
				exportConfigDialogContents = $(EXPORT_CONFIG_DIALOG).detach().show();
				importConfigDialogContents = $(IMPORT_CONFIG_DIALOG).detach().show();
			    	importConfirmDialogContents = $(IMPORT_CONFIRM_DIALOG).detach().show();

			    router.watch('baseline show section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
				//var dummyNodeData = [];
				deleteInfoDialog = $(DELETE_DIALOG_ERROR);
				abortInfoDialog = $(ABORT_DIALOG);

				$(DELETE_BASELINE_NODES_TABLE).dataTable({
				oLanguage : {
				    sEmptyTable: localizer.getString("hpsum.group.noMoreNodesAvailable"),
				    sSearch: localizer.getString('hpsum.common.search')
						},
				bPaginate : false,
				sScrollY: "250px",
				bFilter : true,
				bInfo : false,
				bAutoWidth : false,
				bRetrieve : true,
				//aaData : dummyNodeData,
				aoColumns : [{
					mDataProp : 'nodeurl'
				}, {
					mDataProp : 'type'
				}, {
					mDataProp : 'status'
				}],
				aaSorting : [[1, "asc"]],
				bScrollCollapse : true
				});
				
				$('#hpsum-delete-baseline-node-click').live('click', function(ev) {
					deleteInfoDialog.dialog("close");
					$(DELETE_BASELINE_NODES_TABLE).dataTable().fnClearTable();
				});
                
				$('#hpsum-baseline-delete-ok').live('click', function(ev) {
					//deleteInfoDialog.dialog("close");
					$(DELETE_TITLE).text('');
					$('#hpsum-baseline-delete-title-message').hide();									
					$(DELETE_IN_PROGRESS_SPAN).show();
					$(DELETE_BUTTON_NAME).attr("disabled","disabled");
					$(CLOSE_BUTTON_NAME).attr("disabled","disabled");
					$('#hpsum-delete-baseline-nodes-span').hide ();
										
					presenter.removeBaseline(baselineItem, {
                                    success : onItemDeleteSuccess,
                                    error : onItemDeleteError
                                });
				});
				$('#hpsum-baseline-delete-cancel').live('click', function(ev) {
					deleteInfoDialog.dialog("close");
					$(DELETE_BASELINE_NODES_TABLE).dataTable().fnClearTable();
				});

				$('#hpsum-baseline-abort-ok').live('click', function(ev) {
					if(!abortInProgress){
						abortInProgress = true;
						abortBaselineItem = baselineItem;
						presenter.abortBaseline(baselineItem, {
							success : onItemAbortSuccess,
							error : onItemAbortError
						});
	                }
					abortInProgress = false;
					abortInfoDialog.dialog("close");
				});

				$('#hpsum-baseline-abort-cancel').live('click', function(ev) {
					abortInfoDialog.dialog("close");
				});
						
				
						
				this.resume();
				
				
            };
			
			this.getCompData=function()
			{
				var tabledata=jQuery.makeArray( compData );
				return tabledata;
            };
            
        }

        return new BaselineShowView();
    }());
    
    return BaselineShowView;
});
