// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
    'hp/model/Session',
    'hp/core/LinkTargetBuilder',
    'text!hpsumpages/graphics/enclosure.html',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
	'hp/services/REST',
    'jquery',
    'hp/lib/jquery.hpGridPanels',
    'hp/lib/jquery.hpEllipsis',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter'],
function(presenter, urlFragment,router, session, linkTargetBuilder, enclosureGraphicHtml, noneHtml, localizer,rest) { "use strict";

    var EnclosureShowOverviewView = (function() {
        var BAYS = 32;
        var ROOT = '#tour-enclosure-show-overview';
        var PANELS = '.hp-grid-panels';
        var DESCRIPTION = '#hpsum-enclosure-description',
        	NAME = '#hpsum-enclosure-name',
        	MODEL = '#hpsum-enclosure-model',
        	BASELINE ='#hpsum-enclosure-bundle',
        	LOCATION ='#hpsum-enclosure-rack',
        	FIRMWARE_VERSION ='#hpsum-enclosure-fwversion',
        	MATRIXENABLED = '#hpsum-enclosure-matrix-enabled',
        	MATRIXVERSION = '#hpsum-enclosure-matrix-version',
			GROUP = '#hpsum-server-group',
			ASSOC_DEVICES_SERVER = '#hpsum-enclosure-assocdevices-server',
 			ASSOC_DEVICES_SWITCHES = '#hpsum-enclosure-assocdevices-switches',
        	NO_ASSOC_DEVICES ='#hpsum-enclosure-no-devices',
        	SPINNER = '#hpsum-node-add-spinner';
        var SERVERS_GRAPHIC_CONTAINER = '#hp-enclosure-servers-graphic';
        var SWITCHES_GRAPHIC_CONTAINER = '#hp-enclosure-switches-graphic';
        var INSTALL_LOGS = '#hpsum-enclosure-install-log',
		    EDIT_GENERAL = '#hpsum-enclosure-general-edit';
      
        /**
         * Constructor
         */
        function EnclosureShowOverviewView() {
          
            var noItem;
            var thisNode= null;
            
            function onItemChange(item) {
            	item = item.hapi;
            	thisNode = item;
                noItem.remove();
                $(ASSOC_DEVICES_SERVER).html('');
 		        $(ASSOC_DEVICES_SWITCHES).html('');
                $(NO_ASSOC_DEVICES).show();
        		
        		item.type = item.type.toLowerCase();
        		var uitype = presenter.getUINodeType(item.type);
        		$(ROOT).closest('section').show();
        		
        		if(item.type == "sd2") {
        			if(!router.location().match(item.type))
        				router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
        		}
        		
        		if(!router.location().match(uitype)) {
        		    if(router.location().indexOf("/node") == 0)
        		    	router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')), "enclosure show overview");
        		    else {
        		    	$(ROOT).closest('section').hide();
        		      	return;
        		    }
                }
                
                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();
				
				$(EDIT_GENERAL).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
				if(item.node_state.match(/inventory/i) || item.node_state.match(/installhold/i) || item.node_state.match(/pendingfwupdate/i) ||
                   item.node_state.match(/activatependingfwupdate/i) || item.node_state.match(/scheduled/i) || item.node_state.match(/Install$/i) || 
				   item.node_state.match(/activate_pending/i)){
					$(EDIT_GENERAL).addClass('hp-disabled');
					$('.hp-disabled').css("color", "grey").bind('click.disable-link', function(e) {
						e.preventDefault();
						return false;
					});	
				}
				
        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        			// getNodeStatus(item);
        		}
        		else {
        			$(SPINNER).hide();
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');
        			$(SERVERS_GRAPHIC_CONTAINER).html('');
        			 $(SWITCHES_GRAPHIC_CONTAINER).html('');
        			$(DESCRIPTION).text(item.description);
        			var fwBaseline =presenter.getBaselineOrPkg(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  
        			
        			if(item.oa_name != undefined){
        				$(LOCATION).text(item.rack_name);
        				$(FIRMWARE_VERSION).text(item.fw_version);
        				$(NAME).text(item.oa_name);
        				$(MODEL).text(item.enclosure_type);
        				if ( item.auto_add_assoc_nodes == true )
						{
							var node_uri = "/Session/" + session.getToken() + "/node/" + item.node_id;
							rest.getURI(node_uri +"/getAssociatedNodesCompData",
							{
							
								nodeid : item.node_id,
								success : function(data) {
								var nodeAssoData = data.hapi.associated_nodes;
								showDevicesGraphic(item,nodeAssoData);
								showSwitchesGraphic(item,nodeAssoData);				  
								showAssociatedTargets(item,nodeAssoData);
								$(PANELS).hpGridPanels();
								onResize();
							},
								error : function(errorInfo){ }
							});
				}
        			}
        			else {
        				$(LOCATION).text('');
        				$(FIRMWARE_VERSION).text('');
        				$(NAME).text('');
        				$(MODEL).text('');
        			}
                    
                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();
        		}
                $(PANELS).hpGridPanels('reset');
				$(GROUP).text('');
					if( item.group_name.length == 0) {
						$(GROUP).text('none');
					}
					else {
				
						for(var iter=0 ; iter<item.group_name.length ; iter++)
						{
							var group_uri = '#/group/show/overview/r/session/'+ item.node_session + '/node/group/' + item.groups[iter]+'/getdata';
							
							//Code changes for placement. The code needs some spacing before the individual groups are appended.
							var uri = '<a href="'+group_uri+'">' +item.group_name[iter].group_name+ '</a>' ;
							if(iter == 0) {
								$(GROUP).append(uri);
							}
							else
							{
								$(GROUP).append('&nbsp;&nbsp;' + uri);
							}
								
						}
					}
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }

            
            function getNodeStatusString(nodeAssoc)
			{
			
			if ( nodeAssoc.node_state == undefined    || nodeAssoc.node_state=='')
			return 'unknown';
				if(nodeAssoc.node_state.match(/inventory|analysis|install$/i) ||nodeAssoc.node_phase.match(/initialize/i))
				{
					status = 'unknown';
				}
				if(nodeAssoc.node_state.match(/error/i))
					status = 'error';
				else if(nodeAssoc.node_state.match(/uan/i))
				{
					if(nodeAssoc.node_status.match(/No applicable/i))
						status = 'ok';
					else
						status = 'warning';	
				}
				else if(nodeAssoc.node_state.match(/installdone/i)) 
				{
					if(nodeAssoc.return_code == -2 || nodeAssoc.return_code == -3) 
					{
						status = 'error';
					} 
					else 
					{
						status = 'ok';
					}
				}
				else if(nodeAssoc.node_state.match(/idle/i)) 
				{
					if(nodeAssoc.node_phase.match(/unknown/i))
						status = 'error';
					else if (nodeAssoc.node_phase.match(/Initializing/i))
						status = 'unknown';
					else
						status = 'warning';
				}
				return status;
			} 
			
            function onItemError(error) {
                $(ROOT).append(noItem);
            }
            
            function showDevicesGraphic(item,nodeAssoData){
			   	if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id )
								nodeAssoData.node = new Array(nodeAssoData.node);
				if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id==undefined)
					return;
				if(nodeAssoData.node.length==0)
					return;
            	var enclosureGraphic = $(enclosureGraphicHtml);
                var devicesGraphic = $('.hp-enclosure.hp-horizontal.hp-small', enclosureGraphic);
            	$(NO_ASSOC_DEVICES).hide();
				
				var blades = {};
				var full_hight_blade = {};
				// Iterate all devices and each device information
				for(var i=0; i<nodeAssoData.node.length; i++){	
					if ( nodeAssoData.node[i].device == 'Associate'){
						var bayNumber = Number(nodeAssoData.node[i].location);
						if(bayNumber > BAYS){
						    bayNumber = nodeAssoData.node[i].location - BAYS;
						}
						else if(bayNumber > BAYS/2){
						    bayNumber = nodeAssoData.node[i].location - BAYS/2;
						}
						var node_status_string = getNodeStatusString(nodeAssoData.node[i]);
						var contents = getBayInfomation(nodeAssoData.node[i],node_status_string);
						if(blades.hasOwnProperty(bayNumber)){
						    contents = blades[bayNumber] + contents;						
						}
					
						blades[bayNumber] = contents;					
						if (nodeAssoData.node[i].IsFullHeightBlade){
						    full_hight_blade[bayNumber+BAYS/4] = contents;
						}
					}
				}
				
				// Fill each device information
				for(var j=1; j<17; j++){
					var id = '#hpsum-enclosure-bay'+ j;
            		if(blades.hasOwnProperty(j)){
						contents = blades[j];						
					}
					else if(full_hight_blade.hasOwnProperty(j)){
						contents = full_hight_blade[j];
					}
					else{
            			contents = '<div class="hp-unset">empty</div>';
            			$(id,devicesGraphic).addClass('hp-empty');
            		}
					
            		$(id,devicesGraphic).html(contents);					
					if(full_hight_blade.hasOwnProperty(j)){
						var label = $(devicesGraphic).find(id);
						(label).parent().find('label').html(' ');
					}
            	}
				
            	$('> label', devicesGraphic).text('');
				$('#hpsum-server-graphic').html('');
				$(SERVERS_GRAPHIC_CONTAINER).html('');
                $(SERVERS_GRAPHIC_CONTAINER).append(devicesGraphic);
                   $('#hpsum-enclosure-logical').click(function () {
                    $('#hpsum-server-graphic').removeClass('hp-physical');
                });
                $('#hpsum-enclosure-physical').click(function () {
                    $('#hpsum-server-graphic').addClass('hp-physical');
                });
            	$(ROOT + ' .hp-status').hpStatus(); 
            }
            
			function getBayInfomation(item, status){	
			
				var contents='';
				if(item.node_id){							
					var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ item.node_id+'/getData';
					contents += '<div class="hp-status">'+status+'</div>';
					contents += '<div class="hp-device-name">'+ '<a href= "' + assoc_node_url + '">' +item.ip_or_dns+'</a>'  + '</div>';
					//contents += '<div class="hp-device-product">'+ item.productName + '</div>';
					contents += '<div class="hp-device-model">' + item.type + '</div>';
				}
				else
				{
					contents += '<div class="hp-status">'+status+'</div>';
					contents += '<div class="hp-device-name">' + item.ip_or_dns + '</div>';
					//contents += '<div class="hp-device-product">'+ item.productName + '</div>';
					contents += '<div class="hp-device-model">' + item.type + '</div>';
				}
				return contents;
			}
			
            function showSwitchesGraphic(item,nodeAssoData){
				if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id )
								nodeAssoData.node = new Array(nodeAssoData.node);
				if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id==undefined)
					return;
				if(nodeAssoData.node.length==0)
					return;
					
            	var enclosureGraphic = $(enclosureGraphicHtml);
                var switchesGraphic =
                    $('.hp-enclosure.hp-vertical.hp-small', enclosureGraphic);
            	$(NO_ASSOC_DEVICES).hide();
            	
            	for(var j=1; j<9; j++){
            		var found = false;
            		for(var i=0; i<nodeAssoData.node.length; i++){	
					if (nodeAssoData.node[i].device=='Interconnect'){
            			if(nodeAssoData.node[i].location == j){
            					found =true;
            					break;
            				}
            		}
					}
            		var id = '#hpsum-enclosure-bay'+ j;
						var contents='';
            		if(found){
						if(nodeAssoData.node[i].node_id ){
							var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ nodeAssoData.node[i].node_id+'/getData';
							contents += '<div class="hp-status">'+getNodeStatusString(nodeAssoData.node[i])+'</div>';
							contents += '<div class="hp-device-name">'+ '<a href= "' + assoc_node_url + '">' +nodeAssoData.node[i].ip_or_dns+'</a>'+ '</div>';
							//contents += '<div class="hp-device-product">' + nodeAssoData.interconnect_device[i].productName + '</div>';
							contents += '<div class="hp-device-model">' + nodeAssoData.node[i].type + '</div>';
						}
						else
						{
							contents += '<div class="hp-status">'+getNodeStatusString(nodeAssoData.node[i])+'</div>';
							contents += '<div class="hp-device-name">' + nodeAssoData.node[i].ip_or_dns + '</div>';
							//contents += '<div class="hp-device-product">' + nodeAssoData.interconnect_device[i].productName + '</div>';
							contents += '<div class="hp-device-model">' + nodeAssoData.node[i].type + '</div>';
						}
            		}
            		else{
            			contents = '<div class="hp-unset">empty</div>';
            			$(id,switchesGraphic).addClass('hp-empty');
            			}
            		$(id,switchesGraphic).html(contents);
            			
            	}
            	$('> label', switchesGraphic).text('');
				$('#hpsum-switch-graphic').html('');
				$(SWITCHES_GRAPHIC_CONTAINER).html('');
                $(SWITCHES_GRAPHIC_CONTAINER).append(switchesGraphic); 
                $(ROOT + ' .hp-status').hpStatus();          	
            }
            
function showAssociatedTargets(item,nodeAssoData)
{
	if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id )
					nodeAssoData.node = new Array(nodeAssoData.node);
	if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id==undefined)
		return;
	if(nodeAssoData.node.length==0)
		return;
	$(NO_ASSOC_DEVICES).hide();
	//var tablecontents = "<table><tr> <td> <u>Device type </u> </td> <td> <u>IP/DNS</u> </td></tr>";
	var tablecontents1 = "<table><tr> <td> <u>" + localizer.getString('hpsum.enclosure.deviceType') + "</u> </td> <td> <u>" + localizer.getString('hpsum.common.ipDns') + "</u> </td></tr>";
	var tablecontents2 = "<table><tr> <td> <u>" + localizer.getString('hpsum.enclosure.deviceType') + "</u> </td> <td> <u>" + localizer.getString('hpsum.common.ipDns') + "</u> </td></tr>";
	for(var i=0; i<nodeAssoData.node.length; i++)
	{
		if(nodeAssoData.node[i].device=='Associate')
		{
			if(nodeAssoData.node[i].node_id)
			{
				var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ nodeAssoData.node[i].node_id+'/getData';
				tablecontents1 += "<tr><td>" + nodeAssoData.node[i].type +' '+ nodeAssoData.node[i].productName
					+'</td><td>' + '<a href= "' + assoc_node_url + '">' +nodeAssoData.node[i].ip_or_dns+'</a>' + '</td></tr>';
			}
			else
			{
				tablecontents1 += "<tr><td>" + nodeAssoData.node[i].type +' '+ nodeAssoData.node[i].productName
				+'</td><td>' + nodeAssoData.node[i].ip_or_dns + '</td></tr>';
			}
		
		}
		if(nodeAssoData.node[i].device=='Interconnect')
		{
			if(nodeAssoData.node[i].node_id)
			{
				var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ nodeAssoData.node[i].node_id+'/getData';
				tablecontents2 += "<tr><td>" + nodeAssoData.node[i].type +' '+ nodeAssoData.node[i].productName
					+ '</td><td>' + '<a href= "' + assoc_node_url + '">' +nodeAssoData.node[i].ip_or_dns+'</a>' + '</td></tr>';
			}
			else
			{
				tablecontents2 += "<tr><td>" + nodeAssoData.node[i].type +' '+ nodeAssoData.node[i].productName
					+ '</td><td>' + nodeAssoData.node[i].ip_or_dns + '</td></tr>';
			}
			
		}
	}
	tablecontents1 += "</table>";
	$(ASSOC_DEVICES_SERVER).html(tablecontents1);
	tablecontents2 += "</table>";
	$(ASSOC_DEVICES_SWITCHES).html(tablecontents2);	
}
            
            function getNodeStatus(item){
            	 var  oaTimer = setInterval(function () {
            		
            		presenter.getNodeStatus(item, {
                				success : function(data, oaTimer) {
                    				onNodeStatusSuccess(data);
                    		 	},
                    			error : function(errorInfo, oaTimer) {
                        			onNodeStatusError(errorInfo);
                    			}
                			});
                			
                }, 3000);
            }
            
            function onNodeStatusSuccess(data,oaTimer){
            	if(thisNode.node_id == data.hapi.node_status.node_id) {
            	 if(!data.hapi.node_status.node_phase.match(/initialize/i)){
        			clearInterval(oaTimer);
        			oaTimer = 0;
        			presenter.refreshIndexResults();
        		}
        		}
            }   
            function onNodeStatusError(){
            	
            }  
            
            function onAssociationsChange(tree) {
                var bundle, rack, count, link;
                if (tree.parents.BUNDLE_TO_ENCLOSURE) {
                    bundle = tree.parents.BUNDLE_TO_ENCLOSURE[0].resource;
                }
                if (tree.parents.RACK_TO_ENCLOSURE) {
                    rack = tree.parents.RACK_TO_ENCLOSURE[0].resource;
                }
                
                if (bundle && bundle.uri) {
                    $('#tour-enclosure-bundle').html(linkTargetBuilder.makeLink(
                        bundle.name, bundle.uri)).removeClass('hp-unset hp-unavailable');
                } else {
                    $('#tour-enclosure-bundle').text('not set').
                        removeClass('hp-unavailable').addClass('hp-unset');
                }
                $('#tour-enclosure-bundle-item').removeClass('hp-show-changing');
                
                if (rack && rack.uri) {
                    $('#tour-enclosure-location').html(linkTargetBuilder.makeLink(
                        rack.name, rack.uri)).removeClass('hp-unset hp-unavailable');
                } else {
                    $('#tour-enclosure-location').text('not set').
                        removeClass('hp-unavailable').addClass('hp-unset');
                }
                $('#tour-enclosure-location-item').removeClass('hp-show-changing');
                if(tree.children.ENCLOSURE_TO_SERVER){
                	count = tree.children.ENCLOSURE_TO_SERVER.length;
                	link = linkTargetBuilder.makeCountLink('server', count,
                    	['f_an=ENCLOSURE_TO_SERVER', 'f_suri=' + tree.resource.uri]);
               		$('#hp-enclosure-servers .hp-count', ROOT).text(count);
                	$('#hp-enclosure-servers', ROOT).attr('href', $(link).attr('href'));
                }
                if(tree.children.ENCLOSURE_TO_SWITCH){
                count = tree.children.ENCLOSURE_TO_SWITCH.length;
                link = linkTargetBuilder.makeCountLink('switch', count,
                    ['f_an=ENCLOSURE_TO_SWITCH', 'f_suri=' + tree.resource.uri]);
                $('#hp-enclosure-switches .hp-count', ROOT).text(count);
                $('#hp-enclosure-switches', ROOT).attr('href', $(link).attr('href'));
                }
            }
            
            function onAssociationsError(error) {
                //console.log(error);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
                if ($(ROOT).hasClass('hp-show-init')) {
                    $(ROOT).removeClass('hp-show-init');
                } else {
                    $(ROOT).addClass('hp-show-changing');
                    $('#tour-server-bundle-item').addClass('hp-show-changing');
                }
            }
            
            function onResize() {
                var servers = $('#hp-enclosure-servers-graphic').
                    parents('.hp-panel-contents-container');
                if (servers.width() < 700 || servers.height() < 400) {
                    $('.hp-enclosure', servers).removeClass('hp-vertical').
                        addClass('hp-horizontal hp-small');
                        $('.hp-device-product').hide();
                } else {
                    $('.hp-enclosure', servers).
                        removeClass('hp-horizontal hp-small').
                        addClass('hp-vertical');
                        $('.hp-device-product').show();
                }
                var switches = $('#hp-enclosure-switches-graphic').
                    parents('.hp-panel-contents-container');
                if (switches.width() < 700 || switches.height() < 250) {
                    $('.hp-enclosure', switches).addClass('hp-small');
                    $('.hp-device-product').hide();
                } else {
                    $('.hp-enclosure', switches).removeClass('hp-small');
                    $('.hp-device-product').hide();
                }
            }
          
            /**
             * @public
             */
            this.resume = function() {
                $(PANELS).hpGridPanels('reset');
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
                presenter.on("associationsChange", onAssociationsChange);
                $(window).on('resize', onResize);
                onResize();
            };
            
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                presenter.off("associationsChange", onAssociationsChange);
                $(window).off('resize', onResize);
            };
             
            this.init = function() {
                var enclosureGraphic = $(enclosureGraphicHtml);
                
                var switchesGraphic =
                    $('.hp-enclosure.hp-vertical.hp-small', enclosureGraphic);
                  
                if(!presenter.initialized())
                	presenter.init();
                
                noItem = $(noneHtml);
                $(PANELS).hpGridPanels();
                $(DESCRIPTION).hpEllipsis();
                
 
                
                $(ROOT + ' .hp-status').hpStatus();

                
                this.resume();
            };
        }

        return new EnclosureShowOverviewView();
    }());
    
    return EnclosureShowOverviewView;
});
