// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['jquery', 'hp/lib/jquery.hpStatus'],
function() { "use strict";

    var GraphicsMapView = (function() {
      
        var CANVAS = '.hp-map canvas';
        var MAP = '.hp-map';
        
        /**
         * Constructor
         */
        function GraphicsMapView() {
          
            function itemLocation(item) {
                var itemPosition = item.position();
                return {left: (itemPosition.left + (item.width() / 2) + 35),
                    top: (itemPosition.top + (item.height() / 2) + 35)};
            }
          
            function connect(context, item1, item2, color) {
                var position1 = itemLocation(item1);
                var position2 = itemLocation(item2);
                context.beginPath();
                context.lineWidth = 8;
                context.lineCap = 'round';
                context.strokeStyle = color;
                context.moveTo(position1.left, position1.top);
                context.quadraticCurveTo(
                    position1.left + ((position2.left - position1.left) / 2),
                    position1.top,
                    position2.left, position2.top);
                context.stroke();
            }
          
            function draw() {
                var map = $(MAP);
                var canvas = $(CANVAS)[0];
                $(CANVAS).attr('width', map.width()-2).attr('height', map.height()-2);
                if (canvas.getContext) {
                    var context = canvas.getContext('2d');
                    context.clearRect(0, 0, canvas.width, canvas.height);
                    connect(context, $('#item1'), $('#item2'), 'rgba(82, 134, 30, 0.5)');
                    connect(context, $('#item1'), $('#item3'), 'rgba(255, 153, 0, 0.5)');
                    connect(context, $('#item2'), $('#item4'), 'rgba(82, 134, 30, 0.5)');
                    connect(context, $('#item3'), $('#item4'), 'rgba(255, 153, 0, 0.5)');
                }
            }
          
            /**
             * @public
             */
            this.init = function() {
                $('.hp-status').hpStatus();
                draw();
            };
        }

        return new GraphicsMapView();
    }());
    
    return GraphicsMapView;
});
