// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (GroupDeployView)
 * This is a view class for Group Deploy View.
 */
define(['hpsum/presenter/group/GroupPresenter',
    'hpsum/presenter/node/NodePresenter',
	'hp/core/Router',
	'hp/core/UrlFragment',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
	'hp/view/DialogView',
	'hp/core/Localizer',
	'hp/view/FormStateView',
    'jquery',
    'hpsum/view/node/jquery.hpsumInstallables',	
    'hpsum/view/node/jquery.hpsumWarnings',	
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery.dataTables.rowReordering',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',	
	'hp/lib/jquery.hpSearchCombo'
	],

function(presenter, nodePresenter, router, urlFragment, notifications, helpMenu, DialogView, localizer, FormStateView) {"use strict";

	var GroupDeployView = ( function() {

		//Consts can go here
		var DEPLOY = '#hpsum-group-deploy-ok',
			RESET = '#hpsum-group-reset',
			CANCEL = '#hpsum-group-deploy-close',
			DEPLOY_CONTENTS = '#hpsum-group-deploy',
			GROUP_NODE_DEPLOY_CONTENT = '#hpsum-group-node-deploy-data',
			PANEL_SELECTOR = '#hpsum-deploy-panel-selector',
			FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
			FORM = '#hpsum-group-deploy-add-form',
			PANELS = '#hpsum-group-deploy-panels',
			NAME = '#hpsum-group-deploy-name',
			REBOOTOPTION = '#hpsum-deploy-reboot-option',
			INSTALLATIONOPTION = '#hpsum-installation-option',
			DELAYSEC = '#hpsum-group-deploy-delay-seconds',
			DELAYSECERR = '#hpsum-group-deploy-delay-seconds-err',
			MESSAGE = '#hpsum-group-deploy-reboot-message',
			ROUTE_PREFIX = '/group/deploy',
			COMPVERBOSEOPTION = '#hpsum-comp-verbose-checkbox',
			NONECHECKBOX = '.nonecheckbox',
			USESNMPCHECKBOX = '.useSNMPcheckbox',
			USEAGENTLESSCHECKBOX = '.useAgentlesscheckbox',
			USEWEBEMCHECKBOX = '.useWEBEMcheckbox',
			DOWNGRADECHKBOXCOMP = '.downgradechkbox',
			REWRITECHKBOXCOMP = '.rewritechkbox',
			FIRMWARECHKBOXCOMP = '.firmwarechkbox',
			SOFTWARECHKBOXCOMP = '.softwarechkbox',
			SPLASH_DIALOG = '#hpsum-group-analysis-dialog',
			SPLASH_SPINNER = '#hpsum-group-analysis-spinner',
			THROBBER = '#hpsum-group-deploy-throbber',
			SCHEDULETOGGLE = '#hpsum-group-schedule-enable',
			DATETIMESECTION = '#hpsum-group-schedule-datetimepick',
			SCHEDULE_DATE = '#hpsum-group-schedule-date',
			SCHEDULE_TIME = '#hpsum-group-schedule-time',
			SCHEDULE_TIME_LABEL = '#hpsum-node-schedule-time-label',
			SCHEDULE_WARNING = '#hpsum-group-schedule-warning',
			SCHEDULE_LIST = '#hpsum-group-node-list',
			CURRENT_DATETIME = '#hpsum-group-current-datetime',
			INSTALL_ERROR='#force-options-tbody-err',
			TIME_ZONE = '#hpsum-group-timezone',
			REBOOT_DISABLE = '.hpsum-otu-group-deploy-disable',
			REBOOT_DELAY_SEC = '60';
				
			/**
			 * Constructor
			 */
			function GroupDeployView() {
				var formStateView = new FormStateView();
				var groupItem = null,
				setAttributesOnGroup = false,
				analysisWaitDialog = null, 

				ForceOptions = { 
					hapi: {					
						installation_option:{
							downgrade: false,
							rewrite:false,
							force:false,
							firmware :false,
							software :false						
						},					
            		}
            	},
			
				defaultOptiondetails = { 
					hapi: {					
						reboot_options : {
							action : 'Never',
							delay : REBOOT_DELAY_SEC,
							message : 'Reboot at user request after deploy'
						},					
            		}
            	},

				optiondetails = defaultOptiondetails,
				nodeChanges = [],
				analysisNeededNodes = 0,
				initialGetattr = null;
			var scheduled_getdata_date_time = '',
				scheduled_getdata = '',
				schedaction = '',
				schedule_time = '',
				date_time_new = '',
				time_value = '',
				date_value = '',
				allNodesDetials = [],
				warningmsg = '';
				var failedDependencyCount = 0, 
				SelectedComponents = 0,
				deploy_flag = false,
				failedDependencyFlag = false,
				nodeCount=0,
				applyOptions = false;
				var isSelectionChanged = false;

				function onItemChange(item) {
					groupItem = item.hapi;

					if (groupItem) {
						$(NAME).text(groupItem.group_name);
						enableDeployBtn(true);
						loadAttributes();
						presenter.getNodesData(groupItem, {
							success : function(data) {
								allNodesDetials = [];
								if (data.hasOwnProperty('hapi')) {
									allNodesDetials = data.hapi.output_data.nodes.node;
									loadScheduleoptions(groupItem);
								}
								if(groupItem.group_state.match(/UAN/i) && (groupItem.group_phase.match(/UserActionNeeded|NoComponents/i)))
									populateDeployData();
							},
							error : function(data) {
							}
						});
						
						
					} else {
						$(CANCEL).trigger('click');
					}
				}
				
				function loadAttributes()
				{
					presenter.getAttributes(groupItem, {
						success : function(data) {
							if(data.hapi.hcode == 0)
								showoptions(data);
						},
						error : function(data) {
						}
					});
				}
				
				function setoptiondetails() {
					var atleastOneOptionSelected = false;

					optiondetails.hapi.reboot_options.action = $(REBOOTOPTION).val();
					
					if (($(DELAYSEC).val() != '') && ($(DELAYSEC).val().match(/^[0-9]+$/) !== null)) {
						optiondetails.hapi.reboot_options.delay = $(DELAYSEC).val();
					}
					
					if ($(MESSAGE).val() != '') {
						optiondetails.hapi.reboot_options.message = $(MESSAGE).val();
					}
					if($(COMPVERBOSEOPTION).is(':checked'))
					{
						optiondetails.hapi.verbose = true;
						atleastOneOptionSelected = true;
					}
					if(initialGetattr.hapi.reboot_options.action != optiondetails.hapi.reboot_options.action ||
						initialGetattr.hapi.reboot_options.delay != optiondetails.hapi.reboot_options.delay ||
						initialGetattr.hapi.reboot_options.message != optiondetails.hapi.reboot_options.message) {
						atleastOneOptionSelected = true;
					}
					
					if (!atleastOneOptionSelected) {
						optiondetails.hapi.reboot_options = {};
					} else {
						setAttributesOnGroup = true;
					}
					atleastOneOptionSelected = false;
				}
				
				function applyInstallationOptions()
				{
					deploy_flag = false;
					getInstallationOptions();
					if(applyOptions){
						showAnalysisWaitDialog(true);
						formStateView.setMessage({
							summary: localizer.getString("hpsum.node.installationOptions.applyingOptions"),
							status: 'ok',
							changing: true,
						});
						presenter.setAttributes(groupItem,ForceOptions, {
							success : function(data){
							},
							error : onSetattributeError
						});
						
						getGroupStatus();
					}
				}
				
				function  getInstallationOptions()
				{
					var type = $(INSTALLATIONOPTION).val();
					ForceOptions.hapi.installation_option = {};
								 
					ForceOptions.hapi.installation_option.downgrade = false;
					ForceOptions.hapi.installation_option.rewrite   = false;
					ForceOptions.hapi.installation_option.software = false;
					ForceOptions.hapi.installation_option.firmware = false;
					ForceOptions.hapi.installation_option.forcesoftware = false;
					ForceOptions.hapi.installation_option.forcefirmware = false;
					
					if ( type == "upgradeBoth"){
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.software = true;
					}
					else if ( type == "upgradeFirmware"){
						ForceOptions.hapi.installation_option.firmware = true;
					}
					else if ( type == "upgradeSoftware"){
						ForceOptions.hapi.installation_option.software = true;
					}					
					else if ( type == "downgradeFirmware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "downgradeSoftware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "downgradeBoth"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "rewriteFirmware"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "rewriteSoftware"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "rewriteBoth"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "firmware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "software"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "both"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					if(initialGetattr.hapi.installation_option.downgrade != ForceOptions.hapi.installation_option.downgrade ||
						initialGetattr.hapi.installation_option.rewrite != ForceOptions.hapi.installation_option.rewrite ||
						initialGetattr.hapi.installation_option.software != ForceOptions.hapi.installation_option.software ||
						initialGetattr.hapi.installation_option.firmware != ForceOptions.hapi.installation_option.firmware) {
						applyOptions = true;
					}
				}
				function showoptions(data)
				{
					initialGetattr = null;
					if(data && data.hasOwnProperty("hapi"))
					{
						initialGetattr = data;
						if(data.hapi.hasOwnProperty("reboot_options") && data.hapi.reboot_options)
						{
							$('#hpsum-deploy-reboot-option option').filter(function() {
							if(new RegExp(this.value, 'ig').test( data.hapi.reboot_options.action))
		    		            $(this).attr('selected', true);
							});
							if( -1 < data.hapi.reboot_options.delay){
								$(DELAYSEC).val(data.hapi.reboot_options.delay);				
							}
							else{
								$(DELAYSEC).val(REBOOT_DELAY_SEC);				
							}
						
							$(MESSAGE).attr('value', data.hapi.reboot_options.message);
							$(REBOOTOPTION).selectBox('reset');
						}
					
						if(data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option)
						{
							var rewriteOption = data.hapi.installation_option.rewrite;
							var downgradeOption = data.hapi.installation_option.downgrade;
							var firmwareOption = data.hapi.installation_option.firmware;
							var softwareOption = data.hapi.installation_option.software;
							
							if ( !rewriteOption  && !downgradeOption )
							{
								if(firmwareOption && softwareOption){
									$(INSTALLATIONOPTION).val('upgradeBoth');
								}
								else if(firmwareOption){
									$(INSTALLATIONOPTION).val('upgradeFirmware');
								}
								else if(softwareOption){
									$(INSTALLATIONOPTION).val('upgradeSoftware');
								}
							}
							else if ( rewriteOption  && downgradeOption )
							{
								if(firmwareOption && softwareOption)
									$(INSTALLATIONOPTION).val('both');
								else if(firmwareOption)
									$(INSTALLATIONOPTION).val('firmware');
								else if(softwareOption)
									$(INSTALLATIONOPTION).val('software');
							}
							else if ( rewriteOption )
							{
								if(firmwareOption && softwareOption)
									$(INSTALLATIONOPTION).val('rewriteBoth');
								else if(firmwareOption)
									$(INSTALLATIONOPTION).val('rewriteFirmware');
								else if(softwareOption)
									$(INSTALLATIONOPTION).val('rewriteSoftware');
							}
							else if ( downgradeOption )
							{
								if(firmwareOption && softwareOption)
									$(INSTALLATIONOPTION).val('downgradeBoth');
								else if(firmwareOption)
									$(INSTALLATIONOPTION).val('downgradeFirmware');
								else if(softwareOption)
									$(INSTALLATIONOPTION).val('downgradeSoftware');
							}
											
							$(INSTALLATIONOPTION).selectBox('reset');										
						}						
					}
				}

			function errormsg()
			{
				$(INSTALL_ERROR).hide();
			}

			function onSetattributeSuccess(item) {
				setAttributesOnGroup = false;
				performAnalysis();
			}

			function onSetattributeError(errorMessage) {
				notifications.show(errorMessage, 'error');
				enableDeployBtn(false)
				$(CANCEL).trigger('click');
				setAttributesOnGroup = false;
			}
			
			function performAnalysis() {
				var cContentId,
					installables,
					componentsList;
					
				for (var idx = 0; idx < nodeChanges.length; idx++) {
					if (nodeChanges[idx].selectionChanged == true ) {
						cContentId = '#hpsum-group-node-ccontent-' + nodeChanges[idx].node_id;
						installables = $(cContentId).data('plugin_hpsumInstallables');
						componentsList = installables.getComponents();

						nodePresenter.analysis({
							node_id : nodeChanges[idx].node_id
						}, 
						componentsList, {
							node_id : nodeChanges[idx].node_id,
							success : function(data) {
							},
							error : function(errorInfo) {
							}
						});
					}
				}
				if(isSelectionChanged){
					getGroupStatus();
					isSelectionChanged = false;
				}
				else
					onDeployContinue(); 
			}
				
			function getGroupStatus()
			{
				nodeCount = 0;
				failedDependencyFlag = false;
				var timer = setInterval(function() {
					presenter.getGroupStatus({group_id: groupItem.group_id}, {
						success : function(data) {
							if (data.hapi.hcode == 0) {
								if (data.hapi.group_status.match(/Ready to start deploy/)) {
									clearInterval(timer);			
									var componentCount = 0;
									for (var idx = 0; idx < nodeChanges.length; idx++) {
										componentCount += nodeChanges[idx].component_length;
										nodeChanges[idx].selectionChanged = false;
										
										$('#hpsum-group-node-ccontent-' + nodeChanges[idx].node_id).hpsumInstallables('recalculate'); 
									}
									closeAnalysisWaitDialog();
									if(applyOptions)
									{
										formStateView.setMessage({
											summary: localizer.getString("hpsum.node.installationOptions.optionsSuccess"),
											status: 'ok',
											changing: false,
										});
										applyOptions = false;
										loadAttributes();
									}
								}
							}
						},
						error : function(data) {
							clearInterval(timer);
							closeAnalysisWaitDialog();
						}
					});
				}, 10000); 

			}
			function onPopulateInstallSet(node_id)
			{
				if(deploy_flag)
				{
					var install = $('#hpsum-group-node-ccontent-' + node_id).data('plugin_hpsumInstallables');
					failedDependencyCount = install.failedDependencyCount();
					nodeCount++;
					if(failedDependencyCount > 0)
					{
						failedDependencyFlag = true;
						deploy_flag = false;
					}
					if(nodeCount == nodeChanges.length && !failedDependencyFlag)
					{
						nodeCount = 0;
						deploy_flag = false;
						onDeployContinue(); 
					}
				}
				
				if (nodeChanges.length > 0) {
					var bHasWindowsNode = false;
					for (var idx = 0; idx < nodeChanges.length; idx++) {
						if (nodeChanges[idx].node_type.match(/windows/i))
						{
							bHasWindowsNode = true;
							break;
						}
					}
					if (false === bHasWindowsNode)
					{
						$("#hpsum-comp-verbose-descr").hide();
						$(COMPVERBOSEOPTION).hide();
					}
					else
					{
						$("#hpsum-comp-verbose-descr").show();
						$(COMPVERBOSEOPTION).show();
					}		
				}
			}

			function onDeploy() {
				if(!validateRebootDelay())
					return;
				enableDeployBtn(false);

				deploy_flag = true;
				
				if(isSelectionChanged)	
					showAnalysisWaitDialog();
				
				setoptiondetails();
				
				setscheduleoptions(groupItem);
				if (setAttributesOnGroup) {
					presenter.setAttributes(groupItem, optiondetails, {
						success : onSetattributeSuccess,
						error : onSetattributeError
					});
				}
				else
					performAnalysis();
			}
			/**
			 * @private
			 * Continue the deploy procedure from the Analysis onwards 
			 */
			function onDeployContinue() {
			
				$(THROBBER).show();
									
				presenter.deploy(groupItem, {
					success : onDeploySuccess,
					error : onDeployError
				});
			}

			function enableDeployBtn(able) {
				$(DEPLOY).attr('disabled_org', able? 0:1);
				$('.ignorewarnings').each(function() {
					if (!$(this).is(':checked')) {
						able = false;
					}
				});
				if (able) {
					$(DEPLOY).removeAttr("disabled");
				} else {
					$(DEPLOY).attr('disabled', 'disabled');
				}
			}
			function onDeploySuccess(item) {
				$(THROBBER).hide();
				deploy_flag = false;
				notifications.show(groupItem.group_name + ' Group ' + localizer.getString("hpsum.group.deployStarted"), 'ok');
				$(CANCEL).trigger('click');
			}

			function onDeployError(errorMessage) {
				$(THROBBER).hide();
				notifications.show(errorMessage, 'error');
				$(CANCEL).trigger('click');
			}

			function changeLocation(location) {
				if (location.length > ROUTE_PREFIX.length) {
					$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
				} else {
					$(PANELS).hpStackedPanels('setFirstPanel');
				}
			}

			function populateOptions() {
				optiondetails = defaultOptiondetails;
				$(NONECHECKBOX).attr('checked', false);
				$(USESNMPCHECKBOX).attr('checked', false);
				$(USEAGENTLESSCHECKBOX).attr('checked', false);
				$(USEWEBEMCHECKBOX).attr('checked', false);
				$(INSTALLATIONOPTION).val('upgradeBoth');
				$(INSTALLATIONOPTION).selectBox('reset');
				$(REBOOTOPTION).selectBox('value', 'Never');
				$(INSTALL_ERROR).hide();
				$(DELAYSEC).val(REBOOT_DELAY_SEC);
				$('textarea' + MESSAGE).attr('value', 'Reboot at user request after deploy');
			}

			function populateDeployData() {
			
				var groupNodes = [],
					groupNodeData,
					id,
					contentid,
					name,
					htmlWarnings = '',
					htmlContents = '';
				nodeChanges = [];
				if(allNodesDetials.length != 0) {
					for(var itr =0; itr < allNodesDetials.length; itr++)
					{
						if(allNodesDetials[itr].node_state === "UAN") {
							groupNodes.push(allNodesDetials[itr]);
						}
					}
				}
				else
					return;
				
				for (var idx = 0; idx < groupNodes.length; idx++) {
					id = 'hpsum-group-node-collapse-' + groupNodes[idx].node_id;
					contentid = 'hpsum-group-node-ccontent-' + groupNodes[idx].node_id;
					name  = 'hpsum-group-node-cname-' + groupNodes[idx].node_id;
					htmlContents += '<div class ="my-collapsible" id ="' + id +
					'" data="' + groupNodes[idx].node_id + '"><label id ="'+ name +'" style="clear: both">' + groupNodes[idx].node_id + '</label>' +
					'<div id ="' + contentid + '"><label>Collapse Content</label></div></div>';
					htmlWarnings += '<div><label><b>' + groupNodes[idx].name + '</b></label><div id="hpsum-group-warnings-' + groupNodes[idx].node_id + '"></div></div><br />';
					$('#hpsum-group-node-cname-' + groupNodes[idx].node_id).html(groupNodes[idx].name);
					
					
					nodeChanges = nodeChanges.concat({
								node_id: groupNodes[idx].node_id,
								selectionChanged: false,
								node_name: groupNodes[idx].name,
								node_type: groupNodes[idx].type,
								component_length : 0,
								failed_dependency_cnt : 0
								/*
								is_schedule_running : data.hapi.is_schedule_running,
								scheduled : data.hapi.scheduled,
								node_type : data.hapi.type,
								schedule_date_time : data.hapi.schedule_date_time
								*/
								
								});
				}
				
				$(GROUP_NODE_DEPLOY_CONTENT, DEPLOY_CONTENTS).html(htmlContents);
				if (htmlWarnings.length > 0) {
					htmlWarnings += '<div><label><input class="useWEBEMcheckbox ignorewarnings-tbd" type="checkbox" />' + localizer.getString('hpsum.common.ignoreWarnings') + '</label></div>';
				}
				htmlWarnings = '<div id="hpsum-group-warnings-messages">' + htmlWarnings + '</div><div id="hpsum-group-no-warnings"><label>' + localizer.getString('hpsum.common.noWarnings') + '</label></div>'
				$('#hpsum-group-warnings').html(htmlWarnings);
				$('#hpsum-group-warnings-messages').hide();
				$('#hpsum-group-no-warnings').show();
				
				for (var idx = 0; idx < groupNodes.length; idx++) {
							$("#hpsum-group-nodename-" + groupNodes[idx].node_id).html(groupNodes[idx].name);
							$("#hpsum-group-warnings-" + groupNodes[idx].node_id).hpsumWarnings(groupNodes[idx], false);
							if (groupNodes[idx].warnings.length > 0) {
								if ($('.ignorewarnings-tbd')[0]) {
									$('.ignorewarnings-tbd').addClass('ignorewarnings').removeClass('ignorewarnings-tbd');
									$('#hpsum-group-warnings-messages').show();
									$('#hpsum-group-no-warnings').hide();
									$('.ignorewarnings').on('change', function(){
										if ($(this).is(':checked')) {
											$(DEPLOY).attr("disabled", $(DEPLOY).attr("disabled_org") == 1);
										} else {
											$(DEPLOY).attr("disabled", true);
										}
										
										var nids = $(this).attr("nid").split(" ");
										
										for (var nidx = 0; nidx < nids.length; nidx++) {
											if (!nids[nidx] || nids[nidx].length < 1) {
												continue;
											}
											nodePresenter.setattribute({ node_id: nids[nidx]},{
													hapi : {
														ignore_warnings : $(this).is(':checked'),
														node_id : nids[nidx]
													}
												}, {
												   success : function(){},
												   error : function() {}
											});
										}
									});
									$('.ignorewarnings').attr("nid", groupNodes[idx].node_id);
								} else {
									$('.ignorewarnings').attr("nid", $('.ignorewarnings').attr("nid") + " " + groupNodes[idx].node_id);
								}
							}
							$('#hpsum-warnings-collapsible').removeClass('hp-collapsed');
				}
				$('.my-collapsible', DEPLOY_CONTENTS).hpCollapsible();
				
			
				for (var idx = 0; idx < groupNodes.length; idx++) {
					$('#hpsum-group-node-ccontent-' + groupNodes[idx].node_id, DEPLOY_CONTENTS).hpsumInstallables({
							command: 'init',
							nodeItem: {node_id: groupNodes[idx].node_id, type: ''},
							onSelectionChanged: onSelectionChanged,
							onPopulateInstallSet: onPopulateInstallSet
						});
					$('#hpsum-group-tpm-warning-' + groupNodes[idx].node_id, DEPLOY_CONTENTS).hide();	
				}
						
				
				
				
			}
				
			function onSelectionChanged(id, value, componentList) {		

				if(value == true){
					isSelectionChanged = true;
					enableDeployBtn(true);
				}
				
				var nodeName = '';
				for (var idx = 0; idx < nodeChanges.length; idx++) {
					if (nodeChanges[idx].node_id == id){
						nodeChanges[idx].selectionChanged = value;
						nodeName = nodeChanges[idx].node_name;
						nodeChanges[idx].component_length = componentList.component.length;
						nodeChanges[idx].failed_dependency_cnt = componentList.failed_dependency;
					}
				}
				
				var componentCount = 0;
				var failedDepCount = 0;
				for (var idx = 0; idx < nodeChanges.length; idx++) {
					componentCount += nodeChanges[idx].component_length;
					failedDepCount += nodeChanges[idx].failed_dependency_cnt;
				}
				
				failedDependencyCount = failedDepCount; // failed dep components count that we can use during analysis.
				SelectedComponents = componentCount;
				
				if (componentCount > 0) {
					enableDeployBtn(true);
				}
				if( 0 == componentCount || (false == value && failedDepCount >=0))
				{
					enableDeployBtn(false);
				}
				
				var name  = '#hpsum-group-node-cname-' + id;
				if(componentList.failed_dependency != 0){
					$(name).html('&nbsp&nbsp<p><img src="/img/hp-piano/status-error-small-select.png">&nbsp&nbsp' + nodeName + '<br/>' +
					'&nbsp&nbsp' + localizer.getString("hpsum.node.compFailedDep", [componentList.component.length]));
					deploy_flag = false;
				}
				else{
					if(componentList.component.length == 0){
						$(name).html('&nbsp&nbsp<p><img src="/img/hp-piano/status-warning-small-select.png">&nbsp&nbsp' + nodeName + '<br/>' +
						'&nbsp&nbsp' + localizer.getString("hpsum.node.compSelectZero", [componentList.component.length]));
					}
					else{
						$(name).html('&nbsp&nbsp<p><img src="/img/hp-piano/status-ok-small-select.png">&nbsp&nbsp' + nodeName + '<br/>' +
						'&nbsp&nbsp' + localizer.getString("hpsum.node.compSelect", [componentList.component.length]));
					}	
				}
			}
			
			function showAnalysisWaitDialog(flag) {
					analysisWaitDialog = $(SPLASH_DIALOG);
					analysisWaitDialog.dialog({
						modal : true,
						dialogClass : 'hp-simple-dialog',
						position : "center",
						draggable : false,
						closeOnEscape: false,
						resizable : false,
						width : 280,
						height : 180
					});
					if(flag)
						$('#hpsum-group-analysis-txt').html(localizer.getString("hpsum.group.applyingInstallationOptions"));
					else
						$('#hpsum-group-analysis-txt').html(localizer.getString("hpsum.group.applyingSelectionChanges"));
				$(SPLASH_SPINNER).show();
				analysisWaitDialog.dialog('open');
			}

			function closeAnalysisWaitDialog() {
				$(SPLASH_SPINNER).hide();
				analysisWaitDialog.dialog('destroy');
			}		
			
			
			function reset() {
				populateOptions();
				nodeChanges = [];
				populateDeployData();
				$(SCHEDULE_DATE).val("");
				$(SCHEDULE_TIME).val("");
				$(DELAYSEC).attr("disabled", true);
				$(MESSAGE).attr("disabled", true);
				$(COMPVERBOSEOPTION).attr('checked', false);
				$(DELAYSEC).removeClass("hp-error");
				$(DELAYSECERR).hide();
			}
			
			function validateTime() {
				var time_val = $(SCHEDULE_TIME).val();
				var time_parse = time_val.split(':');
				var time_pattern = /^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/;
				if(!time_val.match(time_pattern)) {
					$(SCHEDULE_TIME_LABEL).addClass("hp-error");
					$(SCHEDULE_TIME_LABEL).show();
				}
				else
				{
					var time_hrs = time_parse[0];
					var time_mins = time_parse[1];
					if(time_hrs >= 12)
					{
						if(time_hrs == 12)
							schedule_time = time_hrs + ':' + time_mins + ' ' +'PM';
						else
						{
							var time_hrs_old = time_hrs - 12 ;
							if((time_hrs_old) <= 9)
							schedule_time = '0' + time_hrs_old + ':' + time_mins + ' ' +'PM';
							else 
							schedule_time = time_hrs_old + ':' + time_mins + ' ' +'PM';
						}
					}
					else if (time_hrs == 0)
					{
						schedule_time = (parseInt(time_hrs) + 12) + ':' + time_mins + ' ' +'AM';
					}
					else if (time_hrs < 12)
					{
						schedule_time = time_hrs + ':' + time_mins + ' ' +'AM';
					}
					enableDeployBtn(false);
				}
			}
			
			function validateRebootDelay() {
				var rebootopt = $('#hpsum-deploy-reboot-option option:selected').val();
				var delaySec = $(DELAYSEC).val();
				var valid = true;
				
				if (rebootopt != "Never") {
					if((isNaN(delaySec) && !isFinite(delaySec)) || 
					  (delaySec < 60 || delaySec > 3600)) {
						$(DELAYSEC).addClass("hp-error");
						$(DELAYSECERR).text(localizer.getString("hpsum.node.rebootDelaySecondsErrMsg"));
						$(DELAYSECERR).show();
						valid = false;
					}
					else {
						$(DELAYSEC).val(parseInt(delaySec));
						$(DELAYSEC).removeClass("hp-error");
						$(DELAYSECERR).hide();
					}
				}
				return valid;
			}
			
			function convertDateTime(date_time)
			{
				date_value = '';
				time_value = '';
				date_time_new = '';
				if(date_time !== "")
				{
					var date_time_split = date_time.split(' ');
					var time_hrs_mins = date_time_split[1].split(':');
					var time_hrs = time_hrs_mins[0];
					date_value = date_time_split[0];
					time_value = '';
					date_time_new = '';
					if((date_time_split[2] == 'PM') && (parseInt(time_hrs) < 12))
					{
						time_hrs = parseInt(time_hrs) + 12;
					}
					else if(date_time_split[2] == 'AM')
					{
						if (parseInt(time_hrs) < 10 && parseInt(time_hrs) < 12)
						{
							time_hrs = '0' + parseInt(time_hrs);
						}
						else if (parseInt(time_hrs) == 12)
						{
							time_hrs = parseInt(time_hrs) - 12;
							time_hrs = '0' + parseInt(time_hrs);
						}
					}
					time_value = time_hrs + ':' + time_hrs_mins[1];
					date_time_new = date_value + ' ' + time_value;
				}
			}
			function setscheduleoptions(groupItem) {
			
				var scheduled = "no";
				var date = "";
				var time = "";
				
				if($(SCHEDULETOGGLE).attr('checked') === "checked")
					scheduled = 'yes';
				else
					scheduled = 'no';
				
				if(scheduled_getdata_date_time == ""){
					scheduled_getdata_date_time = " ";
					schedaction = 'create';
					}
				else
					schedaction = 'update';
				
				if(scheduled === "yes"){
					date = $(SCHEDULE_DATE).val();
					validateTime();
					time = schedule_time;
				}
				
				var schedule_information = {date:date, time:time};
				var schedule_date_time = date + ' ' + time;
				if(scheduled !== scheduled_getdata || scheduled_getdata_date_time !== schedule_date_time)
					presenter.ScheduleNodes(groupItem, schedaction, scheduled, schedule_information, {
						success : function(data) {
							onScheduleNodesSuccess(data); 
						},
						error : function(errorInfo) {
								onScheduleNodesError(errorInfo);
							}
					});
			}
			
			function loadScheduleoptions(groupItem){
				var scheduled_time = '',
					scheduled_date = '',
					timezone = groupItem.group_schedule_timezone,
					current_date_time = '',
					nodeScheduled = false;
					

				scheduled_getdata_date_time = groupItem.group_schedule_date_time;
				scheduled_getdata = groupItem.group_scheduled;
				if(scheduled_getdata === "false")
				{
					scheduled_getdata = "no";
					$(DEPLOY).val(localizer.getString('hpsum.node.deploy'));
					if($(SCHEDULETOGGLE).attr('checked') === "checked"){
						$(SCHEDULETOGGLE).click();	
						$(SCHEDULETOGGLE).removeAttr("checked");
					}
				}
				else if(scheduled_getdata === "true")
				{
					scheduled_getdata = "yes";
					$(DEPLOY).val(localizer.getString('hpsum.node.scheduledeploy'));
					if($(SCHEDULETOGGLE).attr('checked') === undefined){
						$(SCHEDULETOGGLE).click();	
						$(SCHEDULETOGGLE).attr("checked","checked");
					}
				}
				if(scheduled_getdata_date_time !== "")
				{
					convertDateTime(scheduled_getdata_date_time);
					scheduled_date = date_value;
					scheduled_time = time_value;
				}
				
				$(SCHEDULE_DATE).val(scheduled_date);
				$(SCHEDULE_TIME).val(scheduled_time);
				
				convertDateTime(groupItem.group_local_date_time);
				current_date_time = date_time_new;
				$(CURRENT_DATETIME).html(current_date_time);
				$(TIME_ZONE).html(timezone);
				
				var tableContents = "<table><thead><tr><th>Node IP</th><th>Schedule DateTime</th>";//<th>RunNow</th><th>RetainSchedule</th>";
				for(var idx = 0; idx < allNodesDetials.length; idx++){
					if(allNodesDetials[idx].is_schedule_running === "true")
					{
						nodeScheduled = true;
						convertDateTime(allNodesDetials[idx].schedule_date_time);
						tableContents += "<tr><td>" + allNodesDetials[idx].name + "</td><td>" + date_time_new + "</td>";
						//tableContents += "<td><input type = checkbox id=runnow></td><td><input type=checkbox id=retainschedule></td></tr>";
					}
				}
				tableContents += "</table>";
				if(!groupItem.group_schedule_running && nodeScheduled)
				{						
					warningmsg = localizer.getString('hpsum.group.scheduleDeployWarning');
					$('#hpsum-group-warning-label').html(warningmsg);
					$(SCHEDULE_WARNING).show();
					$(SCHEDULE_LIST).show();
					$(SCHEDULE_LIST).html(tableContents);
				}
				else
				{
					$(SCHEDULE_WARNING).hide();
					$(SCHEDULE_LIST).html('');
					$(SCHEDULE_LIST).hide();
				}
				
			}

			function onScheduleNodesError(errorMessage)
			{
				notifications.show(errorMessage, 'error');                          
				enableDeployBtn(false);
				$(CANCEL).trigger('click');	
			}

			function onScheduleNodesSuccess(data)
			{
				var message;	
				$(DEPLOY).val(localizer.getString('hpsum.node.scheduledeploy'));
				if(schedaction === "create")
					message = "Schedule for " + groupItem.group_name + " group created successfully";
				if(schedaction === "update"){
					if($(SCHEDULETOGGLE).attr('checked') === "checked")
						$(DEPLOY).val(localizer.getString('hpsum.node.scheduledeploy'));
					else
						$(DEPLOY).val(localizer.getString('hpsum.node.deploy'));
					message = "Schedule for " + groupItem.group_name + " group updated successfully";  
				}
				notifications.show(message, 'ok');  
				$(SCHEDULE_WARNING).hide();
				$(SCHEDULE_LIST).html('');
				$(SCHEDULE_LIST).hide();
			}	
			
			function toggleSchedule(cb)
			{
				if(cb.target.checked){
					$(DATETIMESECTION).show();
					warningmsg = localizer.getString('hpsum.group.scheduleToggleWarning');
				}
				else
					$(DATETIMESECTION).hide();
				$('#hpsum-group-warning-label').html(warningmsg);
				$(DEPLOY).val(localizer.getString('hpsum.node.deploy'));
				enableDeployBtn(false);
				
				var componentCount = 0;
				for (var idx = 0; idx < nodeChanges.length; idx++) {
					componentCount += nodeChanges[idx].component_length;
				}
			}
			/**
			 * @public
			 * Initialize Group Deploy View
			 */
			this.init = function() {

				$(DEPLOY).live('click', function(ev) {
					onDeploy.call(this);
					ev.preventDefault();
				});
				
				$(CANCEL).live('click', function() {
					$('.hpsumInstallables').hpsumInstallables('destroy');
					presenter.off("itemChange", onItemChange);
					router.go(urlFragment.replaceView(router.location(), 'show'));
				});
				
				$('.require-analysis').on('change', function(){
					if(failedDependencyCount <= 0 && SelectedComponents > 0){
						enableDeployBtn(true);
					}
					else
					{
						enableDeployBtn(false);
					}
				});
				
				//By Default reboot-options value is Never so disable the Reboot delay and Reboot message.
				$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", true);
				//$(ANALYSIS).attr('tooltip', localizer.getString('hpsum.common.deployPreviewToolTip')).hpTooltip();
				$(REBOOTOPTION).change(function() {
					var type = $('#hpsum-deploy-reboot-option option:selected').val();
					if (type == "Never") {
					$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", true);
					$(DELAYSEC).val('');
					$(DELAYSEC).removeClass("hp-error");
					$(DELAYSECERR).hide();
					}
					else
					{
					$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", false);
					}
				});
				$(REBOOTOPTION).selectBox({autoWidth: false});
				$(DELAYSEC).unbind('keyup').bind('keyup',function(){
					$(DELAYSECERR).hide();
					$(DELAYSEC).removeClass('hp-error');
				}); 
				
				$(DELAYSEC).bind('change', function(){
					$(DELAYSECERR).hide();
					$(DELAYSEC).removeClass('hp-error');
				}); 
				
				$(PANELS).hpStackedPanels({
					panelSelector : PANEL_SELECTOR
				});

				$(".hp-collapsible").hpCollapsible();

				enableDeployBtn(true);

				$(RESET).live('click', function() {
					reset.call();
				});
				
				$('#hpsum-downgrade-rewrite-text').html(localizer.getString("hpsum.node.installationOptions.message"));
				$('#hpsum-downgrade-rewrite-text').removeClass('hp-collapsed');
				$(INSTALL_ERROR).hide();
				$("#hpsum-installation-option").change(function() {
					applyInstallationOptions.call();
				});
				$("#hpsum-reboot-options-collapsible").css("margin-top","-20px");
				$(INSTALLATIONOPTION).selectBox({autoWidth: false});
				$(INSTALLATIONOPTION).val('None');
				$(INSTALLATIONOPTION).selectBox('reset');
				$('#hp-force-downgrade-rewrite').hide();
					
				router.watch('Group Deploy section', ROUTE_PREFIX + '.*', {
					parent : ROUTE_PREFIX,
					change : changeLocation
				});
				$(DATETIMESECTION).hide(); 
				
				formStateView.init({form: FORM,
					routePattern: ROUTE_PREFIX + '.*',
					autoTrack: false
				});
				
				$(SCHEDULETOGGLE).hpToggle({checked: 'On', unchecked: 'Off'});
				$(SCHEDULETOGGLE).bind('change',toggleSchedule);
				$(SCHEDULE_DATE).datepicker({ dateFormat: 'yy-mm-dd'});
				$(SCHEDULE_TIME).bind('change', validateTime);
				$(SCHEDULE_TIME).bind('keyup', function () {
					$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
					$(SCHEDULE_TIME_LABEL).hide();
				});
				$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
				$(SCHEDULE_TIME_LABEL).hide();
				$(SCHEDULE_DATE).bind('change', function(){
					enableDeployBtn(false);
				});
				$("#hpsum-schedule-collapsible").removeClass('hp-collapsed');
				this.resume();
			};

				/**
				 * @public
				 * Resume Group Deploy View
				 */
				this.resume = function() {
					$(THROBBER).hide();
					presenter.on("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('resume');
					reset();
					$('#hpsum-group-deploy').hpCollapsible('expand');
					$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
					$(SCHEDULE_TIME_LABEL).hide();
				};

				/**
				 * @public
				 * Pause Group Deploy View
				 */
				this.pause = function() {
					presenter.off("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};
			}

		return GroupDeployView;
	}());

	return new GroupDeployView();
});
