// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/group/GroupPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/view/FormStateView',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpSearchCombo',
    'lib/jquery.selectBox'],

function(presenter,router, urlFragment, notifications, FormStateView, localizer) {"use strict";

	var GroupInventoryView = ( function() {

			//Consts can go here
			var OK = '#hpsum-group-inventory-ok',
			    CANCEL = '#hpsum-group-inventory-close',
			    PANEL_SELECTOR = '#hpsum-group-inventory-panel-selector',
			    PANELS = '#hpsum-group-inventory-panels',
			    FORM = '#hpsum-group-inventory-form',
			    FAILEDMSG = '#hpsum-group-inventory-failed-details',
			    FAILEDPANEL = '#hpsum-group-inventory-failed',
			    BASELINES = '#hpsum-group-baselines-search',
			    ASSOCBASELINE = '#hpsum-group-baseline',
			    HOTFIX = '#hpsum-group-addpackage-search',
			    ASSOCHOTFIX = '#hpsum-group-addpackage',
			    NAME = '#hpsum-group-inventory-name',
			    ROUTE_PREFIX = '/group/inventory',
			    REMOVEBASELINE = '#hpsum-group-baseline-remove',
        		REMOVEHOTFIX = '#hpsum-group-addpackage-remove',
        		THROBBER = '#hpsum-group-inventory-throbber',
        		BASELINE_WARNING = '#hpsum-group-inventory-baseline-warning',
        		NOBASELINE_WARNING = '#hpsum-group-inventory-no-baseline-warning',
        		NOBASELINE_NODES_TABLE = '#hpsum-group-inventory-view-nodes',
        		NOBASELINE_DETAILS = '#hpsum-group-inventory-nobaseline-nodes',
				SCHEDULEINFO = '#hpsum-group-schedule-info',
				BASELINE_INPUT = '#hpsum-group-baselines-search-input',
				HOTFIX_INPUT = '#hpsum-group-addpackage-search-input',
				BASELINE_INPUT_ERR = '#hpsum-group-baselines-search-input-err',
				HOTFIX_INPUT_ERR = '#hpsum-group-addpackage-search-input-err';

			/**
			 * Constructor
			 */
			function GroupInventoryView() {

				var formStateView = new FormStateView();
				var inventoryInProgress = false,
				    groupItem = null,
				    baselines = '',
				    hotfixes = '',
				    assocBaseline = '',
				    newBaseline = null,
				    newHotFix = null,
				    assocHotFix = '',
				    searchResults = [],
					allNodesDetials = [],
					date_time_new = '',
					time_value = '',
					date_value = '';
				var setOk = false;

				function onItemChange(item) {
					item = item.hapi;

					if (item) {
						$(NAME).text(item.group_name);
						$(ASSOCBASELINE).text('');
						$(ASSOCHOTFIX).text('');
						$(REMOVEBASELINE).hide();
                    	$(REMOVEHOTFIX).hide();
						groupItem = item;
						newBaseline = null;
						newHotFix = null;
						if (item.group_baselines) {
							for (var i = 0; i < item.group_baselines.length; i++) {
								var baseline = presenter.getBaselineDetailsforId(item.group_baselines[i]);
								if (baseline) {
									if (baseline.name.match(/^Additional Package/i)) {
										$(ASSOCHOTFIX).text(baseline.name);
										$(REMOVEHOTFIX).show();
										$(HOTFIX).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
										$(NOBASELINE_WARNING).hide();
										assocHotFix = baseline;
									} else {
										$(ASSOCBASELINE).text(baseline.name);
										$(REMOVEBASELINE).show();
										$(BASELINES).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
										$(NOBASELINE_WARNING).hide();
										assocBaseline = baseline;
									}
								}
							}
						}
						presenter.getNodesData(groupItem, {
							success : function(data) {
								allNodesDetials = [];
								if (data.hasOwnProperty('hapi')) {
									allNodesDetials = data.hapi.output_data.nodes.node;
									showScheduleWarning();
								}
							},
							error : function(data) {
							}
						});
					} else {
						$(CANCEL).trigger('click');
					}
					formStateView.reset();
				}
				
				function convertDateTime(date_time)
				{
					date_value = '';
					time_value = '';
					date_time_new = '';
					if(date_time !== "")
					{
						var date_time_split = date_time.split(' ');
						var time_hrs_mins = date_time_split[1].split(':');
						var time_hrs = time_hrs_mins[0];
						date_value = date_time_split[0];
						time_value = '';
						date_time_new = '';
						if((date_time_split[2] == 'PM') && (parseInt(time_hrs) < 12))
						{
							time_hrs = parseInt(time_hrs) + 12;
						}
						else if(date_time_split[2] == 'AM')
						{
							if (parseInt(time_hrs) < 10 && parseInt(time_hrs) < 12)
							{
								time_hrs = '0' + parseInt(time_hrs);
							}
							else if (parseInt(time_hrs) == 12)
							{
								time_hrs = parseInt(time_hrs) - 12;
								time_hrs = '0' + parseInt(time_hrs);
							}
						}
						time_value = time_hrs + ':' + time_hrs_mins[1];
						date_time_new = date_value + ' ' + time_value;
					}
				}
				
				function showScheduleWarning()
				{
					var nodeScheduled=false;
					$('#hpsum-group-schedule-info').hide();
					var tableContents = "<table><thead><tr><th>Node IP</th><th>Schedule DateTime</th></tr></thead>";
						
					for(var idx = 0; idx <allNodesDetials.length; idx++)
					{
						if(allNodesDetials[idx].node_state.match(/scheduled/i))
						{
							nodeScheduled = true;
							convertDateTime(allNodesDetials[idx].schedule_date_time);
							tableContents += "<tr><td>" + allNodesDetials[idx].name + "</td><td>" + date_time_new + "</td></tr>";
						}
					}
					tableContents += "</table>";
					if(nodeScheduled)
					{
						$('#hpsum-group-schedule-info').show();
						$('#hpsum-group-schedule-nodes').html(tableContents);
					}

				}

				function onInventoryError(errorMessage) {
					$(OK).attr('disabled', false);
					$(THROBBER).hide();
					$(FAILEDPANEL).show();
					$(FAILEDMSG).text(errorMessage);
					inventoryInProgress = false;
				}

				function onInventorySuccess(item) {
					$(OK).attr('disabled', false);
					$(THROBBER).hide();
					inventoryInProgress = false;
					formStateView.reset();
					$(CANCEL).trigger('click');
				}
				
				function performInventory() {
					inventoryInProgress = true;
					presenter.startInventory(groupItem, {
						success : onInventorySuccess,
						error : onInventoryError
					});
				}
				
				function onInventory() {
					var fail = false;
					var finalBaseline;
					var finalHotFix;
					var baselineJson = [];
					if (!inventoryInProgress) {
						var errorfound = false;
						if($(BASELINES).val() != ''){
							var baselinedetails = presenter.getBaselineDetailsforId($(BASELINES).val());
							if(!baselinedetails){
								errorfound = true;
								$(BASELINE_INPUT_ERR).text(localizer.getString('hpsum.node.invalidBaseline'));	
								$(BASELINE_INPUT).addClass("hp-error");
								$(BASELINE_INPUT_ERR).show();
							}
						}
						if($(HOTFIX).val() != ''){
							var baselinedetails = presenter.getBaselineDetailsforId($(HOTFIX).val());
							if(!baselinedetails){
								errorfound = true;
								$(HOTFIX_INPUT_ERR).text(localizer.getString('hpsum.node.invalidAdtPackage'));	
								$(HOTFIX_INPUT).addClass("hp-error");
								$(HOTFIX_INPUT_ERR).show();
							}
						}	
						
						if (errorfound == true){
							inventoryInProgress = false;
							return;
						}
						$(OK).attr('disabled', true);
						$(THROBBER).show();
						if ((newBaseline == null) && (assocBaseline == null))
							finalBaseline = null;
						else if (newBaseline == null)
							finalBaseline = assocBaseline;
						else
							finalBaseline = newBaseline;
						if ((newHotFix == null) && (assocHotFix == null))
							finalHotFix = null;
						else if (newHotFix == null)
							finalHotFix = assocHotFix;
						else
							finalHotFix = newHotFix;

						if ((finalHotFix == null) && (finalBaseline == null))
							fail = true;
						else if (finalHotFix == null)
							baselineJson.push(finalBaseline.id);
						else if (finalBaseline == null)
							baselineJson.push(finalHotFix.id);
						else {
							baselineJson.push(finalBaseline.id);
							baselineJson.push(finalHotFix.id);
						}
						if (fail == true) {
							//$(FAILEDPANEL).show();
							//$(FAILEDMSG).text(localizer.getString('hpsum.group.errorPleaseSelectBaseline'));
						} else {
							if (baselineJson[0] == null) {
								baselineJson.splice(0, 1);
							}
							groupItem.baselines = baselineJson;
						}
							
						if (baselineJson.length == 0) {
							var NoBaselinesNodes = [],
							    CanPerformInventory = true;

							$(NOBASELINE_NODES_TABLE).dataTable().fnClearTable();
									
							for (var idx = 0; idx < allNodesDetials.length; idx++) {
								if (allNodesDetials[idx].baselines.length == 0) {
									CanPerformInventory = false;
									$(NOBASELINE_DETAILS).show();
									
									var nodeData = allNodesDetials[idx],
										status = 'unknown',
										change = false,
										nodeStatus = nodeData.node_status,
										rebootRequired = "",
										nodeBaseline = localizer.getString('hpsum.group.noBaseline'),
										adtPackage = localizer.getString('hpsum.group.noAdtPackage'),
										name = "";

									if (nodeData.node_state.match(/inventory|analysis|install$/i) || nodeData.node_phase.match(/initialize/i)) {
										status = 'unknown';
										change = true;
									} else if (nodeData.node_state.match(/error/i) || nodeData.node_phase.match(/initialize|InActive/i)) {
										status = 'error';
									} else if (nodeData.node_state.match(/uan/i)) {
										if (nodeData.node_status.match(/No applicable/i)) {
											status = 'ok';
										} else {
											status = 'warning';
										}
									} else if (nodeData.node_state.match(/installdone/i)) {
										if (nodeData.return_code == -2 || nodeData.return_code == -3) {
											status = 'error';
											nodeStatus = localizer.getString('hpsum.node.installDoneWithErrors');
										} else {
											status = 'ok';
										}

										if (nodeData.return_code == 1) {
											rebootRequired = localizer.getString('hpsum.node.rebootRequired');
										}

									} else if (nodeData.node_state.match(/idle/i)) {
										if (nodeData.node_phase.match(/unknown/i)) {
											status = 'error';
										} else {
											status = 'warning';
										}
									}

									if (nodeData.baselines) {
										for (var i = 0; i < nodeData.baselines.length; i++) {
											var baseline = presenter.getBaselineDetailsforId(nodeData.baselines[i]);
											if (baseline) {
												if (baseline.name.match(/^Additional Package/i)) {
													adtPackage = baseline.name;
												} else {
													nodeBaseline = baseline.name;
												}
											}
										}
									}
									
									name = '<a href="#/node' + '/show/r' + nodeData.node_uri + '/getdata">' + nodeData.name + '</a>';
									
									$(NOBASELINE_NODES_TABLE).dataTable().fnAddData({
										status : status,
										change : change,
										uri : nodeData.uri,
										name : name,
										type : nodeData.type,
										node_status : nodeStatus,
										baseline : nodeBaseline,
										adtPackage : adtPackage
									});
								}
							}

							if (!CanPerformInventory) {
								onInventoryError(localizer.getString('hpsum.group.noBaselineNodes'));	
							}
							else {
								performInventory();
							}
						} else {
							performInventory();
						}
					}
				}

				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				this.resume = function() {
					$(THROBBER).hide();
					$(NOBASELINE_WARNING).show();
					$(BASELINE_WARNING).hide();
					$(NOBASELINE_NODES_TABLE).dataTable().fnClearTable();
					$(NOBASELINE_DETAILS).hide();
					$(BASELINE_INPUT).removeClass("hp-error");
					$(HOTFIX_INPUT).removeClass("hp-error");
					$(BASELINE_INPUT_ERR).hide();
					$(HOTFIX_INPUT_ERR).hide();
					assocBaseline = null;
					assocHotFix = null;
					$(BASELINES).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					$(HOTFIX).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					presenter.on('itemChange', onItemChange);
					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});
					$(PANELS).hpStackedPanels('resume');
					$(FAILEDPANEL).hide();
					$('#hpsum-group-schedule-info').hide();
				};

				this.pause = function() {
					presenter.off('itemChange', onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};

				function baselinesAvailable(data) {
				}

				function getBaseline(string, handlers, count, start) {
					var results = baselines;
					if (string && string.length > 0) {
						results = $.grep(baselines, function(option, index) {
							return (option.name.match(new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
						});
					}
					handlers.success({
						count : results.length,
						members : results, 
						start: 0, 
						total: results.length
					});
				}

				function getHotfixes(string, handlers, count, start) {
					var results = hotfixes;
					if (string && string.length > 0) {
						results = $.grep(hotfixes, function(option, index) {
							return (option.name.match(new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
						});
					}
					handlers.success({
						count : results.length,
						members : results, 
						start: 0, 
						total: results.length
					});
				}

				function getBaselinesSuccess(searchResults) {
					baselines = $.grep(searchResults, function(option, index) {
						return !(option.name.match(new RegExp('^Additional', 'i')));
					});
					hotfixes = $.grep(searchResults, function(option, index) {
						return (option.name.match(new RegExp('^Additional', 'i')));
					});

				}

				function getBaselinesError(msg) {

				}

				/**
				 * @public
				 */
				this.init = function() {

					$(CANCEL).click(function() {
						router.go(urlFragment.replaceView(router.location(), 'show'));
					});
					$(FAILEDPANEL).hide();
					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					formStateView.init({
						form : FORM,
						routePattern : ROUTE_PREFIX + '.*',
						autoTrack : true
					});

					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});

					$(BASELINES).hpSearchCombo({
						getResults : getBaseline
					});
					$(HOTFIX).hpSearchCombo({
						getResults : getHotfixes
					});
					$(BASELINES).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCBASELINE).text(item.name);
							$(REMOVEBASELINE).show();
							newBaseline = item;
						} else {
							if(assocBaseline != null){
								$(ASSOCBASELINE).text(assocBaseline.name);
								$(REMOVEBASELINE).show(); 
							}
							newBaseline = null;
						}
						$(FAILEDPANEL).hide();
						
						if (value != "") {
							$(NOBASELINE_WARNING).hide();
						}
						
						if (value == "" && $(HOTFIX).val() == "") {
							$(BASELINE_WARNING).hide();
							$(NOBASELINE_WARNING).show();
						} else {
							$(BASELINE_WARNING).show();
						}
						
						/*if (value != "") {
							$(NOBASELINE_WARNING).hide();
						} else {
							$(NOBASELINE_WARNING).show();
						}*/
						
						if (value == "") {
							$(ASSOCBASELINE).text('');
							$(REMOVEBASELINE).hide();
							assocBaseline = null;
						}
						if(!setOk){
							$(BASELINE_INPUT_ERR).hide();
							$(BASELINE_INPUT).removeClass('hp-error');
						}
						setOk = false;
					});
					$(HOTFIX).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCHOTFIX).text(item.name);
							$(REMOVEHOTFIX).show();
							newHotFix = item;
						} else {
							if (assocHotFix != null) {
								$(ASSOCHOTFIX).text(assocHotFix.name);
								$(REMOVEHOTFIX).show();
							}
							newHotFix = null;
						}

						$(FAILEDPANEL).hide();
						
						if (value != "") {
							$(NOBASELINE_WARNING).hide();
						}
						
						if (value == "" && $(BASELINES).val() == "") {
							$(BASELINE_WARNING).hide();
							$(NOBASELINE_WARNING).show();
						} else {
							$(BASELINE_WARNING).show();	
						}
						
						/*if (value != "") {
							$(NOBASELINE_WARNING).hide();
						} else {
							$(NOBASELINE_WARNING).show();
						}*/
						
						if (value == "") {
							$(ASSOCHOTFIX).text('');
							$(REMOVEHOTFIX).hide();
							assocHotFix = null;
						}
						if(!setOk){
							$(HOTFIX_INPUT_ERR).hide();
							$(HOTFIX_INPUT).removeClass('hp-error');
						}
						setOk = false;
					});
					
					$(BASELINE_INPUT).unbind('keyup').bind('keyup',function(){
						$(BASELINE_INPUT_ERR).hide();
						$(BASELINE_INPUT).removeClass('hp-error');
					});
								
					$(HOTFIX_INPUT).unbind('keyup').bind('keyup',function(){
						$(HOTFIX_INPUT_ERR).hide();
						$(HOTFIX_INPUT).removeClass('hp-error');
					});

					$(OK).on('click', function(ev) {
						setOk = true;
						onInventory();
						ev.preventDefault();
					});

					$(REMOVEBASELINE).on('click', function(ev) {
						assocBaseline = null;
						$(BASELINES).hpSearchCombo('set', {
							id : '',
							name : ''
						});
						$(ASSOCBASELINE).text('');
						$(REMOVEBASELINE).hide();
					});
					
					$(REMOVEHOTFIX).on('click', function(ev) {
						assocHotFix = null;
						$(HOTFIX).hpSearchCombo('set', {
							id : '',
							name : ''
						});
						$(ASSOCHOTFIX).text('');
						$(REMOVEHOTFIX).hide();
					}); 

					router.watch('group inventory section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});

					var dummyNodeData = [];

					$(NOBASELINE_NODES_TABLE).dataTable({
						oLanguage : {
						    sEmptyTable: localizer.getString("hpsum.group.noMoreNodesAvailable"),
						    sSearch: localizer.getString('hpsum.common.search')
						},
						bPaginate : false,
						sScrollY: "450px",
						bFilter : false,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						aaData : dummyNodeData,
						aoColumns : [
						{mDataProp: 'status',
							fnRender: function (oObj) {
								var statusCode;
								if (oObj.aData.change == true )
									statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-changing"></div></div>';
								else if(oObj.aData.status == "ok")
                                    statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>';
                                else if(oObj.aData.status == "error")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
                                else if(oObj.aData.status == "warning")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-warning"><span class="hp-value">warning</span></div></div>';
                                else if(oObj.aData.status == "unknown")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-unknown"><span class="hp-value">unknown</span></div></div>';
                                return statusCode;
							},
							sWidth: '10px', sClass: "hp-icon"
						},{
							mDataProp : 'name'
						}/*,{
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						},{
							mDataProp : 'baseline'
						}, {
							mDataProp : 'adtPackage'
						}*/],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});
					
					this.resume();
				};
			}

			return new GroupInventoryView();
		}());

	return GroupInventoryView;
});

