/* (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
*/
define(['hp/view/DetailsShowView',
    'hpsum/presenter/group/GroupPresenter',
    'hp/core/Router',
    'hp/view/DialogView',
    'hp/core/UrlFragment',
    'hp/core/LinkTargetBuilder',
    'hp/view/NotificationsView',
    'hp/core/Localizer',
    'hp/core/HashManager',
    'hp/core/Notifications',
	'text!hpsumpages/group/dialog.html',
	'text!hpsumpages/node/delete_confirm.html',
	'text!hpsumpages/node/abort_confirm.html',
    'jquery',
    'hp/lib/date',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpCollapsible'],
function(DetailsShowView, presenter, router, DialogView, urlFragment,
    linkTargetBuilder, NotificationsView, localizer, hashManager, notifications,dialogHtml,deleteConfirmHtml,abortConfirmHtml) { "use strict";

	var GroupShowView = ( function() {

			//Consts can go here
			var VIEW = '#hpsum-group-show',
			    HEADER = '#hpsum-groups-show .hp-details-header',
			    TITLE = '#hpsum-groups-details-title',
			    STATUS = '#hpsum-groups-details-status',
			    ACTIONS = '.hp-details-actions',
			    ADD_ACTION = '#hpsum-group-action-add',
			    EDIT_ACTION = '#hpsum-group-action-edit',
			    INVENTORY_ACTION = '#hpsum-group-action-inventory',
			    INVENTORY_DETAIL_LINK = '#hpsum-node-detail-inventory',
			    DEPLOY_ACTION = '#hpsum-group-action-deploy',
			    ABORT_ACTION = '#hpsum-group-action-abort',			    
			    ABORT_INFO_DIALOG = '#hpsum-abort-info-dialog',
			    DELETE_ACTION = '#hpsum-group-action-delete',
			    DELETE_INFO_DIALOG = '#hpsum-delete-info-dialog',
			    NODES_TABLE = '#hpsum-group-nodes-table',
			    REPORTS_ACTION = '#hpsum-group-action-reports';

			/**
			 * Constructor
			 */
			function GroupShowView() {

				var detailsShowView = new DetailsShowView(),
				    notificationsView = new NotificationsView(),
				    thisgroup = null,
				    item = null,
				    notificationsCleared = false,
				    deleteInfoDialog,
				    abortInfoDialog;
				var date_time_new = '',
					time_value = '',
					date_value = '';
					
					var timer = '';
					
					
					var gid='';
					
				var SUCCESS = 0;
					
				function clearNotifications() {
					if (!notificationsCleared) {
						notificationsCleared = true;
						notificationsView.clear();
					}
				}

				function onInventoryError(errorMessage) {                
                
            	}

           		 function onInventorySuccess(item) {
                
           		 }

				function onInventory(){	   									
					var CanPerformInventory = false;
                    var groupItem = {};		
                    groupItem.baselines = null;	
					groupItem.group_id =  thisgroup.group_id;
            		$(document.body).off("click", INVENTORY_DETAIL_LINK , onInventory);				            										    			
					if(thisgroup.group_baselines.length > 0)
					{	
					    groupItem.baselines = thisgroup.group_baselines;
						CanPerformInventory = true;
					}	
                	else{    
                		var nodeData =  $(NODES_TABLE).dataTable().fnGetData();                		
                        CanPerformInventory = true;
                        for(var node=0; node < nodeData.length; node++){
                            if(nodeData[node].adtPackage == localizer.getString('hpsum.group.noAdtPackage') && nodeData[node].baseline  == localizer.getString('hpsum.group.noBaseline')){
                                CanPerformInventory = false;
                                break;
                            }                             
                        } 
                    }						    				               	    			
                    
                    if(CanPerformInventory){
            	    	presenter.startInventory(groupItem, {
                        	success : onInventorySuccess,
                        	error : onInventoryError
                		});				    						
						router.go('/group/show');   
					}
					else{
						router.go('/group/inventory');
					}	
	    		}

				function onItemChange(groupItem) {
				
					clearNotifications();
					
					
				
					item = groupItem.hapi;
				
					gid = item.group_id;
					$(DELETE_ACTION).css("color", "");
					$(REPORTS_ACTION).css("color", "");
					$(DEPLOY_ACTION).css("color", "");
					$(ABORT_ACTION).css("color", "");
					$(EDIT_ACTION).css("color", "");
					$(INVENTORY_ACTION).css("color", "");
					
					if (item) {
						thisgroup = item;
						
						$(HEADER).removeClass('hp-show-changing');
						$(ACTIONS).removeClass('hp-disabled');
						$(TITLE).removeClass('hp-unavailable');
						$(TITLE).text(item.group_name);

					   	$(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').addClass('hp-primary');//modified as part of HFS requirement
					   
					   if (item.group_phase.match(/Error/i)) {
							$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'error',
								details : localizer.getString('hpsum.group.groupErrorSummary'),
								summary : localizer.getString('hpsum.group.groupErrorDetails'),
							});

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
						}
						
						else if (item.group_phase.match(/InActive/i)) {
							$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'error',
								summary : localizer.getString('hpsum.group.groupInActiveSummary'),
								details : localizer.getString('hpsum.group.groupInActiveDetails'), 
							});

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
							
							//This will restore an In-Active group
							presenter.restore(thisgroup);
						}

					  	else if (item.group_phase.match(/Initialize/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');

							notificationsView.add({								
								status : 'running',
								changing : true,
								summary : localizer.getString('hpsum.group.groupScoutingSummary') 
							});
							
							if(item.group_state.match(/IDLE/i))
								showGroupProgress(thisgroup);

							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_phase.match(/NoNodes/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
							var details = '<a href="#/group/edit/addNodesToGroup">' + localizer.getString('hpsum.group.addNodesToGroup') + '</a>';

							notificationsView.add({
								status : 'warning',
								summary : localizer.getString('hpsum.group.groupNoNodesSummary'),
								details : details
							});

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_state.match(/IDLE/i) && item.group_phase.match(/UserActionNeeded/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
							var notif = {
								status : 'warning',
								summary : localizer.getString('hpsum.group.readyForInventory'),
								details : '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.group.inventory') + '</a>'
							};
							$(document.body).on("click", INVENTORY_DETAIL_LINK , onInventory);
							notificationsView.add(notif);

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.group_state.match(/INVENTORY/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : localizer.getString('hpsum.group.inventoryProgress'),
								changing : true
							};
							notificationsView.add(notif);
							showGroupProgress(thisgroup);
							
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(REPORTS_ACTION).addClass('hp-disabled');
							$(DELETE_ACTION).addClass('hp-disabled');
						}
						
						else if(item.group_state.match(/SCHEDULED/i)){
							$(STATUS).hpStatus('warning',false).removeClass('hp-unavailable');
							var summary = localizer.getString('hpsum.group.scheduleMessage');
							var details = "";
							
							if(item.group_schedule_date_time !== ''){
							if(item.group_schedule_match)
								{
									summary = localizer.getString('hpsum.group.scheduleUnMatchedMessage');
								}
								convertDateTime(item.group_schedule_date_time);
								//summary += " at " + date_time_new;
								details = '<span style="padding:10px;"><a id = "hpsum-group-scheduledelete">' + localizer.getString('hpsum.node.cancelSchedule') + '</a></span>' + 
								  '<span style="padding:10px;"><a id = "hpsum-group-schedule-run">' + localizer.getString('hpsum.node.runNow') + '</a></span>';
						
							}
							var notif = {
								status : 'warning',
								summary : summary,
								details : details,
								changing : false
							};
							
							notificationsView.add(notif);
							
							$('#hpsum-group-schedule-run').unbind('click').bind('click', onRunNow);
							$('#hpsum-group-scheduledelete').unbind('click').bind('click', onDeleteSchedule);
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.group_state.match(/UAN/i) && item.group_phase.match(/UserActionNeeded/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
							var notif = {
								status : 'warning',
								summary : localizer.getString('hpsum.group.readyForDeploy'),
								details : '<a href="#/group/deploy">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>',
								changing : false
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(DEPLOY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
						}
						
						else if (item.group_phase.match(/NoComponents/i)) {
							$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
							var notif = {
								status : 'ok',
								summary : localizer.getString('hpsum.group.noApplicableComp'),
								details : '<a href="#/group/inventory">' + localizer.getString('hpsum.group.startInventoryAgain') + '</a>', 
								changing : false
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
						}
						
						else if (item.group_state.match(/ANALYSIS/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : localizer.getString('hpsum.group.analysisProgress'),
								changing : true
							};
							notificationsView.add(notif);
							showGroupProgress(thisgroup);
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(REPORTS_ACTION).addClass('hp-disabled');
							$(DELETE_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_state.match(/INSTALLDONE/i)) {
							if (item.group_return_code < SUCCESS) {							
								$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');
								var notif = {
									status : 'error',
									summary : localizer.getString('hpsum.node.installDoneWithErrors'),
									details : localizer.getString('hpsum.node.installDoneSeeErrors'),
									changing : false
								}; 
							} else {
								$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
								var notif = {
									status : 'ok',
									summary : localizer.getString('hpsum.group.deployDone'),
									details : localizer.getString('hpsum.node.installDoneSee'),
									changing : false
								}; 
							}
							notificationsView.add(notif);

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
						}
						
						else if (item.group_state.match(/INSTALL$/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : localizer.getString('hpsum.group.deployProgress'),
								changing : true
							};
							notificationsView.add(notif);
							showGroupProgress(thisgroup);
							
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(REPORTS_ACTION).addClass('hp-disabled');
							$(DELETE_ACTION).addClass('hp-disabled');
						}

						else if (item.group_state.match(/INSTALLHOLD/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'warning',
								summary : localizer.getString('hpsum.group.deployHoldSummary'),
								changing : false
							});
							
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_state.match(/PENDINGFWUPDATE/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'warning',
								summary : localizer.getString('hpsum.group.groupPendingFwUpdate'),
							});
							
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_state.match(/PENDING_FW_UPDATE/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'warning',
								summary : localizer.getString('hpsum.group.groupIntNodePendingFw'),
							});
							
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.group_state.match(/ACTIVATEPENDINGFWUPDATE|ACTIVATE_PENDING/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'warning',
								summary : localizer.getString('hpsum.group.groupNodeActivatingPendingFw'),
							});
														
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
							showGroupProgress(thisgroup);
						}
						
						
						
						
						
					} else {
						$(TITLE).text('');
						$(STATUS).hpStatus('unknown');
						$(STATUS + ' span').text('');
					}
					
					$(".hp-disabled").css("color", "grey").bind('click.disable-link', function(e) 
					{
                        e.preventDefault();
                        return false;
                    });
				}
				function showGroupProgress(groupItem) {
					getGroupStat(groupItem);
					setTimer(groupItem);
				}
				
				function setTimer(groupItem)
				{
					timer = setTimeout(function() {
					if(gid != groupItem.group_id)
					{
						if(timer)
						{
							clearTimeout(timer);
							timer = '';
						}
					}
	
						presenter.getGroupStatus({
							group_id : groupItem.group_id
						}, {
							success : function(data) {
							if(groupItem.group_id == data.hapi.group_id) {
								if (data.hapi.hcode == 0) {
									if (data.hapi.group_state.match(/INVENTORY|INSTALL$|SCHEDULED/) ||
										(data.hapi.group_state.match(/IDLE/i) && data.hapi.group_phase.match(/Initialize/i))) {
											setTimer(groupItem);
									}
									else {
									clearTimeout(timer);
									timer = '';
									presenter.refreshIndexResults();
									}
								}
								 else {
									
									clearTimeout(timer);
									timer = '';
								}
							}
							},
							error : function(data) {
								clearTimeout(timer);
								timer = '';
							}
						});
						
					}, 10000);
					
				}
				function getGroupStat(groupItem)
				{
						presenter.getGroupStatus({
							group_id : groupItem.group_id
						}, {
							success : function(data) {
							if(groupItem.group_id == data.hapi.group_id) {
								if (data.hapi.hcode == 0) {
									if (data.hapi.group_state.match(/INVENTORY|INSTALL$|SCHEDULED/) ||
										(data.hapi.group_state.match(/IDLE/i) && data.hapi.group_phase.match(/Initialize/i))) {
									}
									else {
										presenter.refreshIndexResults();
									}
								}
								 else {
								}
							}
							},
							error : function(data) {
							}
						});
				}
	
				function onItemError(errorMessage) {
				}

				function onSelectionChange(selection) {
					notificationsCleared = false;
					clearNotifications();
				//	urlFragment.replaceHrefUris(HEADER, selection.uris, selection.multiSelectId);
					if ($(HEADER).hasClass('hp-show-init')) {
						$(HEADER).removeClass('hp-show-init');
					} else {
						$(HEADER).addClass('hp-show-changing');
						$(ACTIONS).addClass('hp-disabled');
					}
				}
				
				function onItemDeleteSuccess(data) {
					notifications.show(localizer.getString('hpsum.group.deletedGroup') + ' ' + thisgroup.group_name, 'ok');
            	}
            	
            	function onItemDeleteError(errorMessage) {
            		notifications.show(errorMessage, 'error');
            	}
	
				function showDeleteInfoDialog() {

					var contents = $(deleteConfirmHtml);
					$('#hpsum-delete-node',contents).html(localizer.getString('hpsum.group.deleteConfirm')+' '+ thisgroup.group_name +'?');
					$('#hpsum-node-delete-ok',contents).html(localizer.getString('hpsum.baseline.show.yesDelete'));
					$('#hpsum-node-delete-cancel',contents).show();

					localizer.localizeDom(contents);

					var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                            presenter.deleteItem(thisgroup, {
								success : function(data) {
									onItemDeleteSuccess(data)
								},
								error : function(message) {
									onItemDeleteError(message)
								}
							});
                        },
                        cancel: function () {
                            hashManager.replaceHash('/group/show/overview');
                        }
                    });
                }
                
				function onDeleteItem() {
					showDeleteInfoDialog();

				}

				function onItemAbortedSuccess(data) {
					notifications.show(localizer.getString('hpsum.group.abortedGroup') + ' ' + thisgroup.group_name, 'ok');
				}

				function onItemAbortedError(errorMessage) {
					notifications.show(errorMessage, 'error');
				}
                   
				function showAbortInfoDialog() { 
					//QXCR1001374918
					var contents = $(abortConfirmHtml);									
					$('#hpsum-abort-node',contents).html(localizer.getString('hpsum.common.group')+' : '+ thisgroup.group_name );
					localizer.localizeDom(contents);
					var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                            presenter.abortItem(thisgroup, {
								success : function(data) {
									onItemAbortedSuccess(data)
								},
								error : function(message) {
									onItemAbortedError(message)
								}
							});
                        },
                        cancel: function () {
                            hashManager.replaceHash('/group/show/overview');
                        }
                    });				                    
				}

				function onAbortItem() {
				    //QXCR1001374918
					showAbortInfoDialog();					
				}
				
				function onRunNow(ev) {
					var schedule_information;
					var scheduled;
					var	action = 'deploynow';
							 
					presenter.ScheduleNodes(thisgroup,action,scheduled,schedule_information, {
						success : function(data) {
							onRunNowSuccess(data); 
						},
						error : function(errorInfo) {
							onRunNowError(errorInfo);
						}
					});	
				}
				
				function onRunNowSuccess()
				{
					showGroupProgress(thisgroup);
				}
				function onRunNowError()
				{
				
				}
				function onDeleteSchedule(ev) {
					var contents = $(dialogHtml);
					$('#hpsum-groups-warning-title',contents).html('Delete');
					$('#hpsum-groups-message',contents).html(localizer.getString('hpsum.group.deleteschedule'));
					$('#hpsum-groups-schedule-info',contents).hide();
					$('#hpsum-groups-schedule-options',contents).hide();
					$('#hpsum-groups-confirm',contents).hide();
					$('#hpsum-node-delete-cancel',contents).show();
					
					localizer.localizeDom(contents);
					var dialogView = new DialogView();
					dialogView.init({contents: contents,
						ok: function () {
							btnScheduleDelete();
						},
						cancel: function () {
							hashManager.replaceHash('/group/show/overview');
						}
					});
				}
				
				function btnScheduleDelete()
				{
					var scheduled;
					var schedule_information;
					var action = 'delete';
						 
					presenter.ScheduleNodes(thisgroup,action,scheduled,schedule_information, {
						success : function(data) {
							onDeleteScheduleSuccess(data); 
						},
						error : function(errorInfo) {
							onDeleteScheduleError(errorInfo);
						}
					});	
				}
				
				function onDeleteScheduleSuccess()
				{
					var	message = "Schedule for " + thisgroup.group_name + " group deleted successfully";
					notifications.show(message, 'ok');  

					showGroupProgress(thisgroup);
				}
				function onDeleteScheduleError()
				{
				
				}
				
				function convertDateTime(date_time)
				{
					if(date_time !== "")
					{
						var date_time_split = date_time.split(' ');
						var time_hrs_mins = date_time_split[1].split(':');
						var time_hrs = time_hrs_mins[0];
						date_value = date_time_split[0];
						time_value = '';
						date_time_new = '';
						if((date_time_split[2] == 'PM') && (parseInt(time_hrs) < 12))
						{
							time_hrs = parseInt(time_hrs) + 12;
						}
						else if(date_time_split[2] == 'AM')
						{
							if (parseInt(time_hrs) < 10 && parseInt(time_hrs) < 12)
							{
								time_hrs = '0' + parseInt(time_hrs);
							}
							else if (parseInt(time_hrs) == 12)
							{
								time_hrs = parseInt(time_hrs) - 12;
								time_hrs = '0' + parseInt(time_hrs);
							}
						}
						time_value = time_hrs + ':' + time_hrs_mins[1];
						date_time_new = date_value + ' ' + time_value;
					}
				}

				/**
				 * @public
				 * Initialize Group Show View
				 */
				this.init = function() {
					notificationsView.init($(VIEW));
					$(ACTIONS).hpDropMenu();
					$(ABORT_ACTION).bind('click', function(ev) {
						$(ACTIONS).hpDropMenu();
						if($(ABORT_ACTION).hasClass("hp-disabled")) 
						{
							ev.preventDefault();
							return;
						}
						else
						{
							onAbortItem.call(this);
							ev.preventDefault(); 
						}
					});
					$(DELETE_ACTION).bind('click', function(ev) {
						$(ACTIONS).hpDropMenu();
						if($(DELETE_ACTION).hasClass("hp-disabled")) 
						{
							ev.preventDefault();
							return;
						}
						else
						{
							onDeleteItem.call(this);
							ev.preventDefault(); 
						}
					}); 
					this.resume();
				};

				/**
				 * @public
				 * Resume Group Show View
				 */
				this.resume = function() {
					notificationsCleared = false;
					presenter.on("selectionChange", onSelectionChange);
					presenter.on("itemChange", onItemChange);
					presenter.on("itemError", onItemError);
					$(INVENTORY_ACTION).bind('click',onInventory);
					if (notificationsView.resume) {
						notificationsView.resume();
					}
					
				};

				/**
				 * @public
				 * Pause Group Show View
				 */
				this.pause = function() {
			
					presenter.off("selectionChange", onSelectionChange);
					presenter.off("itemChange", onItemChange);
					presenter.off("itemError", onItemError);
					$('#hpsum-group-schedule-run').unbind('click').bind('click', onRunNow);
					$('#hpsum-group-scheduledelete').unbind('click').bind('click', onDeleteSchedule);
					$(INVENTORY_ACTION).unbind('click',onInventory);
					if (notificationsView.pause) {
						notificationsView.pause();
					}
				};
			}

			return new GroupShowView();
		}());

	return GroupShowView;

});
