// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter', 
    'hp/core/UrlFragment',
    'hp/core/Router',
    'hp/core/LinkTargetBuilder',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
	'hp/services/REST',
	'hp/model/Session',
    'jquery',
    'hp/lib/jquery.hpGridPanels'],
function(presenter, urlFragment,router, linkTargetBuilder, noneHtml, localizer,rest, session) { "use strict";

    var IloOverviewView = (function() {
      
        var ROOT = '#hpsum-ilo-show-overview';
        var PANELS = '.hp-grid-panels',
        	DESCRIPTION = '#hpsum-ilo-description',
        	TYPE ='#hpsum-ilo-type',
        	BASELINE='#hpsum-ilo-bundle',
        	LOCATION='#hpsum-ilo-location',
        	OA = '#hpsum-ilo-oa',			
			ASSOC_DEVICES = '#hpsum-iLO-assocdevices',
			NO_ASSOC_DEVICES = '#hpsum-iLO-no-devices',
        	INSTALLEDROM ='#hpsum-ilo-installed-rom',
        	ACTIVEROM = '#hpsum-ilo-active-rom',
        	MATRIXENABLED = '#hpsum-ilo-matrix-enabled',
        	MATRIXVERSION = '#hpsum-ilo-matrix-version',
			GROUP = '#hpsum-server-group',
        	SPINNER = '#hpsum-node-add-spinner',
            INSTALL_LOGS = '#hpsum-ilo-install-log',
			EDIT_GENERAL = '#hpsum-ilo-general-edit';
      
        /**
         * Constructor
         */
        function IloOverviewView() {
          
            var noItem;
            var timer= null;
            var thisNode=null;
            
            function onItemChange(item) {
            	item = item.hapi;
            	thisNode =item;
                noItem.remove();
				$(ASSOC_DEVICES).html('');
 		        $(NO_ASSOC_DEVICES).show();
        		
        		item.type = item.type.toLowerCase();
        		var uitype = presenter.getUINodeType(item.type);
        		$(ROOT).closest('section').show();
        		
        		if(!router.location().match(uitype)) {
        		    if(router.location().indexOf("/node") == 0)
        		    	router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')), "ilo show overview");
        		    else {
        		    	$(ROOT).closest('section').hide();
        		      	return;
        		    }
                }
               
                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();
				
				$(EDIT_GENERAL).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
				if(item.node_state.match(/inventory/i) || item.node_state.match(/installhold/i) || item.node_state.match(/pendingfwupdate/i) ||
                   item.node_state.match(/activatependingfwupdate/i) || item.node_state.match(/scheduled/i) || item.node_state.match(/Install$/i) || 
				   item.node_state.match(/activate_pending/i)){
					$(EDIT_GENERAL).addClass('hp-disabled');
					$('.hp-disabled').css("color", "grey").bind('click.disable-link', function(e) {
						e.preventDefault();
						return false;
					});	
				}
				
        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        		//	 getNodeStatus(item);
        		}
        		else {
        			$(SPINNER).hide();
        			//$(NO_ASSOC_DEVICES).hide();
					//$(ASSOC_DEVICES).hide();
					$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');     			
        			$(DESCRIPTION).text(item.description);
        			if(item.hasOwnProperty('serial_number'))
        				$(LOCATION).text(item.serial_number);
        			else 
        				$(LOCATION).text('');
        			if(item.hasOwnProperty('version')){
						//$(NO_ASSOC_DEVICES).hide();
						//$(ASSOC_DEVICES).show();
        				$(INSTALLEDROM).text(item.version);
        				$(ACTIVEROM).text(item.active_version);
						if ( item.auto_add_assoc_nodes == true )
						{
							var node_uri = "/Session/" + session.getToken() + "/node/" + item.node_id;
							rest.getURI(node_uri +"/getAssociatedNodesCompData",
							{
								nodeid : item.node_id,
								success : function(data) {
								var nodeAssoData = data.hapi.associated_nodes;
								showAssociatedDevices(item,nodeAssoData);
								$(PANELS).hpGridPanels();
					
							},
								error : function(errorInfo){ }
							});
						}				
        			}
        			else{
        				$(INSTALLEDROM).text('');
        				$(ACTIVEROM).text('');
        				//$(NO_ASSOC_DEVICES).show();
						//$(ASSOC_DEVICES).hide();
        			}
        			
        			if(item.product_id == undefined)
        				$(TYPE).text(item.type);
        			else
        				$(TYPE).text(item.product_id);
        			
					$(GROUP).text('');
					if( item.group_name.length == 0) {
						$(GROUP).text('none');
					}
					else {
				
						for(var iter=0 ; iter<item.group_name.length ; iter++)
						{
							var group_uri = '#/group/show/overview/r/session/'+ item.node_session + '/node/group/' + item.groups[iter]+'/getdata';
							
							//Code changes for placement. The code needs some spacing before the individual groups are appended.
							var uri = '<a href="'+group_uri+'">' +item.group_name[iter].group_name+ '</a>' ;
							if(iter == 0) {
								$(GROUP).append(uri);
							}
							else
							{
								$(GROUP).append('&nbsp;&nbsp;' + uri);
							}
								
						}
					}
        			var fwBaseline =presenter.getBaselineOrPkg(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  

                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();

        		}
                $(PANELS).hpGridPanels('reset');
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }
            
function showAssociatedDevices(item,nodeAssoData)
{
	if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id )
		nodeAssoData.node = new Array(nodeAssoData.node);
	if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id==undefined)
		return;
	if(nodeAssoData.node.length==0)
		return;
	$(NO_ASSOC_DEVICES).hide();
	var tablecontents = "<table><tr> <td> <u>" + localizer.getString('hpsum.enclosure.deviceType') + "</u> </td> <td> <u>" + localizer.getString('hpsum.common.ipDns') + "</u> </td></tr>";            	

	for(var i=0; i<nodeAssoData.node.length; i++)
	{
		if(nodeAssoData.node[i].node_id)
		{
			var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ nodeAssoData.node[i].node_id+'/getData';
			tablecontents += "<tr><td>" + nodeAssoData.node[i].type +'</td><td>' + '<a href= "' + assoc_node_url + '">' +nodeAssoData.node[i].ip_or_dns+'</a>' + '</td></tr>';
		}
		else
		{
			tablecontents += "<tr><td>" + nodeAssoData.node[i].type +'</td><td>' + nodeAssoData.node[i].ip_or_dns + '</td></tr>';
		}
	}
	tablecontents += "</table>";
	$(ASSOC_DEVICES).html(tablecontents);
}
			
            function getNodeStatus(item){
            	  var ilotimer = setInterval(function () {
            		
            		presenter.getNodeStatus(item, {
                				success : function(data) {
                    				onIloStatusSuccess(data,ilotimer);
                    		 	},
                    			error : function(errorInfo) {
                        			onNodeStatusError(errorInfo,ilotimer);
                    			}
                			});
                			
                }, 3000);
            }
            
            function onIloStatusSuccess(data,ilotimer){
            	if(thisNode.node_id == data.hapi.node_status.node_id) {
            		if(!data.hapi.node_status.node_phase.match(/initialize/i)){
        				clearInterval(ilotimer);
        				ilotimer = 0;
        				presenter.refreshIndexResults();
        			}
        		}
            }   
            function onNodeStatusError(){
            	
            }      
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
                if ($(ROOT).hasClass('hp-show-init')) {
                    $(ROOT).removeClass('hp-show-init');
                } else {
                    $(ROOT).addClass('hp-show-changing');
                    $('#tour-server-bundle-item').addClass('hp-show-changing');
                }
            }
          
            /**
             * @public
             */
            this.resume = function() {
                $(PANELS).hpGridPanels('reset');
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
                
            };
            
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                
            };
             
            this.init = function() {
            	if(!presenter.initialized())
            		presenter.init();
                noItem = $(noneHtml);
                $(PANELS).hpGridPanels();
                this.resume();
            };
        }

        return new IloOverviewView();
    }());
    
    return IloOverviewView;
});
