// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type (iloFederationView)
 * This is a view class for ilo federation
 * Provides functions for showing master pane and its action.
 */
define(['hpsum/model/ilofederation/iloFederationResource',
	'hp/view/MasterPaneView',
	'hpsum/presenter/ilofederation/iloFederationPresenter',
	'hp/core/Localizer',
    'hp/core/Notifications',
    'jquery',
	'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'hp/lib/jquery.hpSafeClone'],
function(resource, MasterPaneView, presenter, localizer,notifications) {"use strict";

    var iloFederationView = ( function() {
		
		var TYPE = 'ilofederation';
		var PAGE = '#hpsum-ilofederation-page';
        var REFRESH = '#hp-ilofederation-refresh';

        /**
         * @constructor
         * @type {iloFederationView}
         */
        function iloFederationView() {

			var masterPaneView = new MasterPaneView();
			var template = null;
			var types = [],
			     types_existing =[];
            var refreshtimer =0;
			
			function renderer(indexResult) {
               var item = template.hpSafeClone();
                $('.hp-status', item).hpStatus(indexResult.sug_status, indexResult.changing);
                $('.hp-master-item-name', item).html(indexResult.name);
                $('.hpsum-node-type',item).html(localizer.getString('hpsum.common.type') + ':' + indexResult.type);
                $('.hpsum-node-status',item).html(localizer.getString('hpsum.common.statusStr') + ':' +indexResult.sug_status);

                return item;
            }
			
			function getItemUrl(oObj){
								// add Filters
                var types = presenter.getAllNodeTypes();
               	var html = '<li id="hpsum-option-oa" data-id="ilo_federation" class="hp-selected">' + localizer.getString('hpsum.common.all') + '</li>';
                $('#types', PAGE).html(html);
                
                return oObj.aData.name;
                //Commented the following lines to avoid opening the node in another tab in the browser
                /*
	    		return '<a href="#/' + TYPE + '/show/r' + oObj.aData.uri + '?f_q=type:virtual_connect' +
                                    '">' + oObj.aData.name +
                                    '</a>';
                */
				
			}

            function setupRefreshButton()
            {
                var rescanelem = $("<div class='hp-master-add hpsum-refresh' >"
                                                                + "<a href='#' id='hp-ilofederation-refresh' class='hp-button hp-secondary' style='background-image:none; padding-left:10px;' data-localize='hpsum.ilofederation.rescan'>"
                                                                +"[rescan]</a></div>");


                localizer.localizeDom(rescanelem);
                var graphik = $( "<div id='circular3dG'>"
                                    + "<div id='circular3d_1G' class='circular3dG'>"
                                    + "</div>" 
                                    + "<div id='circular3d_2G' class='circular3dG'>" 
                                    + "</div>" 
                                    + "<div id='circular3d_3G' class='circular3dG'>" 
                                    + "</div>" 
                                    + "<div id='circular3d_4G' class='circular3dG'>" 
                                    + "</div>" 
                                    + "<div id='circular3d_5G' class='circular3dG'>"
                                    + "</div>"
                                    + "<div id='circular3d_6G' class='circular3dG'>"
                                    + "</div>"
                                    + "<div id='circular3d_7G' class='circular3dG'>"
                                    + "</div>"
                                    + "<div id='circular3d_8G' class='circular3dG'>"
                                    + "</div>"
                                    + "</div>");
                $('#hp-ilofederation-refresh',$(rescanelem)).prepend($(graphik));
                $('.hp-master-header .hp-master-add').after(rescanelem); 
          
                $('#circular3dG').hide();
            }

            var refreshClicked = function(event)
            {
                if(!refreshtimer)
                {

                var check = false;
                presenter.refresh({
                                      success:function(data){
                                             if(!check && data.hapi.hcode == 0)
                                             {
                                                check=true;
                                                $('#circular3dG').show();  
                                             }

                                             var notif = {
                                                                summary : data.hapi.hmessage,
                                                                status : 'ok',
                                                                sourceName : 'Scalable Update',
                                                            };
                                              notifications.add(notif, true);
                                        },
                                        error:function(data){ 
                                           
                                        }
                                    } , check);

                refreshtimer = setInterval(function()
                             {
                                 presenter.refresh({
                                        success:function(data){
                                             if( data.hapi.hcode == 0)
                                             {
                                                $('#circular3dG').hide();
                                                clearInterval(refreshtimer);
                                                refreshtimer = 0;

                                                var notif = {
                                                                summary : data.hapi.hmessage,
                                                                status : 'ok',
                                                                sourceName : 'Scalable Update',
                                                            };
                                                notifications.add(notif, true);
                                                presenter.resource().getIndexResults();

                                             }
                                        },
                                        error:function(data){ 
                                           clearInterval(refreshtimer);
                                           refreshtimer = 0;
                                        }
                                    } , check);
                                },5000);
                }


                event.preventDefault();
            }
            /**
             * @public
             */
            this.init = function() {
				presenter.init();
                
                template = $('#hpsum-node-item-template').detach().show().attr('id', '');
                
 				//presenter.setFilter("type:ilo_federation");
                
                masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: presenter.resource(),
                    page: $(PAGE),
                    multiSelect: false,
                    addLink: presenter.getAddLink("addIloFedarationNode"),//Human Factor changes req:HF02
                    resetLink: presenter.getResetLink(),
                    dataTableOptions:  {
                        aoColumns : [
                            {fnRender: function (oObj) {
                                return '<div>' + oObj.aData.status +
                                    (oObj.aData.changing ? ' *' : '') +
                                    '</div>';
                            }, mDataProp: 'status'},
                            {fnRender: getItemUrl, mDataProp: 'name', sType: "string"} //,
                            //{mDataProp: 'attributes.model'}
                        ],
                        aaSorting: [[ 1, "asc" ]],
                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0) > div', nRow).hpStatus();
                            return nRow;
                        }
                    },
                    gridItemRenderer: renderer
                });

                //The refresh button is not yet set.So lets get the add button and set the tool tip.
                $('.hp-master-add a').attr('tooltip', localizer.getString('hpsum.ilofederation.iLOFederationGroup')).hpTooltip();

                setupRefreshButton();

         	    this.resume();
               
  
            };

            /**
             * @public
             */
            this.pause = function() {
				masterPaneView.pause();
                $(REFRESH).off('click' ,refreshClicked);

            };

            /**
             * @public
             */
            this.resume = function() {
				masterPaneView.resume();
                $(REFRESH).on('click' ,refreshClicked);

                
            };
        }

        return new iloFederationView();
    }());

    return iloFederationView;
});
