// AssociatedNodeDetails
// This is a view class for asking user for associated target credentials
define(['hpsum/presenter/node/NodePresenter',
	'hp/core/Localizer',
    'jquery'],
function(presenter, localizer) { "use strict";

    var NodeAssociatedNodeDetails = (function() { 
    	
    	var OKBUTTON = '#hpsum-node-partner-ok',
    		CANCELBUTTON = '#hpsum-node-partner-cancel',
    		USERNAME = '#hpsum-node-partner-username',
    		USERNAME_ERR ='#hpsum-node-partner-username-err',
    		PASSWORD = '#hpsum-node-partner-password',
    		PASSWORD_ERR ='#hpsum-node-partner-password-err',
    		TYPELABEL ='#hpsum-node-partner-ip',
    		TYPE = '#hpsum-node-partner-ip-value',
    		NOTIFICATION = '#activatepending-notification';   

        /**
         * Constructor
         */
        function NodeAssociatedNodeDetails() {
        	
        	var nodeItem = null;
        	var submitInProgress = false;
        	var assocNodeType= '';
           
			function onItemChange(item) {
				nodeItem = item.hapi;
				if(nodeItem.type.match(/virtual_connect|sas_switch/i) ){
					assocNodeType = 'oa';
					$(TYPELABEL).text(localizer.getString('hpsum.node.onboardAdministrator'));
					if(nodeItem.oa_ip_address){
						$(TYPE).text(nodeItem.oa_ip_address);
						$(TYPE).attr('disabled','disabled');
					}
					else {
						$(TYPE).removeAttr('disabled');
						$(TYPELABEL).hide();
						$(TYPE).hide();	
					}
						
				}
				else if(nodeItem.type.match(/ipdu/i) ){
					assocNodeType = 'ipdu';
					$(TYPELABEL).text(localizer.getString('hpsum.node.intelligentPowerDistributionUnit'));
					if(nodeItem.partner_available == 'true'){
							if(item.partner_ip_address_ipv4 == '')
        						$(TYPE).text(partner_ip_address_ipv6);
        					else
        						$(TYPE).text(partner_ip_address_ipv4);
						$(TYPE).attr('disabled','disabled');
					}
					else {
						$(TYPE).removeAttr('disabled');
					}
				} 
					
			}
            
            function validate(){
            	var success = true;
            	if($(USERNAME).val() == ''){
            		$(USERNAME).addClass("hp-error");
            		$(USERNAME_ERR).show();
            		$(USERNAME).bind('keyup', function(){
            			$(USERNAME_ERR).hide();
            			$(USERNAME).removeClass('hp-error');
            		});
            		success= false;
            	}
            	if($(PASSWORD).val() == ''){
            		$(PASSWORD).addClass("hp-error");
            		$(PASSWORD_ERR).show();
            		$(PASSWORD).bind('keyup', function(){
            			$(PASSWORD_ERR).hide();
            			$(PASSWORD).removeClass('hp-error');
            		}); 
            		success= false;
            	}
            	return success;
            }
            
			
			function onSubmitSuccess() {
				$(CANCELBUTTON).trigger('click');
			}
			
			function onSubmitError(errorMessage) {
				$(OKBUTTON).attr('disabled','disabled');
				$(CANCELBUTTON).trigger('click');
			}
			
			function onSubmitDetails()
			{
				if(!submitInProgress) {
					if(validate()){
						var assocData = {
							hapi:{
							associated_node : {
								ip: $(TYPE).val(),
								type : assocNodeType,
								username : $(USERNAME).val(),
								password :$(PASSWORD).val()		
							}
							}
						};
						
						submitInProgress = true;
						presenter.setattribute(nodeItem, assocData,
								{
									success: onSubmitSuccess(),
									error : onSubmitError()
								});
						
					}
				}
			}

			this.resume = function () {
				presenter.on("itemChange", onItemChange);
				 $(USERNAME).removeClass("hp-error");
            	 $(PASSWORD).removeClass("hp-error");
            	 $(USERNAME_ERR).hide();
            	 $(PASSWORD_ERR).hide();
            };
            
            this.pause = function() {
            	presenter.off("itemChange", onItemChange);
            	$(USERNAME).text('');
            	$(PASSWORD).text('');
            };
          
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
            	
                			
                $(OKBUTTON).on('click', function(){
					onSubmitDetails.call(this);
                   //	ev.preventDefault();
                });
                
                this.resume();
                					
            };
        }

        return NodeAssociatedNodeDetails;
    }());
    
    return new NodeAssociatedNodeDetails();
});