// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (NodeDeployView)
 * This is a view class for Custom Baseline Add menu option.
 */
define(['hpsum/presenter/node/NodePresenter',
	'hp/core/Router',
	'hp/core/UrlFragment',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
	'hp/view/DialogView',
	 'hp/services/REST',
	'hp/core/Localizer',
	 'hp/model/Session',
	'text!hpPages/core/header_help.html',
	'hp/view/FormStateView',
    'jquery',
    'hpsum/view/node/jquery.hpsumInstallables',	
    'hpsum/view/node/jquery.hpsumWarnings',	
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery.dataTables.rowReordering',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',	
	'lib/jquery-ui-timepicker-addon',
	'hp/lib/jquery.hpSearchCombo'],

function(presenter, router,urlFragment, notifications,helpMenu, DialogView, rest,localizer,session,headerHelpHtml, FormStateView) { "use strict";

    var NodeDeployView = (function() {
      
        var DEPLOY = '#hpsum-node-deploy-ok',
			ASSOC_ANALYSIS = '#hpsum-assoc-node-deploy-analysis',
            CANCEL = '#hpsum-nodes-deploy-close',
			PANEL_SELECTOR = '#hpsum-deploy-panel-selector',
            PANELS = '#hpsum-node-deploy-panels',						
			DESCR = '#hpsum-node-deploy-descr',
			REBOOTOPTION = '#hpsum-reboot-option',
			COMPVERBOSEOPTION = '#hpsum-comp-verbose-checkbox',
			DELAYSEC= '#hpsum-node-delay-seconds',
			DELAYSECERR = '#hpsum-node-delay-seconds-err-msg',
			DELAYMSG= '#hpsum-node-reboot-message',
			TYPE = '#hpsum-node-deploy-type',
			//GROUP = '#hpsum-node-deploy-group',			
            ROUTE_PREFIX = '/node/deploy',
			NONECHECKBOX = '.nonecheckbox',
			USESNMPCHECKBOX ='.useSNMPcheckbox',
			USEAGENTLESSCHECKBOX ='.useAgentlesscheckbox',
			USEWEBEMCHECKBOX ='.useWEBEMcheckbox',
			INSTALLATIONOPTION = '#hpsum-installation-option',
			DEPLOYENCCHKBOXCOMP ='.enclosurechkbox',	
			COMMON_REBOOT = '#hpsum-common-reboot-options',
			REBOOT_ACTIVATE = '#hpsum-reboot-to-activate-options',
			ACTIVATE_SELECTION = '#hpsum-activate-selection',
			NO_REBOOT_REQ = '#hpsum-no-reboot-required',
    		FORM = '#hpsum-node-deploy-add-form',
			ASSOC_NODES = '#all-assocnodes',
			ASSOC_NODE_DIALOG = '#hpsum-assoc-node-dialog',
			ASSOC_NODE_COMP = '#hpsum-assoc-node-components',
			ASSOC_OPTIONS = '#assoc-options',
			ASSOC_NODE_ANALYSIS = "#hpsum-assoc-node-deploy-analysis",
		    SPLASH_DIALOG = '#hpsum-splash-dialog',
        	iLOFED_TECH_PREVIEW_WARNING = '#ilo-federation-tech-preview-warning',					 		
        	VC_ENCRYPTION_SETTINGS = '#hpsum-node-deploy-vc-encryption-collapsible',
        	SPLASH_SPINNER = '#hpsum-splash-spinner',
    		SCHEDULETOGGLE ='#hpsum-node-schedule-enable',
			SCHEDULE_DATE = '#hpsum-node-schedule-date',
			SCHEDULE_TIME = '#hpsum-node-schedule-time',
			SCHEDULE_TIME_LABEL = '#hpsum-node-schedule-time-label',
			SCHEDULE_ERROR = '#hpsum-node-schedule-error',
			CURRENT_DATETIME = '#hpsum-node-current-datetime',
			TIME_ZONE = '#hpsum-node-timezone',
			INSTALL_ERROR='#force-options-tbody-err',
			DATETIMESECTION ='#hpsum-node-schedule-datetimepick',
			REBOOT_DISABLE = '.hpsum-otu-node-deploy-disable',
			REBOOT_DELAY_SEC = '60';
        /**
         * Constructor
         */
        function NodeDeployView() {
			var formStateView = new FormStateView();
            var nodeItem=null;
			var scheduled_getdata_date_time;
			var scheduled_getdata;
			var schedaction;
			var schedule_time;
			var failedDependencyCount = 0;
			var deploy_flag = false;
			var assoc_deploy_flag = false;
			var assoc_dialog_openedonce = false;
			var applyOptions = false;
			var selectedComponentsCount = 0;
			var isSelectionChanged = false;
			var timezone;
			var optiondetails = { 
				hapi: {
					reboot_options: {
						action:'Never',
						delay : REBOOT_DELAY_SEC,
						message :'Reboot at user request after deploy '												
					},
					activate_sfw: false,					
					deploy_enclosure: false,
					associated_nodes: {
						associated_node: []
					}
            	}
            };
            
			var ForceOptions = { 
				hapi: {					
					installation_option:{
						firmware :false,
						software :false,
						downgrade: false,
						rewrite:false,
						force:false,
						forcefirmware:false,
						forcesoftware:false              
					},					
            	}
            };
            var displayBaselineError = false;
			var initialGetattr = null;
			var assocNodeDialogContents = null,
                assocNodeDialog = null;
			var skipInstallOptions = false;
			var selectedAssociatedNodes = [];
            
			function onItemChange(item) 
			{
				nodeItem = item.hapi; 

				if( ( nodeItem.type.match(/windows/i) || nodeItem.type.match(/linux/i) ) && 
				     item.node_phase.match(/UserActionNeeded/i) &&
				     ( item.node_state.match(/remote_staging_uan/i) || item.node_state.match(/idle/i) ) )
				{
                      router.go(urlFragment.replaceView(router.location(), 'stage'));
				}
				if(item.node_phase.match(/deploying/i)) {
					$(CANCEL).trigger('click');
				}
            	           	
                if(item.node_state.match(/install/i)) {
                    $(CANCEL).trigger('click');
                }
                if (nodeItem) {
					skipInstallOptions = false;
                    //for some reason, the getattributes is called multiple times sometimes as undefined node                	
			        loadAttributes();
					//Load the Schedule Information from getdata
					loadScheduleoptions(nodeItem);
                    //If the user has deleted the baseline then we cannot proceed to deploy
                    //so we display a message that there is no available baseline and exit
                    if(nodeItem.baselines.length == 0 && !displayBaselineError) {
                        displayBaselineError = true;
                        $("<div></div>").dialog( {
                            buttons: { "Ok": function () {
                                displayBaselineError = false;
                                $(this).dialog("close");
                                $(CANCEL).trigger('click');
                                }
                            },
                            close: function (event, ui) { $(this).remove(); },
                            resizable: false,
                            title: localizer.getString("hpsum.node.doDeploy"),
                            modal: true
                        }).text( localizer.getString("hpsum.node.noBaselineAvailable") );
                    }
                    $(DESCR).text(nodeItem.name);
                    $(TYPE).text(nodeItem.type);
                    
					$('#vmware-rewrite-warning').hide();
					//$(GROUP).text(nodeItem.group);
					if(nodeItem.type.match(/Windows|Linux/i)) {
					   $('#hpsum-osmanagement-options-collapsible').css("display","block");
                    } else if(nodeItem.type.match(/integrityilo|virtual_connect|ipdu|OA|sd2oa|ilo|switch|SAS_SWITCH/i)) {
					    $('#hpsum-installation-options-collapsible').css("display","none");
					    $('#hpsum-force-options-collapsible').css("display","none");
					    if(nodeItem.type.match(/virtual_connect/i)) {
					        $('#hpsum-vc-options-collapsible').css("display","block");
					        if(nodeItem.is_config_password_required)
                                $(VC_ENCRYPTION_SETTINGS).css("display","block").removeClass('hp-collapsed');
                        }
                    } else if(nodeItem.type.match(/moonshot/i)) {
                        $('#hpsum-installation-options-collapsible').css("display","none");
                        $('#hpsum-force-options-collapsible').css("display","none");
                        $('#hpsum-reboot-options-collapsible').css("display", "none");
                        $("#hpsum-assocnodes-collapsible").css("display", "none");
					}
					
					//Expand reboot options for hp-ux
					if(nodeItem.type.match(/hpux/i)) {
					    $('#hpsum-reboot-options-collapsible').removeClass('hp-collapsed');
					}
					
					$('#hpsum-warning-messages').hpsumWarnings(nodeItem, true);
			  		if(nodeItem.type.match(/vmware/i)) {
                        $('#vmware-rewrite-warning').show();
                    }
						
                    if(nodeItem.hasOwnProperty('activate_sfw'))
					{
                        $('#hpsum-reboot-options-collapsible').css("display","block");
					    $('#hpsum-reboot-options-collapsible').removeClass('hp-collapsed');
						$(COMMON_REBOOT).hide();
						$(REBOOT_ACTIVATE).show();
						if(!nodeItem.is_powered_on) {
							$(ACTIVATE_SELECTION).closest("li").hide();
							$(NO_REBOOT_REQ).show();
						} else {
							$(ACTIVATE_SELECTION).closest("li").show();
							$(NO_REBOOT_REQ).hide();
						}
						if(nodeItem.activate_sfw) {
							$(ACTIVATE_SELECTION).selectBox('value', 'YES');
						} else {
							$(ACTIVATE_SELECTION).selectBox('value', 'NO');
						}
					} else {
						if(nodeItem.type.match(/windows|linux|hpux|vmware/i)){
						$(COMMON_REBOOT).show();
						$(NO_REBOOT_REQ).hide();
						$('#hpsum-reboot-options-collapsible').css("display","block");
						$(REBOOT_ACTIVATE).hide();
						}
						else{
							$('#hpsum-reboot-options-collapsible').css("display","none");
						}
					}     
					var options = {
						command:'init',
						nodeItem:nodeItem,
						onSelectionChanged:onSelectionChanged,
						onPopulateInstallSet:onPopulateInstallSet
						
					};
					
					//Call plugin to show the component list ();
					$('#all-baselines').hpsumInstallables(options);
												
					if(nodeItem.node_state === 'UAN') {
						//The problem is that getdata is called multiple times and there is a chance of changing Deploy button attributes in the following
						//code. So adding conditions to check if the deploy button is enabled or not, based on this change the attribute
						if($(DEPLOY).attr("disabled") == "disabled") 
						    $(DEPLOY).attr("disabled", true);	
						else 
						    $(DEPLOY).attr("disabled", false);
					}
					else if (nodeItem.node_state === 'INSTALLDONE')
					{
						$(DEPLOY).attr("disabled", true);	
					}	
					else
					{	
						$(DEPLOY).attr("disabled", true);	
					}
					showInstallationOptions(nodeItem);
					showAssociatedNodes(nodeItem);

					if(!nodeItem.type.match(/windows/i)) {
						$("#hpsum-comp-verbose-descr").hide();
						$(COMPVERBOSEOPTION).hide();
					}
					//if node is an iLO Federation, then disabling Deploy and Analysis buttons. 
					//This is for HPSUM 6.3.0 release as Deploy functionality is not included.
					if(nodeItem.type.match(/ILO_FEDERATION/i)) {
						$(iLOFED_TECH_PREVIEW_WARNING).fadeIn();
						$(DEPLOY).attr("disabled", true);
					} else {
						$(iLOFED_TECH_PREVIEW_WARNING).hide();
					}
					
					//Schedule Information
					var schedule_date_time_old = nodeItem.local_date_time.split(' ');
					var schedule_time_format = schedule_date_time_old[2];
					var schedule_time = schedule_date_time_old[1];
					var schedule_time_hrs_mins = schedule_time.split(':');
					var schedule_time_hrs = schedule_time_hrs_mins[0];
					var schedule_date_time_new;
					if(schedule_time_format == 'pm')
					{
						if (schedule_time_hrs < 12)
						{
							schedule_time_hrs = parseInt(schedule_time_hrs) + 12;
							schedule_date_time_new = schedule_date_time_old[0] + ' ' + schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
						}
						if (schedule_time_hrs == 12)
						{
							schedule_time_hrs = parseInt(schedule_time_hrs) + 0;
							schedule_date_time_new = schedule_date_time_old[0] + ' ' + schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
						}
					}
					if(schedule_time_format == 'am')
					{
						if (schedule_time_hrs < 12)
						{
							schedule_time_hrs = parseInt(schedule_time_hrs) + 0;
							if(schedule_time_hrs < 10)
							{
								schedule_date_time_new = schedule_date_time_old[0] + ' ' + '0' +schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
							}
							else
							{
								schedule_date_time_new = schedule_date_time_old[0] + ' ' +schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
							}
							
						}
						if (schedule_time_hrs == 12)
						{
							schedule_time_hrs = parseInt(schedule_time_hrs) - 12;
							schedule_date_time_new = schedule_date_time_old[0] + ' ' + '0'+ schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
						}
					}
					timezone = nodeItem.schedule_timezone;
					$(CURRENT_DATETIME).html(schedule_date_time_new);
					$(TIME_ZONE).html(timezone);
                } else {
					notifications.show(localizer.getString('hpsum.node.pleaseSelectCorrectNode'), 'error');
                    $(DESCR).text("");
                    $(TYPE).text("");
					$(DEPLOY).attr("disabled", true);	
					$(CANCEL).trigger('click');	
                }
				formStateView.reset();
            }		
			
			function onSelectionChanged(id, value, componentList){
				if(value == true){
					isSelectionChanged = true;
					$(DEPLOY).attr("disabled", false);
				}
				selectedComponentsCount = componentList.component.length;
				if(componentList.component.length > 0)
				{
					$(DEPLOY).attr("disabled", false);
				}
                else
                {
					$(DEPLOY).attr("disabled",true);
                }

				if(false == value && componentList.failed_dependency > 0)
				{
					$(DEPLOY).attr("disabled",true);
				}
									
                //VC Encryption settings
                if(nodeItem.type.match(/virtual_connect/i) && nodeItem.is_config_password_required) {
					if(!$('#hpsum-node-vc-encryption-key').val()) {
						$(DEPLOY).attr("disabled", true);
                    }
                }
					
				//if node is an iLO Federation, then disabling Deploy and Analysis buttons. 
				//This is for HPSUM 6.3.0 release as Deploy functionality is not included.
				if(nodeItem.type.match(/ILO_FEDERATION/i)) {
					$(DEPLOY).attr("disabled", true);	
				}
				
				// Block deploy button if there is any unchecked ignore warnings checkbox
				// save disabled status to enable recovery it if ignore warnings changed
				$(DEPLOY).attr("disabled_org", $(DEPLOY)[0] && $(DEPLOY)[0].disabled ? 1:0);
				if ($(".ignorewarnings")[0] && !$(".ignorewarnings").is(':checked')) {
					$(DEPLOY).attr("disabled", true);
			}
			}
			
            function showInstallationOptions(data){
            	//send getattributes for this node
            	
            	if(data && data.hasOwnProperty("hapi"))
				{
					if(data.hapi.hasOwnProperty("reboot_options") && data.hapi.reboot_options)
					{
						$('#hpsum-reboot-option option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.reboot_options.action))
		    		            $(this).attr('selected', true);
		                  });
						if( -1 < data.hapi.reboot_options.delay){
							$(DELAYSEC).val(data.hapi.reboot_options.delay);				
						}
						else{
							$(DELAYSEC).val(REBOOT_DELAY_SEC);				
						}
						
						$(DELAYMSG).attr('value', data.hapi.reboot_options.message);
						$(REBOOTOPTION).selectBox('reset');
					}
					if(data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option){
						var rewriteOption = data.hapi.installation_option.rewrite;
						var downgradeOption = data.hapi.installation_option.downgrade;
						var firmwareOption = data.hapi.installation_option.firmware;
						var softwareOption = data.hapi.installation_option.software;
						
						if(data.hapi.installation_option.ignore_warnings)
						{
							$('.ignorewarnings').attr('checked', true);
						}
						if ( !rewriteOption  && !downgradeOption )
						{
							if(firmwareOption && softwareOption){
								$(INSTALLATIONOPTION).val('upgradeBoth');
							}
							else if(firmwareOption){
								$(INSTALLATIONOPTION).val('upgradeFirmware');
							}
							else if(softwareOption){
								$(INSTALLATIONOPTION).val('upgradeSoftware');
							}
						}
						else if ( rewriteOption  && downgradeOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('both');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('firmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('software');
						}
						else if ( rewriteOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('rewriteBoth');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('rewriteFirmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('rewriteSoftware');
						}
						else if ( downgradeOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('downgradeBoth');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('downgradeFirmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('downgradeSoftware');

						}
										
						$(INSTALLATIONOPTION).selectBox('reset');										
					}
					if(data.hapi.hasOwnProperty("vc_activation_options") && data.hapi.vc_activation_options){
						$('#hpsum-Enet-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.eth_activation_order))
		    		            $(this).attr('selected', true);
		                  });
		                 $('#hpsum-fc-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.fc_activation_order))
		    		            $(this).attr('selected', true);
		                  });
						$('#hpsum-Enet-delay').val(data.hapi.vc_activation_options.eth_activation_delay);
						$('#hpsum-FC-delay').val(data.hapi.vc_activation_options.fc_activation_delay);
					}
				}            	
            }

			function errormsg()
			{
				$(INSTALL_ERROR).hide();
			}

			function showAnalysisSplash(flag)
			{
				$(SPLASH_DIALOG).dialog({
			        modal : true,
			        position : "center",
			        draggable : false,
			        resizable : false,
			        show : 'fade',
					closeOnEscape: false,
			        dialogClass : 'hp-splash-dialog',
			        width : 400
			    });
				if(flag)
					$('#hpsum-splash-message').html(localizer.getString("hpsum.group.applyingInstallationOptions"));
				else
					$('#hpsum-splash-message').html(localizer.getString("hpsum.group.applyingSelectionChanges"));
			    $(SPLASH_SPINNER).show();	
			}
			
			function closeAnalysisSplash(){
				$(SPLASH_SPINNER).hide();
				try {
					$(SPLASH_DIALOG).dialog('destroy');
				} catch(e) {}
			}
			
			//Apply Installation Options
			function applyInstallationOptions()
			{
				applyOptions = true;
				deploy_flag = false;
				if(!nodeItem.type.match(/integrityilo|virtual_connect|ipdu|OA|sd2oa|ilo|switch|SAS_SWITCH/i))
					getInstallationOptions(nodeItem);
					
				if(initialGetattr.hapi.installation_option.downgrade != ForceOptions.hapi.installation_option.downgrade ||
					initialGetattr.hapi.installation_option.rewrite != ForceOptions.hapi.installation_option.rewrite ||
					initialGetattr.hapi.installation_option.software != ForceOptions.hapi.installation_option.software ||
					initialGetattr.hapi.installation_option.firmware != ForceOptions.hapi.installation_option.firmware) {

					presenter.setattribute(nodeItem,ForceOptions, {
						success : function(data) {
						},
						error : onsetattributeerror
					});
					formStateView.setMessage({
						summary: localizer.getString("hpsum.node.installationOptions.applyingOptions"),
						status: 'ok',
						changing: true,
					});
					showAnalysisSplash(true);
					getNodeStatus();
				}
			}

			function analysis() {
				//populate the option details into the optiondetails object from UI
				setoptiondetails(nodeItem);
				//Get the schedule information for the node
				//setscheduleoptions(nodeItem);

				showAnalysisSplash();
					
				//send the setattribute command to engine
				if(initialGetattr.hapi.reboot_options.action != optiondetails.hapi.reboot_options.action ||
					initialGetattr.hapi.reboot_options.delay != optiondetails.hapi.reboot_options.delay ||
					initialGetattr.hapi.ignore_warnings != optiondetails.hapi.ignore_warnings ||
					($(COMPVERBOSEOPTION).is(':checked')) || 
					(nodeItem.type.match(/OA|VIRTUAL_CONNECT|ilo|switch|SAS_SWITCH/i) && optiondetails.hapi.associated_nodes.associated_node.length > 0) ||
					nodeItem.type.match(/virtual_connect|sd2oa|integrityilo/i)) {
						presenter.setattribute(nodeItem,optiondetails, {
							success : function(data) {
								doAnalysis();
							},
							error : onsetattributeerror
						});
				} else {
					doAnalysis();
				}
			}
			
			function doAnalysis()
			{
				if(isSelectionChanged){
					var inst = $('#all-baselines').data('plugin_hpsumInstallables');
					var componentsList = inst.getComponents();
					presenter.analysis(nodeItem, componentsList, {
						node_id: nodeItem.node_id,
						success : function(data) {
							analyzeSuccess(data, this.node_id);
							isSelectionChanged = false;
							getNodeStatus();
						},
						error : function(errorInfo) {
							analyzeError(errorInfo);
						}
					});
				} else {
					getNodeStatus();
				}
			}
			
			function getNodeStatus()
			{
				var progressTimer = setInterval(function () {
					var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
					rest.getURI(node_uri + "/getstatus", {
						success : function(data) {
							if(data.hapi.node_status.node_state === "ANALYSIS")
							{
							}
							else if(data.hapi.node_status.node_state === "UAN")
							{
								nodeItem.node_state = data.hapi.node_status.node_state;
								clearInterval(progressTimer);
								closeAnalysisSplash(); 
								$('#all-baselines').hpsumInstallables('recalculate');
								if(applyOptions)
								{
									skipInstallOptions = false;
									formStateView.setMessage({
										summary: localizer.getString("hpsum.node.installationOptions.optionsSuccess"),
										status: 'ok',
										changing: false,
									});
									applyOptions = false;
									loadAttributes();
								}
							}
							else if(data.hapi.node_status.node_state === "ERROR")
							{
								clearInterval(progressTimer);
								closeAnalysisSplash();
							}
						},
						error : function(errorInfo) {
										
						}
					});
		        }, 3000);
			}
		    
			function analyzeSuccess(data, nodeid) {
			
			}
			
			function analyzeError(error) {
				$(SPLASH_SPINNER).hide();
				$(SPLASH_DIALOG).dialog('destroy');
			}
			
			function onPopulateInstallSet(node_id)
			{
				if(deploy_flag)
				{
					var install = $('#all-baselines').data('plugin_hpsumInstallables');

					failedDependencyCount = install.failedDependencyCount();
					if(failedDependencyCount <= 0 && selectedComponentsCount > 0)
					{
						$(DEPLOY).attr("disabled", true);
						onDeployContinue();
					}
					deploy_flag = false;
				}
			}
			
			function validateTime() {
				var time_val = $(SCHEDULE_TIME).val();
				var time_parse = time_val.split(':');
				var time_pattern = /^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/;
				if(!time_val.match(time_pattern)) {
					$(SCHEDULE_TIME_LABEL).addClass("hp-error");
					$(SCHEDULE_TIME_LABEL).show();
					$(ANALYSIS).attr("disabled", true);
					$(DEPLOY).attr("disabled", true);
				}
				else
				{
					var time_hrs = time_parse[0];
					var time_mins = time_parse[1];
					if(time_hrs >= 12)
					{
						if(time_hrs == 12)
							schedule_time = time_hrs + ':' + time_mins + ' ' +'PM';
						else
						{
							var time_hrs_old = time_hrs - 12 ;
							if((time_hrs_old) <= 9)
							schedule_time = '0' + time_hrs_old + ':' + time_mins + ' ' +'PM';
							else 
							schedule_time = time_hrs_old + ':' + time_mins + ' ' +'PM';
						}
					}
					else if (time_hrs == 0)
					{
						schedule_time = (parseInt(time_hrs) + 12) + ':' + time_mins + ' ' +'AM';
					}
					else if (time_hrs < 12)
					{
						schedule_time = time_hrs + ':' + time_mins + ' ' +'AM';
					}
					$(ANALYSIS).removeAttr('disabled');
					$(DEPLOY).attr('disabled','disabled');
				}
			}
			
			function validateRebootDelay() {
				var rebootopt = $('#hpsum-reboot-option option:selected').val();
				var delaySec = $(DELAYSEC).val(); 
				var valid = true;
				
				if (rebootopt != "Never") {
					if((isNaN(delaySec) && !isFinite(delaySec)) || 
					  (delaySec < 60 || delaySec > 3600)) {
						$(DEPLOY).attr("disabled", true);
						$(DELAYSEC).addClass("hp-error");
						$(DELAYSECERR).text(localizer.getString("hpsum.node.rebootDelaySecondsErrMsg"));
						$(DELAYSECERR).show();
						valid = false;       
                    } 
					else {
						$(DELAYSEC).val(parseInt(delaySec));
						$(DEPLOY).attr("disabled", false);
						$(DELAYSEC).removeClass("hp-error");
						$(DELAYSECERR).hide();
					}
				}
				return valid;
            }
			
			function setscheduleoptions(nodeItem) {
			
				var scheduled = "no";
				var date = "";
				var time = "";
				
				if($(SCHEDULETOGGLE).attr('checked') === "checked")
					scheduled = 'yes';
				else
					scheduled = 'no';
				
				if(scheduled_getdata_date_time == ""){
					scheduled_getdata_date_time = " ";
					schedaction = 'create';
					}
				else
					schedaction = 'update';
				
				if(scheduled === "yes"){
					date = $(SCHEDULE_DATE).val();
					validateTime();
					time = schedule_time;
				}
				
				var schedule_information = {date:date, time:time};
				var schedule_date_time = date + ' ' + time;
				if(scheduled !== scheduled_getdata || scheduled_getdata_date_time !== schedule_date_time)
					presenter.ScheduleNodes(nodeItem.node_id,schedaction,scheduled,schedule_information, {
						success : function(data) {
							onScheduleNodesSuccess(data); 
						},
						error : function(errorInfo) {
								onScheduleNodesError(errorInfo);
							}
					});
			}
			
			function loadScheduleoptions(nodeItem){
				var scheduled_date_time_split;
				var scheduled_time;
				var scheduled_date;
				var scheduled_time_hrs_mins;
				var scheduled_time_hrs;
				var scheduled_time_mins;
				scheduled_getdata_date_time = nodeItem.schedule_date_time;
				scheduled_getdata = nodeItem.scheduled;
				if(scheduled_getdata === "false")
				{
					scheduled_getdata = "no";
					$(DEPLOY).val(localizer.getString('hpsum.node.deploy'));
					if($(SCHEDULETOGGLE).attr('checked') === "checked"){
						$(SCHEDULETOGGLE).click();	
						$(SCHEDULETOGGLE).removeAttr("checked");
					}
				}
				else if(scheduled_getdata === "true")
				{
					scheduled_getdata = "yes";
					$(DEPLOY).val(localizer.getString('hpsum.node.scheduledeploy'));
					if($(SCHEDULETOGGLE).attr('checked') === undefined){
						$(SCHEDULETOGGLE).click();	
						$(SCHEDULETOGGLE).attr("checked","checked");
					}
				}
				if(scheduled_getdata_date_time === "")
				{
					$(SCHEDULE_DATE).val('');
					$(SCHEDULE_TIME).val('');
				}	
				else
				{	
					scheduled_date_time_split = scheduled_getdata_date_time.split(' ');
					scheduled_date = scheduled_date_time_split[0];
					scheduled_time = scheduled_date_time_split[1];
					scheduled_time_hrs_mins = scheduled_time.split(':');
					scheduled_time_hrs = scheduled_time_hrs_mins[0];
					scheduled_time_mins = scheduled_time_hrs_mins[1];
					
					var scheduled_time_hrs_new;
					var scheduled_time_new;						
					
					if (scheduled_date_time_split[2] == 'PM')
					{
						if (scheduled_time_hrs < 12)
						{
							scheduled_time_hrs_new = parseInt(scheduled_time_hrs) + 12;	
							scheduled_time_new = scheduled_time_hrs_new + ':' + scheduled_time_mins;
						}
						else if ( scheduled_time_hrs == 12)
						{
							scheduled_time_hrs_new = parseInt(scheduled_time_hrs) + 0;	
							scheduled_time_new = scheduled_time_hrs_new + ':' + scheduled_time_mins;
						}
					}
					else if ( scheduled_date_time_split[2] == 'AM')
					{
						if ( scheduled_time_hrs == 12)
						{
							scheduled_time_hrs_new = parseInt(scheduled_time_hrs) - 12;
							scheduled_time_new = '0' + scheduled_time_hrs_new + ':' + scheduled_time_mins;
						}
						else if ( scheduled_time_hrs < 12)
						{
							if ( scheduled_time_hrs < 10 )
							{
								scheduled_time_hrs_new = parseInt(scheduled_time_hrs) + 0;
								scheduled_time_new = '0' + scheduled_time_hrs_new + ':' + scheduled_time_mins;
							}
							else
							{
								scheduled_time_hrs_new = parseInt(scheduled_time_hrs) + 0;
								scheduled_time_new = scheduled_time_hrs_new + ':' + scheduled_time_mins;
							}
						}
					}

					$(SCHEDULE_DATE).val(scheduled_date);
					$(SCHEDULE_TIME).val(scheduled_time_new);
				}
			}
			
			function onScheduleNodesError(errorMessage)
			{
				notifications.show(errorMessage, 'error');                          
				$(ANALYSIS).attr("disabled", false);
				$(DEPLOY).attr("disabled", false);	
				$(CANCEL).trigger('click');	
			}

			function onScheduleNodesSuccess(data)
		    {
				var message;	
				$(DEPLOY).val(localizer.getString('hpsum.node.scheduledeploy'));
				if(schedaction === "create")
					message = "Schedule for " + nodeItem.name + " created successfully";
				if(schedaction === "update")
					message = "Schedule for " + nodeItem.name + " updated successfully";  
				notifications.show(message, 'ok');  
			}	
			
			function toggleSchedule(cb)
            {
            	if(cb.target.checked)
            		$(DATETIMESECTION).show();
            	else
            		$(DATETIMESECTION).hide();
				$(ANALYSIS).removeAttr('disabled');
                $(DEPLOY).attr('disabled','disabled');
            }
			
			function  setoptiondetails(nodeItem){
			    if((nodeItem.hasOwnProperty('activate_sfw')) || (nodeItem.type.match(/windows|linux|vmware|hpux/i))){
					optiondetails.hapi.reboot_options ={};	
					optiondetails.hapi.reboot_options.action = $(REBOOTOPTION).val();
					optiondetails.hapi.reboot_options.delay = $(DELAYSEC).val();				
					optiondetails.hapi.reboot_options.message = $(DELAYMSG).val();
				}
				if($(COMPVERBOSEOPTION).is(':checked'))
				{
					optiondetails.hapi.verbose = true;
				}
				
				optiondetails.hapi.ignore_warnings = false;
				if ($(".ignorewarnings")[0]) {
					optiondetails.hapi.ignore_warnings = $(".ignorewarnings").is(':checked');
				}
				if(nodeItem.type.match(/virtual_connect/i)) {
					optiondetails.hapi.vc_activation_options ={};			
            		optiondetails.hapi.vc_activation_options.eth_activation_order = $('#hpsum-Enet-order').val();
					optiondetails.hapi.vc_activation_options.fc_activation_order = $('#hpsum-fc-order').val();     
					optiondetails.hapi.vc_activation_options.eth_activation_delay = $('#hpsum-Enet-delay').val();
					optiondetails.hapi.vc_activation_options.fc_activation_delay= $('#hpsum-FC-delay').val();	
					
				    optiondetails.hapi.vc_encryption_settings ={};
				    optiondetails.hapi.vc_encryption_settings.vc_encryption_key = $('#hpsum-node-vc-encryption-key').val();
				}
				var tmp = $(ACTIVATE_SELECTION).val();
				if( tmp == 'NO') {
					optiondetails.hapi.activate_sfw = false;
				} else {
					optiondetails.hapi.activate_sfw = true;
				}
				if($(DEPLOYENCCHKBOXCOMP).is(':checked'))
				{
					optiondetails.hapi.deploy_enclosure = true;
				}
				if(nodeItem.type.match(/OA|VIRTUAL_CONNECT|ilo|switch|SAS_SWITCH/i)){
					var tableid = '#hpsum-assoc-nodes-' + nodeItem.node_id + '-table';
					var currTable = $(tableid).dataTable();
					
					var selectedRows = $(tableid + ' tbody tr');
					
					for(var tmp=0; tmp < selectedRows.length; tmp++){
						var compData = currTable.fnGetData(selectedRows[tmp].rowIndex-1);
						
						if(compData) {
							var bselected = false, bforce = false;
							if(selectedRows[tmp].className.indexOf('hp-selected') != -1)
								bselected = true;
							else
								bselected = false;
						
							var item = {
								node_id : compData.node_id,
								selected : bselected
							};
						
							optiondetails.hapi.associated_nodes.associated_node.push(item);
						} 
					}
				}
			}
			
			function  getInstallationOptions(nodeItem){
					ForceOptions.hapi.installation_option ={};
                    var type = $(INSTALLATIONOPTION).val();
								 
					ForceOptions.hapi.installation_option.downgrade = false;
					ForceOptions.hapi.installation_option.rewrite   = false;
					ForceOptions.hapi.installation_option.software = false;
					ForceOptions.hapi.installation_option.firmware = false;
					ForceOptions.hapi.installation_option.forcesoftware = false;
					ForceOptions.hapi.installation_option.forcefirmware = false;
								  
					if ( type == "upgradeBoth"){
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.software = true;
					}
					else if ( type == "upgradeFirmware"){
						ForceOptions.hapi.installation_option.firmware = true;
					}
					else if ( type == "upgradeSoftware"){
						ForceOptions.hapi.installation_option.software = true;
					}
					else if ( type == "downgradeFirmware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "downgradeSoftware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "downgradeBoth"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "rewriteFirmware"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "rewriteSoftware"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "rewriteBoth"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "firmware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "software"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "both"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
			}
			function onsetattributeSuccess(item) {       
				skipInstallOptions = false;
				loadAttributes();
               //do nothing
            }
			
			function onsetattributeerror(errorMessage) {               
				
               onAnalysisError(errorMessage);
            }

            function onAnalysisError(errorMessage) {
                notifications.show(errorMessage, 'error');                          
				$(DEPLOY).attr("disabled", false);	
				$(CANCEL).trigger('click');	

            }			

            /**
             * @private
             * Call presenter's deploy() to deploy  a selected component/baseline to the node 
             */
            function onDeploy() {   
				skipInstallOptions = true;
				if(!validateRebootDelay())
					return;
				deploy_flag = true;
				formStateView.reset();
				loadAttributes();
            }
			
			/**
             * @private
             * Continue the deploy procedure from the Analysis onwards 
             */
			function onDeployContinue() 
			{
				if(nodeItem  && nodeItem.node_state === 'UAN') 
				{
					$(DEPLOY).attr("disabled", true);        
					presenter.deploy(nodeItem, {
						success : onDeploySuccess,
						error : onDeployError
					});  
					$(CANCEL).trigger('click');
				}
			}
			
			 /**
             * @private
             */
            function onDeploySuccess(item) {    
				deploy_flag = false;
            }

            /**
             * @private
             */
            function onDeployError(errorMessage) {
                notifications.show(errorMessage, 'error'); 
				deploy_flag = false;
            }
			
			function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }					
			function handleSelectToggleRowselection(row){
			        var selectElem = row.innerHTML.split('"');
					var selectId = '#' + selectElem[3];
					if(selectId.indexOf('hpToggle')>=0)
						selectId = '#' + selectElem[3].slice(0, -9);
						else
						selectId = '#' + selectElem[5].slice(0, -9);
						 if(row.outerHTML.match(/hp-selected/i)){	 
								 $(selectId).prop('checked', true);
								 $(selectId).trigger('change');
								 if($.inArray(selectId,selectedAssociatedNodes) == -1)
								 {
									selectedAssociatedNodes.push(selectId);
								 }
							 } else {
								 $(selectId).prop('checked', false);
								 $(selectId).trigger('change');
								 if($.inArray(selectId,selectedAssociatedNodes) != -1)
								 {
									 selectedAssociatedNodes.splice(selectId,1);
								 }
			
							 }
							 if(row.outerHTML.match(/hp-disabled/i)){
								 
								 $(selectId).prop('checked', false);
								 $(selectId).trigger('change');
			
			                      }
						}
			//Initialize Associated Nodes table to show the list of associated nodes
            function initAssocTable(tableid) {
		    
				var oTab = $(tableid).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString('hpsum.node.noAssociatedNodes'),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
					bServerSide:false,
				    //aaData: data,
					aoColumns : [
						{mDataProp: 'node_selection'},
						{mDataProp: 'node_ip'},
						{mDataProp: 'node_type'},
				        {mDataProp: 'link' ,
						fnRender: function (oObj) {
							if(oObj.aData.node_id){
								if(!(oObj.aData.nodeitem_type.match(/SAS_SWITCH/i) || oObj.aData.nodeitem_type.match(/VIRTUAL_CONNECT/i)))
								{
									if(oObj.aData.state.match(/UAN/i))
									{
										return '<a id = "componentLink" href="javascript:void(0);">' + localizer.getString('hpsum.node.applicableComponents') + '</a>';
									}
									else if ((oObj.aData.state.match(/install$/i)) || (oObj.aData.state.match(/InstallDone$/i)) || (oObj.aData.state.match(/installhold$/i)))
									{
										return "";
									}
									else
									{
										return localizer.getString('hpsum.node.nodeNotReady');
									}
								}
								else
								{
									return "";
								}
							}
							else
							{
								return localizer.getString('hpsum.node.waitingForComp');
							}
						}},
						{mDataProp: 'status',
						fnRender: function (oObj) {
							if(oObj.aData.state.match(/UAN/i))
									return  oObj.aData.associated_node_status;
								else
									return oObj.aData.status;
						}},
				      		{mDataProp: 'node_id', "bVisible": false, sWidth: 5},
						{mDataProp: 'state', "bVisible": false, sWidth: 5}
					],
				    aaSorting: [[ 0, "asc" ]],				    
					fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_id);
				        return nRow;
				    }
				    });//.rowReordering().addClass('hp-reorderable');			
			}

			function showAssociatedNodes(nodeItem) {
			
				$(ASSOC_OPTIONS).hide();
						   
				$(ASSOC_NODES).empty();
						  				   
				$(ASSOC_NODES).append('<table class="hp-selectable" id="hpsum-assoc-nodes-' + nodeItem.node_id + '-table"><thead><tr><td><b>' 
										+ localizer.getString('hpsum.node.selectnodes')+ '</b></td><td><b>' 
										+ localizer.getString('hpsum.node.ip') + '</b></td><td><b>' + localizer.getString('hpsum.node.type') + '</b></td><td><b>' 
										+ localizer.getString('hpsum.node.componentDetails') + '</b></td><td><b>' + localizer.getString('hpsum.common.statusStr') + '</b></td><td></td><td></td></tr></thead></table>');
						   
				var tableid = '#hpsum-assoc-nodes-' + nodeItem.node_id + '-table';
				initAssocTable(tableid);
				var associated_ips=[];

				var assoc_table = $(tableid).dataTable();
				$('#hpsum-associated-nodes-text').html(localizer.getString("hpsum.node.nodesBelowList" , [nodeItem.type]));
				$('#hpsum-associated-nodes-text').removeClass('hp-collapsed');
				//$('#hpsum-assoc-nodes-' + nodeItem.node_id + '-table_filter').hpSearchCombo("disable");
				assoc_table.fnClearTable();	
				
				if ( nodeItem.auto_add_assoc_nodes == true )
				{
					var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
					rest.getURI(node_uri +"/getAssociatedNodesCompData",
							{
								nodeid : nodeItem.node_id,
								success : function(data) {
								
								var nodeAssoData = data.hapi.associated_nodes;
							if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id )
								nodeAssoData.node = new Array(nodeAssoData.node);
							if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id==undefined)
            			return;
							if(nodeAssoData.node.length==0)
            			return;
					
					for(var i=0; i<nodeAssoData.node.length; i++){
						if(nodeAssoData.node[i].node_id){
						
							var node_data = [{
							'node_selection': '<input id="toggle-' + nodeAssoData.node[i].node_id+ '" class="hp-toggle" type="checkbox"/>',
								'node_type': nodeAssoData.node[i].type +' '+ nodeAssoData.node[i].productName,
							  							  
								'node_ip': nodeAssoData.node[i].ip_or_dns,
								'link': "",
								'status': nodeAssoData.node[i].node_status,
								'node_id': nodeAssoData.node[i].node_id,
								'state': nodeAssoData.node[i].node_state,
								'type_string': nodeAssoData.node[i].type,
								'nodeitem_type' : nodeAssoData.node[i].type,
								'associated_node_status': nodeAssoData.node[i].associated_node_status
								
							}];
							if(nodeItem.type.match(/OA/i))
							{
								if ( nodeAssoData.node[i].device == 'Interconnect' || nodeAssoData.node[i].device == 'Associate')
								{
									if(nodeAssoData.node[i].type.match(/VCDEV/i)) 
									{
										if(nodeAssoData.node[i].isConjoined != "0")
										{	
											
											
											if ( jQuery.inArray(nodeAssoData.node[i].ip_or_dns,associated_ips) == -1){
									assoc_table.fnAddData(node_data);
										associated_ips.push(nodeAssoData.node[i].ip_or_dns);
										if(nodeAssoData.node[i].node_state == "UAN")
						    {
							        $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
									checked : localizer.getString("hpsum.oneTouchUpdate.selected")
								    });      
								}
							else
							{
                                    $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.common.disabled"),
									checked : localizer.getString("hpsum.common.disabled")
									});
							}
										}
										}		
					}
									else
							{
														
									if ( jQuery.inArray(nodeAssoData.node[i].ip_or_dns,associated_ips) == -1){
										assoc_table.fnAddData(node_data);associated_ips.push(nodeAssoData.node[i].ip_or_dns);
										if(nodeAssoData.node[i].node_state == "UAN")
						    {
							        $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
									checked : localizer.getString("hpsum.oneTouchUpdate.selected")
								    });      
							}
							else
							{
                                    $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.common.disabled"),
									checked : localizer.getString("hpsum.common.disabled")
							});
						}
					}
							}
						}
					}
								else
							{
			
								if ( jQuery.inArray(nodeAssoData.node[i].ip_or_dns,associated_ips) == -1){
								assoc_table.fnAddData(node_data);associated_ips.push(nodeAssoData.node[i].ip_or_dns);
								if(nodeAssoData.node[i].node_state == "UAN")
						    {
							        $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
									checked : localizer.getString("hpsum.oneTouchUpdate.selected")
								    });      
							}
							else
							{
                                    $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.common.disabled"),
									checked : localizer.getString("hpsum.common.disabled")
									});
						}
					}
				}
					
							if(nodeAssoData.node[i].node_state.match(/UAN/i)){
								if(nodeAssoData.node[i].selected)
									$(tableid + ' tbody tr').last().addClass('hp-selected');
								else
									$(tableid + ' tbody tr').last().removeClass('hp-selected');
							}
							else
								$(tableid + ' tbody tr').last().addClass('hp-disabled');
							//if((nodeItem.type.match(/SAS_SWITCH/i)) || (nodeItem.type.match(/VIRTUAL_CONNECT/i)))
								//$(tableid + ' tbody tr').last().addClass('hp-disabled');
						
						if($.inArray('#toggle-' + nodeAssoData.node[i].node_id,selectedAssociatedNodes) != -1)
						{
							$('#toggle-' + nodeAssoData.node[i].node_id).prop('checked', true);
							$('#toggle-' + nodeAssoData.node[i].node_id).trigger('change');
							$(tableid + ' tbody tr').last().addClass('hp-selected');
					}
				}
					}
								
					
					$(tableid + " tbody tr").click( function( e ) {
					var srcElem, browsertype = 0;
					var data = $(tableid).dataTable().fnGetData( this );
					
					//if(data.nodeitem_type.match(/SAS_SWITCH/i) || data.nodeitem_type.match(/VIRTUAL_CONNECT/i))
					//{
						//return;
					//}
					
					//Check if firefox or (chrome and IE)
					if(e.srcElement)
						srcElem = e.srcElement;//Chrome and IE
					else
					{
						srcElem = e.target;//Firefox
						browsertype = 1;
					}
					
						if ( srcElem.tagName == 'A' )			
							populateComponents(data.node_id,data.type_string);
						else{
							//row is disabled, so only force option can be applied
							//no row selection/deselection supported
							if ( $(this).hasClass('hp-disabled') ) 
								return;	
							$(this).toggleClass('hp-selected');
							handleSelectToggleRowselection(this);
							$(DEPLOY).attr("disabled", false);
						}
				});	
				},
								error : function(errorInfo){ }
							});
			}
			}

			function showAssocDialog(nodeid,type){
			     
			     if(!assocNodeDialog) {
			     	var closefunc =  function(elem) {
                        	$(ASSOC_ANALYSIS, assocNodeDialogContents).off('click');
                            assocNodeDialog = null;
                            assoc_dialog_openedonce = false;
                     };
                    assocNodeDialog = new DialogView();
                    assocNodeDialog.init({contents: assocNodeDialogContents,
                        position : "center",
                        ok : function(){ closefunc() },
                        cancel: function(){ closefunc() }
                    }); 
                    
                    $(ASSOC_ANALYSIS, assocNodeDialogContents).on('click', function(ev) {
                        btnAssocAnalyzeClicked.call(this,nodeid,type);
                    });
                }
			}
									
			

			function onAssocSelectionChanged(id, value, componentList)
			{
				if(value == true){
					$(ASSOC_NODE_ANALYSIS).attr("disabled", false);
				}
				else
				{
					$(ASSOC_NODE_ANALYSIS).attr("disabled", true);
					
				}
			}

		    function onAssocPopulateInstallSet(node_id)
			{
				
				var install = $('#all-associated-baselines').data('plugin_hpsumInstallables');
				failedDependencyCount = install.failedDependencyCount();
				if(failedDependencyCount <= 0 && assoc_dialog_openedonce == true)
				{
					assocNodeDialog.cancel();
					return;
				}
				if(assoc_dialog_openedonce == false) 
					assoc_dialog_openedonce = true;
			}


			function populateComponents(node_id,type) {
				var node_uri = "/Session/" + session.getToken() + "/node/" + node_id;
				showAssocDialog(node_id,type);
				$(ASSOC_ANALYSIS).attr("disabled", true);
				$(ASSOC_NODE_COMP).empty();

				$(ASSOC_NODE_COMP).append("<div id='all-associated-baselines' style='margin:10px;' ></div>");

				var asscnodeItem = {
								'node_id':node_id,
								 'type': type
								};

				var options = {
						command:'init',
						nodeItem:asscnodeItem,
						onSelectionChanged:onAssocSelectionChanged,
						onPopulateInstallSet:onAssocPopulateInstallSet
						
					};
					
				//Call plugin to show the component list ();
				$('#all-associated-baselines').hpsumInstallables(options);
					if(type!="VCDEV")
				{
					$('#hpsum-vc-encryption-label').hide();
				}else {
					$('#hpsum-vc-encryption-label').show();
				}						
			}
           
			function btnAssocAnalyzeClicked(nodeid,type) {
			
				showAnalysisSplash();

				var inst = $('#all-associated-baselines').data('plugin_hpsumInstallables');
				var componentsList = inst.getComponents();

				
				var uri = '/Session/'+session.getToken()+'/node/'+nodeid +'/analysis';			 
				rest.postObject(uri, componentsList,"",{
						node_id: nodeItem.node_id,
						success : function(data) {
							analyzeSuccess(data, this.node_id);
						},
						error : function(errorInfo) {
							analyzeError(errorInfo);
						}
				});
					
		        var progressTimer = setInterval(function () {
					var node_uri = "/Session/" + session.getToken() + "/node/" + nodeid;
					rest.getURI(node_uri + "/getstatus", {
										
						success : function(data) {
							
							if(data.hapi.node_status.node_state === "ANALYSIS")
							{
								
							}
							else if(data.hapi.node_status.node_state === "UAN")
							{
								clearInterval(progressTimer);
				
								//show install review for all the nodes
								populateComponents(data.hapi.node_status.node_id,type);
				
								closeAnalysisSplash();
				
								//disable analyze button
								$(ASSOC_ANALYSIS).attr("disabled", true);
								showAssociatedNodes(nodeItem) ;

								
							}
							else if(data.hapi.node_status.node_state === "ERROR")
							{
								clearInterval(progressTimer);
								closeAnalysisSplash();
							}
						},
						error : function(errorInfo) {
							
						}
					});
				}, 3000);
			}	
			
			/**
             * @private
             */

            function reset() {
                $(DESCR).text(localizer.getString('hpsum.common.loading'));
                $(TYPE).text("");
                $(NONECHECKBOX).attr('checked', false);
                $(USESNMPCHECKBOX).attr('checked', false);
                $(USEAGENTLESSCHECKBOX).attr('checked', false);
                $(USEWEBEMCHECKBOX).attr('checked', false);
				$(COMPVERBOSEOPTION).attr('checked', false);
                $(REBOOTOPTION).selectBox('value', 'Never');
                $(DELAYSEC).prop("disabled", true);
				$(DELAYMSG).prop("disabled", true);
				$(REBOOTOPTION).live('change',function(e){
				if($(REBOOTOPTION).val().toLowerCase() == "never"){
					$(DELAYSEC).prop("disabled", true);
					$(DELAYMSG).prop("disabled", true);
					}
					else{
					$(DELAYSEC).prop("disabled", false);
					$(DELAYMSG).prop("disabled", false);
					}
				});
				$(DELAYSECERR).hide();
				$(DELAYSEC).removeClass('hp-error');
                $(SCHEDULE_DATE).val("");
				$(SCHEDULE_TIME).val("");
				$(DELAYSEC).val(REBOOT_DELAY_SEC);
                $(DELAYMSG).attr('value', 'Reboot at user request after deploy ');
                $("#hpsum-osmanagement-options-collapsible").css("display", "none");
                $('#hpsum-installation-options-collapsible').css("display","block");
                $('#hpsum-force-options-collapsible').css("display","block");
                $('#hpsum-reboot-options-collapsible').css("display", "block");
                $("#hpsum-assocnodes-collapsible").css("display", "block");
                $('#hpsum-vc-options-collapsible').css("display","none");
                $(VC_ENCRYPTION_SETTINGS).css("display","none");
                $('#hpsum-node-vc-encryption-key').val(''); 
            }
			function loadAttributes() {
				
				initialGetattr = null;
				
				var handler = {
						success : function(data) {
							initialGetattr = data;
							if(!skipInstallOptions){
						        showInstallationOptions(data);
								}
								else{
								analysis();}
							
						},
						error : function(errorInfo) {
						}
					};
					
				presenter.otheroption(nodeItem, handler);
			}
			
            /**
             * @public
             */
            this.resume = function () {
            	reset();
				presenter.on("itemChange", onItemChange);
				$(PANELS).hpStackedPanels('resume');
				$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
				$(SCHEDULE_TIME_LABEL).hide();
				//If any input that needs a setattribute call to be set is changed
					//enable the analysis button, and disable the deploy button
                $('.require-analysis').on('click', function(){					
					if(failedDependencyCount <= 0 && selectedComponentsCount > 0){
                		$(DEPLOY).attr("disabled", false);
					}
					else {
                    	$(DEPLOY).attr('disabled',true);
					}
                    
					var delaySec = parseInt($(DELAYSEC).val());  
		            if (delaySec < 60) { 
						$(DEPLOY).attr('disabled','disabled');
		            }
                });
            };
            
            this.pause = function () {
				selectedAssociatedNodes = [];
				presenter.off("itemChange", onItemChange);
				$('.hpsumInstallables').hpsumInstallables('destroy');
				$(PANELS).hpStackedPanels('pause');
				$(iLOFED_TECH_PREVIEW_WARNING).hide();
            };
            
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
			// put help in header
                if ($('.hp-details-header-controls', $(FORM).parent()).length === 0) {
                    var headerHelp = $(headerHelpHtml);
                    localizer.localizeDom(headerHelp);
                    $('.hp-details-header', $(FORM).parent()).append(headerHelp);
                }
				$('#hpsum-force-options-collapsible').attr('tooltip', localizer.getString('hpsum.node.installationOptions.help')).hpTooltip();
                $('#hpsum-node-deploy-vc-encryption-collapsible div.hp-form-content').attr('tooltip', localizer.getString('hpsum.node.vcFIPSEncryptionKeyHelp')).hpTooltip();
				
				$(CANCEL).click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });

                $(DEPLOY).live('click', function(ev) {
                    onDeploy.call(this);
                    ev.preventDefault();
                });
				
				//By Default reboot-options value is Never so disable the Reboot delay and Reboot message.
				$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", true);
				
				$("#hpsum-reboot-option").change(function() {
					var type = $('#hpsum-reboot-option option:selected').val();
					if (type == "Never") {
						$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", true);
						$(DELAYSEC).val('');
						$(DELAYSEC).removeClass("hp-error");
						$(DELAYSECERR).hide();
					}
					else
					{
						$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", false);
					}
				});
				$('#hpsum-downgrade-rewrite-text').html(localizer.getString("hpsum.node.installationOptions.message"));
				$('#hpsum-downgrade-rewrite-text').removeClass('hp-collapsed');
				//$(ANALYSIS).attr('tooltip', localizer.getString('hpsum.common.deployPreviewToolTip')).hpTooltip();
				$(INSTALL_ERROR).hide();
				$(INSTALLATIONOPTION).val('upgradeBoth');
				$("#hpsum-installation-option").change(function() {
					applyInstallationOptions.call();
				});
				$("#hpsum-assocnodes-collapsible").css("margin-top","-20px");
				$(INSTALLATIONOPTION).selectBox({autoWidth: false});
                formStateView.init({form: FORM,
                    routePattern: ROUTE_PREFIX + '.*',
                    autoTrack: false
				});

				$(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });	
				
				$(DELAYSEC).unbind('keyup').bind('keyup', function(){
					$(DELAYSECERR).hide();
					$(DELAYSEC).removeClass('hp-error');
				}); 
				
				$(DELAYSEC).bind('change', function(){
					$(DELAYSECERR).hide();
					$(DELAYSEC).removeClass('hp-error');
				}); 
				
                assocNodeDialogContents = $(ASSOC_NODE_DIALOG).detach().show();
                $(REBOOTOPTION).selectBox({autoWidth: false});
                $(ACTIVATE_SELECTION).selectBox({autoWidth: false});
				$(ASSOC_NODE_COMP).empty();
				$("#assoc-footer").hide();
				$(".hp-collapsible").hpCollapsible();
				$(DATETIMESECTION).hide(); 
				$(SCHEDULETOGGLE).hpToggle({checked: 'On', unchecked: 'Off'});
    			$(SCHEDULETOGGLE).bind('change',toggleSchedule);
				$(SCHEDULE_DATE).datepicker({ dateFormat: 'yy-mm-dd'});
				$(SCHEDULE_TIME).bind('change', validateTime);
				$(SCHEDULE_TIME).bind('keyup', function () {
					$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
					$(SCHEDULE_TIME_LABEL).hide();
				});
				$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
				$(SCHEDULE_TIME_LABEL).hide();
				$(SCHEDULE_DATE).bind('change', function(){
					$(ANALYSIS).removeAttr('disabled');
					$(DEPLOY).attr('disabled','disabled');
				});
				$("#hpsum-schedule-collapsible").removeClass('hp-collapsed');
				$("#hpsum-assocnodes-collapsible").removeClass('hp-collapsed');
				$("#hpsum-baseline-collapsible").removeClass('hp-collapsed');
				$(DEPLOY).attr("disabled", true);
				
				$('#hpsum-node-vc-encryption-key').on('keyup', function() {
				    $(DEPLOY).attr("disabled", true);
				    if($('#hpsum-node-vc-encryption-key').val().length > 7)
						$(DEPLOY).attr("disabled", false);
				    else
						$(DEPLOY).attr("disabled", true);
			     });	
				
				router.watch('Node Deploy section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
			
								
                this.resume();
            };
        }

        return NodeDeployView;
    }());
    
    return new NodeDeployView();
});
