// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
	'hp/core/Localizer',
    'hp/view/FormStateView',
	'hp/view/DialogView',
	'hp/model/Session',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpCollapsible',
    'lib/jquery.selectBox',
	'hpsum/common/jquery.hpsumBrowse'],
function(presenter,  router, urlFragment, notifications, localizer, FormStateView, DialogView, session) { "use strict";

    var NodeEditView = (function() {
      
        var OK = '#hpsum-node-edit-ok';
        var PANEL_SELECTOR = '#hpsum-node-edit-panel-selector';
        var PANELS = '#hpsum-node-edit-panels';
        var FORM = '#hpsum-node-edit-form';
        var TITLE = '#hpsum-node-details-title';
        var TYPE ='#hpsum-node-type';
        var NAME = '#hpsum-node-name',
        	CANCEL ='#hpsum-node-edit-close',
        	DESCRIPTION = '#hpsum-node-description',
        	USERNAME = '#hpsum-node-credential-username',
           	PASSWORD = '#hpsum-node-credential-password',
			CURRENT_BASELINE = '#hpsum-node-baseline',
            CURRENT_HOTFIX = '#hpsum-node-addpackage',
			LINUXUSERNAME = '#hpsum-linux-node-credential-username',
			LINUXPASSWORD = '#hpsum-linux-node-credential-password',
			LINUX_ENTER_CRED = '#hpsum-linux-node-cred-details',
			LINUX_CRED_PANEL = '#hpsum-linux-node-edit-credentials',
			LINUX_SSH_KEY_FILE_SELECTION = '#hpsum-linux-node-credential-ssh-key-file-selection',
			LINUX_SSH_KEY_FILE_PANEL = '#hpsum-linux-node-cred-ssh-key-file-details',
			LINUX_SSH_KEY_FILE_USERNAME = '#hpsum-linux-node-credential-ssh-key-file-username',
			LINUX_SSH_KEY_FILE_USERNAME_ERR = '#hpsum-linux-node-credential-ssh-key-file-username-err',
			LINUX_SSH_KEY_FILE_PATH = "#hpsum-linux-node-credential-ssh-key-file-path",
			LINUX_SSH_KEY_FILE_PATH_ERR = "#hpsum-linux-node-credential-ssh-key-file-path-err",
			LINUX_SSH_KEY_FILE_PASSPHRASE = "#hpsum-linux-node-credential-ssh-key-file-passphrase",
			LINUX_CRED_GROUP_SELECTION = "#hpsum-linux-node-cred-group-selection",
			NODE_CRED_INPUT = "#hpsum-node-cred-details",
			NODE_CRED_USERNAME = "#hpsum-node-credential-username",
			NODE_CRED_PASSWORD = "#hpsum-node-credential-password",
			USEVCENTER_CHKBOX = "#chkbox-use-vcenter",
			VCENTERSECTION = '#hpsum-node-edit-vcenter-credentials',
			VCENTERPANEL = '#hpsum-node-vcenter-cred-details',
			VCENTERUSERNAME = '#hpsum-node-vcenter-credential-username',
			VCENTERUSERNAME_ERR = '#hpsum-node-vcenter-username-err',
			VCENTERPASSWORD = '#hpsum-node-vcenter-credential-password',
			VCENTERPASSWORD_ERR = '#hpsum-node-vcenter-password-err',
			VCENTERIPADDR = '#hpsum-node-vcenter-credential-ipaddress',
			VCENTERIPADDR_ERR = '#hpsum-node-vcenter-ipaddress-err',
        	BASELINES = '#hpsum-node-baselines-search',
        	NONECHECKBOX = '.nonecheckbox',
        	USESNMPCHECKBOX ='.useSNMPcheckbox',
			USEAGENTLESSCHECKBOX ='.useAgentlesscheckbox',
			INSTALLATIONOPTION = '#hpsum-installation-option',
			USEWEBEMCHECKBOX ='.useWEBEMcheckbox',
			DOWNGRADECHKBOXCOMP ='.downgradechkbox',
			REWRITECHKBOXCOMP ='.rewritechkbox',
			INSTALL_ERROR='#force-options-tbody-err',
			FIRMWARECHKBOXCOMP ='.firmwarechkbox',
			SOFTWARECHKBOXCOMP ='.softwarechkbox',
			REBOOTOPTION = '#hpsum-reboot-option',
			DELAYSEC= '#hpsum-node-delay-seconds',
			DELAYSECERR= '#hpsum-node-delay-seconds-err',
			DELAYMSG= '#hpsum-node-reboot-message',
			REBOOT_ACTIVATE = '#hpsum-reboot-to-activate-options',
			COMMON_REBOOT = '#hpsum-common-reboot-options',
			ACTIVATE_SELECTION = '#hpsum-activate-selection',
			NO_REBOOT_REQ = '#hpsum-no-reboot-required',
            HOTFIX = '#hpsum-node-hotfix-search',
        	PARTNER_TYPE ='#hpsum-node-add-partner',
           	PARTNER_CRED_PANEL ='#hpsum-node-add-partner-credentials',
            PARTNER_IP_LABEL = '#hpsum-node-partner-ip',
            PARTNER_IP_VALUE ='#hpsum-node-partner-ip-value',
            PARTNER_IP_LIST = '#hpsum-node-edit-partner-ip-list',
            PARTNER_ENTER_CRED = '#hpsum-node-partner-cred-details',
            PARTNER_USERNAME = '#hpsum-node-partner-credential-username',
           	PARTNER_PASSWORD = '#hpsum-node-partner-credential-password',
			ADD_ASSOC_NODES = '#hpsum-node-addassocnodes',
			BASELINE_INPUT = '#hpsum-node-baselines-search-input',
			BASELINE_INPUT_ERR = '#hpsum-node-baselines-search-input-err',
			HOTFIX_INPUT = '#hpsum-node-hotfix-search-input',
			HOTFIX_INPUT_ERR = '#hpsum-node-hotfix-search-input-err',
			EDIT_LINUX_BROWSE_PANEL = '#hpsum-node-edit-linux-sshkey-browse-panel',
			REBOOT_DELAY_SEC = '60';

        var ROUTE_PREFIX = '/node/edit';
        
        /**
         * Constructor
         */
        function NodeEditView() {
          
            var formStateView = new FormStateView();
            var updateInProgress = false;
			var useSudoCredentials = false;
            var searchResults = [];
            var nodeItem = null;
	    var checkedVal = '';
            var currentbaseline = "";
            var currenthotfixbaseline = "";
            var baselines = "";
            var hotfixes = "";
            var newbaseline = "";
            var newhotfix = "";
            var partnerUsername ='';
            var partnerPassword ='';
            var partnerType ='';
            var auto_add_assoc_nodes;
            var node_skip = $("input[name='hpsum-node-edit-active']:checked").val();
			var usevcenter = false;
			if($(USEVCENTER_CHKBOX).is(':checked')){
				usevcenter = true;
			}
			var vcenter_gusername = '';
			var vcenter_gpassword = '';
			var vcenter_gvcenterip = '';
            var editOptions =  {
                    	hapi: {
                    	username : $(USERNAME).val(),
                    	password : $(PASSWORD).val(),
                    	description : $(DESCRIPTION).val(),
						su_username : $(LINUXUSERNAME).val(),
						su_password : $(LINUXPASSWORD).val(),
						use_sudo : useSudoCredentials,
						use_vcenter: usevcenter,
						vcenter_ip: $(VCENTERIPADDR).val(),
						vcenter_username: $(VCENTERUSERNAME).val(),
						vcenter_password: $(VCENTERPASSWORD).val(),
						use_sshkeyfile : false,
						auto_add_assoc_nodes : auto_add_assoc_nodes,
						node_skip : node_skip
                    	}
                    };
			var setOk = false;
			var baselineChange = false;
			var addpkgChange = false;
			var instEditLinuxSshkeyBrowse;
			
			function clearCredInput() {
				$(LINUX_SSH_KEY_FILE_USERNAME).val("");
				instEditLinuxSshkeyBrowse.setPanelText("");
				$(LINUX_SSH_KEY_FILE_PASSPHRASE).val("");		
				
				$(NODE_CRED_USERNAME).val("");
				$(NODE_CRED_PASSWORD).val("");
			}
			
			function clearvCenterCredInput() {				
				$(VCENTERUSERNAME).val("");
				$(VCENTERPASSWORD).val("");
			}
			
			function OnResize(){
				var BaseLineSearchWidth = ($(window).width() / 3);
				$(BASELINES).hpSearchCombo({getResults:getBaseline, width:BaseLineSearchWidth});
				$(HOTFIX).hpSearchCombo({getResults: getHotfixes, width:BaseLineSearchWidth});
			}
			
			
			function hideLinuxCredGroupSelection() {
				$(LINUX_CRED_GROUP_SELECTION).hide();
				$(LINUX_SSH_KEY_FILE_PANEL).hide();
				$('#hpsum-node-credential-key').attr('checked',true);
				clearCredInput();	
			}
			
			function showLinuxCredGroupSelection() {
				$(LINUX_CRED_GROUP_SELECTION).show();
				$(LINUX_SSH_KEY_FILE_PANEL).hide();
				$('#hpsum-node-credential-key').attr('checked',true);
				clearCredInput();
			}
			
			function showVCenterCredentialSelection(){
				$(VCENTERPANEL).show();
				clearVcenterErrorMessages();
			}
			
			function clearVcenterErrorMessages(){
				$(VCENTERIPADDR_ERR).hide();
				$(VCENTERUSERNAME_ERR).hide();
				$(VCENTERPASSWORD_ERR).hide();
				
				$(VCENTERUSERNAME).removeClass('hp-error');
				$(VCENTERIPADDR).removeClass('hp-error');
				$(VCENTERPASSWORD).removeClass('hp-error');
			}
			
			function credentialsOptions(value){
				$(NODE_CRED_INPUT).hide();
				$(LINUX_SSH_KEY_FILE_PANEL).hide();
				clearCredInput();
				clearvCenterCredInput();
          		if(value.target)
            		value = value.target.value;

            	if(value == "one"){
            		$(NODE_CRED_INPUT).show();
					
            	} else if(value == "two"){
					$(LINUX_SSH_KEY_FILE_PANEL).show();
					$(LINUX_SSH_KEY_FILE_PANEL).css({"display":""});
					$(LINUX_SSH_KEY_FILE_USERNAME).removeClass("hp-error");
					instEditLinuxSshkeyBrowse.removeInputClass("hp-error");
					$(LINUX_SSH_KEY_FILE_USERNAME_ERR).hide();
					$(LINUX_SSH_KEY_FILE_PATH_ERR).hide();
				}
            		
            }
			
            function onItemChange(item) {
            	item = item.hapi;				
                if (item) {
					//For fix of quix QXCR1001404674 "hpsum7.3:Invalid switch credentials shown for Moonshot(Unknown Node)"
					var moonshotcredential = '#hpsum-moonshot-admin-credentials';
					if(item.node_status === "Invalid Moonshot switch credentials.")
					{	
						$(moonshotcredential).hide();
					}
					else
					{
						$(moonshotcredential).show();
					}
					
                	nodeItem =item;
                    $(TITLE).text(item.name);
                    $(NAME).text(item.name);
                    $(DESCRIPTION).val(item.description);
							
										
                    if(nodeItem.hasOwnProperty('activate_sfw')){
					    $('#hpsum-reboot-options-collapsible').removeClass('hp-collapsed');
						$(COMMON_REBOOT).hide();
						$(REBOOT_ACTIVATE).show();
						if(!nodeItem.is_powered_on) {
							$(ACTIVATE_SELECTION).closest("li").hide();
							$(NO_REBOOT_REQ).show();
						} else {
							$(ACTIVATE_SELECTION).closest("li").show();
							$(NO_REBOOT_REQ).hide();
						}
						if(nodeItem.activate_sfw) {
							$(ACTIVATE_SELECTION).val('YES');
						} else {
							$(ACTIVATE_SELECTION).val('NO');
						}
					} else {
						if(nodeItem.type.match(/windows|linux|hpux|vmware/i)){
						$(COMMON_REBOOT).show();
						$(NO_REBOOT_REQ).hide();
						$('#hpsum-reboot-options-collapsible').css("display","block");
						$(REBOOT_ACTIVATE).hide();
						}
						else{
							$('#hpsum-reboot-options-collapsible').css("display","none");
						}
					}
					
						
                    showInstallationOptions(item);
					/*if(nodeItem.type.match(/Windows|Linux/i)) {
					   $('#hpsum-osmanagement-options-collapsible').css("display","block");
					   $('#hpsum-node-deploy-osmanagement-Options').css("display","block");
					   if(!$('#hpsum-node-deploy-osmanagement-Options-li').length)
					   {
						   $('#hpsum-node-reboot-options-li').closest('li').before('<li id="hpsum-node-deploy-osmanagement-Options-li"><a class="hp-anchor-uri" data-panel-id="hpsum-node-deploy-osmanagement-Options" href="#/node/edit/options">'+ localizer.getString("hpsum.node.osManagementOptions") +'</a></li>');
					   }
					}
					else {
						$('#hpsum-osmanagement-options-collapsible').css("display","none");
						$('#hpsum-node-deploy-osmanagement-Options').css("display","none");
						$('#hpsum-node-deploy-osmanagement-Options-li').remove();
					}*/
					if(nodeItem.type.match(/integrityilo|ipdu|virtual_connect/i)) {
					    $('#hpsum-installation-options-collapsible').css("display","none");
					    $("#hpsum-force-options-collapsible").css("display","none");

					}
					else
					{	
						$('#hpsum-force-options-collapsible').css("display","block");
						$('#hpsum-installation-options-collapsible').css("display","block");
					}
					if(nodeItem.type.match(/ipdu|virtual_connect|moonshot/i))
					    {
					    	$('#hpsum-node-reboot-options').css("display","none");
							$('#hpsum-node-reboot-options-li').remove();
					    }
					    else{
					    	$('#hpsum-node-reboot-options').css("display","block");
							if(!$('#hpsum-node-reboot-options-li').length)
							{
								$('#hpsum-node-details-edit li:last').after('<li id="hpsum-node-reboot-options-li"><a class="hp-anchor-uri" data-panel-id="hpsum-node-reboot-options" href="#/node/edit/installationoptions">' + localizer.getString("hpsum.node.installationOptions.header") + '</a></li>');
							}
					    }
					if(nodeItem.type.match(/virtual_connect/i)) {
						$('#hpsum-vc-options-collapsible').css("display","block");
						$('#hpsum-node-deploy-vc-Options').css("display","block");	
						$('#hpsum-vc-options-collapsible').hpCollapsible('expand');
						$('#hpsum-vc-options-collapsible').show();
						if(!$('#hpsum-node-deploy-vc-Options-li').length)
						{
							$('#hpsum-node-details-edit li:last').after('<li id="hpsum-node-deploy-vc-Options-li"><a class="hp-anchor-uri" data-panel-id="hpsum-node-deploy-vc-Options" href="#/node/edit/vcoptions">' + localizer.getString("hpsum.node.vcOptionstitle") + '</a></li>');
						}
					}
					else
					{
						$('#hpsum-vc-options-collapsible').css("display","none");
						$('#hpsum-node-deploy-vc-Options').css("display","none");
						$('#hpsum-node-deploy-vc-Options').remove();
						$('#hpsum-vc-options-collapsible').hide();
					}
					
		            if(item.type.match(/ilo/i))
					{
						$(TYPE).selectBox('value', "ilo");
					}
					else
					{
						$(TYPE).selectBox('value', item.type.toLowerCase());
					}	

					
		            if(item.type.match(/integrityilo/i))
		              $(TYPE).selectBox('value', 'ilo');
		       showPartnerOptions();
                    if(item.baselines){
                        for (var i=0; i<item.baselines.length; i++ ){
                            var baseline = presenter.getBaselineDetailsforId(item.baselines[i]);
                            if(baseline){
                                if(baseline.name.match(/^Additional/i)){
                                    currenthotfixbaseline = baseline; 
                                    $(CURRENT_HOTFIX).text(baseline.name);
                                    $(HOTFIX).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
                                }else{
                                    currentbaseline = baseline;
                                    $(CURRENT_BASELINE).text(baseline.name);
                                    $(BASELINES).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
                                }
                            }
                        }
                     } else {
                         $(CURRENT_BASELINE).text('');
                         editOptions.hapi.baselines = {remove_existing_baselines:'true'};
                         $(CURRENT_HOTFIX).text('');
                     }
                } else {
                    $(TITLE).text('');
                }

                formStateView.reset();
            }
            
            function onItemError(errorMessage) {
                formStateView.noItem(errorMessage);
            }
			
			function errormsg()
			{
				$(INSTALL_ERROR).hide();
			}
            
			function validateVCenterIP(ipaddr){
				//test ipv4
				if(ipaddr == '0.0.0.0' | ipaddr == '255.255.255.255'){
						return false;
					}
					var patt = /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
					if(ipaddr.match(patt))
						return true;
					else{
						patt = /^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))?$/;
						if(ipaddr.match(patt))
							return true;
						patt = /^[a-zA-Z0-9-_]+(\.[a-zA-Z0-9-_]+)*\.([a-zA-Z]{2,4})$/;
						//FQDN match
						if(ipaddr.match(patt))
							return true;  
				}	
				return false;
			}
            function showInstallationOptions(item){
            	//send getattributes for this node
            	presenter.otheroption(item, {success:function(data){
            						if(data && data.hasOwnProperty("hapi")){
				
				//if its vmware type and use vcenter is selected, check the checkbox and display credentials.
				$(USEVCENTER_CHKBOX).attr('checked', false);
				$(VCENTERPANEL).hide();
				$(VCENTERIPADDR).val('');
				vcenter_gusername = '';
				vcenter_gpassword = '';
				var nodeType = $(TYPE).val().toLowerCase();
				if(data.hapi.type.match(/vmware/i) && nodeType.match(/vmware/i)){
					$(VCENTERSECTION).show();
					if(data.hapi.use_vcenter == true){
						$(USEVCENTER_CHKBOX).attr('checked', true);
						showVCenterCredentialSelection();
						$(VCENTERIPADDR).val(data.hapi.vcenter_ip);
						vcenter_gvcenterip = data.hapi.vcenter_ip;
						$(VCENTERUSERNAME).val('');
						vcenter_gusername = data.hapi.vcenter_username;
						$(VCENTERPASSWORD).val('');
						vcenter_gpassword = data.hapi.vcenter_password;
					}
				}
				else
					$(VCENTERSECTION).hide();
						
				
				if(data.hapi.hasOwnProperty("reboot_options") && data.hapi.reboot_options){
						 
						$('#hpsum-reboot-option option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.reboot_options.action))
		    		            $(this).attr('selected', true);
		                  });
						if( -1 < data.hapi.reboot_options.delay){
							$(DELAYSEC).val(data.hapi.reboot_options.delay);				
						}
						else{
							$(DELAYSEC).val(REBOOT_DELAY_SEC);				
						}
						
						$(DELAYMSG).attr('value', data.hapi.reboot_options.message);				
					}
					/*if(data.hapi.hasOwnProperty("os_management_options") && data.hapi.os_management_options){
						$(USESNMPCHECKBOX).attr('checked', false);							
						$(USEAGENTLESSCHECKBOX).attr('checked', false);							
						$(USEWEBEMCHECKBOX).attr('checked', false);
						$(NONECHECKBOX).attr('checked', false);
						if( data.hapi.os_management_options.length > 0){
							if(data.hapi.os_management_options[0].match(/NONE/i))
								$(NONECHECKBOX).attr('checked', true);
							else{
								if (data.hapi.os_management_options[0].match(/AMS/i))
									$(USEAGENTLESSCHECKBOX).attr('checked', true);
								if (data.hapi.os_management_options[0].match(/SNMP/i))
									$(USESNMPCHECKBOX).attr('checked', true);
								if (data.hapi.os_management_options[0].match(/WBEM/i))
									$(USEWEBEMCHECKBOX).attr('checked', true);
									
							}
						}
					}*/
					if(data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option){
						var rewriteOption = data.hapi.installation_option.rewrite;
						var downgradeOption = data.hapi.installation_option.downgrade;
						var firmwareOption = data.hapi.installation_option.firmware;
						var softwareOption = data.hapi.installation_option.software;
						
						if ( !rewriteOption  && !downgradeOption )
						{
							if(firmwareOption && softwareOption){
								$(INSTALLATIONOPTION).val('upgradeBoth');
							}
							else if(firmwareOption){
								$(INSTALLATIONOPTION).val('upgradeFirmware');
							}
							else if(softwareOption){
								$(INSTALLATIONOPTION).val('upgradeSoftware');
							}
						}
						else if ( rewriteOption  && downgradeOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('both');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('firmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('software');
						}
						else if ( rewriteOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('rewriteBoth');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('rewriteFirmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('rewriteSoftware');
						}
						else if ( downgradeOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('downgradeBoth');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('downgradeFirmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('downgradeSoftware');

						}
										
						$(INSTALLATIONOPTION).selectBox('reset');										
					}
					if(data.hapi.hasOwnProperty("vc_activation_options") && data.hapi.vc_activation_options){
						$('#hpsum-Enet-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.eth_activation_order))
		    		            $(this).attr('selected', true);
		                  });
		                 $('#hpsum-fc-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.fc_activation_order))
		    		            $(this).attr('selected', true);
		                  });
						$('#hpsum-Enet-delay').val(data.hapi.vc_activation_options.eth_activation_delay);
						$('#hpsum-FC-delay').val(data.hapi.vc_activation_options.fc_activation_delay);
					}
					if(data.hapi.hasOwnProperty("auto_add_assoc_nodes") && data.hapi.auto_add_assoc_nodes)
						$(ADD_ASSOC_NODES).attr('checked', true);
					else
						$(ADD_ASSOC_NODES).attr('checked', false);				
					if(data.hapi.hasOwnProperty("node_skip"))
						if(data.hapi.node_skip)
							$("input[name='hpsum-node-edit-active']")[0].checked = true;
					else
							$("input[name='hpsum-node-edit-active']")[1].checked = true;
				}
				},
            	error:function(){
            		
            	}
            		
            	});
            	
            	
            }

            function onItemUpdateSuccess(item) {
            	
            	var nodeType = $(TYPE).val().toLowerCase();
				if(nodeType.match(/virtual_connect/i)){
	            	//Start inventory
	            	presenter.startInventory(nodeItem, {
	                	success : function(data){},
	                    error : function(errormsg){}
	                });
	            }
                    
                updateInProgress = false;
                formStateView.reset();
                $(CANCEL).trigger('click');
            }
            function showPartnerOptions() {
            	
            	//Show partner IP field by default, only for VC node this is hidden
            	$(PARTNER_IP_LIST).show();
            	
                var nodeType = $(TYPE).val().toLowerCase();
				if (nodeType.match(/Windows/i) ||
					nodeType.match(/Linux/i) ||
					nodeType.match(/hpux/i))
					$('#hpsum-node-edit-alreadyExist').show();
				else
					$('#hpsum-node-edit-alreadyExist').hide();
				if(nodeType.match(/Linux|hpux/i)){
					$(LINUX_CRED_PANEL).css({"display":""});
					$(LINUX_ENTER_CRED).hide();
					//$('input[name="hpsum-linux-node-credential"]').click(linuxCredentialOptions);
					//linuxCredentialOptions("two");
					showLinuxCredGroupSelection();
				} else {
					$(LINUX_CRED_PANEL).css({"display":"none"});
					hideLinuxCredGroupSelection();
				}
					
				if(nodeType.match(/sas_switch/i) || 
            		nodeType.match(/virtual_connect/i) ||
            		nodeType.match(/ipdu/i)) {
            			if(nodeType.match(/ipdu/i)){
            				$(PARTNER_TYPE).html(localizer.getString('hpsum.common.PartnerIpduCredentials'));
            				$(PARTNER_IP_LABEL).html(localizer.getString('hpsum.common.PartnerIpduIP'));
            				partnerType = 'ipdu';
            			}
            			else{
            				$(PARTNER_TYPE).html(localizer.getString('hpsum.common.associatedOACredentials'));
            				$(PARTNER_IP_LABEL).html(localizer.getString('hpsum.common.associatedOAIp'));
            				partnerType = 'oa';
            			}
            			
            			//if node is VC, then hide OA IP field
            			if(nodeType.match(/virtual_connect/i)) {
            				$(PARTNER_IP_LIST).hide();
            			}
            				
            			$(PARTNER_CRED_PANEL).css({"display":""});;
            			$('input[name="hpsum-node-partner-credential"]').click(partnerCredentialsOptions);
            			partnerCredentialsOptions("two");
            			
            		
            		}
            	else{
            		$(PARTNER_CRED_PANEL).css({"display":"none"});
            		partnerType ='';
            	}
				
				if($(TYPE).val().toLowerCase().match(/virtual_connect/i) ||
            			$(TYPE).val().toLowerCase().match(/sas_switch/i) ||
            			$(TYPE).val().toLowerCase().match(/oa/i) ||
						$(TYPE).val().toLowerCase().match(/switch/i) ||
						$(TYPE).val().toLowerCase().match(/ilo/i)) {
            				$(ADD_ASSOC_NODES).show();
							$('#hpsum-node-addassoc-description').show();
				}
            	else {	
            			$(ADD_ASSOC_NODES).hide();
						$('#hpsum-node-addassoc-description').hide();
				}
				if($(TYPE).val().toLowerCase().match(/virtual_connect/i))
					$('#hpsum-node-deploy-vc-Options').show();
				else
					$('#hpsum-node-deploy-vc-Options').hide();
           	
				
				//Moonshot
				if(nodeType.match(/moonshot/i)) {
				    $('#hpsum-node-cred-details').hide();
				    $('#hpsum-moonshot-edit-credentials').show();
				    
				    //Enable OK button based on moon shot specific field edit
				    $('#hpsum-moonshot-admin-credentials-username').keyup(enableOk);
                    $('#hpsum-moonshot-admin-credentials-password').keyup(enableOk);
                    $('#hpsum-moonshot-switch-credentials-username').keyup(enableOk);
                    $('#hpsum-moonshot-switch-credentials-password').keyup(enableOk);
                    $('#hpsum-moonshot-switch-credentials-enablePassword').keyup(enableOk);
                    $('#hpsum-moonshot-switchB-credentials-username').keyup(enableOk);
                    $('#hpsum-moonshot-switchB-credentials-password').keyup(enableOk);
                    $('#hpsum-moonshot-switchB-credentials-enablePassword').keyup(enableOk);
                    //
                        
				} else {
				    $('#hpsum-node-cred-details').show();
                    $('#hpsum-moonshot-edit-credentials').hide();
				}
				
				if(nodeType.match(/vmware/i)){
					$(VCENTERSECTION).show();
					clearVcenterErrorMessages();
					clearvCenterCredInput();
				}
				else{
					$(VCENTERSECTION).hide();
				}
           }
		   function linuxCredentialOptions(value)
           {
           	    if(value.target)
            		value = value.target.value;
				if(checkedVal === value)
				{
					checkedVal = '';
					useSudoCredentials =false;
					if(value ==="one")
						$('#hpsum-linux-node-sudo').attr('checked',false);
					if(value == "two"){
						$(LINUX_ENTER_CRED).hide();
						$('#hpsum-linux-node-root').attr('checked',false);
					}
					}
				else{
					checkedVal = $('input[name="hpsum-linux-node-credential"]:checked').val();
					if(value == "one"){
						$(LINUX_ENTER_CRED).hide();
						useSudoCredentials =true;
					}
					if(value == "two"){
						$(LINUX_ENTER_CRED).show();
						useSudoCredentials = false;
					}
				}
           }
		   
           function partnerCredentialsOptions(value)
           {
           	    if(value.target)
            		value = value.target.value;
            	if(value == "one"){
            		$(PARTNER_ENTER_CRED).hide();
            		partnerUsername= $(USERNAME).val();
            		partnerPassword= $(PASSWORD).val();
            		//useCurrentCredentials =true;
            	}
            	if(value == "two"){
            		$(PARTNER_ENTER_CRED).show();
            	}
           	
           }
           

            /**
             * @private
             */
            function onItemUpdateError(errorMessage) {
                notifications.show(errorMessage);
                updateInProgress = false;
            }
            
            function onUpdateItem() {
					
				
                if (! updateInProgress) {
                    updateInProgress = true;
				
				//validate VCenter details.
				if(!validateVCenterCredentials()){
					updateInProgress = false;
					return;
				}
				if(!validateRebootDelay() || !validateLinuxSshKeyFile()){
					updateInProgress = false;
					return;
				}
				
				var baselineJson = [];
				//For Quix QXCR1001370034
            	if($(BASELINES).val() != ''){
            		baselineJson.push($(BASELINES).val());
            	}
				if(($(HOTFIX).val() != '')){
            		baselineJson.push($(HOTFIX).val());
            	}
				
				var errorFound = false; 
				for (var tmp = 0; tmp < baselineJson.length; tmp++) {
					if(baselineJson[tmp]){
						var baselinedetails = presenter.getBaselineDetailsforId(baselineJson[tmp]);
						if(!baselinedetails) {
							errorFound = true;
							if(baselineJson[tmp] == $(BASELINES).val()){
								$(BASELINE_INPUT_ERR).text(localizer.getString('hpsum.node.invalidBaseline'));	
								$(BASELINE_INPUT).addClass("hp-error");
								$(BASELINE_INPUT_ERR).show();
							}
							if(baselineJson[tmp] == $(HOTFIX).val()){
								$('#hpsum-node-edit-msg-container').removeClass("hp-empty");
								$(HOTFIX_INPUT_ERR).text(localizer.getString('hpsum.node.invalidAdtPackage'));	
								$(HOTFIX_INPUT).addClass("hp-error");
								$(HOTFIX_INPUT_ERR).show();
							}
						}	
					}
				}
				// Return if the baseline or additional package is invalid
				if(errorFound){
					updateInProgress = false;
					return;
				}
				//var auto_add_assoc_nodes;
				var nodeType = $(TYPE).val().toLowerCase();
				if(nodeType.match(/virtual_connect|sas_switch|oa|switch|ilo/i)){
					if($(ADD_ASSOC_NODES).is(':checked'))
						auto_add_assoc_nodes = true;
					else
						auto_add_assoc_nodes = false;
				}
						
				//node_skip will keep a track of selected option set for HP SUM behaviour if active update process is detected on the remote node
				node_skip = $("input[name='hpsum-node-edit-active']:checked").val();
				if (node_skip == "one")
					node_skip = true;
				else
					node_skip = false;
					var usevcenter = false;
					if($(USEVCENTER_CHKBOX).is(':checked'))
						usevcenter = true;
                     editOptions =  {
                    	hapi: {
                    	username : $(USERNAME).val(),
                    	password : $(PASSWORD).val(),
                    	description : $(DESCRIPTION).val(),
						su_username : $(LINUXUSERNAME).val(),
						su_password : $(LINUXPASSWORD).val(),
						use_vcenter: usevcenter,
						vcenter_ip: $(VCENTERIPADDR).val(),
						vcenter_username: $(VCENTERUSERNAME).val(),
						vcenter_password: $(VCENTERPASSWORD).val(),
						use_sudo : useSudoCredentials,
						auto_add_assoc_nodes : auto_add_assoc_nodes,
						node_skip : node_skip,
						type: $(TYPE).val()
                    	}
                    };
					
					if(nodeType.match(/Linux|hpux/i) && $('input[name="hpsum-node-credential"]:checked').val() == "two") {
						editOptions.hapi.use_sshkeyfile = true;
						editOptions.hapi.sshkeyfile_username = $.trim($(LINUX_SSH_KEY_FILE_USERNAME).val());
						editOptions.hapi.sshkeyfile_location = $.trim(instEditLinuxSshkeyBrowse.getLocation()).split('\\').join('/');
						editOptions.hapi.sshkeyfile_passphrase = $.trim($(LINUX_SSH_KEY_FILE_PASSPHRASE).val());
					} else 
						editOptions.hapi.use_sshkeyfile = false;
					
					if (newbaseline=='' && newhotfix=='')
					{
						editOptions.hapi.baselines = {remove_existing_baselines:'true'};
					}
                    
                    if( (currentbaseline != newbaseline) || (currenthotfixbaseline != newhotfix))  //something got changed
                    {
                        var baselinestosend = [];
                        if(newbaseline){
                            if(newbaseline.id != 'none') {
                                baselinestosend.push(newbaseline.id);
                            }
                        } //For Quix QXCR1001370034
                        if(newhotfix) { 
                            if(newhotfix.id != 'none') {
                                baselinestosend.push(newhotfix.id);
                            }
                        } //For Quix QXCR1001370034                    
                        if(baselinestosend.length > 0 ){
						    //For Quix QXCR1001370034
                            editOptions.hapi.baselines = {remove_existing_baselines:'true'};
                            editOptions.hapi.baselines.baseline = baselinestosend;
                        } else {
                        	//editOptions.hapi.baselines = {remove_existing_baselines:'false'};
                            if(!nodeItem.node_state.match(/idle/i)) {
                                //If the node is not idle we need to have a valid baseline
                                $("<div></div>").dialog( {
                                buttons: { "Ok": function () {
                                    $(this).dialog("close");
                                    }
                                },
                                close: function (event, ui) { $(this).remove(); },
                                resizable: false,
                                title: "Edit",
                                modal: true
                                }).text(localizer.getString('hpsum.node.pleaseSelectAPorB'));
                                updateInProgress = false;
                                return;
                            }
                        }
                    } 
                    
                    //Moonshot
                    var switchAUser, switchAPassword, switchAEnablePwd;
                    var switchBUser, switchBPassword, switchBEnablePwd;
                    
                    if(nodeType.match(/moonshot/i)) {
                        editOptions.hapi.username = $('#hpsum-moonshot-admin-credentials-username').val();
                        editOptions.hapi.password = $('#hpsum-moonshot-admin-credentials-password').val();
                    
                        switchAUser = $('#hpsum-moonshot-switch-credentials-username').val();
                        switchAPassword = $('#hpsum-moonshot-switch-credentials-password').val();
                        switchAEnablePwd = $('#hpsum-moonshot-switch-credentials-enablePassword').val();
                        
                        if($('#hpsum-moonshot-switch-same-credentials').is(":checked")) {
                            switchBUser = switchAUser;
                            switchBPassword = switchAPassword;
                            switchBEnablePwd = switchAEnablePwd;
                        } else {
                            switchBUser = $('#hpsum-moonshot-switchB-credentials-username').val();
                            switchBPassword = $('#hpsum-moonshot-switchB-credentials-password').val();
                            switchBEnablePwd = $('#hpsum-moonshot-switchB-credentials-enablePassword').val();
                        }
                        
                        editOptions.hapi.moonshot_switch_credentials = {};
                        if(switchAUser)
                            editOptions.hapi.moonshot_switch_credentials.switch_username = switchAUser;
                        if(switchBUser)
                            editOptions.hapi.moonshot_switch_credentials.switchb_username = switchBUser;
                        if(switchAPassword)
                            editOptions.hapi.moonshot_switch_credentials.switch_password = switchAPassword;
                        if(switchBPassword)
                            editOptions.hapi.moonshot_switch_credentials.switchb_password = switchBPassword;
                        if(switchAEnablePwd)
                            editOptions.hapi.moonshot_switch_credentials.switch_enable = switchAEnablePwd;
                        if(switchBEnablePwd)
                            editOptions.hapi.moonshot_switch_credentials.switchb_enable = switchBEnablePwd;                                                
                    }
                    
                    //For Quix QXCR1001370034
                    if(nodeType.match(/virtual_connect|ipdu|sas_switch/i)){
                    	editOptions.hapi.associated_node ={};
                    	editOptions.hapi.associated_node.ip = $(PARTNER_IP_VALUE).val();
            			editOptions.hapi.associated_node.type = partnerType;
            			if(partnerUsername == '' ){
            				partnerUsername= $(PARTNER_USERNAME).val();
            				partnerPassword= $(PARTNER_PASSWORD).val();
            			}
            			editOptions.hapi.associated_node.username = partnerUsername;            		
            			editOptions.hapi.associated_node.password = partnerPassword;
                    	
                    }
                    //For Quix QXCR1001370034
                    if(!nodeType.match(/integrityilo|virtual_connect|ipdu/i)){
                   		editOptions.hapi.installation_option ={};
                    	var type = $(INSTALLATIONOPTION).val();
						editOptions.hapi.installation_option.downgrade = false;
						editOptions.hapi.installation_option.rewrite   = false;
						editOptions.hapi.installation_option.software = false;
						editOptions.hapi.installation_option.firmware = false;
						editOptions.hapi.installation_option.forcesoftware = false;
						editOptions.hapi.installation_option.forcefirmware = false;
									  
						if ( type == "upgradeBoth"){
							editOptions.hapi.installation_option.software = true;
							editOptions.hapi.installation_option.firmware = true;
						}
						else if ( type == "upgradeFirmware"){
							editOptions.hapi.installation_option.firmware = true;
						}
						else if ( type == "upgradeSoftware"){
							editOptions.hapi.installation_option.software = true;
						}
						else if ( type == "downgradeFirmware"){
							editOptions.hapi.installation_option.downgrade = true;
							editOptions.hapi.installation_option.firmware = true;
							editOptions.hapi.installation_option.forcefirmware = true;
						}
						else if ( type == "downgradeSoftware"){
							editOptions.hapi.installation_option.downgrade = true;
							editOptions.hapi.installation_option.software = true;
							editOptions.hapi.installation_option.forcesoftware = true;
						}
						else if ( type == "downgradeBoth"){
							editOptions.hapi.installation_option.downgrade = true;
							editOptions.hapi.installation_option.firmware = true;
							editOptions.hapi.installation_option.forcefirmware = true;
							editOptions.hapi.installation_option.software = true;
							editOptions.hapi.installation_option.forcesoftware = true;
						}
						else if ( type == "rewriteFirmware"){
							editOptions.hapi.installation_option.rewrite = true;
							editOptions.hapi.installation_option.firmware = true;
							editOptions.hapi.installation_option.forcefirmware = true;
						}
						else if ( type == "rewriteSoftware"){
							editOptions.hapi.installation_option.rewrite = true;
							editOptions.hapi.installation_option.software = true;
							editOptions.hapi.installation_option.forcesoftware = true;
						}
						else if ( type == "rewriteBoth"){
							editOptions.hapi.installation_option.rewrite = true;
							editOptions.hapi.installation_option.firmware = true;
							editOptions.hapi.installation_option.forcefirmware = true;
							editOptions.hapi.installation_option.software = true;
							editOptions.hapi.installation_option.forcesoftware = true;
						}
						else if ( type == "firmware"){
							editOptions.hapi.installation_option.downgrade = true;
							editOptions.hapi.installation_option.rewrite = true;
							editOptions.hapi.installation_option.firmware = true;
							editOptions.hapi.installation_option.forcefirmware = true;
						}
						else if ( type == "software"){
							editOptions.hapi.installation_option.downgrade = true;
							editOptions.hapi.installation_option.rewrite = true;
							editOptions.hapi.installation_option.software = true;
							editOptions.hapi.installation_option.forcesoftware = true;
						}
						else if ( type == "both"){
							editOptions.hapi.installation_option.downgrade = true;
							editOptions.hapi.installation_option.rewrite = true;
							editOptions.hapi.installation_option.firmware = true;
							editOptions.hapi.installation_option.forcefirmware = true;
							editOptions.hapi.installation_option.software = true;
							editOptions.hapi.installation_option.forcesoftware = true;
						}
					}
					/*if($(SOFTWARECHKBOXCOMP).is(':checked') || $(FIRMWARECHKBOXCOMP).is(':checked'))
					{
						editOptions.hapi.installation_option.force = true;
					}*/
					if((nodeItem.hasOwnProperty('activate_sfw')) || (nodeItem.type.match(/windows|linux|vmware|hpux/i))){
						editOptions.hapi.reboot_options ={};	
						editOptions.hapi.reboot_options.action = $(REBOOTOPTION).val();
						editOptions.hapi.reboot_options.delay = $(DELAYSEC).val();				
						editOptions.hapi.reboot_options.message = $(DELAYMSG).val();
					}
					
					//vcenter details..					
					if(nodeItem.type.match(/vmware/i)){
						editOptions.hapi.vcenter_ip = $(VCENTERIPADDR).val();
						editOptions.hapi.vcenter_username = $(VCENTERUSERNAME).val();
						editOptions.hapi.vcenter_password = $(VCENTERPASSWORD).val();
					}
					/*if(nodeItem.type.match(/windows|linux|hpux/i)){
						editOptions.hapi.os_management_options='';
						if($(NONECHECKBOX).attr('checked'))
							editOptions.hapi.os_management_options = "None";
						else {
							if($(USESNMPCHECKBOX).attr('checked'))
								editOptions.hapi.os_management_options += "SNMP|";						
							if($(USEAGENTLESSCHECKBOX).attr('checked'))
								editOptions.hapi.os_management_options += "AMS|";													
							if($(USEWEBEMCHECKBOX).attr('checked'))
								editOptions.hapi.os_management_options += "WBEM|";
						}
					}*/
					//For Quix QXCR1001370034
					if(nodeType.match(/virtual_connect/i)) {
						editOptions.hapi.vc_activation_options ={};			
			            editOptions.hapi.vc_activation_options.eth_activation_order = $('#hpsum-Enet-order').val();
		    		    editOptions.hapi.vc_activation_options.fc_activation_order = $('#hpsum-fc-order').val();     
						editOptions.hapi.vc_activation_options.eth_activation_delay = $('#hpsum-Enet-delay').val();
						editOptions.hapi.vc_activation_options.fc_activation_delay= $('#hpsum-FC-delay').val();	
					
					}
					var tmp = $(ACTIVATE_SELECTION).val();
					if( tmp == 'NO') {
						editOptions.hapi.activate_sfw = false;
					} else {
						editOptions.hapi.activate_sfw = true;
					}
				
            
                    presenter.setattribute(nodeItem, editOptions, {
                        success : onItemUpdateSuccess,
                        error : onItemUpdateError
                    });
                }
            }
						
			function validateVCenterCredentials() {
				var validDetails = true;
				var vcenterIpChanged = false;
				if($(USEVCENTER_CHKBOX).is(':checked')){
					if($(VCENTERIPADDR).val() == ''){
		            		$(VCENTERIPADDR).addClass("hp-error");
		            		$(VCENTERIPADDR_ERR).show();
							$(VCENTERIPADDR_ERR).text(localizer.getString('hpsum.node.required'));		            		
		            		validDetails = false;
		            	}
						else{ // validate ip address value.
							if($(VCENTERIPADDR).val() != vcenter_gvcenterip){
								vcenterIpChanged = true;
							}
							if(!validateVCenterIP($(VCENTERIPADDR).val())){
								$(VCENTERIPADDR).addClass("hp-error");
								$(VCENTERIPADDR_ERR).text(localizer.getString('hpsum.node.invalidIPV4orIPV6'));								
								$(VCENTERIPADDR_ERR).show();								
								validDetails =  false;							
								}
						}						
						if( (vcenter_gusername == '' || vcenterIpChanged) && $(VCENTERUSERNAME).val() == ''){
		            		$(VCENTERUSERNAME).addClass("hp-error");
		            		$(VCENTERUSERNAME_ERR).show();		            		
		            		validDetails = false;
		            	}
		            	if( (vcenter_gpassword == '' || vcenterIpChanged) && $(VCENTERPASSWORD).val() == ''){
		            		$(VCENTERPASSWORD).addClass("hp-error");
		            		$(VCENTERPASSWORD_ERR).show();		            		 
		            		validDetails = false;
		        		}
				}
				return validDetails;
			}
			
			function validateRebootDelay() {
				var rebootopt = $('#hpsum-reboot-option option:selected').val();
				var delaySec = $(DELAYSEC).val();
				var valid = true;
				
				if (rebootopt != "Never") {
					if((isNaN(delaySec) && !isFinite(delaySec)) || 
					  (delaySec < 60 || delaySec > 3600)) {
						$(DELAYSEC).addClass("hp-error");
						$(DELAYSECERR).text(localizer.getString("hpsum.node.rebootDelaySecondsErrMsg"));
						$(DELAYSECERR).show();
						valid = false;       
                    } 
					else {
						$(DELAYSEC).val(parseInt(delaySec));
						$(DELAYSEC).removeClass("hp-error");
						$(DELAYSECERR).hide();
					}
				}
				return valid;
            }
            
			function validateLinuxSshKeyFile() {
				var valid = true;
				var nodeType = $(TYPE).val();
				
				if(nodeType.match(/Linux|hpux/i) && $('input[name="hpsum-node-credential"]:checked').val() == "two"){
					var sshKeyFile_username = $.trim($(LINUX_SSH_KEY_FILE_USERNAME).val());
					var	sshKeyFile_location = $.trim(instEditLinuxSshkeyBrowse.getLocation()).split('\\').join('/');	
					var sshKeyFile_passphrase = $.trim($(LINUX_SSH_KEY_FILE_PASSPHRASE).val());
					if(!sshKeyFile_username || !sshKeyFile_location || !sshKeyFile_passphrase) {
						if(!sshKeyFile_username){
		            		$(LINUX_SSH_KEY_FILE_USERNAME).addClass("hp-error");
		            		$(LINUX_SSH_KEY_FILE_USERNAME_ERR).show();
		            		$(LINUX_SSH_KEY_FILE_USERNAME).bind('keyup', function(){
		            			$(LINUX_SSH_KEY_FILE_USERNAME_ERR).hide();
		            			$(LINUX_SSH_KEY_FILE_USERNAME).removeClass('hp-error');
		            		});
		            		valid = false;
		            	}
					
						if(!sshKeyFile_location){
							instEditLinuxSshkeyBrowse.addInputClass("hp-error");
							$(LINUX_SSH_KEY_FILE_PATH_ERR).show();
							instEditLinuxSshkeyBrowse.setInputEvent('onkeyup', function(){
								$(LINUX_SSH_KEY_FILE_PATH_ERR).hide();
								instEditLinuxSshkeyBrowse.removeInputClass('hp-error');
							});
							valid = false;
						}
					}
				}
					
				return valid;
			}
            
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
			
			function enableOk(){ 
				$(OK).attr('disabled', false);
			}
            this.resume = function () {
				$(OK).attr('disabled', true);
            	presenter.on('itemChange', onItemChange);
				$(USERNAME).val('');
				$(PASSWORD).val('');				
				$('.moonshot').val('');
            	$(TYPE).bind('change', showPartnerOptions);
				$(VCENTERUSERNAME).val('');
				$(VCENTERPASSWORD).val('');
				clearVcenterErrorMessages();
				$(DELAYSECERR).hide();
				$(PARTNER_IP_LIST).show();
				$(DELAYSEC).removeClass('hp-error');
               // presenter.on('searchSuggestionChange', baselinesAvailable);
                $(PANELS).hpStackedPanels('resume');
                presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
				baselineChange = false;
				addpkgChange = false;
            };
            
            this.pause = function () {
            	presenter.off('itemChange', onItemChange);
                $(BASELINES).hpSearchCombo('set', {id:'', name: ''});
                $(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
              	//presenter.off('searchSuggestionChange', baselinesAvailable);
                $(PANELS).hpStackedPanels('pause');
            };
          
          	function baselinesAvailable(data){
    			//data = {count: data.count, members: data};
            	//$(BASELINES).hpSearchCombo({getResults: presenter.getResults});
            }

            function getBaseline(string, handlers, count, start){
                var results=baselines;
                    if (string && string.length > 0) {
                         results =
                            $.grep(baselines, function(option, index) {
                                return (option.name.match(
                                         new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
                          });   
                     }
                    handlers.success({count: results.length, members: results, start: 0, total: results.length});
            }
            function getHotfixes(string, handlers, count, start){
                    var results=hotfixes;
                    if (string && string.length > 0) {
                         results =
                            $.grep(hotfixes, function(option, index) {
                                return (option.name.match(
                                         new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
                          });   
                     }
                    handlers.success({count: results.length, members: results, start: 0, total: results.length});
            }

            function getBaselinesSuccess(searchResults)
            {
                    baselines = $.grep(searchResults, function (option, index ) {
                        return !(option.name.match(new RegExp('^Additional', 'i')));
                    });
                    hotfixes = $.grep(searchResults, function (option, index) {
                        return (option.name.match(new RegExp('^Additional', 'i')));
                    });
                
            }
            
            function getBaselinesError(msg)
            {
                
            }
            
            function onBrowseButtonClick() {
            	enableOk();
            }
          
			/**
             * @public
             */
            this.init = function () {
              
				var resource = router.location().split('/');
                	resource = resource[1];
                
                var options = 	{
									command : 'init',
									panelLabel: "hpsum.common.SshKeyFile",
									panelLabelStyle: "",
						            panelHelp: "",
						            panelBrowseText: "hpsum.common.browse",
						            bshowFile: true,
						            onBrowseButtonClick: onBrowseButtonClick
						        };
						        
				$(EDIT_LINUX_BROWSE_PANEL).hpsumBrowse(options);
				
				instEditLinuxSshkeyBrowse = $(EDIT_LINUX_BROWSE_PANEL).data('plugin_hpsumBrowse');
                
				$('#hpsum-node-edit-namehelp').attr('tooltip', localizer.getString('hpsum.common.ipDnshelpedit')).hpTooltip();
				$('#hpsum-node-edit-additionalpackagehelp').attr('tooltip', localizer.getString('hpsum.node.additionalPackageshelp')).hpTooltip();
				$('#hpsum-node-addassocnodes').attr('tooltip', localizer.getString('hpsum.common.typetoaddhelp')).hpTooltip();
				$('#hpsum-installation-options-collapsible').attr('tooltip', localizer.getString('hpsum.node.installationOptions.help')).hpTooltip();
              	$('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
  					ROUTE_PREFIX = '/'+ resource +'/edit';
               		$('#hpsum-node-edit-close').click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
                
				$("input").bind("keypress", function(event) {
                    var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
                    if (keycode == 13) { // keycode for enter key
						var isDisabled = $(OK).attr('disabled');
						if(isDisabled === undefined)
						{
							$(OK).trigger('click');
						}
                        event.preventDefault();
                      }
                });
				
				//By Default reboot-options value is Never so disable the Reboot delay and Reboot message.
				$(".hpsum-otu-node-edit-disable").find('input,textarea,select,button').prop("disabled", true);
				$('#hpsum-downgrade-rewrite-text').html(localizer.getString("hpsum.node.installationOptions.message"));
				$('#hpsum-downgrade-rewrite-text').removeClass('hp-collapsed');
				$(FIRMWARECHKBOXCOMP).bind('change', errormsg);
				$(INSTALL_ERROR).hide();
					$(SOFTWARECHKBOXCOMP).bind('change', errormsg);
				$("#hpsum-installation-option").change(function() {
					var type = $(INSTALLATIONOPTION).val();
					if (type == "None")
					{
						$('#hp-force-downgrade-rewrite').hide();
						$(FIRMWARECHKBOXCOMP).attr('checked', false);							
						$(SOFTWARECHKBOXCOMP).attr('checked', false);
					}
					else
						$('#hp-force-downgrade-rewrite').show();
						$(INSTALL_ERROR).hide();
					
				});
				$(INSTALLATIONOPTION).selectBox({autoWidth: false});
				$(REBOOTOPTION).selectBox({autoWidth: false});
				
				$("#hpsum-reboot-option").change(function() {
					var type = $('#hpsum-reboot-option option:selected').val(); 
					$(OK).attr('disabled', false);
					if (type == "Never") {
					$(".hpsum-otu-node-edit-disable").find('input,textarea,select,button').prop("disabled", true);
					$(DELAYSEC).val('');
					$(DELAYSEC).removeClass("hp-error");
					$(DELAYSECERR).hide();
					}
					else
					{
					$(".hpsum-otu-node-edit-disable").find('input,textarea,select,button').prop("disabled", false);
					}
				});
				
				$(DELAYSEC).unbind('keyup').bind('keyup', function(){
					$(DELAYSECERR).hide();
					$(DELAYSEC).removeClass('hp-error');
				}); 
				
				$(DELAYSEC).bind('change', function(){
					$(DELAYSECERR).hide();
					$(DELAYSEC).removeClass('hp-error');
				}); 
				
                   $(PANELS).hpStackedPanels({
                    	panelSelector : PANEL_SELECTOR
                	});
					
				if ((navigator.appVersion.indexOf("X11")!=-1) ||
				   (navigator.appVersion.indexOf("Linux")!=-1)) { 
				        $('#hpsum-node-type option[value="windows"]').remove();
					    $(TYPE).selectBox('reset');
				    }	
					  
                $(TYPE).selectBox({autoWidth: false});
                formStateView.init({form: FORM,
                    routePattern: ROUTE_PREFIX + '.*',
                    autoTrack: true});
					
				
				$(TYPE).change(enableOk);
				$("input[name='hpsum-node-edit-active']").change(enableOk);
				$('input[name="hpsum-linux-node-credential"]').change(enableOk);
				$(DESCRIPTION).keyup(enableOk);
				$(USERNAME).keyup(enableOk);
				$(PASSWORD).keyup(enableOk);
				$(INSTALLATIONOPTION).change(enableOk);
				
				$(LINUX_SSH_KEY_FILE_USERNAME).keyup(enableOk);
				instEditLinuxSshkeyBrowse.setInputEvent('onkeyup', enableOk);
				$(LINUX_SSH_KEY_FILE_PASSPHRASE).keyup(enableOk);
						
				$(window).on('resize', OnResize);
				//set width for baseline and additional package search box.
				OnResize();
								
				
				$(USEVCENTER_CHKBOX).change( // call to show vcenter.
					function(){ 
						$(VCENTERPANEL).toggle(); 
						clearVcenterErrorMessages();
						enableOk();
					}
				) 
				$(VCENTERIPADDR).keyup(enableOk);
				$(VCENTERUSERNAME).keyup(enableOk);
				$(VCENTERPASSWORD).keyup(enableOk);
				
				//bind function for vcenter inputs
				
				$(VCENTERIPADDR).bind('keyup', function(){
					$(VCENTERIPADDR_ERR).hide();
					$(VCENTERIPADDR).removeClass('hp-error');
				});

				$(VCENTERUSERNAME).bind('keyup', function(){
		        	$(VCENTERUSERNAME_ERR).hide();
		        	$(VCENTERUSERNAME).removeClass('hp-error');
		        });

				$(VCENTERPASSWORD).bind('keyup', function(){
		        	$(VCENTERPASSWORD_ERR).hide();
		        	$(VCENTERPASSWORD).removeClass('hp-error');
		        });
				
                $(BASELINES).hpSearchCombo({getResults: getBaseline});

                $(HOTFIX).hpSearchCombo({getResults: getHotfixes});
				
				$(LINUX_SSH_KEY_FILE_USERNAME).keyup(enableOk);
				$(LINUX_SSH_KEY_FILE_PATH).keyup(enableOk);
				$(LINUX_SSH_KEY_FILE_PASSPHRASE).keyup(enableOk);
						
				$(window).on('resize', OnResize);
				//set width for baseline and additional package search box.
				OnResize();
                $(BASELINES).change(function (ev, value) {
                    var item = presenter.getBaselineDetailsforId(value);
                    if(item){
                        newbaseline = item;
                        $(CURRENT_BASELINE).text(newbaseline.name);
                    } else {
                    	newbaseline='';                        
                        $(CURRENT_BASELINE).text('');                        
                    }
					if(!setOk){
						$(BASELINE_INPUT_ERR).hide();
						$(BASELINE_INPUT).removeClass('hp-error');
					}
					setOk = false;
					
					baselineChange = true;
					if(baselineChange)
						$(OK).attr('disabled', false);
                });

                $(HOTFIX).change(function (ev, value) {
                    var item = presenter.getBaselineDetailsforId(value);
                    if(item){
                        newhotfix = item;
                        $(CURRENT_HOTFIX).text(newhotfix.name);
                    } else {
                    	newhotfix='';
                        $(CURRENT_HOTFIX).text('');  
                    }
					if(!setOk){
						$(HOTFIX_INPUT_ERR).hide();
						$(HOTFIX_INPUT).removeClass('hp-error');
					}
					setOk = false;
					
					addpkgChange = true;
					if(addpkgChange)
						$(OK).attr('disabled', false);
                });
				
				$(BASELINE_INPUT).unbind('keyup').bind('keyup',function(){
					$(BASELINE_INPUT_ERR).hide();
					$(BASELINE_INPUT).removeClass('hp-error');
				});
				
				$(HOTFIX_INPUT).unbind('keyup').bind('keyup',function(){
					$(HOTFIX_INPUT_ERR).hide();
					$(HOTFIX_INPUT).removeClass('hp-error');
				});	

              	presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
                
                $(OK).on('click', function(ev) {
					setOk = true;
                    onUpdateItem();
                    ev.preventDefault();
                });
                
				$('input[name="hpsum-node-credential"]').click(credentialsOptions);
                //Moonshot
                $('#hpsum-moonshot-switch-same-credentials').click(function(){
                    $('#hpsum-moonshot-switchB-credentials').toggle();
                    enableOk();
                });
                
                hideLinuxCredGroupSelection();
                
                $('.hp-collapsible').hpCollapsible();
				$('input[name="hpsum-linux-node-credential"]').click(linuxCredentialOptions);
                router.watch('node edit section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                showPartnerOptions();
                this.resume();
				
            };
       }
	
	return NodeEditView;

			
		}());

	return new NodeEditView();
	

});
