// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/view/FormStateView',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpToggle',
    'lib/jquery.selectBox'],
function(presenter,router, urlFragment, notifications, FormStateView, localizer) { "use strict";

    var NodeInventoryDView = (function() {
      
        var OK = '#hpsum-node-inventory-ok';
        var CANCEL ='#hpsum-node-inventory-close';
        var PANEL_SELECTOR = '#hpsum-node-inventory-panel-selector';
        var PANELS = '#hpsum-node-inventory-panels';
        var FORM = '#hpsum-node-inventory-form';
        var TITLE = '#hpsum-node-details-title';
        var TYPE ='#hpsum-node-type';
        var NAME = '#hpsum-node-name',
        	FAILEDMSG ='#hpsum-node-inventory-failed-details',
        	FAILEDPANEL ='#hpsum-node-inventory-failed',
        	BASELINES = '#hpsum-node-baselines-search',
        	ASSOCBASELINE = '#hpsum-node-baseline',
        	REMOVEBASELINE='#hpsum-node-baseline-remove',
        	REMOVEHOTFIX='#hpsum-node-addpackage-remove',
        	HOTFIX ='#hpsum-node-addpackage-search',
        	ASSOCHOTFIX ='#hpsum-node-addpackage',
			BASELINE_INPUT = '#hpsum-node-baselines-search-input',
			HOTFIX_INPUT = '#hpsum-node-addpackage-search-input',
			BASELINE_INPUT_ERR = '#hpsum-node-baselines-search-input-err',
			HOTFIX_INPUT_ERR = '#hpsum-node-addpackage-search-input-err',
            STAGE_HEADING = '#hpsum-stage-heading',
            START_DEPLOY = '#hpsum-stage-deploy',
            START_DEPLOY_PANEL = '#hpsum-node-start-deploy',
            BASELINE_PANEL ='#hpsum-node-inventory-baseline';

        var ROUTE_PREFIX = '/node/inventoryd';
        var STAGE_FLAG = '#hpsum-node-stage';
        
        /**
         * Constructor
         */
        function NodeInventoryDView() {
          
            var formStateView = new FormStateView();
            var inventoryInProgress = false;
            var nodeItem=null;
            var baselines='',
    			hotfixes='',
    			assocBaseline=null,
    			newBaseline = null,
    			newHotFix  = null,
    			assocHotFix = null;
            var searchResults = [];
            var setOk = false;
            var stage_mode = 0;
			
            function onItemChange(item) {
            	item = item.hapi;
				if(item.node_state.match(/inventory/i)) {
					$(CANCEL).trigger('click');
				}

                if( $(STAGE_FLAG).length != 0 ){
                    if( ( item.type.match(/windows/i) || item.type.match(/linux/i) ) && 
                         (item.node_phase.match(/UserActionNeeded/i) || item.node_state.match(/installdone/i) ||
                            item.node_state.match(/error/i)))
                    {
                         //Then this page was rerouted from the deploy view.

                         //The user want to do a direct stage and deploy 
                        //In this state we send both stage and deploy, If stage mode is 1. This is done internally in the state
                        //machine. 
                        if( item.node_state.match(/idle/i) ||  item.node_state.match(/installdone/i) ||
                            item.node_state.match(/error/i)){
                            stage_mode = 1;
                            $(STAGE_HEADING).text(localizer.getString('hpsum.server.stageandDeploy'));
                            $(OK).prop('value',localizer.getString('hpsum.server.stage'));
                            var list= $(START_DEPLOY_PANEL);
                            $(START_DEPLOY_PANEL).show();
                            $(BASELINE_PANEL).show();
                        }
                        else if(item.node_state.match(/remote_staging_uan/i)){
                            //The user has already stage. Just deploy
                            stage_mode = 3;
                            $(STAGE_HEADING).text(localizer.getString('hpsum.server.stageDeploy'));
                            $(OK).prop('value', localizer.getString('hpsum.node.deploy'));
                            $(START_DEPLOY_PANEL).hide();
                            $(BASELINE_PANEL).hide();
                        }
                    }
                }
                if (item) {
                    $(TITLE).text(item.name);
                    $(NAME).text(item.name);
                    $(ASSOCBASELINE).text('');
                    $(REMOVEBASELINE).hide();
                    $(ASSOCHOTFIX).text('');
                    $(REMOVEHOTFIX).hide();
                    nodeItem= item;
                    newBaseline = null;
    				newHotFix  = null;
                    assocHotFix = null;
                    assocBaseline = null;
                    if(item.baselines){
                    	for (var i=0; i<item.baselines.length; i++ ){
                    		var baseline = presenter.getBaselineDetailsforId(item.baselines[i]);
                    		if(baseline){
                    			if(baseline.name.match(/^Additional Package/i)){
                    				$(ASSOCHOTFIX).text(baseline.name);
                    				$(REMOVEHOTFIX).show();
                    				assocHotFix = baseline; 
                    			}else{
                    				$(ASSOCBASELINE).text(baseline.name );
                    				$(REMOVEBASELINE).show();
                    				assocBaseline = baseline;
                    			}
                    		}
                    	}
 					 }
                } else {
                    $(TITLE).text('');
                }
                formStateView.reset();
            }
            
            function onInventoryError(errorMessage) {
                $(FAILEDPANEL).show();
                $(FAILEDMSG).text(errorMessage);
                $(OK).attr("disabled", "disabled");
                inventoryInProgress = false;
            }

            function onInventorySuccess(item) {
				if($(STAGE_FLAG).length != 0)
						stage_mode = 3;
                inventoryInProgress = false;
                $(CANCEL).trigger('click');
            }

            function OnResize(){
				var BaseLineSearchWidth = ($(window).width() / 3);
				$(BASELINES).hpSearchCombo({getResults:getBaseline, width:BaseLineSearchWidth});
				$(HOTFIX).hpSearchCombo({getResults: getHotfixes, width:BaseLineSearchWidth});
			}
			
            function onInventory() {
            	var fail=false;
            	var finalBaseline;
            	var finalHotFix;
            	var baselineJson=[];
                if (! inventoryInProgress) {

                    if(nodeItem.node_state.match(/remote_staging_uan/i))
                    {
                        //This is deploy after staging is complete
                        presenter.deploy(nodeItem, {
                                success : onDeploySuccess,
                                error : onDeployError});
                        return;
                    }
					var errorFound = false;
					if($(BASELINES).val() != ''){
						var baselinedetails = presenter.getBaselineDetailsforId($(BASELINES).val());
						if(!baselinedetails){
							errorFound = true;
							$(BASELINE_INPUT_ERR).text(localizer.getString('hpsum.node.invalidBaseline'));	
							$(BASELINE_INPUT).addClass("hp-error");
							$(BASELINE_INPUT_ERR).show();
						}
					}
					if($(HOTFIX).val() != ''){
						var baselinedetails = presenter.getBaselineDetailsforId($(HOTFIX).val());
						if(!baselinedetails){
							errorFound = true;
							$(HOTFIX_INPUT_ERR).text(localizer.getString('hpsum.node.invalidAdtPackage'));	
							$(HOTFIX_INPUT).addClass("hp-error");
							$(HOTFIX_INPUT_ERR).show();
						}
					}	
					
					if (errorFound == true){
						inventoryInProgress = false;
						return;
					}
					
                	if((newBaseline == null) && (assocBaseline == null))
                		finalBaseline = null;
                	else if (newBaseline == null)
                		finalBaseline = assocBaseline;
                	else
                		finalBaseline = newBaseline;
                	if((newHotFix == null) && (assocHotFix == null))
                		finalHotFix = null;
                	else if (newHotFix == null)
                		finalHotFix = assocHotFix;
                	else
                		finalHotFix = newHotFix;
                		
                	if((finalHotFix == null) &&  (finalBaseline == null))
                		fail = true;
                	else if(finalHotFix == null)
                		baselineJson.push(finalBaseline.id);
                	else if (finalBaseline == null)
                		baselineJson.push(finalHotFix.id);
                	else{
                		if(finalBaseline)
                			baselineJson.push(finalBaseline.id);
                		if(finalHotFix)
                			baselineJson.push(finalHotFix.id);
                	}
                	if(fail == true){
                		$(FAILEDPANEL).show();
                		$(FAILEDMSG).text(localizer.getString('hpsum.node.errorPleaseSelectBaseline'));
                	}
                	else {
                		nodeItem.baselines = baselineJson;
                        nodeItem.stage = stage_mode;
                    inventoryInProgress = true;
                    presenter.startInventory(nodeItem, {
                        success : onInventorySuccess,
                        error : onInventoryError
                    });
                   }
                }
            }

            function onDeploySuccess(item)
            {
                 $(CANCEL).trigger('click');
            }

            function onDeployError(errorMessage)
            {
                $(FAILEDPANEL).show();
                $(FAILEDMSG).text(errorMessage);
                $(OK).attr("disabled", "disabled");
                inventoryInProgress = false;
            }
            
            
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            
        
          
          	function baselinesAvailable(data){
    			//data = {count: data.count, members: data};
            	//$(BASELINES).hpSearchCombo({getResults: presenter.getResults});
            }
            
            function getBaseline(string, handlers, count, start){
            	var results=baselines;
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(baselines, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results, start: 0, total: results.length});
        	}
            function getHotfixes(string, handlers, count, start){
          		  	var results=hotfixes;
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(hotfixes, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results, start: 0, total: results.length});
          	}
          
           function getBaselinesSuccess(searchResults)
            {
					baselines = $.grep(searchResults, function (option, index ) {
        				return !(option.name.match(new RegExp('^Additional', 'i')));
        			});
        			hotfixes = $.grep(searchResults, function (option, index) {
        				return (option.name.match(new RegExp('^Additional', 'i')));
           			});
            	
            }
            
            function getBaselinesError(msg)
            {
            	
            }

            function onStartDeployclicked(event)
            {
                if($(START_DEPLOY).is(':checked')){
                    stage_mode = 2;
                    $(OK).prop('value',localizer.getString('hpsum.server.stageandDeploy'));
                }
                else{
                    stage_mode = 1;
                    $(OK).prop('value',localizer.getString('hpsum.server.stage'));
                }
            }

            this.resume = function () {
                presenter.on('itemChange', onItemChange);
                //presenter.on('searchSuggestionChange', baselinesAvailable);
                $(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
                baselines = hotfixes = localizer.getString('hpsum.common.loading');
                    presenter.getAllBaselines({
                            success:getBaselinesSuccess,
                            error: getBaselinesError
                    });
                $(PANELS).hpStackedPanels('resume');
                $(OK).removeAttr("disabled");
                $(FAILEDPANEL).hide();
                $(BASELINES).hpSearchCombo('set', {id:'', name: ''});
                $(BASELINE_INPUT).removeClass("hp-error");
                $(HOTFIX_INPUT).removeClass("hp-error");
                $(BASELINE_INPUT_ERR).hide();
                $(HOTFIX_INPUT_ERR).hide();
                /*
                    We will use the same view for staging and regular inventory.
                    The page is going to be stage.html
                */
                if($(STAGE_FLAG).length != 0 )
                {
                    stage_mode = 1;
                    ROUTE_PREFIX = '/node/stage';
                }
                else
                {
                    stage_mode = 0;
                }

                
                
            };
            
            this.pause = function () {
                presenter.off('itemChange', onItemChange);
                $(BASELINES).hpSearchCombo('set', {id:'', name: ''});
                $(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
                //presenter.off('searchSuggestionChange', baselinesAvailable);
                $(PANELS).hpStackedPanels('pause');
            };
            /**
             * @public
             */
            this.init = function () {
              
				var resource = router.location().split('/');
                	resource = resource[1];
			$('#hpsum-node-inventory-ok').attr('tooltip', localizer.getString('hpsum.common.inventoryhelp')).hpTooltip();
                	if(resource === 'node')
                		$(TYPE).val("Unknown");
                	else
                		$(TYPE).val(resource);
               		$('#hpsum-node-inventory-close').click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
                $(FAILEDPANEL).hide();
                   $(PANELS).hpStackedPanels({
                    	panelSelector : PANEL_SELECTOR
                	});
                
                formStateView.init({form: FORM,
                    routePattern: ROUTE_PREFIX + '.*',
                    autoTrack: true});
               
				$(REMOVEBASELINE).on('click',function(ev){
					assocBaseline=null;
					$(BASELINES).hpSearchCombo('set', {id:'', name: ''});
					$(ASSOCBASELINE).text('');
					$(REMOVEBASELINE).hide();
				});
				$(REMOVEHOTFIX).on('click',function(ev){
					assocHotFix=null;
					$(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
					$(ASSOCHOTFIX).text('');
					$(REMOVEHOTFIX).hide();
				});
				
				$(window).on('resize', OnResize);
				//set width for baseline and additional package search box.
				OnResize();
				
                $(BASELINES).change(function (ev, value) {
                	var item = presenter.getBaselineDetailsforId(value);
                	if(item){
        				$(ASSOCBASELINE).text(item.name);
        				$(REMOVEBASELINE).show();
        				newBaseline = item;
        				}
        			else {
        				if(assocBaseline != null){
        					$(ASSOCBASELINE).text(assocBaseline.name);
        					$(REMOVEBASELINE).show();
        				}
        				newBaseline = null;
        			}//nodeItem.baselines = value;
					if(!setOk){		
						$(BASELINE_INPUT_ERR).hide();
						$(BASELINE_INPUT).removeClass('hp-error');
					}
					setOk = false;
					$(OK).removeAttr("disabled");
        			$(FAILEDPANEL).hide();
    			});
                $(HOTFIX).change(function (ev, value) {
                	var item = presenter.getBaselineDetailsforId(value);
                	if(item){
        				$(ASSOCHOTFIX).text(item.name);
        				$(REMOVEHOTFIX).show();
        				newHotFix = item;
        				}
        			else {
        				if(assocHotFix != null){
        				$(ASSOCHOTFIX).text(assocHotFix.name);
        				$(REMOVEHOTFIX).show();
        				}
        				newHotFix = null;
        			}
        			//nodeItem.baselines = value;
					if(!setOk){
						$(HOTFIX_INPUT_ERR).hide();
						$(HOTFIX_INPUT).removeClass('hp-error');
					}
					setOk = false;
					$(OK).removeAttr("disabled");
        			$(FAILEDPANEL).hide();
    			});
				
				$(BASELINE_INPUT).unbind('keyup').bind('keyup',function(){
					$(BASELINE_INPUT_ERR).hide();
					$(BASELINE_INPUT).removeClass('hp-error');
				});
				
                $(HOTFIX_INPUT).unbind('keyup').bind('keyup',function(){
					$(HOTFIX_INPUT_ERR).hide();
					$(HOTFIX_INPUT).removeClass('hp-error');
				});
                
				$(OK).on('click', function(ev) {
					setOk = true;
                    onInventory();
                    ev.preventDefault();
                });

                if($(STAGE_FLAG).length != 0)
                {
                    $(START_DEPLOY).hpToggle({ checked: localizer.getString('hpsum.common.yes'),
                        unchecked: localizer.getString('hpsum.common.no')});

                    $(START_DEPLOY).on('change',function(){ onStartDeployclicked()});
                }
                

                router.watch('node inventory section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                
                this.resume();
            };
        }

        return new NodeInventoryDView();
    }());
    
    return NodeInventoryDView;
});
