// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (NodeShowReports)
 * This is a view class for Node Reports menu option.
 */

define(['hpsum/presenter/node/NodePresenter',
	'hpsum/presenter/ilofederation/iloFederationPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/view/FormStateView',
    'hp/core/HelpMenu',
	'hp/core/Localizer',
	'hp/core/Notifications',
	'hp/view/DialogView',
	'hp/model/Session',
    'jquery',
    'hpsum/common/jquery.hpsumBrowse',
    'lib/jquery.selectBox'],
function(presenter, ilofederationPresenter, router,urlFragment, FormStateView, helpMenu, localizer, notifications, DialogView, session) {"use strict";

	var ReportsShowView = ( function() {
			var FORM = '#hpsum-nodes-reports-form',
			    RESET = '#hpsum-nodes-reset',
			    CANCEL = '#hpsum-nodes-reports-close',
			    GENERATE = '#hpsum-nodes-reports-generate',
			    TYPE = '#hpsum-node-reports-type',
			    ROUTE_PREFIX = '/node/reports',
				BROWSE_OK='#hp-report-add-ok',
				BROWSE_CANCEL='#browse-dialog-cancel',
				INFO_DIALOG = '#hpsum-info-dialog',
				BROWSE_LOCATION_ERROR = '#hpsum-invalid-location-error',
			    FIRMWARECHECKBOX = '#hpsum-node-reports-firmware',
			    INSTALLABLECHECKBOX = '#hpsum-node-reports-installable',
			    FAILEDDEPCHECKBOX = '#hpsum-node-reports-faileddep',
			    INSTALLEDCHECKBOX = '#hpsum-node-reports-installed',
			    INVENTORYCHECKBOX = '#hpsum-node-reports-inventory',
			    COMBINEDCHECKBOX = '#hpsum-node-reports-combined',
			    REPORTFORMATHTML = '#hpsum-node-reports-html',
			    REPORTFORMATXML = '#hpsum-node-reports-xml',
			    REPORTFORMATCSV = '#hpsum-node-reports-csv',
			    RUNBACKCHECKBOX = '#chkbox-runbackReport',
			    TITLE = '#hpsum-node-reports-title',
			    SPLASH_DIALOG = '#hpsum-report-wait-dialog',
			    SPLASH_SPINNER = '#hpsum-report-spinner',
			    REPORTS_TABLE = '#hpsum-reports-table',
				REPORTS_LOCATION = '#hpsum-reports-location',
				REPORTS_LOC_BROWSE = '#hpsum-report-browse-panel';

			function ReportsShowView() {
				var nodeItem = null,
				    timer = null,
				    inProgressTimer = null,
				    inProgressReportId = null,
				    reportWaitDialog,
					allReportsDialog,
				    deleteInfoDialog,
				    deleteReportId,
					infoDialog,
					instReportLocBrowse,
					rept_path,
				    generateInProgress = false;
				    
				function reset() {
				}
				
			function handleInvalidPath(hapi) {
				if (hapi.hcode == 5) {
					$(BROWSE_LOCATION_ERROR).html(localizer.getString('hpsum.baseline.add.inValidLocation'));
					instReportLocBrowse.addInputClass("hp-error");
					$(BROWSE_LOCATION_ERROR).show();
					$(GENERATE).attr("disabled", true);
				} else {
				    $(BROWSE_LOCATION_ERROR).hide();
				    instReportLocBrowse.removeInputClass("hp-error");
				}
			}

				function onItemChange(item) {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					
					if(router.location().match(/baseline/i))
					   return;
					
					nodeItem = item.hapi;
					if (nodeItem && nodeItem.hasOwnProperty("node_id")) {
						$(TITLE).text(nodeItem.name);
						
						if(nodeItem.node_state != "INSTALLDONE" && !router.location().match(/one-touch-update/i)){
						    //Disable installed reports
						    $(INSTALLEDCHECKBOX).attr('checked', false).attr('disabled','disabled');
						} else {
						    $(INSTALLEDCHECKBOX).removeAttr('disabled').attr('checked', true);
						}
					} else {
						$(CANCEL).trigger('click');
					}
				}

				function showReportGenerationWait() {

					var reportButtons = {};

					reportButtons[localizer.getString('hpsum.node.runbackReport')] = function() {
						notifications.show(localizer.getString("hpsum.node.runningReportInBack", new Array(nodeItem.name)) + 
										   localizer.getString("hpsum.node.referForReportStatus"), 'ok');
						//clearInterval(timer);
						closesReportGenerationWait();
						//populateReportsTable(false);
						//$(GENERATE).attr("disabled", false);
					};

					if (!reportWaitDialog) {
						reportWaitDialog = $(SPLASH_DIALOG);
						reportWaitDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							buttons : reportButtons,
							width : 300,
							height : 180
						});
					}
					$(SPLASH_SPINNER).show();
					reportWaitDialog.dialog('open');
				}

				function closesReportGenerationWait() {
					$(SPLASH_SPINNER).hide();
					if (reportWaitDialog) {
					   reportWaitDialog.dialog('close');
					}
				}

				function populateReportsTable(isItemOnChange) {	
					var reports = [],
					    firmware_report,
					    update_applied_report,
					    installed_report,
					    dependency_report,
					    inventory_report,
					    combined_report,
					    nodes = [],
					    scalableobjects=[];

					presenter.getAllReports({
						success : function(data) {
							reports = data.hapi.reports.report;
							var tableReports = [],
							    reportTypes = [],
							    reportStatus,
							    inProgress = false;

							    var tmp_path =  localizer.getString('hpsum.node.reportsLocationMessage') + data.hapi.reports.report_location;
								rept_path=data.hapi.reports.report_location;
								$(REPORTS_LOCATION).text(tmp_path); 
								instReportLocBrowse.setPanelText(rept_path);
							    
							for (var idx = 0; idx < reports.length; ++idx) {
								    reportStatus = reports[idx].report_state;
								    
								if (reportStatus == "report_generation_completed") {
									reportStatus = localizer.getString("hpsum.node.completed");
								} else if (reportStatus == "in_progress" || reportStatus == "not_started" || reportStatus == "partially_generated") {
									reportStatus = localizer.getString("hpsum.node.inProgress");
									inProgress = true;
									if (isItemOnChange) {
										inProgressReportId = reports[idx].report_id;

										$(GENERATE).attr("disabled", true);
										inProgressTimer = setInterval(function() {
											presenter.getReportStatus(inProgressReportId, {
												success : function(data) {
													if (data.hapi.report_state.match(/in_progress|not_started|partially_generated/i)) {
													} else if (data.hapi.report_state.match(/report_generation_completed/i)) {

														clearInterval(inProgressTimer);

														$(GENERATE).attr("disabled", false);
														populateReportsTable(false);
														generateInProgress = false;

													} else {

														clearInterval(inProgressTimer);

													}
												},
												error : function(errorInfo) {

													clearInterval(inProgressTimer);
												}
											});

										}, 3000);
									}
								} else {
									reportStatus = localizer.getString("hpsum.node.failed");
								}

								    
								    reportTypes = reports[idx].report_type;
								    firmware_report = update_applied_report = installed_report = dependency_report = inventory_report = combined_report = "";					    
								    for (var i=0; i < reportTypes.length; i++) {
								    	
								    	if (reportTypes[i] == "firmware_report") {
								    		reportTypes[i] = "Firmware";
								    		if (inProgress) {
												firmware_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
											} else { 	
								    		    firmware_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' + 
								    		                   '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                   localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "update_applied_report") {
								    		reportTypes[i] = "deploy_preview";
								    		if (inProgress) {
												update_applied_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
											} else { 
								    		    update_applied_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                      '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                      localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "installed_report") {
								    		reportTypes[i] = "Installed";
								    		if (inProgress) {
												installed_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
											} else { 
								    		    installed_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                    '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                     localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "dependency_report") {
								    		reportTypes[i] = "FailedDependency";
								    		if (inProgress) {
												dependency_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
											} else { 
								    		    dependency_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                     '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                   localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "inventory_report") {
                                            reportTypes[i] = "Inventory";
                                            if (inProgress) {
                                                inventory_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
                                            } else { 
                                                inventory_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
                                                                 '<img src="/img/hp-piano/status-ok.png" ></br>' +
                                                               localizer.getString("hpsum.node.viewDetails") + '</a>';
                                            }
                                        }
								    	else if (reportTypes[i] == "combined_report") {
                                            reportTypes[i] = "Combined";
                                            if (inProgress) {
                                                combined_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
                                            } else { 
                                                combined_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
                                                                 '<img src="/img/hp-piano/status-ok.png" ></br>' +
                                                               localizer.getString("hpsum.node.viewDetails") + '</a>';
                                            }
                                        }
								    }
								    
								    inProgress = false;
								
								var deleteReport = '<a id="hpsum-delete-report" data-custom-value="' + reports[idx].report_id + '">' +
								'<img src="/img/hp-piano/close.png" >' + '</a>';
								
								tableReports.push({
									time_stamp : reports[idx].date_and_time,
									report_path:reports[idx].report_path,
									report_format : reports[idx].report_format,
									firmware_type : firmware_report,
									update_applied_type : update_applied_report,
									installed_type : installed_report,
									dependency_type : dependency_report,
									inventory_type: inventory_report,
									combined_report: combined_report,
									report_status : reportStatus,
									node_name : reports[idx].node_id,
									delete_report : deleteReport
								});
							}
	
							presenter.getAllNodes({
								success : function(data) {
									nodes = data.hapi.output_data.nodes.node;

									for (var jdx = 0; jdx < tableReports.length; ++jdx) {
										for (var idx = 0; idx < nodes.length; ++idx) {
											if (nodes[idx].node_id == tableReports[jdx].node_name) {
												tableReports[jdx].node_name = nodes[idx].node_name;
												break;
											}
										}
									}

									$(REPORTS_TABLE).dataTable().fnClearTable();
									$(REPORTS_TABLE).dataTable().fnAddData(tableReports);

								},
								error : function() {
								}
							}); 

							ilofederationPresenter.getAllScalableObjects({
								success: function(data){
									 console.log(data);
									 scalableobjects = data.hapi.output_data.scalable_groups.scalable_group;

									 for (var jdx = 0; jdx < tableReports.length; ++jdx) {
										for (var idx = 0; idx < scalableobjects.length; ++idx) {
											if (scalableobjects[idx].node_id == tableReports[jdx].node_name) {
												tableReports[jdx].node_name = scalableobjects[idx].sug_interface_ilo_ip;
												break;
											}
										}
									}

									$(REPORTS_TABLE).dataTable().fnClearTable();
									$(REPORTS_TABLE).dataTable().fnAddData(tableReports);
								},
								error: function(data){

								}
							})

									    
							$(REPORTS_TABLE).dataTable().fnClearTable();
							$(REPORTS_TABLE).dataTable().fnAddData(tableReports);
						},
						error : function(data) {
							notifications.show(localizer.getString("hpsum.node.failedReport", new Array(nodeItem.name)), 'error');
							$(CANCEL).trigger('click');
						}
					});
				};

					
				function onGenerate() {
					
					generateInProgress = true;
					
					$(GENERATE).attr("disabled", true);
					
					if (!$(RUNBACKCHECKBOX).is(':checked')) {
						showReportGenerationWait();
					}

					var request,
					    firmwaretype = "false",
					    update_appliedtype = "false",
					    faileddeptype = "false",
					    installedtype = "false",
					    inventorytype = "false",
					    combinedtype = "false",
					    reportformat = "false";

					if ($(REPORTFORMATHTML).is(':checked')) {
						reportformat = $(REPORTFORMATHTML).val();
					} else if ($(REPORTFORMATXML).is(':checked')) {
						reportformat = $(REPORTFORMATXML).val();
					} else if ($(REPORTFORMATCSV).is(':checked')) {
						reportformat = $(REPORTFORMATCSV).val();
					}

					if ($(FIRMWARECHECKBOX).is(':checked')) {
						firmwaretype = "true";
					}
					if ($(INSTALLABLECHECKBOX).is(':checked')) {
						update_appliedtype = "true";
					}
					if ($(FAILEDDEPCHECKBOX).is(':checked')) {
						faileddeptype = "true";
					}
					if ($(INSTALLEDCHECKBOX).is(':checked')) {
						installedtype = "true";
					}
					if ($(INVENTORYCHECKBOX).is(':checked')) {
                        inventorytype = "true";
                    }
					if ($(COMBINEDCHECKBOX).is(':checked')) {
                        combinedtype = "true";
                    }
					
					var nodeId,
						currentLocation = router.location();
						
					if (currentLocation.match(/one-touch-update/i) || currentLocation.match(/baseline/i)) {
						nodeId = "N1localhost";
						nodeItem = {name: "localhost"};
					}
					else {
						if (nodeItem && nodeItem.hasOwnProperty("node_id")) {
						nodeId = nodeItem.node_id;
						}
						else {
							nodeItem = {name: "localhost"};
							nodeId = "N1localhost";	
						}
					}
					
					//Since we are using a common UI screen for reports
					//set a flag to indicate if the report was requested
					//from the baseline screen to generate inventory reports
					var isBaselineReport = "false";
					if(currentLocation.match(/baseline/i))
					   isBaselineReport = "true";
						
					var request = {
						hapi : {
							report_format : reportformat,
							baseline_report: isBaselineReport,
							nodes : {
								node : {
									node_id : nodeId,	
									firmware_report : firmwaretype,
									update_applied_report : update_appliedtype,
									dependency_report : faileddeptype,
									installed_report : installedtype,
									inventory_report : inventorytype,
									combined_report : combinedtype
								}
							}
						}
					};
					
					var requestSetSessionAttribute = {
						hapi : {
							report_dir : instReportLocBrowse.getLocation() 
							}
					};
					
					if ( rept_path.toLowerCase() != instReportLocBrowse.getLocation().toLowerCase() ) {
					presenter.setSessionAttribute(requestSetSessionAttribute, {
						success : function(data) {
							createRepPresenter(request)	;
					
						},
						error : function(errorInfo) {
							closesReportGenerationWait();
							$(BROWSE_LOCATION_ERROR).show();
							$(BROWSE_LOCATION_ERROR).html(localizer.getString('hpsum.baseline.add.errorReportText'));
							instReportLocBrowse.addInputClass('hp-error');
							$(GENERATE).attr("disabled", true);
							}
						});
					}
					else
					{
						createRepPresenter(request)	;
					}
				}
				
				function createRepPresenter(request)
				{
					presenter.createReport(request, {
						success : function(data) {
							onSuccessReportCreation(data.hapi.report_id);
						},
						error : function(errorInfo) {
							notifications.show(errorInfo, 'error');
							closesReportGenerationWait();
							$(CANCEL).trigger('click');
						}
					});
				}

				function getReportStatus(reportId) {
					
					if (timer) {
						clearInterval(timer);
						timer = null;
					}

					//var status = "";
					timer = setInterval(function() {
						presenter.getReportStatus(reportId, {
							success : function(data) {
						//	if (status != data.hapi.status) {
							//	status = data.hapi.status;
								if (data.hapi.report_state.match(/in_progress|not_started/i)) {
								} else if (data.hapi.report_state.match(/report_generation_completed/i)) {
									notifications.show(localizer.getString("hpsum.node.doneReport", new Array(nodeItem.name)), 'ok');
									closesReportGenerationWait();
									//clearInterval(timer);
								
									if (timer) {
										clearInterval(timer);
										timer = null;
									}

									$(GENERATE).attr("disabled", false);
									populateReportsTable(false);
									generateInProgress = false;
									//status = "";
									//changeLocation('/node/reports/allAvailableReports');
								} else if (data.hapi.report_state.match(/partially_generated/i)) {
									//notifications.show(localizer.getString("hpsum.node.partialReport", new Array(nodeItem.name)), 'warning');
									//closesReportGenerationWait();
									//clearInterval(timer);
									//$(GENERATE).attr("disabled", false);
									//populateReportsTable();
									//status = "";
									//changeLocation('/node/reports/allAvailableReports');
									
								} else {
									notifications.show(localizer.getString("hpsum.node.failedReport", new Array(nodeItem.name)), 'error');
									closesReportGenerationWait();
									
									if (timer) {
										clearInterval(timer);
										timer = null;
									}

									$(CANCEL).trigger('click');
								}
							 //}
							},
							error : function(errorInfo) {
								notifications.show(errorInfo, 'error');
								closesReportGenerationWait();
								
								if (timer) {
									clearInterval(timer);
									timer = null;
								}

								$(CANCEL).trigger('click');
							}
						});

					}, 3000);
				}

				function onSuccessReportCreation(reportId) {
					//$(GENERATE).attr("disabled", false);
					populateReportsTable(false);
					presenter.generateReport(reportId, {
						success : function(data) {
							if (!$(RUNBACKCHECKBOX).is(':checked')) {
								populateReportsTable(false);
								getReportStatus(reportId);
							} else {
								notifications.show(localizer.getString("hpsum.node.runningReportInBack") + nodeItem.name +
												   '. ' + localizer.getString("hpsum.node.referForReportStatus"), 'ok');
							    populateReportsTable(false);
								//$(GENERATE).attr("disabled", false);
								getReportStatus(reportId);
							}
						},
						error : function(errorInfo) {
							notifications.show(errorInfo, 'error');
							closesReportGenerationWait();
							$(CANCEL).trigger('click');
						}
					});
				}

				function onDeleteReport() {
					var deleteConfirmButtons = {};

					deleteConfirmButtons[localizer.getString('hpsum.baseline.show.yesDelete')] = function () {
						presenter.deleteReport({report_id : deleteReportId},
							{
							success : function(data) {
								notifications.show(data.hapi.hmessage, 'ok');
								populateReportsTable(false);
							},
							error : function(message) {
								notifications.show(message, 'error');
							}
						});
						deleteInfoDialog.dialog('close');
					};

					deleteConfirmButtons[localizer.getString('hpsum.common.cancel')] = function () {
						deleteInfoDialog.dialog('close');
					};
					
					if (!deleteInfoDialog) {
						deleteInfoDialog = $('#hpsum-delete-report-dialog');
						deleteInfoDialog.dialog({
							autoOpen: false,
							show: {
								effect: "slide",
								duration: 10
							},
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							buttons : deleteConfirmButtons
						});
					}
					
					deleteInfoDialog.dialog('open');	
				}
				

			
			function showInfoDialog()
            {
            	if (!infoDialog) {
                    infoDialog =  $(INFO_DIALOG);
                    infoDialog.dialog({
                        modal : true,
                        dialogClass: 'hp-simple-dialog',
                        position : "center",
                        draggable : false,
                        resizable : false
                    });
                    $('button', infoDialog).on('click', function () {
                        infoDialog.dialog('close');
                    });
                }
                infoDialog.dialog('open');
            }
            
            function onNoSelection(){
            	showInfoDialog();	
            }
            
           
               function onReportLocationKeyup(){
					var path= instReportLocBrowse.getLocation(); //$(PATH).val();
					if( path=="" ){
							$(BROWSE_LOCATION_ERROR).show();
							$(BROWSE_LOCATION_ERROR).html(localizer.getString('hpsum.baseline.add.emptyReportText'));
							//$(PATH).addClass('hp-error');
							instReportLocBrowse.addInputClass('hp-error');
							$(GENERATE).attr("disabled", true);
						}
						else
						{
							$(BROWSE_LOCATION_ERROR).hide();
							//$(PATH).removeClass('hp-error');
							instReportLocBrowse.removeInputClass('hp-error');
							$(GENERATE).attr("disabled", false);
						}
		            		
		       	}
		       	
		       	function onReportLocationChange(){
					var path= instReportLocBrowse.getLocation(); //$(PATH).val();
						if( path=="" ){
							$(BROWSE_LOCATION_ERROR).show();
							$(BROWSE_LOCATION_ERROR).html(localizer.getString('hpsum.baseline.add.emptyReportText'));
							//$(PATH).addClass('hp-error');
							instReportLocBrowse.addInputClass('hp-error');
							$(GENERATE).attr("disabled", true);
						}
						else
						{
							$(BROWSE_LOCATION_ERROR).hide();
							//$(PATH).removeClass('hp-error');
							instReportLocBrowse.removeInputClass('hp-error');
							$(GENERATE).attr("disabled", false);
						}
				}

				this.init = function() {
				
				$('#hpsum-report-location-text').html(localizer.getString('hpsum.baseline.add.browseReportText'));
				$('#hpsum-report-location-text').removeClass('hp-collapsed');
				
               	var options = 	{
									command : 'init',
									panelLabel: "hpsum.baseline.add.enterDirectory",
									panelLabelStyle: "padding-left: 33px;",
						            panelHelp: "",
						            panelBrowseText: "hpsum.common.browse",
						            onNoSelection: onNoSelection
						        };
				$(REPORTS_LOC_BROWSE).hpsumBrowse(options);
				
				instReportLocBrowse = $(REPORTS_LOC_BROWSE).data('plugin_hpsumBrowse');
				
				instReportLocBrowse.setInputEvent("onkeyup", onReportLocationKeyup);
				instReportLocBrowse.setInputEvent("onchange", onReportLocationChange);
               
					var resource = router.location().split('/');
                	resource = resource[1];
              	$('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
				$('#hpsum-node-reports-firmware').attr('tooltip', localizer.getString('hpsum.node.firmwareDetailshelp')).hpTooltip();
				$('#hpsum-node-reports-combined').attr('tooltip', localizer.getString('hpsum.node.combinedReporthelp')).hpTooltip();
				$('#hpsum-node-reports-faileddep').attr('tooltip', localizer.getString('hpsum.node.failedDependencyDetailshelp')).hpTooltip();
				$('#hpsum-node-reports-installable').attr('tooltip', localizer.getString('hpsum.node.installableDetailshelp')).hpTooltip();
				$('#hpsum-node-reports-installed').attr('tooltip', localizer.getString('hpsum.node.installedDetailshelp')).hpTooltip();
				$('#hpsum-node-reports-inventory').attr('tooltip', localizer.getString('hpsum.node.inventoryhelp')).hpTooltip();
				$('#hpsum-node-reports-html').attr('tooltip', localizer.getString('hpsum.node.htmlhelp')).hpTooltip();
				$('#hpsum-node-reports-csv').attr('tooltip', localizer.getString('hpsum.node.csvhelp')).hpTooltip();
				$('#hpsum-node-reports-xml').attr('tooltip', localizer.getString('hpsum.node.xmlhelp')).hpTooltip();
				$('#chkbox-runbackReport').attr('tooltip', localizer.getString('hpsum.node.runbackReporthelp')).hpTooltip();
						
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
  					ROUTE_PREFIX = '/'+ resource +'/reports';

					$(RESET).live('click', function() {
						reset.call();
					});

					$(GENERATE).live('click', function(ev) {
						var path= instReportLocBrowse.getLocation(); 
						if (!generateInProgress && path != "") {
						 onGenerate.call();
						}
						else
						$(GENERATE).attr("disabled", true);
						ev.preventDefault();
					});
					
					$('#hpsum-delete-report').live('click', function(ev) {
						deleteReportId = $(this).data("custom-value");
						onDeleteReport.call();
						ev.preventDefault();
					});
					
					$(CANCEL).click(function () {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					if (inProgressTimer) {
						clearInterval(inProgressTimer);
						inProgressTimer = null;
					}
					
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
					router.watch('node report section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
					});
					
					this.resume();
				};

				this.resume = function() {
				    presenter.on("itemChange", onItemChange);
				    ilofederationPresenter.on("itemChange", onItemChange);
					var guimode = session.getProperty("gui_mode");
               				if(guimode === "offline_automatic" || guimode === "offline_interactive" || guimode === "express")
					{
						//Disable installed reports						
						$(REPORTFORMATXML).attr('checked', false).attr('disabled','disabled');
						$(REPORTFORMATCSV).attr('checked', false).attr('disabled','disabled');
					} 
					else
					{         
						//Enable installed reports
						 $(REPORTFORMATXML).removeAttr('disabled');
						 $(REPORTFORMATCSV).removeAttr('disabled');
					}					
					var dummyReportsData = [];
					$(REPORTS_TABLE).dataTable({
						oLanguage : {
						    sEmptyTable: localizer.getString("hpsum.node.noReports"),
						    sSearch: localizer.getString('hpsum.common.search')
						},
						bPaginate : false,
						bFilter : false,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						bDestroy : true,
						aaData : dummyReportsData,
						aoColumns : [{
							mDataProp : 'time_stamp'
						},{
							mDataProp : 'report_path'
						},{
							sWidth: 75, mDataProp : 'firmware_type'
						},{
							sWidth: 75, mDataProp : 'update_applied_type'
						},{
							sWidth: 75, mDataProp : 'installed_type'
						},{
							sWidth: 75, mDataProp : 'dependency_type'
						},{
                            sWidth: 75, mDataProp : 'inventory_type'
                        },{
                            sWidth: 75, mDataProp : 'combined_report'
                        },{
							mDataProp : 'report_format'
						},{
							mDataProp : 'node_name'
						},{
							mDataProp : 'report_status'
						},{
							mDataProp : 'delete_report'
						}],
						aaSorting: [[ 0, "desc" ]]
					});
					
					generateInProgress = false;
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					if (inProgressTimer) {
						clearInterval(inProgressTimer);
						inProgressTimer = null;
					}
					
					$(RESET).trigger('click');
					$(GENERATE).attr("disabled", false);
					$(BROWSE_LOCATION_ERROR).hide();
					instReportLocBrowse.removeInputClass('hp-error');
					populateReportsTable(true);
					
					if(router.location().match(/baseline/i)) {
                        //Disable all report except inventory
						$('#hpsum-node-reports-firmware-label').hide();
						$('#hpsum-node-reports-installable-label').hide();
						$('#hpsum-node-reports-faileddep-label').hide();
						$('#hpsum-node-reports-installed-label').hide();
						$('#hpsum-node-reports-combined-label').hide();
                        $(FIRMWARECHECKBOX).attr('checked', false).hide();
                        $(INSTALLABLECHECKBOX).attr('checked', false).hide();
                        $(FAILEDDEPCHECKBOX).attr('checked', false).hide();
                        $(INSTALLEDCHECKBOX).attr('checked', false).hide();
                        $(COMBINEDCHECKBOX).attr('checked', false).hide();
                    }
				};

				this.pause = function() {
					
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					presenter.off("itemChange", onItemChange);
					ilofederationPresenter.off("itemChange", onItemChange);
				};

			}

			return ReportsShowView;
		}());

	return new ReportsShowView();

});



