/* (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
*/
define(['hp/view/DetailsShowView',
    'hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/view/DialogView',
    'hp/core/UrlFragment',
    'hp/core/LinkTargetBuilder',
    'hp/view/NotificationsView',
    'hp/core/Localizer',
    'text!hpsumpages/node/abort_confirm.html',
    'text!hpsumpages/node/delete_confirm.html',
    'text!hpsumpages/node/failed_components.html',
    'text!hpsumpages/one-touch-update/reboot_confirm.html',
    'hpsum/presenter/baseline/BaselinePresenter',
	'hp/core/Notifications',
	'hp/model/Session',
    'jquery',
    'hpsum/view/node/jquery.hpsumWarnings',
    'hp/lib/date',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpCollapsible'],
function(DetailsShowView, presenter,router, DialogView, urlFragment,
    linkTargetBuilder, NotificationsView, localizer,abortConfirmHtml, deleteConfirmHtml,failedComponentsHtml,rebootConfirmHtml,BaselinePresenter,notifications, session) { "use strict";

    var NodeShowView = (function() {
        
        var VIEW = '#hpsum-nodes-show';
        var HEADER = '#hpsum-nodes-show .hp-details-header';
        var TITLE = '#hpsum-nodes-details-title';
        var STATUS = '#hpsum-nodes-details-status';
        var ACTIONS = '.hp-details-actions';
        var DELETE_ACTION = '#hpsum-node-action-delete',
        	ABORT_ACTION ='#hpsum-node-action-abort',
        	INVENTORY_ACTION = '#hpsum-node-action-inventory',
			INVENTORY_DETAIL_LINK = '#hpsum-node-detail-inventory',
        	DEPLOY_ACTION = '#hpsum-node-action-deploy',
            STAGE_ACTION = '#hpsum-node-action-stage',
            ONLINE_DEPLOY ='#hpsum-node-action-onlinedeploy',
            OFFLINE_DEPLOY ='#hpsum-node-action-offlinedeploy',
        	REPORTS_ACTION = '#hpsum-node-action-reports',
        	SCHEDULE_ACTION ='#hpsum-node-action-schedule',			
			DELETE_SCHEDULE = '#hpsum-delete-schedule-info',
			EDIT_ACTION = '#hpsum-node-action-edit',
			REBOOT_ACTION = '#hpsum-node-action-reboot';
        var DELETE_TITLE = '#hpsum-nodes-delete-title';
		
        var NOTIFY_STATUSES = {error:'error', warning:'warning', unknown:'info'};
        
        var ABORT_TITLE = '#hpsum-nodes-abort-title',
       	   ABORT_ERROR = '#hpsum-abort-err';

        var F_VMWARE_DISC_GENERAL = 5052, /*! Discovery general failure */ 
            F_VMWARE_DISC_SYS_HW_ERROR = 5186, /*!  Discovery data creation error during System Hardware data collection*/
            F_VMWARE_DISC_PCI_ERROR = 5187, /*!  Discovery data creation error during PCI data collection*/
            F_VMWARE_DISC_NIC_ERROR = 5188, /*!  Discovery data creation error during NIC data collection*/
            F_VMWARE_DISC_FCHBA_ERROR = 5189, /*!  Discovery data creation error during FCHBA data collection*/
            F_VMWARE_DISC_OS_ERROR = 5190, /*!  Discovery data creation error during OS data collection*/
            F_VMWARE_DISC_SMARTARRAY_ERROR = 5191, /*!  Discovery data creation error during SA data collection*/
            F_VMWARE_DISC_ILO_ERROR = 5192, /*!  Discovery data creation error during iLO data collection*/
            F_VMWARE_SEFL_DISC_DNL_ERROR = 5003, /*!  Self-discovery download failure*/
			F_VC_DOMAIN_NOT_CONFIGURED = 5108;	/*! VC domain is not configured properly.*/
		
	var RETURN_CODE_GENERAL_FAILURE = -1,
            RETURN_CODE_COULD_NOT_RUN = -2,
	    RETURN_CODE_ERROR_RETURN = -3;
			
        var FAILED_COMPONENTS_TABLE = '#hpsum-failed-comps-table';

        /**
         * Constructor
         */
        function NodeShowView() {
          
            var notificationsView = new NotificationsView();
            var deleteInProgress = false;
            var abortInProgress = false;
	        var rebootInProgress = false;
            var thisNode = null,
            	timerMap={};
            var notificationsCleared = false;
            var nodeItem = null;
			
            function clearNotifications() {
                if (! notificationsCleared) {
                    notificationsCleared = true;
                    notificationsView.clear();
                }
            }
                      
            function convertTypeStringForTitle(val) {
                if (val.match(/hpux/i)) {
                    return "HP-UX";	
                }
                return val;
            }
            
			function onInventoryError(errorMessage) {                
                
            }

            function onInventorySuccess(item) {
                
            }
			
	    function onInventory(){	   
            $(document.body).off("click", INVENTORY_DETAIL_LINK , onInventory);				            									
	    	var resource = router.location().split('/');
                resource = resource[1];                   
		if(thisNode.baselines.length > 0)
			{	
				presenter.startInventory(thisNode, {
                        	success : onInventorySuccess,
                        	error : onInventoryError
                	});				    						
			router.go("/" + resource + '/show');				   
		}	
                else{                                      
			router.go("/" + resource + '/inventory');				   
                }			   
	    }
			
            function onItemChange(item) {
                clearNotifications();
                item = item.hapi;
                nodeItem = item;

                var resource = router.location().split('/');
                	resource = resource[1];
                var base ='#/'+resource ;
                if (item) {
                	notificationsView.clear();
                	thisNode = item;
                    $(HEADER).removeClass('hp-show-changing');
                    $('.deploy-domain').remove();
		            var deploy_url = base + '/deploy';
                    $(DEPLOY_ACTION).attr('href',deploy_url).text(localizer.getString('hpsum.node.reviewDeploy'));
                    if(!item.node_phase.match(/Initialize/i))
                    	$(ACTIONS).removeClass('hp-disabled');
                    $(TITLE).removeClass('hp-unavailable');
                    $(TITLE).text(convertTypeStringForTitle(item.type).toUpperCase() +': ' +item.name);
                    $(STATUS).hpStatus('unknown', true).
                        removeClass('hp-unavailable');

                    if(item.node_phase.match(/InActive/i)) {
                		presenter.restore(thisNode.node_id);	
                	}
					$('#hpsum-warning-messages').hpsumWarnings(item, false);

                    if (item.node_state.match(/installdone/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type).toUpperCase() +': ' +item.name);
                    	
                    	var status,summary,details;
                    	if((item.return_code == RETURN_CODE_GENERAL_FAILURE) || (item.return_code == RETURN_CODE_COULD_NOT_RUN) || (item.return_code == RETURN_CODE_ERROR_RETURN)) {
                    	    $(STATUS).hpStatus('error').removeClass('hp-unavailable');
                            status = 'error';
                            summary = localizer.getString('hpsum.node.installDoneWithErrors'); 
                            details = localizer.getString('hpsum.node.installDoneSeeErrors'); 
                    	} else {
                        	$(STATUS).hpStatus('ok').removeClass('hp-unavailable');
    						status = 'ok';
                        	summary = localizer.getString('hpsum.node.installDone');
                        	details =    localizer.getString('hpsum.node.installDoneSee');
                            if(item.type == "HPUX"){
                                details = item.node_status.replace(/\n/g, "<br/>");
                            }
                        }
						if(item.return_code == 1 && item.reboot_initiated == false)
						{
							details +=    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-reboot">' + localizer.getString('hpsum.node.rebootRequired') + '</a>';
						}
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
						
						$('#hpsum-node-reboot').die('click').live('click', onReboot);
                      	
                	}
                	
                	if (item.node_state.match(/installhold/i)) {
         				//$(HEADER).addClass('hp-show-changing');
					 $(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').addClass('hp-primary');
					 $(REPORTS_ACTION).removeClass('hp-disabled');
					 $(INVENTORY_ACTION).addClass('hp-disabled');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type).toUpperCase() +': ' +item.name);
						$(SCHEDULE_ACTION).addClass('hp-disabled');
						$(DEPLOY_ACTION).addClass('hp-disabled');
						$(EDIT_ACTION).addClass('hp-disabled');
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						summary = localizer.getString('hpsum.node.waitingforAssoc'); // Add in translation
						details =   item.node_status;
						$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                       // showInstallProgress(item);
                      	
                	}
					
					if (item.node_state.match(/pendingfwupdate/i)) {
					    $(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').addClass('hp-primary');
					    $(REPORTS_ACTION).removeClass('hp-disabled');
					    $(INVENTORY_ACTION).addClass('hp-disabled');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
						$(SCHEDULE_ACTION).addClass('hp-disabled');
						$(DEPLOY_ACTION).addClass('hp-disabled');
						$(EDIT_ACTION).addClass('hp-disabled');
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						summary = localizer.getString('hpsum.node.pendingfwUpdate'); // Add in translation
						details =   item.node_status;
						$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                	}

					if (item.node_state.match(/activatependingfwupdate/i)) {
					 $(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').addClass('hp-primary');
					 $(REPORTS_ACTION).removeClass('hp-disabled');
					 $(INVENTORY_ACTION).addClass('hp-disabled');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
						$(SCHEDULE_ACTION).addClass('hp-disabled');
						$(DEPLOY_ACTION).addClass('hp-disabled');
						$(EDIT_ACTION).addClass('hp-disabled');
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						summary = localizer.getString('hpsum.node.activatingPendingfwUpdate'); // Add in translation
						details =   item.node_status;
						$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                	}


					if (item.node_state.match(/scheduled/i)) {
         				//$(HEADER).addClass('hp-show-changing');
						$(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').addClass('hp-primary');
						$(REPORTS_ACTION).removeClass('hp-disabled');
						$(INVENTORY_ACTION).addClass('hp-disabled');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(item.type.toUpperCase() +': ' +item.name);
						$(SCHEDULE_ACTION).addClass('hp-disabled');
						$(DEPLOY_ACTION).addClass('hp-disabled');
						$(EDIT_ACTION).addClass('hp-disabled');
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');
						
						var sched_flag = item.scheduled;
						var schedule_date_time_new = '';
						if(item.schedule_date_time)
						{
							var schedule_date_time_old = item.schedule_date_time.split(' ');
							var schedule_time_format = schedule_date_time_old[2];
							var schedule_time = schedule_date_time_old[1];
							var schedule_time_hrs_mins = schedule_time.split(':');
							var schedule_time_hrs = schedule_time_hrs_mins[0];
														
							status = 'unknown';
							if(schedule_time_format == 'PM')
							{
								if (schedule_time_hrs < 12)
								{
									schedule_time_hrs = parseInt(schedule_time_hrs) + 12;
									schedule_date_time_new = schedule_date_time_old[0] + ' ' + schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
								}
								if (schedule_time_hrs == 12)
								{
									schedule_time_hrs = parseInt(schedule_time_hrs) + 0;
									schedule_date_time_new = schedule_date_time_old[0] + ' ' + schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
								}
							}
							if(schedule_time_format == 'AM')
							{
								if (schedule_time_hrs < 12)
								{
									schedule_time_hrs = parseInt(schedule_time_hrs) + 0;
									if(schedule_time_hrs < 10)
										schedule_date_time_new = schedule_date_time_old[0] + ' ' + '0' +schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
									else
										schedule_date_time_new = schedule_date_time_old[0] + ' ' +schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
								}
								if (schedule_time_hrs == 12)
								{
									schedule_time_hrs = parseInt(schedule_time_hrs) - 12;
									schedule_date_time_new = schedule_date_time_old[0] + ' ' + '0'+ schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
								}
							}
						}
						details = '<span style="padding:10px;"><a id = "hpsum-node-scheduledelete">' + localizer.getString('hpsum.node.cancelSchedule') + '</a></span>' + 
								  '<span style="padding:10px;"><a id = "hpsum-node-schedule-run">' + localizer.getString('hpsum.node.runNow') + '</a></span>';
						summary = localizer.getString('hpsum.node.nodeScheduled') + schedule_date_time_new; // Add in translation
						$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');

						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
						$('#hpsum-node-schedule-run').live('click', onRunNow);
						$('#hpsum-node-scheduledelete').live('click', onDeleteSchedule);
                       // showInstallProgress(item);
                      	
                	}
					
                	if (item.node_state.match(/install$/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type).toUpperCase() +': ' +item.name);
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');
                    	var status,summary,details;
						status = 'unknown';
						if(item.type.match(/moonshot/i )) {
						    summary = localizer.getString('hpsum.node.installProgressMoonshot');
						} else
                    	   summary = localizer.getString('hpsum.node.installProgress'); // Add in translation
                    	details = item.node_status;
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            changing:true,
                            details: details
                        });
                      	showNodeProgress(item);
                	}
         			
         			if (item.node_state.match(/inventory$|analysis$/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type).toUpperCase() +': ' +item.name);
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');
                    	        			
        				var notif = {
        				  	status: 'info',
                            summary: localizer.getString('hpsum.node.inventoryInProgress'), // Add in translation
                           	changing: true
                            
        				};
        				notificationsView.add(notif);
                    	showNodeProgress(item);
                	}
                    if (item.node_state.match(/error/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	$(STATUS).hpStatus('error', false).
                        	removeClass('hp-unavailable');
                    	var status,summary,details;
                    	
                    	status = 'error';
                    	summary = item.node_status;
				        if(!(item.type.match(/VMWARE/i)))
                        {
							if(item.node_status.match(/Inventory Error/i))
                        	{
                        		var details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
                        			'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
                        	} 
							else if (item.type.match(/SWITCH/i) && item.node_status.match(/Inventory Failed/i)) {
								var details = '<p>' + localizer.getString('hpsum.switchUI.FTPUpdatesFailure')  + '</p>' + 
                        			'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
							}
							else if (item.type.match(/virtual_connect/i) && item.node_status.match(/Inventory Failed/i)){
								if(item.internal_error_code == F_VC_DOMAIN_NOT_CONFIGURED)
									var details = '<p>' + localizer.getString('hpsum.node.vcDomainNotConfigured')  + '.</p>';
							}
							else if (item.node_status.match(/configuration warnings/i)) {
                                details = localizer.getString('hpsum.common.rerunInventory', new Array('<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>'));
								$(document.body).on("click", INVENTORY_DETAIL_LINK , onInventory);
                            } else {
    	                    	if(item.node_status.match(/Need Associated Node Details/i)){
    	                    		if(item.type.match(/virtual_connect|sas_switch/i )) {
    	                    			details = '<p>' + item.name + ' ' + localizer.getString('hpsum.node.needAssociatedOADetails') + '.</p>' + 
    	                    				'<a href="'+ base+'/associated">' + localizer.getString('hpsum.node.enterAssociatedOADetails') + '</a>';
    	                    		}
    	                    		else if(item.type.match(/ipdu/i))
    	                    			details = '<p>' + item.name + ' ' + localizer.getString('hpsum.node.needAssociatediPDUDetails') + '</p>' + 
    	                    			'<a href="'+ base+'/associated">' + localizer.getString('hpsum.node.enterPartnerIpduDetails') + '</a>';
    	                    	} else if (item.node_status.match(/standby oa/i)) {
    	                    	    details = '';
    	                    	}
								else if ((item.type.match(/ILO/i) && item.node_status.match(/deploy error/i)))
								{
									var oa_ip_ind = item.node_status.indexOf("[");
									if (oa_ip_ind != -1)
									{
										var oa_ip_end_ind = item.node_status.indexOf("]", oa_ip_ind);
										if (oa_ip_end_ind != -1)
										{
											var oa_node_ip = item.node_status.substring(oa_ip_ind + 1, oa_ip_end_ind);
											if (item.assoc_node_id != undefined && item.assoc_node_id != '')
											{
												var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ item.assoc_node_id+'/getData';
												details='<a href= "' + assoc_node_url + '">' +oa_node_ip+'</a>';
											}
											else
												details=oa_node_ip;
												
											var summaryStr =  item.node_status.substring(0, oa_ip_ind);
											summaryStr += item.node_status.substring(oa_ip_end_ind + 1);
											summary = summaryStr;
										}
									}
								}
								else
    							{
    								details = '<p>' + item.name + ': ' + item.node_status + '.</p>';
                                    /* If details message contains a URL then convert the URL a hyperlink */
                                    var urlStartIndex;
                                    urlStartIndex = details.indexOf("http://");
                                    if (urlStartIndex == -1)
                                    {
                                        urlStartIndex = details.indexOf("https://");
                                    }
                                    if (urlStartIndex != -1)
                                    {
                                        var urlEndIndex = details.indexOf(" ", urlStartIndex);
                                        if (urlEndIndex != -1)
                                        {
                                            var url = details.substring(urlStartIndex, urlEndIndex);
                                            var hyperlink = "'<a href=\"" + url + "\">" + url + "</a>'";
                                            details = details.substring(0, urlStartIndex) + hyperlink + details.substring(urlEndIndex);
                                        }
                                    }
    							}
                        	}
                        }
                        else
                        {
                            if(item.internal_error_code == F_VMWARE_DISC_FCHBA_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_FCHBA_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_NIC_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_NIC_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_ILO_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_ILO_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_OS_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_OS_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_SYS_HW_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SYSHW_DISC_ERR__MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_SMARTARRAY_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SA_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            } 
                            else if(item.internal_error_code == F_VMWARE_DISC_PCI_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_PCI_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            } 
                            else if(item.internal_error_code == F_VMWARE_SEFL_DISC_DNL_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SELF_DISC_DNL_ERROR_MSG')  + " " + '<a id="hpsum-failed-components-link">' + localizer.getString('hpsum.common.failedComponents') + '</a>' +'</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_GENERAL)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_GENERAL_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.node_status.match(/Inventory Error/i))
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
                                    '<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
                            }
                            
                        }
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });

                         $('#hpsum-failed-components-link').live('click', onFailedComponents);
                         
                    }
                    
                    if(item.node_state.match(/pending_fw_update/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	var status, summary,details;
                    	
                    	status = 'warning';
                    	summary = localizer.getString('hpsum.integrityilo.haspendingupdate');
                    	details = '<p>' + localizer.getString('hpsum.integrityilo.hasprevious', [item.name]) + '</p>' + 
                    			'<a href="'+ base+'/integrityilo/activatepending">' + localizer.getString('hpsum.integrityilo.activateorcancel') + '</a>';
                    	$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
                    	var url = base+'/integrityilo/activatepending';
                    	$(DEPLOY_ACTION).attr('href',url).text(localizer.getString('hpsum.integrityilo.activatepending'));
                    	
                        notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });               	
                    }
                	

					if (item.node_state.match(/activate_pending/i)) {
						$(HEADER).addClass('hp-show-changing');
						$(ACTIONS).removeClass('hp-disabled');
						$(TITLE).removeClass('hp-unavailable');
						$(TITLE).text(convertTypeStringForTitle(item.type).toUpperCase() + ': ' + item.name);
						$(STATUS).hpStatus('ok', true).removeClass('hp-unavailable');
						var deploy_url = base+'/deploy';
						$(DEPLOY_ACTION).attr('href',deploy_url).text(localizer.getString('hpsum.node.reviewDeploy'));

						var notif = {
							status : 'info',
							summary : item.node_status,
							changing : true

						};
						notificationsView.add(notif);
						showNodeProgress(item);
					}
					
					if (item.node_state.match(/idle/i) && item.node_phase.match(/Warning/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	$(STATUS).hpStatus('warning', false).
                        	removeClass('hp-unavailable');
                    	var status,summary,details;
                    	
                    	status = 'warning';
                    	summary = item.node_status;                       
						if(item.hasOwnProperty('port_blocked') && item.port_blocked) {
	                    		//If the remote or local node is server (windows or linux), and inventory failed with error due to 
	                    		//firewall blocked, provide an option to user either to open the ports manually or let HPSUM do this for user.
	                    		
	                    		//provide option to user
	                    		details = '<p>' + localizer.getString('hpsum.node.openFirewallMsg') + '</p>' +
	                    					'<a id="hpsum-node-show-openfirewall">' + localizer.getString('hpsum.node.openFirewall') + '</a>';
    	                    				
    	                }					    
						
						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
					}
					
					if (item.node_state.match(/idle/i) && item.node_phase.match(/unknown|error/i)) {
						$(HEADER).removeClass('hp-show-changing');
                    	$(STATUS).hpStatus('error', false).
                        	removeClass('hp-unavailable');
                        	
                    	var status,summary,details;
                    	status = 'error';
                    	summary = item.node_status;
                    	
                    	if(item.node_status.match(/The specified iLo federation group was not found in the network/i)) {
                    		details = '<p>' + localizer.getString('hpsum.common.unknownNodeFederationGrpError')  + '</p>'; 
						}
						//Added for QXCR1001367572 : Change error msg for OneView managed VC when info is not returned for VC.
						else if(item.node_status.match("A device at URL:") && item.node_status.match("managing this Virtual Connect Module and it cannot be updated directly using HP SUM"))
						{
							details = '<p>' + item.name + ': ' + item.node_status + '.</p>';
						}
						else if (  item.type.match(/vmware/i) )
						{
							summary = localizer.getString('hpsum.common.vmwareLoginError');
							details = '<p>' + localizer.getString('hpsum.common.vmwareLockDownMode') + '</p>' + 
									'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
							
						}
						else {
							details = '<p>' + localizer.getString('hpsum.common.unknownNodeError')  + '</p>' + 
									'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
						}
						if(item.node_phase.match(/error/i)) {
                            details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
									'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
                        }
						if (summary.indexOf("management software. URL:") != -1)
						{
							var httpsIndex = summary.indexOf("https://");
							if(httpsIndex!=-1)
							{
								var httpURL = summary.substring(httpsIndex);
								var urlIndex = summary.indexOf("URL:");
								if( urlIndex != -1)
								{
									var baseMessage = summary.substring(0, urlIndex);
									details = '<p>Management Software is accessible at: ' + '<a target=_blank href="'+httpURL+'">' + httpURL + '</a>'+ '</p>' + '<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
									summary = baseMessage;
								}
							}
						}
						
						notificationsView.add({
							status: NOTIFY_STATUSES[status],
							summary: summary, 
							details: details
						});
						
					}

					showActionMenu(item.node_state, item.node_phase, item.type, item );
                    
                    if (item.node_phase.match(/useractionneeded/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	var status, summary,details;
                    	
                    	if(item.node_state.match(/idle/i)){
                    		status = 'warning';
                    		summary = localizer.getString('hpsum.common.doActionInventory');
                    	 	details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
                    	 	$(document.body).on("click", INVENTORY_DETAIL_LINK , onInventory);
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');										            
                    	}
                    	if(item.node_state.match(/uan/i)){
                    		summary = details = '';
							if(item.node_status.match(/No Applicable/i)){
                                status = 'ok';
                                if(item.node_status.match(/firewall/i)){
                                    summary = localizer.getString('hpsum.node.noApplicableComponentsFound');
                                    details = localizer.getString('hpsum.node.noApplicableComponentsFound') + '. ' + localizer.getString('hpsum.node.firewallBlocking');
                                } else {
                                    summary = localizer.getString('hpsum.node.nodeUpToDate') + '. ' + localizer.getString('hpsum.node.noApplicableComponentsFound');
                                    details = localizer.getString('hpsum.node.noApplicableComponentsFound');
                                }
                                 $(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                    		}
                    		else if (item.node_status.match(/inventory/i) && !item.type.match(/moonshot/i)) {
                    		     status = 'warning';
                                summary = localizer.getString('hpsum.common.doActionInventory');
                                details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
								$(document.body).on("click", INVENTORY_DETAIL_LINK , onInventory);
                                $(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
                                $(DEPLOY_ACTION).addClass('hp-disabled').css("color", "grey").bind('click.disable-link', function(e) {
                                    e.preventDefault();
                                    return false;
                                });
                    		}
                    		else if(item.hasOwnProperty('port_blocked') && item.port_blocked) {
	                    		//If the remote or local node is server (windows or linux), and inventory failed with error due to 
	                    		//firewall blocked, provide an option to user either to open the ports manually or let HPSUM do this for user.
	                    		
	                    		status = 'warning';
	                    		summary = localizer.getString('hpsum.node.openFirewallMsg');
	                    		//provide option to user
	                    		details = '<a id="hpsum-node-show-openfirewall">' + localizer.getString('hpsum.node.openFirewallDeploy') + '</a>';
											
								$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
    	                    }
                    		else {
                    				status = 'warning';
                    				summary =  localizer.getString('hpsum.node.readyForDeploy'); // Add in translation
									var sched_flag = item.scheduled;
									var iso_time = item.schedule_date_time;
									var sched_local = iso_time.toString();
									
                            		if(item.type.match(/sd2/i)) {
                                		//SD2 has its own deploy options screen
                                		if(item.analysis_errors) {
                                			status = 'error';
                                			summary = localizer.getString('hpsum.node.sd2HasErrors'); // Add in translation
                                		} else if (item.analysis_warnings){
                                			status = 'warning';
                    						summary = localizer.getString('hpsum.node.sd2HasWarnings'); // Add in translation
                                		}
                                		details =    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/sd2/deploy">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>';
                                		var url = base + '/sd2/deploy';
                               	 		$(DEPLOY_ACTION).attr('href',url);
                            		} else if(item.type.match(/moonshot/i)) {
                              		      if(item.invalid_switch_credentials == true) {
                              		        summary = localizer.getString('hpsum.moonshot.invalidSwitchCredentials');
                              		        details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/edit">' + localizer.getString('hpsum.moonshot.edit') + '</a>';
                                        } else if (item.switch_vsp_connect_error == true) {
                                            summary = localizer.getString('hpsum.moonshot.failedtoValidateSwitchCredentials');
                                            details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
											$(document.body).on("click", INVENTORY_DETAIL_LINK , onInventory);
                                        } else if (item.node_status.match(/Ready to start inventory/i)) {
			                    		    status = 'warning';
			                                summary = localizer.getString('hpsum.common.doActionInventory');
			                                details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
											$(document.body).on("click", INVENTORY_DETAIL_LINK , onInventory);
			                                $(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
			                                $(DEPLOY_ACTION).addClass('hp-disabled').css("color", "grey").bind('click.disable-link', function(e) {
			                                    e.preventDefault();
			                                    return false;
			                                });
			                    		} else {
                                            summary =  localizer.getString('hpsum.node.readyForDeploy');
                              		            details = '<p>' + item.name + ': ' + localizer.getString('hpsum.node.readyForDeploy') + '.</p>' + '<a href="'+ base+'/deploy">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>';
                              		      }
                                        
                                        //Prevent deploy in case of any error
                                        if(item.invalid_switch_credentials == true || item.switch_vsp_connect_error == true) {
                                            $(DEPLOY_ACTION).addClass('hp-disabled').css("color", "grey").bind('click.disable-link', function(e) {
                                                e.preventDefault();
                                                return false;
                                            });
                              		  }
        
                                    }
                            		else {
                              		  details =    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/deploy">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>';
                              		  if( ( nodeItem.type.match(/windows/i) || nodeItem.type.match(/linux/i) ) && 
                                                item.node_phase.match(/UserActionNeeded/i) &&
                                                ( item.node_state.match(/remote_staging_uan/i) ) )
                                      {
                                            details =    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/stage">' + localizer.getString('hpsum.server.stageDeploy') + '</a>';
                                      }

                              		  if(item.hasOwnProperty('is_ilo_domain')) {
                              		  	details += '<p><a href="'+ base+'/integrityilo/deploydomain">' + localizer.getString('hpsum.integrityilo.doDeployDomain') + '</a></p>';
                              		  	if(!$('.deploy-domain').length) {
                              		  		$(DEPLOY_ACTION).closest("ol").after('<ol class=\"deploy-domain\"><li><a href="'+ base+'/integrityilo/deploydomain\">'+ localizer.getString('hpsum.integrityilo.deployDomain') +'</a></li></ol>');	
                              		  	}
                              		  }
                            		}                           		
                    	 		$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
                    	 	}
                    	}
                        notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                       
                       }
					   
				} else {
                    $(TITLE).text('');
                    $(STATUS).hpStatus('unknown');
                    $(STATUS + ' span').text('');
                }
            }
            
            function onOpenFirewall(ev) {
            	
            	if($('#hpsum-node-show-openfirewall').hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }
				
				var options =  {
                        hapi: {
                        open_firewall : "true"
                        }
                    };

				presenter.setattribute(thisNode, options, {															
					success : onOpenFirewallSuccess,
					error : onOpenFirewallError									
					});
					
				ev.preventDefault();
            }
            
            function onOpenFirewallSuccess()
			{
				var	message = localizer.getString('hpsum.node.openFirewallSuccessNotifMsg') + nodeItem.name;
				notifications.show(message, 'ok');
				
				var status = 'ok';
                var summary = localizer.getString('hpsum.node.openFirewallSuccessNotifMsg') + nodeItem.name;
                 
				
				if(nodeItem.hasOwnProperty('firewall_node_state') && nodeItem.firewall_node_state.match(/inventory/i)) {
					presenter.startInventory(thisNode, {															
						success : onStartInventorySuccess,
						error : onStartInventoryError									
						}); 
				}
				else if(nodeItem.hasOwnProperty('firewall_node_state') && nodeItem.firewall_node_state.match(/install/i)) {
					presenter.deploy(thisNode, {															
						success : onStartDeploySuccess,
						error : onStartDeployError									
						}); 
				}
				
				$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                
                notificationsView.add({
                status: NOTIFY_STATUSES[status],
                summary: summary,
                details: ''});
			}
			
			function onOpenFirewallError()
			{
				var	message = localizer.getString('hpsum.node.openFirewallErrorNotifMsg') + nodeItem.name;
				notifications.show(message, 'error');
			}
			
			function onStartInventorySuccess()
			{
				var	message = localizer.getString('hpsum.node.openFirewallInventoryStartNotifMsg') + nodeItem.name;
				notifications.show(message, 'ok');
				
				var status = 'ok';
                var summary = localizer.getString('hpsum.node.openFirewallInventoryStartNotifMsg') + nodeItem.name;
                
                $(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                
                notificationsView.add({
                status: NOTIFY_STATUSES[status],
                summary: summary,
                details: ''});
			}
			
			function onStartInventoryError()
			{
				var	message = localizer.getString('hpsum.node.openFirewallInventoryErrorNotifMsg') + nodeItem.name;
				notifications.show(message, 'error');
			}
			
			function onStartDeploySuccess()
			{
				var	message = localizer.getString('hpsum.node.openFirewallDeployStartNotifMsg') + nodeItem.name;
				notifications.show(message, 'ok');
				
				var status = 'ok';
                var summary = localizer.getString('hpsum.node.openFirewallDeployStartNotifMsg') + nodeItem.name;
                
                $(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                
                notificationsView.add({
                status: NOTIFY_STATUSES[status],
                summary: summary,
                details: ''});
			}
			
			function onStartDeployError()
			{
				var	message = localizer.getString('hpsum.node.openFirewallDeployErrorNotifMsg') + nodeItem.name;
				notifications.show(message, 'error');
			}
            
			function onRunNow(ev) {
				var schedule_information;
				var scheduled;
				var node_id = nodeItem.node_id;
				var	action = 'deploynow';
						 
					presenter.ScheduleNodes(node_id,action,scheduled,schedule_information, {
						success : function(data) {
							onRunNowSuccess(data); 
						},
						error : function(errorInfo) {
							onRunNowError(errorInfo);
						}
					});	
			}
			
			function onRunNowSuccess()
			{
				showNodeProgress(nodeItem);
			}
			function onRunNowError()
			{
			
			}
			function onDeleteSchedule(ev) {
				var contents = $(deleteConfirmHtml);
				$('#hpsum-delete-node',contents).html(localizer.getString('hpsum.node.deleteschedule')); // Add in translation
				$('#hpsum-node-delete-cancel',contents).show();
				
				localizer.localizeDom(contents);
				var dialogView = new DialogView();
                dialogView.init({contents: contents,
					ok: function () {
						btnScheduleDelete();
					},
					cancel: function () {
						router.go('/node/show');
					}
				});
			}
			
			function btnScheduleDelete()
			{
				var scheduled;
				var schedule_information;
				var node_id = nodeItem.node_id;
				var action = 'delete';
					 
				presenter.ScheduleNodes(node_id,action,scheduled,schedule_information, {
					success : function(data) {
						onDeleteScheduleSuccess(data); 
					},
					error : function(errorInfo) {
						onDeleteScheduleError(errorInfo);
					}
				});	
			}
			
			function onDeleteScheduleSuccess()
			{
				var	message = "Schedule for " + nodeItem.name + " deleted successfully";
				notifications.show(message, 'ok');  

				showNodeProgress(nodeItem);
			}
			function onDeleteScheduleError()
			{
			
			}
            
	    
            function onConfirmWarning() {
					var summary = localizer.getString('hpsum.common.applyUserSelection');

					notificationsView.add({
							status: 'warning',
                            summary: summary,
							changing: true
                    });
                var options =  {
                    hapi: {
                        ignore_warnings : "true"
                    }
                };
                presenter.setattribute(nodeItem, options, {
                    success: function() {
                      notificationsView.add({details: localizer.getString('hpsum.common.confirmSelected')}, true);
                    },
                    error: function() {}
                });
            }
			        	
            function onCancelWarning() {
                var options =  {
                    hapi: {
                        ignore_warnings : "false"
                    }
                };
                presenter.setattribute(nodeItem, options, {
                    success: function() {
                      notificationsView.add({details: localizer.getString('hpsum.common.cancelSelected')}, true);
                    },
                    error: function() {}
                });
            }
			
            function onItemUpdateSuccess()
            {
				presenter.refreshIndexResults();
            }

            function onItemUpdateError()
            {
                
            }

            function showActionMenu(state, phase, type,item) {
                    $(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');               
                    $(ONLINE_DEPLOY).parent().parent().hide();
                    $(OFFLINE_DEPLOY).parent().parent().hide();
                    $(DEPLOY_ACTION).parent().parent().show();
                   

                    $(EDIT_ACTION).removeClass('hp-disabled').attr('style', '');
		    if (state.match(/Idle/i)) {
                    $(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        if (phase.match(/UnKnown/i)) {
                            $('.hpsum-deploy').removeClass('hp-disabled').attr('style', 'color:#007dba;');
                            $(ABORT_ACTION).addClass('hp-disabled');
                            $(INVENTORY_ACTION).addClass('hp-disabled');
                            $(STAGE_ACTION).addClass('hp-disabled'); /* disable Satge/Deploy in scout failed case */
                            $('.hpsum-deploy').addClass('hp-disabled');
                            $(REPORTS_ACTION).addClass('hp-disabled');
                            $(SCHEDULE_ACTION).addClass('hp-disabled');
			                $(REBOOT_ACTION).addClass('hp-disabled');
				$(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                        } else {
							if ( phase.match(/initialize/i))
							{
								$(DELETE_ACTION).addClass('hp-disabled');
								$(DELETE_ACTION).css("color", "grey").bind('click.disable-link', function(e) {
								});
							}
							else
							{
								$(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
							}
                            $(ABORT_ACTION).addClass('hp-disabled');
                            $(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                            $('.hpsum-deploy').addClass('hp-disabled');
                            if(type.match(/windows|linux/i) && !item.node_id.match(/N1localhost/i))
                            {
                                 $(STAGE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link'); 
                            } else {
                            
                                 $(STAGE_ACTION).addClass('hp-disabled');
                            }
                            $(REPORTS_ACTION).addClass('hp-disabled');
                            $(SCHEDULE_ACTION).addClass('hp-disabled');
			                $(REBOOT_ACTION).addClass('hp-disabled');
                        }
                    } else if (state.match(/inventory$/i)) {
                        $(DELETE_ACTION).addClass('hp-disabled');
                        $(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                        $(INVENTORY_ACTION).addClass('hp-disabled');
                        $('.hpsum-deploy').addClass('hp-disabled');
                        $(STAGE_ACTION).addClass('hp-disabled')
                        $(REPORTS_ACTION).addClass('hp-disabled');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
			            $(REBOOT_ACTION).addClass('hp-disabled');
                        $(EDIT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/UAN/i) || state.match(/remote_staging_uan/i)) {
                        $(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                        $(ABORT_ACTION).addClass('hp-disabled');
                        $(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        /* after inventory/staging, user may go for normal inventory or stage, so wee need to enable stage/deploy again for remote win/lin case.*/
                        if(type.match(/windows|linux/i) && !item.node_id.match(/N1localhost/i)){
                            $(STAGE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                            if(state.match(/remote_staging_uan/i)){
                                /* If staged inevntory: dissable report and ReviewDeploy*/
                                $('.hpsum-deploy').addClass('hp-disabled');
                                $(REPORTS_ACTION).addClass('hp-disabled');   
                            }
                            else{
                                $('.hpsum-deploy').removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                                $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');    
                            }
                        }
                        else{
                            $('.hpsum-deploy').removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                            $(STAGE_ACTION).addClass('hp-disabled');
                            $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        }
                       
                        $(SCHEDULE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        $(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        $(REBOOT_ACTION).addClass('hp-disabled');

                    } else if (state.match(/InstallDone/i)) {
                        $(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                        $(ABORT_ACTION).addClass('hp-disabled');

                        $(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        /* after installdone, user may go for normal inventory or stage, so wee need to enable stage/deploy again */
                        if(type.match(/windows|linux/i) && !item.node_id.match(/N1localhost/i))
                        {
                            $(STAGE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link'); 
                        }
                        else
                        {
                            $(STAGE_ACTION).addClass('hp-disabled');    
                        }
                        
                        $('.hpsum-deploy').addClass('hp-disabled');

                        $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        $(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
                         
                        //Modify condition here to disable reboot link after install is done
                        //if the reboot action is not supported for the node type
                        if(type.match(/ilo|switch|ipdu|virtual_connect|oa|sas_switch|sd2|sd2oa|integrityilo|moonshot/i))
                            $(REBOOT_ACTION).addClass('hp-disabled');
                        else
                            $(REBOOT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                    } else if (state.match(/Install$/i)) {
                        $(DELETE_ACTION).addClass('hp-disabled');
                        if(type.match(/switch|ipdu|virtual_connect|oa|sas_switch|sd2|sd2oa|ilo|integrityilo/i)) {
                          $(ABORT_ACTION).addClass('hp-disabled');
                        }
                        else {
                          $(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                        }
                        $(INVENTORY_ACTION).addClass('hp-disabled');
                        /* dissable Stage/Deploy during install */
                        $(STAGE_ACTION).addClass('hp-disabled');
                        $('.hpsum-deploy').addClass('hp-disabled');
                        $(REPORTS_ACTION).addClass('hp-disabled');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
			            $(EDIT_ACTION).addClass('hp-disabled');
			            $(REBOOT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/activate_pending/i)) {
                        $(DELETE_ACTION).addClass('hp-disabled');
                        $(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                        $(INVENTORY_ACTION).addClass('hp-disabled');
                        $('.hpsum-deploy').addClass('hp-disabled');
                        $(REPORTS_ACTION).addClass('hp-disabled');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
			            $(REBOOT_ACTION).addClass('hp-disabled');
                        $(EDIT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/pending_fw_update/i)) {
                        $(DELETE_ACTION).addClass('hp-disabled');
                        $(ABORT_ACTION).addClass('hp-disabled');
                        $(INVENTORY_ACTION).addClass('hp-disabled');

                        $('.hpsum-deploy').removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        $(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        $(REPORTS_ACTION).addClass('hp-disabled');
                        $(SCHEDULE_ACTION).addClass('hp-disabled');
			            $(REBOOT_ACTION).addClass('hp-disabled');
                    } else if (state.match(/error/i)) {
                        $(DELETE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;');
                        $(ABORT_ACTION).addClass('hp-disabled');
                        $(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        /* Enable stage/deploy incase of node is in error state, to allow redo the same action */
                        if(type.match(/windows|linux/i) && !item.node_id.match(/N1localhost/i)){
                            $(STAGE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link'); 
                        }
                        else{
                            $(STAGE_ACTION).addClass('hp-disabled');    
                        }
                        $('.hpsum-deploy').addClass('hp-disabled');
                        $(REPORTS_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                        $(SCHEDULE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
			            $(REBOOT_ACTION).removeClass('hp-disabled').attr('style', '');
                        $(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                    }

			 if (!phase.match(/Initialize/i)) {
                    $(".hp-disabled").css("color", "grey").bind('click.disable-link', function(e) {
                        e.preventDefault();
                        return false;
                    });
             }
            }
                
            function showNodeProgress(item){
            		if(timerMap[item.node_id])
            			return;
        		   	timerMap[item.node_id] = setInterval(function () {
            		presenter.getNodeStatus(item, {
                				success : function(data) {
                    				onNodeStatusSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			onNodeStatusError(errorInfo);
                    			}
                			});
                			
                }, 3000);
        	}
        	
        	function onNodeStatusSuccess(data){
        		if(thisNode.node_id == data.hapi.node_status.node_id) 
                {
                    var detailsContent = '';
                    if(data.hapi.node_status.node_state.match(/install$/i) && data.hapi.node_status.livelog != ""){
                        detailsContent = "<div class='hpsum-expandabale'><a><div class='hpsum-down-icon hpsum-icon'></div>" + localizer.getString('hpsum.node.liveLog') + "</a><div class='hpsum-live-log-window' style='display:block;'><textarea id='hpsum-component-installation-notes' name='note'  readonly='readonly' style='width:100%; height:100%;min-height:200px;resize:both'>" + data.hapi.node_status.livelog + "</textarea></div></div>";
					}
                    else if(data.hapi.node_status.node_state.match(/inventory$/i)){
                        detailsContent = localizer.getString('hpsum.node.inventoryInProgress');
                    }
					
                    var notif = {
        				  	status: 'info',
                            summary: data.hapi.node_status.node_status,
                            // timestamp: (new Date().toISOString()),
                            changing: true,
                            details: detailsContent // Add in translation
        			};
        			 
        			 
        			if(data.hapi.node_status.node_state.match(/uan|error|pending_fw_update|idle|installdone|installhold|scheduled|pendingfwupdate|activatependingfwupdate/i)){
        				notificationsView.remove(notif);
        				presenter.refreshIndexResults();
        				clearInterval(timerMap[data.hapi.node_status.node_id]);
        				delete timerMap[data.hapi.node_status.node_id];
        			}
                    else {
                        notificationsView.add(notif);
			$('#hpsum-component-installation-notes').scrollTop($(('#hpsum-component-installation-notes')[0]).scrollHeight);
                    }
        		}
        		else
        		{
        				clearInterval(timerMap[data.hapi.node_status.node_id]);
        				delete timerMap[data.hapi.node_status.node_id];
        		}
        	}
        	
        	function onNodeStatusError(error){
        		
        		/*if(data.hapi.node_status.node_state.match(/uan|error|pending_fw_update|idle/i)){
        				//clearInterval(inventoryTimer);
        				presenter.refreshIndexResults();
        		}*/
        	}

            function onItemError(errorMessage) {
            }
            
            function onSelectionChange(selection) {
                notificationsCleared = false;
                clearNotifications();
                urlFragment.replaceHrefUris(HEADER,
                    selection.uris, selection.multiSelectId);
                if ($(HEADER).hasClass('hp-show-init')) {
                    $(HEADER).removeClass('hp-show-init');
                } else {
                    $(HEADER).addClass('hp-show-changing');
                    $(ACTIONS).addClass('hp-disabled');
                }
            }
            
            function onAggregateChange(aggregate) {
                $(TITLE).removeClass('hp-unavailable').text(localizer.getString('hpsum.node.nodeCount',[ aggregate.count ]));
                $(STATUS).hide();
                notificationsCleared = false;
                clearNotifications();
            }
            
            function onItemDeleteSuccess(item_name) {
                notificationsView.add({summary: localizer.getString('hpsum.switchUI.deleted')}, true); // Add in translation
                deleteInProgress = false;
            }
			
			function onItemRebootSuccess(item_name) {
                notificationsView.add({summary: localizer.getString('hpsum.node.nodeRebooted')}, true); // Add in translation
                rebootInProgress = false;
            }
			
			function onItemRebootError(errorMessage) {
                notificationsView.add({summary:errorMessage}, true);
                rebootInProgress = false;
            }

            /**
             * @private
             */
            function onItemDeleteError(errorMessage) {
                notificationsView.add({summary:errorMessage}, true);
                deleteInProgress = false;
            }
            
            function onAbort(ev){
                
                if($(ABORT_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }
                
        		if (! abortInProgress) {
                   abortInProgress = true;
                    
                   var contents = $(abortConfirmHtml);
                   localizer.localizeDom(contents);
                    $(ABORT_TITLE, contents).text(localizer.getString('hpsum.node.abortFor', [presenter.selectionLabel()]));
                        
                    $(ABORT_ERROR, contents).hide();
                    var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                                presenter.abortAction({
                                    success : function(){
                                    	abortInProgress = false;
                                    	var notif = {									
														status : 'info',
														summary : localizer.getString('hpsum.node.abortActionSuccessful'),
														changing : true
													};
										notificationsView.add(notif);
                                    },
                                    error : function(msg){
                                    	notificationsView.add({summary:msg}, true);
                                    	abortInProgress = false;
                                    }
                                });
                        },
                        cancel: function () {
                            abortInProgress = false;
                        }
                    });
                }
                
                ev.preventDefault();
        	}

            /**
             * @private
             */
            function onDeleteItem(ev) {
                
                if($(DELETE_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }
                
				if ( presenter.selectionLabel() === 'localhost')
				{
					var contents = $(deleteConfirmHtml);
					$('#hpsum-delete-node',contents).html(localizer.getString('hpsum.node.cannotDelete'));
					$('#hpsum-node-delete-cancel',contents).hide();
					$('#hpsum-node-delete-ok',contents).html(localizer.getString('hpsum.common.ok'));

					var dialogView = new DialogView();
                    dialogView.init({contents: contents,
						ok: function ()
						{}
					 });
				}
				else {
					if (! deleteInProgress) {
						deleteInProgress = true;
					
						var contents = $(deleteConfirmHtml);
						$('#hpsum-delete-node',contents).html(localizer.getString('hpsum.common.continueWithDeleting')+' '+presenter.selectionLabel()+'?');
						$('#hpsum-node-delete-ok',contents).html(localizer.getString('hpsum.baseline.show.yesDelete'));
						$('#hpsum-node-delete-cancel',contents).show();

						localizer.localizeDom(contents);
						if(nodeItem.scheduled === 'true')
						{
							var table;
							//var data;
							var schedule_date_time_new = '';
							if(nodeItem.schedule_date_time)
							{
								var schedule_date_time_old = nodeItem.schedule_date_time.split(' ');
								var schedule_time_format = schedule_date_time_old[2];
								var schedule_time = schedule_date_time_old[1];
								var schedule_time_hrs_mins = schedule_time.split(':');
								var schedule_time_hrs = schedule_time_hrs_mins[0];
								if(schedule_time_format == 'PM')
								{
									if (schedule_time_hrs < 12)
									{
									schedule_time_hrs = parseInt(schedule_time_hrs) + 12;
									schedule_date_time_new = schedule_date_time_old[0] + ' ' + schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
									}
									if (schedule_time_hrs == 12)
									{
									schedule_time_hrs = parseInt(schedule_time_hrs) + 0;
									schedule_date_time_new = schedule_date_time_old[0] + ' ' + schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
									}
								}
								if(schedule_time_format == 'AM')
								{
									if (schedule_time_hrs < 12)
									{
									schedule_time_hrs = parseInt(schedule_time_hrs) + 0;
									schedule_date_time_new = schedule_date_time_old[0] + ' ' + '0' +schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
									}
									if (schedule_time_hrs == 12)
									{
									schedule_time_hrs = parseInt(schedule_time_hrs) - 12;
									schedule_date_time_new = schedule_date_time_old[0] + ' ' + '0'+ schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
									}
								}	
								if(nodeItem.scheduled === "true")
								{
									 $('#hpsum-delete-node',contents).hide();
									
									table = "<p>This node is scheduled for deployment at" + ' ' + schedule_date_time_new  + '.' + ' ' +"Do you still want to continue with delete? </p>";
									//table +="<table><thead><tr><th>Node Name</th><th>Schedule DateTime</th></tr> ";
									//table += "<tr><td>" + nodeItem.name + "</td>";
									//table += "<td>" + nodeItem.schedule_date_time + "</td></tr>";
									//sched_flag = "yes";
									
								}
								//table += "</table>";
							}
							$(DELETE_SCHEDULE,contents).html(table);
							$(DELETE_TITLE, contents).text(
									localizer.getString('hpsum.common.deleteArg',
									[presenter.selectionLabel()]));
					}
					else
					{
						$(DELETE_TITLE, contents).text(
							localizer.getString('core.deleteConfirm.title',
								[presenter.selectionLabel()]));
					}
                    var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                                presenter.deleteItem({
                                    success : onItemDeleteSuccess,
                                    error : onItemDeleteError
                                });
                        },
                        cancel: function () {
                            deleteInProgress = false;
                        }
                    });
                }
                }
                ev.preventDefault();
            }
            
            function updateActionLinks(){
            	  	var resource = router.location().split('/');
                	resource = resource[1];
    				
    				 $('a[data-change]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
            }
			
			function onReboot(ev){
			    
               if($(REBOOT_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }

			var contents = $(rebootConfirmHtml);
                localizer.localizeDom(contents);
                $('#hpsum-otu-reboot-title', contents).text(
                    localizer.getString('hpsum.RebootConfirm.title'));
				var dialogView = new DialogView();
                dialogView.init({contents: contents,
                	ok: function () {
						if (!rebootInProgress) 
						{
							rebootInProgress = true;
							
							presenter.rebootNode(thisNode.node_id, {															
								success : onItemRebootSuccess,
								error : onItemRebootError									
								});		
						}
                    },
                    cancel: function () {
						rebootInProgress = false;
                        return;
                    }
                });				
				ev.preventDefault();
			}

            function onFailedComponents(ev) {
                var contents = $(failedComponentsHtml);
                localizer.localizeDom(contents);
                var failedDialog = new DialogView();
                failedDialog.init({contents: contents,
                    cancel: function () {
                        router.go('/node/show');
                    }
                }); 
                populateFailedComponentTable();             
            }
            

            function initComponentTable(tableid) {
                var oTab = $(tableid).dataTable({
                    oLanguage: {
                        sEmptyTable: localizer.getString("hpsum.node.noApplicableComponentsFound"),
                        sSearch: localizer.getString('hpsum.common.search')
                                        },
                    bPaginate : false,
                    bProcessing : true,
                    bFilter : true,
                    bSort : true,
                    bAutoWidth : false,
                    bInfo : false,
                    bRetrieve : true,
                    bDestroy : true,
                    //aaData: data,
                    aoColumns : [
                        {mDataProp: 'Component_ID'},
                        {mDataProp: 'Component_Name'},
                      ],
                    aaSorting: [],
                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                        return nRow;
                    }
                });
            }

            //Populate failed components table
            function populateFailedComponentTable(){
                    initComponentTable(FAILED_COMPONENTS_TABLE);
                    var oTable = $(FAILED_COMPONENTS_TABLE).dataTable();
                    //oTable.fnClearTable();
                    for(var i=0; i<nodeItem.failed_component_id.length; i++)
                    {
                    var compItem = [{
                            'Component_ID': nodeItem.failed_component_id[i],
                            'Component_Name': nodeItem.failed_component_name[i]
                        }];
                    oTable.fnAddData(compItem);
                    }
                }

            this.resume = function () {
                notificationsCleared = false;
                $('#hp-page-notifications').remove();
                notificationsView.init({context: $(VIEW),
                    allLocation: '#/node/show/activity',
                    resource: presenter.resource()});
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("aggregateChange", onAggregateChange);
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                updateActionLinks();
                                
                $(DELETE_ACTION).bind('click', onDeleteItem);
                $(ABORT_ACTION).bind('click', onAbort);
                $(REBOOT_ACTION).bind('click', onReboot);
				$(INVENTORY_ACTION).bind('click',onInventory);
                $(document).on('click', '#hpsum-node-show-openfirewall', onOpenFirewall);
                $(document).on('click', '#hpsum-warning-confirm', onConfirmWarning);
                $(document).on('click', '#hpsum-warning-cancel', onCancelWarning);		

                if (notificationsView.resume) {
                    notificationsView.resume();
                }
            };
            
            this.pause = function () {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("aggregateChange", onAggregateChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                $(DELETE_ACTION).unbind('click', onDeleteItem);
                $(ABORT_ACTION).unbind('click', onAbort);
                $(REBOOT_ACTION).unbind('click', onReboot);
				$(INVENTORY_ACTION).unbind('click',onInventory);
                $('#hpsum-node-reboot').unbind('click', onReboot);
                $('#hpsum-node-schedule-run').unbind('click').bind('click', onRunNow);
                $('#hpsum-node-scheduledelete').unbind('click').bind('click', onDeleteSchedule);
                $('#hpsum-failed-components-link').unbind('click', onFailedComponents);
                $(document).off('click', '#hpsum-node-show-openfirewall');
                $(document).off('click', '#hpsum-warning-confirm');
                $(document).off('click', '#hpsum-warning-cancel');


                for (var key in timerMap) {
                    clearInterval(timerMap[key]);
                    delete timerMap[key];
                }
                if (notificationsView.pause) {
                    notificationsView.pause();
                }
            };
          
            /**
             * @public
             */
            this.init = function() {
                
                $(ACTIONS).hpDropMenu();
                $('#hpsum-activity-actions').hide();
                this.resume();
            };
            
        }

        return new NodeShowView();
    }());
    
    return NodeShowView;
});
