define(['hpsum/presenter/node/NodePresenter',
                                'hpsum/presenter/baseline/BaselinePresenter',
                                'hp/core/EventDispatcher',
                                'hp/core/Localizer', 
                                'hp/view/DialogView',
                                'text!hpsumpages/node/component_dialog.html',   
                                'jquery', 
                                'hp/lib/jquery.hpStatus',
                                'lib/jquery.dataTables',
                                'hp/lib/jquery.hpCollapsible',
                                'hp/lib/jquery.hpToggle'], 
function(presenter,baselinePresenter, EventDispatcher, localizer,DialogView,componentDialogHtml) {"use strict";
                (function($) {
                                // Create the defaults once
                                var pluginName = "hpsumInstallables",
        defaults = {
            nodeItem: null
        };
                                var selectedRows = [];
                                var failed_dep_count = 0;
                                var sortDirection = 'desc', sortColumn = 3;
                                function initInstallReviewTable(tableid) {
                                                var oTab = $(tableid).dataTable({
                                                                oLanguage : {
                                                                                sEmptyTable : localizer.getString("hpsum.node.noApplicableComponentsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
                                                                },
                                                                bPaginate : false,
                                                                bProcessing : true,
                                                                bFilter : true,
                                                                bSort : true,
                                                                bAutoWidth : false,
                                                                bInfo : false,
                                                                bRetrieve : true,
                                                                bDestroy : true,
                                                                //aaData: data,
                                                                aoColumns : [
                                                                {mDataProp: 'group_id', "bVisible": false},
                                                                {
                                                                                mDataProp : 'selected'
                                                                },
                                                                {
                                                                                mDataProp : 'name'
                                                                }, {
                                                                                                mDataProp : 'status',
                                                                                }, {
                                                                                    mDataProp : 'product_type',
                                                                                    fnRender: function (oObj) {
                                                                                        
                                                                                        switch (oObj.aData.product_type.toUpperCase()) {
                                                                                            case 'FIRMWARE':
                                                                                                return localizer.getString("hpsum.common.firmware");
                                                                                            case 'DRIVER':
                                                                                                return localizer.getString("hpsum.common.driver");
                                                                                            case 'PCI':
                                                                                                return localizer.getString("hpsum.common.pci");
                                                                                            case 'UTILITY':
                                                                                                return localizer.getString("hpsum.common.utility");
                                                                                            case 'SOFTWARE':
                                                                                                return localizer.getString("hpsum.common.software");
                                                                                            default:
                                                                                                
                                                                                                return oObj.aData.product_type;

                                                                                        }
                                                                                    }
                                                                                                }, {
                                                                                                mDataProp : 'product_sub_type',
                                                                                                    fnRender: function (oObj) {
                                                                                    
                                                                                                        switch (oObj.aData.product_sub_type.toUpperCase()) {
                                                                                                            case "BIOS": return localizer.getString("hpsum.common.bios"); break;
                                                                                                            case "ARRAY CONTROLLER": return localizer.getString("hpsum.common.arrayController"); break;
                                                                                                            case "MANAGEMENT PROCESSOR": return localizer.getString("hpsum.common.managementProcessor"); break;
                                                                                                            case "INTEGRITY SFW": return localizer.getString("hpsum.common.integritysfw"); break;
                                                                                                            case "SAS": return localizer.getString("hpsum.common.sas"); break;
                                                                                                            case "SAS HARD DRIVE": return localizer.getString("hpsum.common.sasHD"); break;
                                                                                                            case "DRIVER": return localizer.getString("hpsum.common.driver"); break;
                                                                                                            case "NIC": return localizer.getString("hpsum.common.nic"); break;
                                                                                                            case "INTEL NIC": return localizer.getString("hpsum.common.nicIntel"); break;
                                                                                                            case "NETXEN NIC": return localizer.getString("hpsum.common.nicNetXEN"); break;
                                                                                                            case "TAPE": return localizer.getString("hpsum.common.tape"); break;
                                                                                                            case "QLOGIC": return localizer.getString("hpsum.common.qlogic"); break;
                                                                                                            case "EMULEX": return localizer.getString("hpsum.common.emulex"); break;
                                                                                                            case "BROCADE": return localizer.getString("hpsum.common.brocade"); break;
                                                                                                            case "SOLEX": return localizer.getString("hpsum.common.solex"); break;
                                                                                                            case "OA": return localizer.getString("hpsum.common.oa"); break;
                                                                                                            case "SD2OA": return localizer.getString("hpsum.common.sdoa"); break;
                                                                                                            case "DHOA": return localizer.getString("hpsum.common.dhoa"); break;
                                                                                                            case "PCI": return localizer.getString("hpsum.common.pci"); break;
                                                                                                            case "EVACONTROLLER": return localizer.getString("hpsum.common.evaController"); break;
                                                                                                            case "EVADRIVE": return localizer.getString("hpsum.common.evaDrive"); break;
                                                                                                            case "SEP": return localizer.getString("hpsum.common.sep"); break;
                                                                                                            case "BPM": return localizer.getString("hpsum.common.bpm"); break;
                                                                                                            case "VC": return localizer.getString("hpsum.common.vc"); break;
                                                                                                            case "FCHBA": return localizer.getString("hpsum.common.fchba"); break;
                                                                                                            case "IPDU": return localizer.getString("hpsum.common.ipdu"); break;
                                                                                                            case "MOONSHOT": return localizer.getString("hpsum.common.moonshot"); break;
                                                                                                            case "SWITCH:BROCADE": return localizer.getString("hpsum.common.switchBrocade"); break;
                                                                                                            case "SWITCH:CISCO": return localizer.getString("hpsum.common.switchCisco"); break;
                                                                                                            case "SWITCH:QLOGIC": return localizer.getString("hpsum.common.switchQlogic"); break;
                                                                                                            case "VMWARE DRIVER": return localizer.getString("hpsum.common.vmwareDriver"); break;
                                                                                                                // additions for RPM
                                                                                                            case "FILE": return localizer.getString("hpsum.common.file"); break;
                                                                                                            case "LIBRARY": return localizer.getString("hpsum.common.library"); break;
                                                                                                            case "RPM": return localizer.getString("hpsum.common.rpm"); break;

                                                                                                                //HP-UX
                                                                                                            case "DEPOT": return localizer.getString("hpsum.common.depot"); break;
                                                                                                            case "INFINIBAND": return localizer.getString("hpsum.common.infiniband"); break;
                                                                                                            case "BROADCOM": return localizer.getString("hpsum.common.broadcom"); break;
                                                                                                            case "SASHBA": return localizer.getString("hpsum.common.sashba"); break;
                                                                                                            case "SA CONTROLLER": return localizer.getString("hpsum.common.saController"); break;
                                                                                                            case "HPUXSMIF": return localizer.getString("hpsum.common.hpuxsmif"); break;
                                                                                                            case "EMBEDDED NIC": return localizer.getString("hpsum.common.nicEmbedded"); break;
                                                                                                            case "INTEL & BROADCOM": return localizer.getString("hpsum.common.intelBroadcom"); break;

                                                                                                            default:
                                                                                                                    return oObj.aData.product_sub_type;
                                                                                                        }

                                                                                                    }
                                                                                                }, {
                                                                                                                mDataProp : 'installed_version',
                                                                                                                fnRender: function(oObj){
                                                                                                                                var version = oObj.aData.installed_version;
                                                                                                                                var device_info = oObj.aData.device_info;
                                                                                                                                if((version == '') && (device_info != ''))
                                                                                                                                                return '<a id="device_info" href="javascript:void(0);">View Devices</a>';
                                                                                                                                else
                                                                                                                                                return version;
                                                                                                                }
                                                                                                                
                                                                                                }, {
                                                                                                                mDataProp : 'active_version',
                                                                                                                fnRender: function(oObj){
                                                                                                                                var version = oObj.aData.active_version;
                                                                                                                                var device_info = oObj.aData.device_info;
                                                                                                                                if((version == '') && (device_info != ''))
                                                                                                                                                return '<a id="device_info" href="javascript:void(0);">View Devices</a>';
                                                                                                                                else
                                                                                                                                                return version;
                                                                                                                }
                                                                                                                
                                                                                                }, {
                                                                                                                mDataProp : 'available_version',
                                                                                                                fnRender: function (oObj) {
                                                                                                                                var version = oObj.aData.available_version;
                                                                                                                                return '<a id="revision_history" href="javascript:void(0);">' + version+ '</a>';
                                                                                                                }
                                                                                                }, {
                                                                                                                mDataProp : 'reboot_required'
                                                                                    },
                                                                                                //{mDataProp: 'has_failed_dependencies'},
                                                                                                {mDataProp: 'baseline_details', "bVisible": false}, 
                                                                                                {
                                                                                                                mDataProp : 'file_name',
                                                                                                                "bVisible" : false
                                                                                                }, {
                                                                                                                mDataProp : 'component_id',
                                                                                                                "bVisible" : false
                                                                                                }, {
                                                                                                                mDataProp : 'failed_deps',
                                                                                                                "bVisible" : false
                                                                                                },
                                                                                                {mDataProp: 'group_name', "bVisible": false}, 
                                                                                                {
                                                                                                                mDataProp : 'device_info',
                                                                                                                "bVisible" : false
                                                                }],
                                                                fnCreatedRow:function(nRow, aData, iDataIndex){
                                                                                if(aData.status.match(/ok|selected/i))
                                                                                                                                nRow.className += ' hp-selected ' + aData.group_id;
                                                                                                else{
                                                                                                                                if(aData.status.match(/selectable/i))
                                                                                                                                                nRow.className += ' ' + aData.group_id;
                                                                                                                                else
                                                                                                                                                nRow.className += ' hp-disabled ' + aData.group_id;
                                                                                                                }
                                                                },
                                                                //aaSorting : [],
                                                                fnRowCallback : function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                                                                                //nRow.className += ' ' + aData.group_id;
                                                                                return nRow;
                                                                },
                                                                "fnDrawCallback": function ( oSettings ) {
                                                                                if ( oSettings.aiDisplay.length == 0 )
                                                                                {
                                                                                                return;
                                                                                }
                                                                                
                                                                                var nTrs = $(tableid + ' tbody tr');
                                                                                var iColspan = nTrs[0].getElementsByTagName('td').length;
                                                                                var sLastGroup = "";
                                                                                for ( var i=0 ; i<nTrs.length ; i++ )
                                                                                {
                                                                                                var iDisplayIndex = oSettings._iDisplayStart + i;
                                                                                                var sGroup = oSettings.aoData[ oSettings.aiDisplay[iDisplayIndex] ]._aData.group_id;
                                                                                                var sGroupName = oSettings.aoData[ oSettings.aiDisplay[iDisplayIndex] ]._aData.group_name;
                                                                                                if(sGroup == ''){
                                                                                                                sLastGroup = sGroup;
                                                                                                                continue;
                                                                                                }
                                                                                                if ( sGroup != sLastGroup )
                                                                                                {
                                                                                                                var nGroup = document.createElement( 'tr' );
                                                                                                                nGroup.className='hp-disabled';
                                                                                                                var nCell = document.createElement( 'td' );
                                                                                                                nCell.colSpan = iColspan;
                                                                                                                nCell.className = "group";
                                                                                                                nCell.innerHTML = '<b>' + sGroupName + '</b>';
                                                                                                                nGroup.appendChild( nCell );
                                                                                                                nTrs[i].parentNode.insertBefore( nGroup, nTrs[i] );
                                                                                                                sLastGroup = sGroup;
                                                                                                }
                                                                                }
                                                                                $('.group').css({'background-color': '#dddddd'});
                                },
                                "aaSortingFixed": [[ 0, 'asc' ]],
                                "aaSorting": [[ sortColumn, sortDirection ]], //by default, the sorting is done on Ready to proceed column
                                "sDom": 'lfr<"giveHeight"t>ip'
                                                });

                                                $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                
                                    $(tableid).unbind('sort').bind('sort', function (e, dt) {
                                                    sortDirection = dt.aaSorting[0][1];
                                                    sortColumn = dt.aaSorting[0][0];
                                                });
                                }
    // The actual plugin constructor
    function Plugin( element, options ) {
        this.element = element;

        // jQuery has an extend method which merges the contents of two or
        // more objects, storing the result in the first object. The first object
        // is generally empty as we don't want to alter the default options for
        // future instances of the plugin
        this.options = $.extend( {}, defaults, options );
                                this.dispatcher = new EventDispatcher();
        this._defaults = defaults;
        this._name = pluginName;

        this.init();
    }

    Plugin.prototype = {

        init: function() {
                                                $(this.element).addClass('hpsumInstallables');
                                                if(this.options.command =='init')
                                this.calculate(this.element, this.options);

        },
        getComponents:function(el){
                if(this.options.nodeItem == null)
                                return false;
                var nodeItem = this.options.nodeItem;
                var tableid = '#hpsum-otu-installables-' + nodeItem.node_id+ '-table';
                var currTable= $(tableid).dataTable();
                                                var componentsList = {
                                                                hapi : {
                                                                                components : {
                                                                                                component : []
                                                                                }
                                                                }
                                                };
                                                var rowsSelected = currTable.fnGetNodes();;
                                                //rowsSelected contains the entire list of components to be installed.
                for (var tmp = 0; tmp < rowsSelected.length; tmp++) {
                                                                var compData = currTable.fnGetData(rowsSelected[tmp]._DT_RowIndex);
                                                                if(compData == null)
                                                                                continue;
                                                                var bselected = false, bforce = false;

                                                                if (rowsSelected[tmp].className.indexOf('hp-selected') != -1)
                                                                                bselected = true;
                                                                else
                                                                                bselected = false;
                                                                if (bselected && rowsSelected[tmp].firstChild.firstChild) 
                                                                {
                                                                                if ($(rowsSelected[tmp]).find("li:first")[0].innerHTML.match(localizer.getString("hpsum.oneTouchUpdate.forced"))){
                                                                                                bforce = true;
                                                                                }
                                                                }
                                                                var item = {
                                                                                component_name : compData.file_name,
                                                                                selected : bselected,
                                                                                force : bforce
                                                                };

                                                                componentsList.hapi.components.component.push(item);
                                                }
                return componentsList;
        },
        getSelectedComponents:function(id){
                 if(id == null)
                                return false;
                var tableid = '#hpsum-otu-installables-' + id+ '-table';
                var currTable= $(tableid).dataTable();
                var selectedList= {failed_dependency:0,
                                                                                component:[]};
                if($(tableid).length == 0)
                                return selectedList;
                                                var rowsSelected = currTable.fnGetNodes();;
                for (var tmp = 0; tmp < rowsSelected.length; tmp++) {
                                                                var compData = currTable.fnGetData(rowsSelected[tmp]._DT_RowIndex);
                                                                if (rowsSelected[tmp].className.indexOf('hp-selected') != -1){
                                                                                if(compData){
                                                                                selectedList.component.push(compData.file_name);
                                                                                if(compData.failed_deps != '')
                                                                                                selectedList.failed_dependency++;
                                                                                }
                                                                }
                                                                                
                                                }
                                                return selectedList;
                
        },
        populateInstallSet: function(data,id, nodeItem){
                var plugin =this;
                                var deployflag = false, analysisflag = false;
                                                failed_dep_count = 0;
                    
                                                $(id).empty();
                                                this._defaults.nodeItem =nodeItem;
                                                $(id).append('<div><b>Total components suggested : <label style="width:100px;" id="total-component-number-' + nodeItem.node_id+'"></label></b></div><br>');
                                                $(id).append('<div><b>Total components selected : <label style="width:100px" id="selected-component-number-' + nodeItem.node_id+'"</label></b></div><br>');
                                                $(id).append('<table class="hp-selectable" id="hpsum-otu-installables-' + nodeItem.node_id + '-table"><thead><tr><td></td><td><b>'+
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.selectComponents") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.packageStr") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.statusStr") + '</b></td><td><b>' +
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.reports.type") + '</b></td><td><b>' +
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.criticality") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.installedVersion") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.activeVersion") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.availableVersion") + '</b></td><td><b>' +
                                                                                                                                localizer.getString("hpsum.common.rebootRequired") + '</b></td><td></td><td></td><td></td><td></td></tr></thead></table>');
                                                initInstallReviewTable('#hpsum-otu-installables-' + nodeItem.node_id + '-table');
                                                var currtableId = '#hpsum-otu-installables-' + nodeItem.node_id + '-table';
                                                var currTable = $('#hpsum-otu-installables-' + nodeItem.node_id + '-table').dataTable();
                                                if($(currtableId).length)
                                                                currTable.fnClearTable();
                                                var baselineslist = data.hapi.baselines;
                                                var componentMap = {}, componentAdded = {}, compCount = 0;
                                                if (currTable && baselineslist) {
                                                                for (var j = 0; j < baselineslist.baseline.length; j++) {
                                                                                var currbaseline = baselineslist.baseline[j];
                                                                                if (currbaseline.hasOwnProperty("components")) {
                                                                                                var comps = currbaseline.components.component;
                                                                                                for (var k = 0; k < comps.length; k++){
                                                                                                                var comp = comps[k];
                                                                                                                var group_id= comp.product_family_name + comp.product_sub_type; 
                                                                                                                var comp_id_redefined = comp.component_id.replace(/\./g,'_');
                                                                                                                if(componentMap[group_id] == undefined )
                                                                                                                                componentMap[group_id] = comp_id_redefined;
                                                                                                                else
                                                                                                                                componentMap[group_id] += comp_id_redefined;
                                                                                                }
																								compCount += comps.length;
                                                                                }
                                                                }
                                                                $("#total-component-number-" + nodeItem.node_id+"").text(compCount);
                                                                for (var j = 0; j < baselineslist.baseline.length; j++) {
                                                                                var currbaseline = baselineslist.baseline[j];
                                                                                if (currbaseline.hasOwnProperty("components")) {
                                                                                                var comps = currbaseline.components.component;
                                                                                                
                                                                                                var baseline_details= {baseline_id:currbaseline.baseline_id,
                                                                                                                location_id:currbaseline.location_id  };
                                                                                                //first add all the selected components
                                                                                                for (var k = 0; k < comps.length; k++) {
                                                                                                                var comp = comps[k];
                                                                                                                if(componentAdded[comp.component_id]!=true)
                                                                                                                {
                                                                                                                var stat = '', forcetoggle = '', comp_id = comp.component_id, comp_name = ' (' + comp_id + ')', selectedtoggle = '', isSelected = '';
                                                                                                                var comp_id_refined = comp_id.replace(/\./g,'_');

                                                                                                                if(comp.selected){
                                                                                                                                stat = '<div class="hp-status"><div class="hp-status-value hp-status-ok tooltip" tooltip="Ready to proceed. No Errors found"><span class="hp-value">ok</span></div></div>';
                                                                                                                                isSelected = 'selected';
                                                                                                                                if(comp.is_forced == true)
                                                                                                                                                forcetoggle = '<input id="toggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" checked/>';
                                                                                                                                else
                                                                                                                                                selectedtoggle = '<input id="selectToggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" checked/>';
                                                                                                                }
                                                                                                                else {
                                                                                                                                stat = '<div id="selectable" class="hp-status"><div class="hp-status-value tooltip hp-status-disabled" tooltip="Component is up to date. No Errors found"><span class="hp-value">disabled</span></div></div>';
                                                                                                                                if (comp.is_forcible === true)
                                                                                                                                                forcetoggle = '<input id="toggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" />';
                                                                                                                                else if(comp.is_selectable == true)
                                                                                                                                                selectedtoggle = '<input id="selectToggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" />';
                                                                                                                                else
                                                                                                                                                selectedtoggle = '<input id="selectToggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" disabled />';
                                                                                                                }
                                                                                                                
                                                                                                                if(forcetoggle != '')
                                                                                                                                selectedtoggle = forcetoggle;
                                                                                                                
                                                                                                                var failed_deps = '';

                                                                                                                if (comp.has_failed_dependencies === true) {
                                                                                                                                stat = '<div id="'+isSelected +'" class="hp-status"><div class="hp-status-value tooltip hp-status-error" tooltip="Dependency Errors. Double click to view details"><span class="hp-value">error</span></div></div>';
                                                                                                                                failed_deps = comp.failed_dependencies.failed_dependency;
                                                                                                                                failed_dep_count++;
                                                                                                                                //disable deploy button if failed dependency component is selected
                                                                                                                                if(comp.selected)
                                                                                                                                                deployflag = false;
                                                                                                                }
                                                                                                                var group_id = comp.product_family_name + comp.product_sub_type;
                                                                                                                var group_name = '';
                                                                                                                var componentName  = comp.name + comp_name;
                                                                                                                if(componentMap[group_id] === comp_id_refined){
                                                                                                                                group_id  = '';
                                                                                                                                group_name ='';
                                                                                                                }
                                                                                                                else{
                                                                                                                                group_id = componentMap[group_id];
                                                                                                                                group_name = comp.name;
                                                                                                                                componentName = comp_id;
                                                                                                                                
                                                                                                                }
                                                                                                                var installedVersion ='', activeVersion='';
                                                                                                                if(nodeItem.type.match(/ilo_federation/i)){
                                                                                                                                var installedVersion ='';
                                                                                                                                if(comp.hasOwnProperty("installed_versions_list")){
                                                                                                                                                if(comp.installed_versions_list.hasOwnProperty("installed_version")) {
                                                                                                                                                                for(var it=0; it < comp.installed_versions_list.installed_version.length; it++ ) {
                                                                                                                                                                                if(it != 0)
                                                                                                                                                                                                installedVersion += ', ';
                                                                                                                                                                                installedVersion += comp.installed_versions_list.installed_version[it];
                                                                                                                                                                }              
                                                                                                                                                }
                                                                                                                                //else
                                                                                                                                                //installedVersion = comp.installed_version;
                                                                                                                                }

                                                                                                                                var re = new RegExp(comp.installed_version, "g");
                                                                                                                                if(!installedVersion.match(re))
                                                                                                                                                installedVersion += ", " + comp.installed_version;
                                                                                                                                installedVersion= "\<div class=\"hp-ellipsis\"\  style=\"width:100px; color:#007dba\">"+ installedVersion +"\<\/div\>";
                                                                                                                                activeVersion= "\<div class=\"hp-ellipsis\"\  style=\"width:100px; color:#007dba\">"+ installedVersion +"\<\/div\>";
                                                                                                                }
                                                                                                                else{
                                                                                                                                installedVersion = comp.installed_version;
                                                                                                                                activeVersion = comp.active_version;
                                                                                                                }

                                                                                                                var reboot_required;
                                                                                                                if(comp.reboot_required == true)
                                                                                                                                reboot_required = localizer.getString("hpsum.common.yes");
                                                                                                                else if (comp.reboot_required == false)
                                                                                                                                reboot_required = localizer.getString("hpsum.common.no");
                                                                                                                                
                                                                                                                var compItem = [{
                                                                                                                                'group_id': group_id,
                                                                                                                                'name' : componentName,
                                                                                                                                'status' : stat,
                                                                                                                                'product_type' : comp.product_type,
                                                                                                                                'product_sub_type' : comp.criticality,
                                                                                                                                'installed_version' : installedVersion,
                                                                                                                                'active_version' : activeVersion,
                                                                                                                                'available_version' : comp.available_version,
                                                                                                                                'reboot_required' : reboot_required,
                                                                                                                                //'has_failed_dependencies': currbaseline.components.component[k].has_failed_dependencies,
                                                                                                                                'force' : forcetoggle,
                                                                                                                                'baseline_details' : baseline_details,
                                                                                                                                'file_name' : comp.file_name,
                                                                                                                                'component_id' : comp.component_id,
                                                                                                                                'failed_deps' : failed_deps,
                                                                                                                                'group_name':group_name,
                                                                                                                                'selected' : selectedtoggle,
                                                                                                                                'device_info' : (comp.hasOwnProperty('device_info')) ? comp.device_info : ''
                                                                                                                }];
                                                                                                                if($(currtableId).length)
                                                                                                                                currTable.fnAddData(compItem);
                                                                                                                if (forcetoggle != ""){
                                                                                                                                $('#toggle-' + comp_id_refined + '-' + nodeItem.node_id).hpToggle({
                                                                                                                                                unchecked : localizer.getString("hpsum.oneTouchUpdate.force"),
                                                                                                                                                checked : localizer.getString("hpsum.oneTouchUpdate.forced")
                                                                                                                                });
                                                                                                                }
                                                                                                                if (selectedtoggle != "")
                                                                                                                                if(comp.is_selectable == false && comp.is_forcible ==  false){
                                                                                                                                                $('#selectToggle-' + comp_id_refined + '-' + nodeItem.node_id).hpToggle({
                                                                                                                                                unchecked : localizer.getString("hpsum.common.disabled"),
                                                                                                                                                checked : localizer.getString("hpsum.common.disabled")
                                                                                                                                });
                                                                                                                                }
                                                                                                                                else {
                                                                                                                                $('#selectToggle-' + comp_id_refined + '-' + nodeItem.node_id).hpToggle({
                                                                                                                                                unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
                                                                                                                                                checked : localizer.getString("hpsum.oneTouchUpdate.selected")
                                                                                                                                });
                                                                                                                                }
                                                                                                                                componentAdded[comp.component_id] = true;
                                                                                                                }
                                                                                                                }
                                                                                                }
                                                                                }
                                                                                }
																				$('.tooltip').hpTooltip();
                                                                                $('.hp-ellipsis').hpEllipsis();
                                                                                //selectedRows = $('#hpsum-otu-installables-'+ nodeItem.node_id +'-table'+ ' tbody tr');
                                                                                
                                                                                $(currtableId + " tbody tr").click(function(e) {
																				
                                                                                                var srcElem;
                                                                                                                                                //Check if firefox or (chrome and IE)
                                                                                                if (e.srcElement) {
                                                                                                                                                                srcElem = e.srcElement;
                                                                                                                                                                                //Chrome and IE
                                                                                                                                                } else {
                                                                                                                                                                srcElem = e.target;
                                                                                                                                                                //Firefox
                                                                                                                                                }
                                                                                                                                                if(srcElem.id == 'revision_history'){
                                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                                plugin.showRevisionHistory(data);
                                                                                                                                                                
                                                                                                                                                                return;  
                                                                                                                                                }
                                                                                                                                                else if (srcElem.id == 'device_info'){
                                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                                var componentsList = {
                                                                                                                                                                                hapi : {
                                                                                                                                                                                                components : {
                                                                                                                                                                                                                component : []
                                                                                                                                                                                                }
                                                                                                                                                                                }
                                                                                                                                                                };
                                                                                                                                                                var item = {
                                                                                                                                                                                component_id : data.component_id,
                                                                                                                                                                                file_name : data.file_name,
                                                                                                                                                                                component_log : '',
                                                                                                                                                                                failed_deps : data.failed_deps,
                                                                                                                                                                                device_info : data.device_info
                                                                                                                                                                };
                                                                                                                                                                componentsList.hapi.components.component.push(item);
                                                                                                                                                                plugin.showComponentDialog(nodeItem,componentsList);
                                                                                                                                                                return;  
                                                                                                                                                }
                                                                                                                                                

                                                                                                                                                if($('.hp-toggle',$(this)).attr("disabled") == "disabled")
                                                                                                                                                                return;
                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                var clickedCellIndex = srcElem.cellIndex;
                                                                                                                                                if (clickedCellIndex === undefined) {
                                                                                                                                                             
                                                                                                                                                                var forceid = data.force.split('"');
                                                                                                                                                                forceid ='#'+ forceid[1];//+'-hpToggle';
                                                                                                                                                                if(srcElem.innerHTML.match(/Selected/i)){
                                                                                                                                                                                $(forceid).removeAttr('checked');
                                                                                                                                                                                $(forceid).trigger('change');
                                                                                                                                                                             
                                                                                                                                                                } else if(srcElem.innerHTML.match(/Select/i)){
                                                                                                                                                                                $(forceid).prop('checked', true);
                                                                                                                                                                                $(forceid).trigger('change');
                                                                                                                                                                               
                                                                                                                                                                }																																								
                                                                                                                                                               // $('#selected-component-number').text(selected_comp);
                                                                                                                                                                analysisflag = false;
                                                                                                                                                                //$(MULTI_ANALYSIS_BTN).attr("disabled", false);
                                                                                                                                                                                deployflag = true;
                                                                                                                                                                                //$(MULTI_DEPLOY_BTN).attr("disabled", true);
                                                                                                                                                                
                                                                                                                                                                var selectforceid = data.selected.split('"');
                                                                                                                                                                selectforceid ='#'+selectforceid[1];//+'-hpToggle';
                                                                                                                                                                
                                                                                                                                                                if(srcElem.className =='hp-on')
                                                                                                                                                                {
                                                                                                                                                                                if(data.force != '')
                                                                                                                                                                                $(this).addClass('hp-disabled');
                                                                                                                                                                                $(this).removeClass('hp-selected');
                                                                                                                                                                                $(selectforceid).removeAttr('checked');
                                                                                                                                                                }
                                                                                                                                                                else {//row highlighting
                                                                                                                                                                                if(srcElem.className.match(/hp-status-value/i))
                                                                                                                                                                                {
                                                                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                                                                var componentsList = {
                                                                                                                                                                                                                hapi : {
                                                                                                                                                                                                                                components : {
                                                                                                                                                                                                                                component : []
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                }
                                                                                                                                                                                                };
                                                                                                                                                                                                var item = {
                                                                                                                                                                                                                component_id : data.component_id,
                                                                                                                                                                                                                component_log : '',
                                                                                                                                                                                                                file_name : data.file_name,
                                                                                                                                                                                                                failed_deps : data.failed_deps,
                                                                                                                                                                                                                device_info : data.device_info,
                                                                                                                                                                                                                component_desc: data.name
                                                                                                                                                                                                };
                                                                                                                                                                                                componentsList.hapi.components.component.push(item);
                                                                                                                                                                                                plugin.showComponentDialog(nodeItem,componentsList);
                                                                                                                                                                                                return;
                                                                                                                                                                                }
                                                                                                                                                                                if(srcElem.className.match(/hp-status/i))
                                                                                                                                                                                {
                                                                                                                                                                                     if ($(this).hasClass('hp-disabled')) 
                                                                                                                                                                                                                return;   
                                                                                                                                                                                }
                                                                                                                                                                                $(this).removeClass('hp-disabled');
                                                                                                                                                                                $(this).addClass('hp-selected');
                                                                                                                                                                                $(selectforceid).prop('checked', true);
                                                                                                                                                                                
                                                                                                                                                                                if(data.group_id != ''){
                                                                                                                                                                                                var group = '.' + data.group_id;
                                                                                                                                                                                //var group ='.groupName';
                                                                                                                                                                                                $(group).each(function(item){
                                                                                                                                                                                                                var rdata = currTable.fnGetData(this);
                                                                                                                                                                                                                if(rdata == data)
                                                                                                                                                                                                                                return;
                                                                                                                                                                                                                $(this).removeClass('hp-selected');
                                                                                                                                                                                                                $(this).addClass('hp-disabled');
                                                                                                                                                                                                                if(rdata.force != ''){
                                                                                                                                                                                                                                var id = rdata.force.split('"');
                                                                                                                                                                                                                                id='#'+id[1];//+'-hpToggle';
                                                                                                                                                                $(id).removeAttr('checked');
                                                                                                                                                                $(id).trigger('change');
                                                                                                                                                                                                                }
																																																				if(rdata.selected != ''){
                                                                                                                                                                                                                                var id = rdata.selected.split('"');
                                                                                                                                                                                                                                id='#'+id[1];//+'-hpToggle';
                                                                                                                                                                $(id).removeAttr('checked');
                                                                                                                                                                $(id).trigger('change');
                                                                                                                                                                                                                }
                                                                                                                                                                                                                
                                                                                                                                                                                                });
                                                                                                                                                                                }
                                                                                                                                                                }
                                                                                                                                                                $(selectforceid).trigger('change');
                                                                                                                                                                plugin.setChanged(nodeItem.node_id, true);
                                                                                                                                                                return;
                                                                                                                                                }

                                                                                                                                                //Select toggle button changes 
                                                                                                                                                var selectid = data.selected.split('"');
                                                                                                                                                selectid='#'+selectid[1];//+'-hpToggle';
                                                                                                                                                if ($(this).hasClass('hp-selected')) {
                                                                                                                                                                $(selectid).removeAttr('checked');
                                                                                                                                                }
                                                                                                                                                else {
                                                                                                                                                                $(selectid).prop('checked', true);
                                                                                                                                                }
                                                                                                                                                $(selectid).trigger('change');
                                                                                                                                                
                                                                                                                                                //toggle row selection
                                                                                                                                                                if(data.group_id != ''){
                                                                                                                                                                                var group = '.' + data.group_id;
                                                                                                                                                                                
                                                                                                                                                                                $(group).each(function(item){
                                                                                                                                                                                                var rdata = currTable.fnGetData(this);
                                                                                                                                                                                                if(rdata == data)
                                                                                                                                                                                                                return;
                                                                                                                                                                                                $(this).removeClass('hp-selected');
                                                                                                                                                                                                if(rdata.force != ''){
                                                                                                                                                                                                                var id = rdata.force.split('"');
                                                                                                                                                                                                                id='#'+id[1];//+'-hpToggle';
                                                                                                                                                $(id).removeAttr('checked');
                                                                                                                                                $(id).trigger('change');
                                                                                                                                                                                                }
                                                                                                                                                                                                                
                                                                                                                                                                                });
                                                                                                                                                                }
                                                                                                                                                $(this).toggleClass('hp-selected');
                                                                                                                                                plugin.setChanged(nodeItem.node_id, true);
                                                                                                                                                //                $(MULTI_ANALYSIS_BTN).attr("disabled", false);
                                                                                                                                                //                $(MULTI_DEPLOY_BTN).attr("disabled", true);
                                                                                                                                });
                                                                                                                $(currtableId + " tbody tr").dblclick(function(e) {
                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                var componentsList = {
                                                                                                                                                                hapi : {
                                                                                                                                                                                components : {
                                                                                                                                                                                                component : []
                                                                                                                                                                                }
                                                                                                                                                                }
                                                                                                                                                };
                                                                                                                                                var item = {
                                                                                                                                                                component_id : data.component_id,
                                                                                                                                                                component_log : '',
                                                                                                                                                                file_name : data.file_name,
                                                                                                                                                                failed_deps : data.failed_deps,
                                                                                                                                                                device_info : data.device_info,
                                                                                                                                                                component_desc: data.name
                                                                                                                                                };
                                                                                                                                                componentsList.hapi.components.component.push(item);
                                                                                                                                                plugin.showComponentDialog(nodeItem,componentsList);
                                                                                                                                });
                                                                plugin.setChanged(nodeItem.node_id, false);
                                                                plugin.installsetChanged(nodeItem.node_id);
                                },
                                failedDependencyCount: function(el) {
                                return failed_dep_count;
                                },
                                setChanged: function(id, value){
                                                var componentList = this.getSelectedComponents(id);
												var selected_comp;
												selected_comp = componentList.component.length;
												$("#selected-component-number-" +id+"").text(selected_comp);
                                                this.options.onSelectionChanged(id,value,componentList);
                                },
                                installsetChanged: function(node_id){
                                                this.options.onPopulateInstallSet(node_id);
                                },
                                showRevisionHistory: function(data){
                                                //First sent getComponentData
                                                var item = {baseline_id:data.baseline_details.baseline_id,
                                                                                                location_id:data.baseline_details.location_id,
                                                                                                component_id:data.component_id,
                                                                                                filter: "revision_history"
                                                                                                };
                                                baselinePresenter.getComponentData(item,{
                                                                success:function(data) {
                                                                var componentDialogContents  =$(componentDialogHtml);
                localizer.localizeDom(componentDialogContents);
                //show component dialog
                var dialog = new DialogView();
                dialog.init({contents: componentDialogContents,
                    ok: function (elem) {
                        return true;
                    },
                    cancel: function () {
                    }
                });
                var component= data.hapi.component_data;
                $('#component_title',componentDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.componentDetailsFor", [component.component_file_name]));
                                                                $('#hpsum-ok-button',componentDialogContents).hide();
                $('#hpsum-comp-fail-dep',componentDialogContents).hide();
                            $('#hpsum-comp-inst-notes',componentDialogContents).show();
                            $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                $('#hpsum-comp-user-options', componentDialogContents).hide();
                                                                $('#hpsum-device-list',componentDialogContents).hide();
                                                                $('#hpsum-component-id',componentDialogContents).html(component.package_name);
                                                                var revision= component.revision_history.revision;
                                                                var htmlContents='';
                                                                for(var i=0; i<revision.length; i++){
                                                                                var version = revision[i].version;
                                                                                if(revision[i].revision != '')
                                                                                                version += '('+ revision[i].revision + ')';
                                                                                htmlContents+='<div class="hp-collapsible"><label>'+ version+ '</label>';
                                                                                var enhancement, fixes;
                                                                                enhancement = revision[i].enhancement;
                                                                                                                fixes = revision[i].fixes;
                                                                                                                if(enhancement == '')
                                                                                                                                enhancement =  'None';
                                                                                                                if(fixes == '')
                                                                                                                                fixes ='None'
                                                                                                                
                                                                                                
                                                                                htmlContents+='<div><b><u>Enhancements</u></b></br>'+enhancement+ '</br>'+
                                                                                                                                '<b><u>Fixes</u></b></br>' + fixes+ '</br></div></div>';
                                                                }
                                                                $('#hpsum-component-installation-notes').html(htmlContents);
                                                                $('.hp-collapsible',componentDialogContents).hpCollapsible();
                                                                $('.hp-collapsible',componentDialogContents).hpCollapsible('expand'); 
                                                                },
                                                                error:function(){
                                                                                
                                                                }
                                                });
                                },
                                showComponentDialog:function(nodeItem, data) {
                var componentDialogContents  =$(componentDialogHtml);
                                                                var plugin =this;
                localizer.localizeDom(componentDialogContents);
                //show component dialog
                var dialog = new DialogView();
                dialog.init({contents: componentDialogContents,
                    ok: function (elem) {
                                                                                                var compOptions =  {
                                                                                                                                                hapi: {
                                                                                                                                                                comp_name : data.hapi.components.component[0].file_name,
                                                                                                                                                                device_info : {
                                                                                                                                                                                takes_effect : '',
                                                                                                                                                                                user_options : {
                                                                                                                                                                                                user_option : []
                                                                                                                                                                                },
                                                                                                                                                                                devices : {
                                                                                                                                                                                                device : []
                                                                                                                                                                                }
                                                                                                                                                                }
                                                                                                                                                }
                                                                                                                                };
                                                                                                                                
                                                                                                                                var immediate_flag = true;
                                                                                                                                var deferred_flag = false;
                                                                                                                                for (var idx = 0; idx<deferred_device.length; idx++)
                                                                                                                                {
                                                                                                                                                var device = {
                                                                                                                                                                device_id : deferred_device[idx][0].deviceid,
                                                                                                                                                                isSelected : deferred_device[idx][0].isSelected
                                                                                                                                                }
                                                                                                                                                if(deferred_device[idx][0].isSelected)
                                                                                                                                                                deferred_flag = true;
                                                                                                                                                compOptions.hapi.device_info.devices.device.push(device);
                                                                                                                                }
                                                                                                                                
                                                                                                                                for (var idx = 0; idx<immediate_device.length; idx++)
                                                                                                                                {
                                                                                                                                                var device = {
                                                                                                                                                                device_id : immediate_device[idx][0].deviceid,
                                                                                                                                                                isSelected : immediate_device[idx][0].isSelected
                                                                                                                                                }
                                                                                                                                                if(!immediate_device[idx][0].isSelected)
                                                                                                                                                                immediate_flag = false;
                                                                                                                                                compOptions.hapi.device_info.devices.device.push(device);
                                                                                                                                }
                                                                                                                                for(var idx = 0; idx < user_options.length; idx++)
                                                                                                                                {
                                                                                                                                                var isChecked = $('#user_option'+idx)[0].checked ? "true" : "false";
                                                                                                                                                var options = {
                                                                                                                                                                name: user_options[idx][0].name,
                                                                                                                                                                value: isChecked
                                                                                                                                                }
                                                                                                                                                compOptions.hapi.device_info.user_options.user_option.push(options);
                                                                                                                                }
                                                                                                                                if(immediate_flag && !deferred_flag)
                                                                                                                                                compOptions.hapi.device_info.takes_effect = "immediate";
                                                                                                                                else
                                                                                                                                                compOptions.hapi.device_info.takes_effect = "deferred";
                                                                                                                                presenter.setDeviceInfo(nodeItem, compOptions, {
                                                                                                                                                success : function() {},
                                                                                                                                                error : function() {}
                                                                                                                                });
                        return true;
                    },
                    cancel: function () {
                    }
                });
                
                if(data.hapi.components.component[0].hasOwnProperty('failed_deps'))
                {
                    $('#component_title',componentDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.componentDetails"));
                                if(data.hapi.components.component.length > 0)
                                {
                                                $('#hpsum-comp-fail-dep',componentDialogContents).show();
                                                                                                $('#hpsum-ok-button',componentDialogContents).hide();
                                                $('#hpsum-comp-inst-notes',componentDialogContents).hide();
                                                                                                $('#hpsum-comp-user-options', componentDialogContents).hide();
                                                $('#hpsum-component-id',componentDialogContents).html(data.hapi.components.component[0].component_id);
                                                                                                $('#hpsum-component-help-id').html(data.hapi.components.component[0].component_desc);
                                                                                                
                                                                                                var id= $('#hpsum-component-failed-dep',componentDialogContents);
                                                this.initFailedDependencyTable(id);
                                                
                                                var oFailedDepTable = $(id).dataTable();
                                                
                                                if(oFailedDepTable) {
                                                                                                                oFailedDepTable.fnClearTable();
                                                                for(var i=0; i < data.hapi.components.component[0].failed_deps.length; i++)
                                                                {
                                                                                var item =  [
                                                                                                                                                {
                                                                                                                                                                failed_dependency: data.hapi.components.component[0].failed_deps[i]
                                                                                                                                                }
                                                                                                                                ];
                                                                                oFailedDepTable.fnAddData(item);
                                                                }
                                                }
                                                
                                                                                                if(data.hapi.components.component[0].hasOwnProperty('device_info') && data.hapi.components.component[0].device_info.hasOwnProperty('user_options'))
                                                                                                {
                                                                                                                var immediate_device = [];
                                                                                                                var deferred_device = [];
                                                                                                                var user_options = [];
                                                                                                                var userOptions = {
                                                                                                                                                hapi: {
                                                                                                                                                                comp_name : data.hapi.components.component[0].file_name
                                                                                                                                                }
                                                                                                                };
                                                                                                                presenter.getDeviceInfo (nodeItem, userOptions, {
                                                                                                                                success: function(item) {
                                                                                                                                                $('#hpsum-comp-user-options', componentDialogContents).show();
                                                                                                                                                $('#hpsum-ok-button',componentDialogContents).show();
                                                                                                                                                
                                                                                                                                                var htmlContents = '<ul>';
                                                                                                                                                
                                                                                                                                                for(var idx = 0; idx < item.hapi.device_info.user_options.user_option.length; idx++)
                                                                                                                                                {
                                                                                                                                                                htmlContents += "<li><input type=checkbox id = user_option"+idx+">"+ item.hapi.device_info.user_options.user_option[idx].name +"</li>"
                                                                                                                                                }
                                                                                                                                                htmlContents += "</ul>";
                                                                                                                                                $('#hpsum-component-user-options').html(htmlContents);
                                                                                                                                                
                                                                                                                                                for(var idx = 0; idx < item.hapi.device_info.user_options.user_option.length; idx++)
                                                                                                                                                {
                                                                                                                                                                if(item.hapi.device_info.user_options.user_option[idx].value === "true")
                                                                                                                                                                                $('#user_option'+idx)[0].checked = true;
                                                                                                                                                                else
                                                                                                                                                                                $('#user_option'+idx)[0].checked = false;
                                                                                                                                                                
                                                                                                                                                                var optionitem = [{name : item.hapi.device_info.user_options.user_option[idx].name,
                                                                                                                                                                                                                                value : $('#user_option'+idx)[0].checked
                                                                                                                                                                                                                                }];

                                                                                                                                                                user_options.push(optionitem);
                                                                                                                                                }
                                                                                                                                                if(item.hapi.device_info.hasOwnProperty('devices'))
                                                                                                                                                {
                                                                                                                                                                $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                                                                                                                
                                                                                                                                                                $('#hpsum-device-list',componentDialogContents).show();

                                                                                                                                                                var enable_select;
                                                                                                                                                                
                                                                                                                                                                if(item.hapi.device_info.hasOwnProperty('enable_device_select'))
                                                                                                                                                                                enable_select = item.hapi.device_info.enable_device_select;
                                                                                                                                                                
                                                                                                                                                                $('#hpsum-device-list-div').append('<ul style=padding-left:300px;"><li><input type=checkbox id=all_immediate>All Immediate</li><li><input type=checkbox id=all_deferred>All Deferred</li></ul>');
                                                                                                                                                                if(enable_select === "false")
                                                                                                                                                                {
                                                                                                                                                                                $('#all_immediate')[0].disabled = true;
                                                                                                                                                                                $('#all_deferred')[0].disabled = true;
                                                                                                                                                                }
                                                                                                                                                                for(var devInd=0; devInd < item.hapi.device_info.devices.device.length; devInd++)
                                                                                                                                                                {
                                                                                                                                                                                var device = item.hapi.device_info.devices.device[devInd];
                                                                                                                                                                                
                                                                                                                                                                                // Use index as table id instead of including device id in case of multiple devices with the same ID
                                                                                                                                                                                // Not sure why use device id, save it into attribute so that could find it if need.
                                                                                                                                                                                var devid = 'deviceid="' + device.device_id.replace(/\W/g, '-') + '"';
                                                                                                                                                                                var headertableid = 'hpsum-devices-header-table-' + devInd;
                                                                                                                                                                                $('#hpsum-device-list-div').append('<table id="' + headertableid + '" ' + devid + '><thead><tr><td></td><td></td><td></td></tr></thead></table>');
                                                                                                                                                                                
                                                                                                                                                                                plugin.initDevicesHeaderTable('#' + headertableid);
                                                                                                                                                                                
                                                                                                                                                                                var headerTable = $('#' + headertableid).dataTable();
                                                                                                                                                                                
                                                                                                                                                                                var headeritem = [{deviceid: "Controller ID: " + device.device_id, 
                                                                                                                                                                                                                                productid: "Product ID: " + device.product_id 
                                                                                                                                                                                                                                }];
                                                                                                                                                                                                                                                                
                                                                                                                                                                                headerTable.fnAddData(headeritem);
                                                                                                                                                                                
                                                                                                                                                                                //replace white spaces with - as element id should not have white spaces
                                                                                                                                                                                var rowtableid = 'hpsum-devices-rows-table-' + devInd; 
                                                                                                                                                                                $('#hpsum-device-list-div',componentDialogContents).append('<table class="hp-selectable" id="' + rowtableid + '" ' + devid + '><thead><tr><td>'+localizer.getString('hpsum.oneTouchUpdate.select')+'</td><td>'+localizer.getString('hpsum.common.type')+'</td><td>'+localizer.getString('hpsum.common.statusStr')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.activeVersion')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.availableVersion')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.activation')+'</td><td>'+localizer.getString('hpsum.common.rebootRequired')+'</td></tr></thead></table>');

                                                                                                                                                                                plugin.initSDDevicesRowTable('#' + rowtableid);
                                                                                                                                                                                
                                                                                                                                                                                var rowTable = $('#' + rowtableid).dataTable();
                                                                                                                                                                                
                                                                                                                                                                                for(var fwInd=0; fwInd < device.fw_item.length; fwInd++)
                                                                                                                                                                                {
                                                                                                                                                                                                var fwitem = device.fw_item[fwInd];
                                                                                                                                                                                                
                                                                                                                                                                                                var rowitem = [{ select:'',
                                                                                                                                                                                                                                                type: fwitem.type, 
                                                                                                                                                                                                                                                fw_item_status: fwitem.fw_item_status,
                                                                                                                                                                                                                                                active_version: fwitem.active_version,
                                                                                                                                                                                                                                                version: fwitem.version,
                                                                                                                                                                                                                                                activation: fwitem.takes_effect === "deferred" ? "Deferred" : "Immediate",
                                                                                                                                                                                                                                                enable_selection: enable_select,
                                                                                                                                                                                                                                                devindex: devInd,
                                                                                                                                                                                                                                                fwindex: fwInd
                                                                                                                                                                                                                                                }];
                                                                                                                                                                                                                                                                                
                                                                                                                                                                                                rowTable.fnAddData(rowitem);
                                                                                                                                                                                                                
                                                                                                                                                                                                if(device.IsSelected)
                                                                                                                                                                                                                $('#device_id'+devInd)[0].checked = true;
                                                                                                                                                                                                else
                                                                                                                                                                                                                $('#device_id'+devInd)[0].checked = false;
                                                                                                                                                                                                                
                                                                                                                                                                                                if(enable_select === "true")
                                                                                                                                                                                                                $('#device_id'+devInd)[0].disabled = false;
                                                                                                                                                                                                else
                                                                                                                                                                                                                $('#device_id'+devInd)[0].disabled = true;
                                                                                                                                                                                                
                                                                                                                                                                                                var device_options =[{deviceid:device.device_id,
                                                                                                                                                                                                                                                                deviceindex:devInd,      
                                                                                                                                                                                                                                                                takes_effect:fwitem.takes_effect,
                                                                                                                                                                                                                                                                isSelected:$('#device_id'+devInd)[0].checked
                                                                                                                                                                                                                                                                }];
                                                                                                                                                                                
                                                                                                                                                                                                if(fwitem.takes_effect === "deferred")
                                                                                                                                                                                                                deferred_device.push(device_options);
                                                                                                                                                                                                else
                                                                                                                                                                                                                immediate_device.push(device_options);
                                                                                                                                                                                }
                                                                                                                                                                                $('#device_id'+devInd).click (function (e) {
                                                                                                                                                                                                var checked = this.checked;
                                                                                                                                                                                                var devindex = parseInt(this.id.substring(9,12));
                                                                                                                                                                                                var deferred_flag = true;
                                                                                                                                                                                                var immediated_flag = true;
                                                                                                                                                                                                
                                                                                                                                                                                                // QXCR1001374655 - dataset is undefined in IE. This is an IE specific change hence 
                                                                                                                                                                                                // using the getAtrribute to fetch the value. 
                                                                                                                                                                                                
                                                                                                                                                                                                if( this.dataset == undefined ) {
                                                                                                                                                                                                                this.dataset = this.getAttribute('data-model');
                                                                                                                                                                                                }
                                                                                                                                                                                                if(this.dataset.model === "Deferred")
                                                                                                                                                                                                {
                                                                                                                                                                                                                for (var idx = 0; idx < deferred_device.length; idx++)
                                                                                                                                                                                                                {
                                                                                                                                                                                                                                if(deferred_device[idx][0].deviceindex === devindex)
                                                                                                                                                                                                                                                deferred_device[idx][0].isSelected = checked;
                                                                                                                                                                                                                                if(deferred_device[idx][0].isSelected !== checked)
                                                                                                                                                                                                                                                deferred_flag = false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if(deferred_flag)
                                                                                                                                                                                                                                $('#all_deferred')[0].checked = checked;
                                                                                                                                                                                                                else if(!checked && !deferred_flag)
                                                                                                                                                                                                                                $('#all_deferred')[0].checked = false;
                                                                                                                                                                                                }
                                                                                                                                                                                                else
                                                                                                                                                                                                {
                                                                                                                                                                                                                for (var idx = 0; idx < immediate_device.length; idx++)
                                                                                                                                                                                                                {
                                                                                                                                                                                                                                if(immediate_device[idx][0].deviceindex === devindex)
                                                                                                                                                                                                                                                immediate_device[idx][0].isSelected = checked;
                                                                                                                                                                                                                                if(immediate_device[idx][0].isSelected !== checked)
                                                                                                                                                                                                                                                immediated_flag = false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if(immediated_flag)
                                                                                                                                                                                                                                $('#all_immediate')[0].checked = checked;
                                                                                                                                                                                                                else if(!checked && !immediated_flag)
                                                                                                                                                                                                                                $('#all_immediate')[0].checked = false;
                                                                                                                                                                                                }
                                                                                                                                                                                });
                                                                                                                                                                                
                                                                                                                                                                                if(enable_select === "true")
                                                                                                                                                                                {
                                                                                                                                                                                                $('#' + rowtableid + " tbody tr").click( function( e ) {
                                                                                                                                                                                                                
                                                                                                                                                                                                                var data = rowTable.fnGetData( this );
                                                                                                                                                                                                                
                                                                                                                                                                                                                //toggle row selection              
                                                                                                                                                                                                                $(this).toggleClass('hp-selected');
                                                                                                                                                                                                });
                                                                                                                                                                                }
                                                                                                                                                                }
                                                                                                                                                                var immediated_flag = true;
                                                                                                                                                                var deferred_flag = true;
                                                                                                                                                                if(immediate_device.length > 0)
                                                                                                                                                                {
                                                                                                                                                                                var device_checked = immediate_device[0][0].isSelected;
                                                                                                                                                                                for (var idx = 0; idx < immediate_device.length; idx++)
                                                                                                                                                                                {
                                                                                                                                                                                                if(immediate_device[idx][0].isSelected !== device_checked)
                                                                                                                                                                                                                immediated_flag = false;
                                                                                                                                                                                }
                                                                                                                                                                                if(immediated_flag)
                                                                                                                                                                                                $('#all_immediate')[0].checked = device_checked;
                                                                                                                                                                                else if(!device_checked && !immediate_flag)
                                                                                                                                                                                                $('#all_immediate')[0].checked = false;
                                                                                                                                                                }
                                                                                                                                                                else
                                                                                                                                                                                $('#all_immediate')[0].disabled = true;
                                                                                                                                                                if(deferred_device.length > 0)
                                                                                                                                                                {
                                                                                                                                                                                device_checked = deferred_device[0][0].isSelected;
                                                                                                                                                                                for (var idx = 0; idx < deferred_device.length; idx++)
                                                                                                                                                                                {
                                                                                                                                                                                                if(deferred_device[idx][0].isSelected !== device_checked)
                                                                                                                                                                                                                deferred_flag = false;
                                                                                                                                                                                }
                                                                                                                                                                                if(deferred_flag)
                                                                                                                                                                                                $('#all_deferred')[0].checked = device_checked;
                                                                                                                                                                                
                                                                                                                                                                }
                                                                                                                                                                else
                                                                                                                                                                                $('#all_deferred')[0].disabled = true;
                                                                                                                                                                $('#all_immediate').click(function(e){
                                                                                                                                                                                var checked = this.checked;
                                                                                                                                                                                for (var idx = 0; idx < immediate_device.length; idx++)
                                                                                                                                                                                {
                                                                                                                                                                                                var devInd = immediate_device[idx][0].deviceindex;
                                                                                                                                                                                                $('#device_id'+devInd)[0].checked = checked;
                                                                                                                                                                                                immediate_device[idx][0].isSelected = checked;
                                                                                                                                                                                }
                                                                                                                                                                });
                                                                                                                                                                
                                                                                                                                                                $('#all_deferred').click(function(e){
                                                                                                                                                                                var checked = this.checked;
                                                                                                                                                                                for (var idx = 0; idx < deferred_device.length; idx++)
                                                                                                                                                                                {
                                                                                                                                                                                                var devInd = deferred_device[idx][0].deviceindex;
                                                                                                                                                                                                $('#device_id'+devInd)[0].checked = checked;
                                                                                                                                                                                                deferred_device[idx][0].isSelected = checked;
                                                                                                                                                                                }
                                                                                                                                                                });
                                                                                                                                                }
                                                                                                                                                else
                                                                                                                                                {
                                                                                                                                                                $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                                                                                                                $('#hpsum-device-list',componentDialogContents).hide();
                                                                                                                                                }
                                                                                                                                },
                                                                                                                                error : function(){
                                                                                                                                }
                                                                                                                });
                                                                                                }
                                                //this is for textarea
                                                //$('#hpsum-component-failed-dep').val(data.hapi.components.component[0].failed_deps);
                                                
                                                                                                else if(data.hapi.components.component[0].hasOwnProperty('device_info') && data.hapi.components.component[0].device_info.hasOwnProperty('devices'))
                                                                                                {
                                                                                                                $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                                                                
                                                                                                                $('#hpsum-device-list',componentDialogContents).show();
                                                                                                                
                                                                                                                for(var devInd=0; devInd < data.hapi.components.component[0].device_info.devices.device.length; devInd++)
                                                                                                                {
                                                                                                                                var device = data.hapi.components.component[0].device_info.devices.device[devInd];
                                                                                                                                
                                                                                                                                // Use index as table id instead of including device id in case of multiple devices with the same ID
                                                                                                                                // Not sure why use device id, save it into attribute so that could find it if need.
                                                                                                                                var devid = 'deviceid="' + device.device_id.replace(/\W/g, '-') + '"';
                                                                                                                                var headertableid = 'hpsum-devices-header-table-' + devInd;
                                                                                                                                $('#hpsum-device-list-div').append('<table id="' + headertableid + '" ' + devid + '><thead><tr><td></td><td></td><td></td></tr></thead></table>');
                                                                                                                                
                                                                                                                                this.initDevicesHeaderTable('#' + headertableid);
                                                                                                                                
                                                                                                                                var headerTable = $('#' + headertableid).dataTable();
                                                                                                                                
                                                                                                                                var item = [{deviceid: device.device_id, 
                                                                                                                                productid: device.product_id 
                                                                                                                                }];
                                                                                                                                                                
                                                                                                                                headerTable.fnAddData(item);
                                                                                                                                
                                                                                                                                //replace white spaces with - as element id should not have white spaces
                                                                                                                                var rowtableid = 'hpsum-devices-rows-table-' + devInd; 
                                                                                                                                $('#hpsum-device-list-div',componentDialogContents).append('<table class="hp-selectable" id="' + rowtableid + '" ' + devid + '><thead><tr><td>'+localizer.getString('hpsum.common.type')+'</td><td>'+localizer.getString('hpsum.common.statusStr')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.activeVersion')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.availableVersion')+'</td></tr></thead></table>');

                                                                                                                                this.initDevicesRowTable('#' + rowtableid);
                                                                                                                                
                                                                                                                                var rowTable = $('#' + rowtableid).dataTable();
                                                                                                                                
                                                                                                                                for(var fwInd=0; fwInd < device.fw_item.length; fwInd++)
                                                                                                                                {
                                                                                                                                                var fwitem = device.fw_item[fwInd];
                                                                                                                                                
                                                                                                                                                var rowitem = [{type: fwitem.type, 
                                                                                                                                                fw_item_status: fwitem.fw_item_status,
                                                                                                                                                active_version: fwitem.active_version,
                                                                                                                                                version: fwitem.version 
                                                                                                                                                }];
                                                                                                                                                                                
                                                                                                                                                rowTable.fnAddData(rowitem);
                                                                                                                                }
                                                                                                                }
                                                                                                }
                                                                                                else
                                                                                                {
                                                                                                                $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                                                                $('#hpsum-device-list',componentDialogContents).hide();
                                                                                                }
                                            }
                                                }
                            
            },
            initDevicesHeaderTable:function(tableid) {
                
                var oTab = $(tableid).dataTable({
                                                                                oLanguage: {
                                                                                                                                sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
                                                                                                                   },
                                                                    bPaginate : false,
                                                                    bProcessing : false,
                                                                    bFilter : false,
                                                                    bSort : false,
                                                                    bAutoWidth : false,
                                                                    bInfo : false,
                                                                    bRetrieve : true,
                                                                    bDestroy : true,
                                                                    aoColumns : [
                                                                                {mDataProp: 'deviceid'},
                                                                                {mDataProp: 'productid'}
                                                                        ],
                                                                    aaSorting: [],
                                                                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                                                       return nRow;
                                                                    }
                                                                    });
                                                
                                                                $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                },
                                                
                                                //Initialize component device info row table 
            initDevicesRowTable:function(tableid) {
                
                var oTab = $(tableid).dataTable({
                                                                                oLanguage: {
                                                                                                                                sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
                                                                                                                   },
                                                                    bPaginate : false,
                                                                    bProcessing : false,
                                                                    bFilter : false,
                                                                    bSort : false,
                                                                    bAutoWidth : false,
                                                                    bInfo : false,
                                                                    bRetrieve : true,
                                                                    bDestroy : true,
                                                                    aoColumns : [
                                                                                {mDataProp: 'type'},
                                                                                {mDataProp: 'fw_item_status'},
                                                                                {mDataProp: 'active_version'},
                                                                                {mDataProp: 'version'}
                                                                        ],
                                                                    aaSorting: [],
                                                                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                                                        return nRow;
                                                                    }
                                                                    });
                                                
                                                                $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                },
                                                initSDDevicesRowTable:function(tableid) {
                
                var oTab = $(tableid).dataTable({
                                                                                oLanguage: {
                                                                                                                                sEmptyTable: "",
                                                                                    sSearch: localizer.getString('hpsum.common.search')
                                                                                                                   },
                                                                    bPaginate : false,
                                                                    bProcessing : false,
                                                                    bFilter : false,
                                                                    bSort : false,
                                                                    bAutoWidth : false,
                                                                    bInfo : false,
                                                                    bRetrieve : true,
                                                                    bDestroy : true,
                                                                    aoColumns : [
                                                                                                {
                                                                                                mDataProp: 'select',
                                                                                                                fnRender: function(oObj){
                                                                                                                                return "<input id = device_id"+oObj.aData.devindex+" type=checkbox data-model="+oObj.aData.activation+">";
                                                                                                                }
                                                                                                },
                                                                                {mDataProp: 'type'},
                                                                                {mDataProp: 'fw_item_status'},
                                                                                {mDataProp: 'active_version'},
                                                                                {mDataProp: 'version'},
                                                                                                {mDataProp: 'activation'},
                                                                                                {mDataProp: 'enable_selection', "bVisible": false},
                                                                                                {mDataProp: 'devindex', "bVisible": false},
                                                                                                {mDataProp: 'fwindex', "bVisible": false}
                                                                        ],
                                                                    aaSorting: [],
                                                                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                                                        return nRow;
                                                                    }
                                                                    });
                                                
                                                                $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                },
                                recalculate:function() {
                                                if(this.options.nodeItem == undefined){
                                                                window.console.error("recalculate before init is not allowed");
                                                                return;
                                                }
                                                this.calculate(this.element,this.options);
                                                
                                },
                
        calculate: function(el, options) {
                var plugin =this;
           presenter.getbaseline(options.nodeItem, {
                                                                                                success : function(data) {
                                                                                                                plugin.populateInstallSet(data, el, options.nodeItem);
                                                                                                                if (typeof (plugin.options.onSelectionCompleted) == 'function')
                                                                                                                                plugin.options.onSelectionCompleted();
                                                                                                },
                                                                                                error : function(data){ 
                                                                                                                plugin.onPopulateError(el);
                                                                                                }
                                                                                });
        },
        onPopulateError : function(el){
                el.text("GetUpdatelist failed for this node");
        },
        destroy: function(el){
                                $(this.element).removeClass('hpsumInstallables');
                                $.removeData(this.element, "plugin_" + pluginName);
        },
                    //Initialize component device info row table 
        initFailedDependencyTable:function(tableid) {
                
                var oTab = $(tableid).dataTable({
                                                                                oLanguage: {
                                                                                                                                sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
                                                                                                                   },
                                                                    bPaginate : false,
                                                                    bProcessing : false,
                                                                    bFilter : false,
                                                                    bSort : false,
                                                                    bAutoWidth : false,
                                                                    bInfo : false,
                                                                    bRetrieve : true,
                                                                    bDestroy : true,
                                                                    aoColumns : [
                                                                                {mDataProp: 'failed_dependency'}
                                                                        ],
                                                                    aaSorting: [],
                                                                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                                                        return nRow;
                                                                    }
                                                                    });
                                                
                                                //            $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                }
       
                                
        
    };

    // A really lightweight plugin wrapper around the constructor,
    // preventing against multiple instantiations
    $.fn[pluginName] = function ( options ) {
                var instance;
                if ( typeof options === 'string' ) { 
                // call method
                var args = Array.prototype.slice.call( arguments, 1 );
                                                                this.each(function() {
                    instance = $.data( this, "plugin_" + pluginName );
                    if ( !instance ) {
                        if (window.console) {
                            window.console.error( "cannot call methods on hpInstallables prior to initialization; " +
                                "attempted to call method '" + options + "'" );
                        }
                        return;
                    }
                    if ( !$.isFunction( instance[options] ) || options.charAt(0) === "_" ) {
                        if (window.console) {
                            window.console.error( "no such method '" + options + "' for hpInstallables instance" );
                        }
                        return;
                    }
                    // apply method
                                instance[ options ].call( instance, args );
                });  
              }
               else{
        return this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin( this, options ));
               }

        });
        }
    };


}(jQuery));
});
                
