//                                    OM
/******************************************************************************
 * @file jquery.hpsumWarnings.js
 * @author  Boa <zao-bao.zhang@hp.com>
 *
 *
 * @section LICENSE
 *
 * HP Confidential
 * Copyright 2015 Hewlett-Packard Development Company, L.P.
 *
 * @section DESCRIPTION
 *
 * This is a plugin for the showing the Warnings/Alerts found by node.
 *
 *
 *******************************************************************************/
define(['hp/core/Localizer',
        'jquery',
        'hp/lib/jquery.hpStatus',
        'hp/lib/jquery.hpToggle'],
function(localizer) {
    "use strict";
    //Lets create the plugin.
    (function($) {

        //Adding the plugin as jquery extension.
        $.fn.hpsumWarnings = function(item, action_required, id) {
			//Write the plugin here
			var warnings = item.warnings || [];
			if (warnings.length > 0) {
				$('#hpsum-warnings-collapsible').removeClass('hp-collapsed');
			}
			var html = "";
			for (var len = 0; len < warnings.length; len++) {
				html += '<div class="hpsum-warning"><label>' + warnings[len].replace(/\n/gi, "<br />") + '</label><br /></div>';
			}

			if (html != "") {
				if (action_required) {
					var nid = id ? 'id="' + id + '"' : "";
					html += '<label><input class="useWEBEMcheckbox ignorewarnings" type="checkbox" ' + nid + ' />' + localizer.getString('hpsum.common.ignoreWarnings') + '</label>';
				}
			} else {
				html = localizer.getString('hpsum.common.noWarnings');
			}
			$(this).html(html);
			
			var DEPLOY = '#hpsum-node-deploy-ok';
			$('.ignorewarnings').on('change', function(){
				if ($(DEPLOY)[0]) {
					if ($(this).is(':checked')) {
						$(DEPLOY).attr("disabled", $(DEPLOY).attr("disabled_org") == 1);
					} else {
						$(DEPLOY).attr("disabled", true);
					}
				}
			});
			
        };
    }(jQuery));
});