// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
//One Touch Update View
//Initial Version
define(['hp/view/AssociationAddView',
  'hp/view/DialogView',
  'hp/view/FormStateView',
  'hp/core/Router',
  'hpsum/presenter/baseline/BaselinePresenter',
  'hpsum/presenter/node/NodePresenter',
  'hp/services/REST',
  'hp/model/Session',
  'hp/core/Localizer',
  'hp/services/Log',
  'text!hpsumpages/one-touch-update/reboot_confirm.html',
  'hp/view/NotificationsView',
  'jquery',
  'hpsum/view/node/jquery.hpsumInstallables',
  'hpsum/view/node/jquery.hpsumInstallResults',
  'hpsum/view/node/jquery.hpsumAddNodeDetails',
  'hpsum/view/node/jquery.hpsumWarnings', 
  'hp/lib/jquery.hpPanels',
  'hp/lib/jquery.hpSelect',
  'lib/wizard',
  'hp/lib/jquery.hpCollapsible',
  'hp/lib/jquery.hpDropMenu',
  'hp/lib/jquery.hpProgressBar',
  'lib/jquery.validate',
  'hp/lib/jquery.hpSearchCombo',
  'hp/lib/jquery.hpStackedPanels',
  'hp/lib/jquery.hpToggle'],
function(AssociationAddView, DialogView, FormStateView, router, BaselinePresenter, NodePresenter, rest, session, localizer, Log , rebootConfirmHtml,NotificationsView) { "use strict";

    var OneTouchUpdateView = (function() {

		var VIEW = '#one-touch-page';      
        var PANELS = '.hp-panels';
        var DELTA_BASE = '#hpsum-home-delta-base';
        var NODES_TABLE = '#nodes';
        var ADD_NODES = '#hpsum-nodes-add';
        var NODES_MESSAGE = '#hpsum-nodes-message';
        var BASELINES_TABLE = '#baselines';
        var ADD_BASELINES = '#hpsum-baselines-add';
        var BASELINES_MESSAGE = '#hpsum-baselines-message';
        var ACTION_DIALOG = '#hpsum-action-dialog';
        var INVENTORY_BASELINE_TABLE = '#hpsum-otu-inventory-baseline',
        	INVENTORY_NODE_TABLE = '#hpsum-otu-inventory-node',
        	INSTALLPROGRESS_TABLE = '#hpsum-otu-install-progress',
        	COMPONENT_DIALOG = '#hpsum-component-dialog',
        	SPLASH_DIALOG = '#hpsum-splash-dialog',
        	SPLASH_SPINNER = '#hpsum-splash-spinner',
        	AUTOMATIC_UPDATE_CONFIRM = '#automatic-confirmation-dialog';
		var baselines='',
    		hotfixes='';
		var newBaseline = null,
    		newHotFix  = null;
		var isGuidedUpdateWithBaselines = false;
		var nodeChanges = [];
		var bInAnalysis = false;
        	
        var STEP_INVENTORY = 0, STEP_REVIEW = 1, STEP_DEPLOY = 2;

        var NOTIFY_STATUSES = {error:'error', warning:'warning', unknown:'info'};
		var selectionChange = false;
		var deployToDo = false;
		
		
		/** 
		 * Disabling all the features excluding one touch update in offline mode. 
		*/
		
		var guimode = session.getProperty("gui_mode");

        if (guimode === "offline_automatic" || guimode === "offline_interactive" || guimode === "express") {

				$('#hp-main-menu-control').css('display', 'none');
				$('#hp-search-control').css('display', 'none');
				$('#hp-session-control').css('display', 'none');
				$('#hp-activity-control').css('display', 'none');
        }

        
        /**
         * Constructor
         */
        function OneTouchUpdateView() {
          
          	var associationsNodesTable = null;
          	var associationsBaselinesTable = null;
            var allNodes = [], allBaselines = [];
            var currNodes = [], currBaselines = [];
            var actionDialogContents;
            var bModeInteractive=false, bModeNonInteractive=false, bInProgress=false;
            var baselineIterator, nodeIterator;
            var progressTimer, bBaselineInventoryDone;
            var componentLogDialogContents;
            var bLoadMulti = false;
            var actiondialog;
            var abortButtonPressed = false;
            var bStartDeploy = false;
            var gnodeNodeSettings = [];
            var gnodeWarnings = "";
            var notificationsView = new NotificationsView();
            var status,summary,details;
            var notificationsCleared = true;
            var modeValue, nodeValue;
            var autoConfDialogContents, autoConfDialog;
            var selectedNode;
			var nodeadded;
            function initActionNodeTable() {
				
				//Initialize nodes table in the action dialog
            	associationsNodesTable = $(NODES_TABLE).dataTable({
                    bPaginate : false,
                    bFilter : true,
                    bInfo : false,
                    bSort : false,
                    bRetrieve : false,
					bAutoWidth : false,
                    bDestroy : true,
                    aaData: currNodes,
                    aoColumns : [
                        {sTitle: localizer.getString("hpsum.menu.node"), mDataProp: 'node'},
                        {sTitle: localizer.getString("hpsum.common.type"),  mDataProp: 'descr'},
                        {mDataProp: 'uri', "bVisible": false},
                        {mDataProp: 'uname', "bVisible": false},
                        {mDataProp: 'pwd', 
                        fnRender: function (oObj) {
                            return '<div class="hp-close"></div>';
                        }, sClass: 'hp-icon', sWidth: 20}]
                });
                
                $(NODES_TABLE + ' .hp-close').click(onDeleteNode);
			$(NODES_MESSAGE).text('');
            }
            
            function initActionBaselineTable() {
            	
            	//Initialize baselines table in the action dialog
            	associationsBaselinesTable = $(BASELINES_TABLE).dataTable({
                    bPaginate : false,
                    bFilter : true,
                    bInfo : false,
                    bSort : false,
                    bRetrieve : false,
					bAutoWidth : false,
                    bDestroy : true,
                    aaData: currBaselines,
                    aoColumns : [
                        {sTitle: localizer.getString("hpsum.common.baseline"), mDataProp: 'baseline', sDefaultContent:''},
                        {sTitle: localizer.getString("hpsum.common.locationStr"), mDataProp: 'descr', sDefaultContent:''},
                        {mDataProp: 'uri', "bVisible": false},
                        {mDataProp: 'name',
                        fnRender: function (oObj) {
                            return '<div class="hp-close"></div>';
                        }, sClass: 'hp-icon', sWidth: 20}
                    ]
                });
                
                $(BASELINES_TABLE + ' .hp-close').click(onDeleteBaseline);
				$(BASELINES_MESSAGE).text('');
            }
                                    
            function getNodeAssociations(search) {
                var regexp = new RegExp(search, 'i');
                var results =
                    $.grep(allNodes, function(result, index) {
                        // exclude existing
                        if ($.grep(currNodes, function(result2, index2) {
                            return (result2.node === result.node);
                        }).length > 0) {
                            return false;
                        }
                        // check search
                        if (search && search.length > 0) {
                            return (result.node.match(regexp) ||
                                    result.descr.match(regexp));
                        }
                        return true;
                    });
                return ({count: results.length, members: results});
            }
            
            function getBaselineAssociations(search) {
                var regexp = new RegExp(search, 'i');
                var results =
                    $.grep(allBaselines, function(result, index) {
                        // exclude existing
                        if ($.grep(currBaselines, function(result2, index2) {
                            return (result2.uri === result.uri);
                        }).length > 0) {
                            return false;
                        }
                        // check search
                        if (search && search.length > 0) {
                            return (result.baseline.match(regexp) ||
                                    result.descr.match(regexp));
                        }
                        return true;
                    });
                return ({count: results.length, members: results});
            }
            
            function onDeleteNode(event) {
                var row = $(this).parents('tr')[0];
                var association = associationsNodesTable.fnGetData(row);
                
                if(association === null)
                	return;
                	
                currNodes = $.grep(currNodes, function (association2) {
                    return association2.uri !== association.uri;
                });
                associationsNodesTable.fnDeleteRow(row);
                $(NODES_MESSAGE).
                    text('Removed ' + association.node);
                event.stopPropagation();
				
				if (allNodes.length == currNodes.length)
					$(ADD_NODES).attr("disabled","disabled");
				else
					$(ADD_NODES).removeAttr("disabled");
            }
            
            function onDeleteBaseline(event) {
                var row = $(this).parents('tr')[0];
                var association = associationsBaselinesTable.fnGetData(row);
                
                if(association === null)
                	return;
                	
                currBaselines = $.grep(currBaselines, function (association2) {
                    return association2.uri !== association.uri;
                });
                associationsBaselinesTable.fnDeleteRow(row);
                $(BASELINES_MESSAGE).
                    text('Removed ' + association.baseline);
                event.stopPropagation();
				
				if (allBaselines.length == currBaselines.length)
					$(ADD_BASELINES).attr("disabled","disabled");
				else
					$(ADD_BASELINES).removeAttr("disabled");
            }
            
            function onAddNodes() {
                var numAdded = 0;
                new AssociationAddView({
                    title: "Add Nodes",
                    dataTableOptions:  {
                        aoColumns : [
                          {sTitle: localizer.getString("hpsum.menu.node"), mDataProp: 'node', sWidth: 100},
                          {sTitle: localizer.getString("hpsum.common.type"), mDataProp: 'descr', sWidth: 200},
                          {mDataProp: 'uri', bVisible: false},
                          {mDataProp: 'uname', bVisible: false},
                          {mDataProp: 'pwd', bVisible: false}
                        ]
                    },
                    getResults: function (query, handlers) {
                        // simulate error if string is "error"
                        if ('error' === query) {
                            localizer.getString("hpsum.oneTouchUpdate.addBaselinesError");
                        } else {
                            // It is assumed this would be performed on the server side
                            handlers.success(getNodeAssociations(query));
                        }
                    },
                    apply: function (results) {
                        numAdded += results.length;
                        currNodes = currNodes.concat(results);
                        associationsNodesTable.fnAddData(results);
                        associationsNodesTable.fnAdjustColumnSizing();
                        $(NODES_TABLE + ' .hp-close').
                            click(onDeleteNode);
                        $(NODES_MESSAGE).
                            text(numAdded + ' ' + localizer.getString("hpsum.common.added") + ' ');
							
						if (allNodes.length == currNodes.length)
							$(ADD_NODES).attr("disabled","disabled");
						else
							$(ADD_NODES).removeAttr("disabled");
                    }
                });
            }
            
            function onAddBaselines() {
                var numAdded = 0;
                new AssociationAddView({
                    title: localizer.getString("hpsum.oneTouchUpdate.addBaselines"),
                    dataTableOptions:  {
                        aoColumns : [
                          {sTitle: localizer.getString("hpsum.common.baseline"), mDataProp: 'baseline', sWidth: 100, sDefaultContent: ''},
                          {sTitle: localizer.getString("hpsum.common.locationStr"), mDataProp: 'descr', sWidth: 200, sDefaultContent: ''},
                          {mDataProp: 'uri', bVisible: false},
						  {mDataProp: 'name', "bVisible": false}
                        ]
                    },
                    getResults: function (query, handlers) {
                        // simulate error if string is "error"
                        if ('error' === query) {
                            handlers.error(localizer.getString("hpsum.oneTouchUpdate.addBaselinesError"));
                        } else {
                            // It is assumed this would be performed on the server side
                            handlers.success(getBaselineAssociations(query));
                        }
                    },
                    apply: function (results) {
                        numAdded += results.length;
                        currBaselines = currBaselines.concat(results);
                        associationsBaselinesTable.fnAddData(results);
                        associationsBaselinesTable.fnAdjustColumnSizing();
                        $(BASELINES_TABLE + ' .hp-close').
                            click(onDeleteBaseline);
                        $(BASELINES_MESSAGE).
                            text(numAdded + ' ' + localizer.getString("hpsum.common.added") + ' ');
							
						if (allBaselines.length == currBaselines.length)
							$(ADD_BASELINES).attr("disabled","disabled");
						else
							$(ADD_BASELINES).removeAttr("disabled");
                    }
                });
            }
            
            function getAllNodesSuccess(data) {

				allNodes = [];
            	currNodes = [];
            	
            	//add default localhost into the list
            
                for (var i=0; i< data.hapi.output_data.nodes.node.length; i+=1) {
                    allNodes.push({
                        node: data.hapi.output_data.nodes.node[i].node_name,
                        descr: data.hapi.output_data.nodes.node[i].type,
                        uri: data.hapi.output_data.nodes.node[i].node_uri,
						node_id: data.hapi.output_data.nodes.node[i].node_id,
						node_phase: data.hapi.output_data.nodes.node[i].node_phase,
                        uname: "",
                        pwd:""
                    });
					
				if(data.hapi.output_data.nodes.node[i].node_name === 'localhost')
				{
					currNodes.push({
                        node: "localhost",
                        descr: data.hapi.output_data.nodes.node[i].type,
                        uri: "",
                        uname:"",
						id: data.hapi.output_data.nodes.node[i].node_id,
                        pwd:""
                    });
					}
                }
			
                //Initialize action dialog node table with default value
                initActionNodeTable();
                
                bLoadMulti = true;
				
				if (allNodes.length == currNodes.length)
					$(ADD_NODES).attr("disabled","disabled");
				else
					$(ADD_NODES).removeAttr("disabled");
				
				//var nodeValue = $('input[name="node-option"]:checked').val();
				var nodeValue = $('input[name="node-option"]').val();
				nodeOptions(nodeValue);
            }
            
            function getAllNodesError(error) {
                
            }
            
            function getBaselineSuccess(baselines) {
            	
            	allBaselines = [];
            	currBaselines = [];
            	
            	//add default baseline into the list
            	allBaselines.push({
                        baseline: "default",
                        descr: 'default',
                        uri: "default",
						name:"default"
                   	});
                
                //Only add default working directory as default location which is selected for operation
                //if user wants to add more baselines then he can use Add Baselines button to add more   	
                currBaselines.push({
                        baseline: "default",
                        descr: 'default',
                        uri: "default",
                        name:"default"
                   	});
                
                for(var i=0; i < baselines.length; i++)
            	{
            	    allBaselines.push({
                        baseline: baselines[i].baseline_name,
                        descr: baselines[i].baseline_url,
                        uri: baselines[i].baseline_uri,
			name:baselines[i].baseline_name
                    });
                }
                
                //Initialize action dialog baseline table with default value
                initActionBaselineTable();
                
                bLoadMulti = true;
				
		if (allBaselines.length == currBaselines.length)
			$(ADD_BASELINES).attr("disabled","disabled");
		else
			$(ADD_BASELINES).removeAttr("disabled");
            }
            
            function getBaselineError(error) {
                
            }
            
            function loadBaselines() {
            	
            	var handlers =	{
                    			success : function(data) {
                        			getBaselineSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			getBaselineError(errorInfo);
                    			}
                			};
                
                BaselinePresenter.getBaselines(handlers);
            }
            
            function loadNodes() {
            	
            	var handlers =	{
                    			success : function(data) {
                        			getAllNodesSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			getAllNodesError(errorInfo);
                    			}
                			};
            		
        		NodePresenter.getAllNodes(handlers);
            }
            
            function btnNextClicked(i) {  
				
				
                switch (i) {
                	case 0:
                        
                        initNodeSettings();
                        
                        if(bModeNonInteractive)
                        	return 0; 
                        
                        $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step-selected");
                        $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step");
                        
                        return 1;
					case 1:
                      deployToDo = true;
                        
                        //call analyze if any changes to the selection
                        if(selectionChange == true &&
                        	bModeNonInteractive == false)
                        {
                        		//if no changes to component selection, go directly to deploy
                        		btnAnalyzeClicked(STEP_REVIEW, true)();							
                        	return -1;
                        }
                        else
                        {
                        		//if no changes to component selection, go directly to deploy
                        		initDeploy();
                        }
                        
                        return 2;
					case 2:
                        $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
                        //handle Reboot functionality here
                        break;
				}
            }
			
			function btnPrevClicked(i) {                
                switch (i) {
					case 1:
                        $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step-selected");
                        $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step");
                        return 0;
					case 2:
						
						$("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step-selected");
                        $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step");
                        //Handle reset functionality here as the name of the button is changed reset in this step
						initReset();
						return 0;
						
                    case 3: 
						$("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
                        break;
				}
            }
			
			function abortBaselines(step) {
				//not yet implemented in baseline manager.. so not functional
			}
			
			function abortNodes(step) {
				
				var nodes = [];
	        	var uri, index, op_status;
	        	var oNodeTable;
	        		
				if(step == 0){
					//iterate through node inventory table 
					//if node is in inventory state, then only send abort command
					oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
	            		
	        		if(oNodeTable)
	        			nodes = oNodeTable.fnGetData();
	        	}
	        	else if(step == 2)
	        	{
	        		oNodeTable = $(INSTALLPROGRESS_TABLE).dataTable();
	            		
	        		if(oNodeTable)
	        			nodes = oNodeTable.fnGetData();
	        	}
	        	
	            //add each node, check the current state and send abort command if require
        		for(var i=0; i < nodes.length; i++)
        		{
        			var list = nodes[i].node_uri.split("/");
					var nodeid = list[4];
					op_status = nodes[i].op_status;
					
					if(op_status === "inprogress")
					{
						NodePresenter.abortNode(nodeid, {
							row: i,
							node_id: nodeid,
							success: function(data){
								if(data.hapi.hcode == 0){
									oNodeTable.fnUpdate('abort_success', this.row, 6);
									oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.userAborted"), this.row, 2);
									oNodeTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
									
									if(step == STEP_INVENTORY)
									   oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.nodeInventoryAborted"), this.row, 4);
									else if (step == STEP_DEPLOY)
									   oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.nodeDeployAborted"), this.row, 4);
								}
								else
								{
									oNodeTable.fnUpdate('abort_error', this.row, 6);
									oNodeTable.fnUpdate(data.hapi.hmessage, this.row, 2);
									oNodeTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">ok</span></div></div>', this.row, 0);
								}
								
								$('#node-progress-' + this.node_id).hpProgressBar(0);
							},
							error: function (errorinfo){
								oNodeTable.fnUpdate('abort_error', this.row, 6);
								oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.userAbortedError"), this.row, 2);
								oNodeTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
							}
						});
					}
				}
			}
			
			//Handle abort functionality here
			function btnAbortClicked(i) {
				
				//Baseline abort is not yet implemented in engine
				abortBaselines(i);
				
                //issue abort command for each node. Based on the result, update the node state column
                abortNodes(i);

                //Disable the next button since we aborted the process.
                disableNextButton(i);
                disableAbortButton(i);
                enableResetButton(i);

                abortButtonPressed = true;
            }
            
            function rebootNodes()
            {
            	//Issue reboot command activate to all the nodes 
                //Later on this needs to be enhanced based on node return code (when it is available in REST API)
				var nodes = [];
	        	var uri, index, op_status;
	        	var oNodeTable;
	        		
				oNodeTable = $(INSTALLPROGRESS_TABLE).dataTable();
            		
        		if(oNodeTable)
        			nodes = oNodeTable.fnGetData();
	        	
	            //for each node, check the current state and send activate command if require
        		for(var i=0; i < nodes.length; i++)
        		{
        			var list = nodes[i].node_uri.split("/");
					var nodeid = list[4];
					op_status = nodes[i].op_status;
					
					if(op_status === "done")
					{
						NodePresenter.rebootNode(nodeid, {
							row: i,
							node_id: nodeid,
							success: function(data){
								if(data.hapi.hcode == 0){
									oNodeTable.fnUpdate(localizer.getString('hpsum.RebootConfirm.node'), this.row, 2);
								}
								else
								{
									oNodeTable.fnUpdate(data.hapi.hmessage, this.row, 2);
								}
							},
							error: function (errorinfo){
								oNodeTable.fnUpdate(localizer.getString('hpsum.RebootConfirm.errorReboot'), this.row, 2);
							}
						});
					}
				}
            }
            
            //Handle reboot functionality here
            function btnFinishClicked(step) {                
                
                if(step != 2)
					return;
				
				var contents = $(rebootConfirmHtml);
                localizer.localizeDom(contents);
                $('#hpsum-otu-reboot-title', contents).text(
                    localizer.getString('hpsum.RebootConfirm.title'));
                
                var dialogView = new DialogView();
                dialogView.init({contents: contents,
                	ok: function () {
                    	rebootNodes();
                    },
                    cancel: function () {
                        return;
                    }
                });
	        }
            
            function btnResetClicked(step) {
                
                if(!$('#step' + step + 'Reset').hasClass("hp-disabled")) {
					initReset();
                    //showActionDialog();
                }
			}
			
			function selectBaseline() {
				$('#hpsum-otu-inventory-baseline-collapse').hide();
				$('#hpsum-otu-action-title-message').text(localizer.getString("hpsum.oneTouchUpdate.nodeInventoryTitle"));
				isGuidedUpdateWithBaselines = false;
				//(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
                baselines = hotfixes = localizer.getString('core.loading'); 
                 	NodePresenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
                $(PANELS).hpStackedPanels('resume');
                $(OK).removeAttr("disabled");
                if( $(ASSIGN_BASELINE_CHECK_BOX).is(':checked') ) {
					$('#hpsum-one-touchupdate-assign-baseline-span').show ();
					if(assocHotFix != null){
        				$(ASSOCHOTFIX).text(assocHotFix.name);
        				$(REMOVEHOTFIX).show();
        				}
				}
				else {
					$('#hpsum-one-touchupdate-assign-baseline-span').hide ();
				}
			}
			
			function showAnalysisSplash(){
				
				 $(SPLASH_DIALOG).dialog({
			        modal : true,
			        position : "center",
			        draggable : false,
			        resizable : false,
			        show : 'fade',
			        dialogClass : 'hp-splash-dialog',
			        width : 400
			    });
			    
			    $(SPLASH_SPINNER).show();	
			}
			
			function closeAnalysisSplash(){
				$(SPLASH_SPINNER).hide();
				$(SPLASH_DIALOG).dialog('destroy');
			}
			
			function btnAnalyzeClicked(step, bdeploy) {
				
				var nodes = [];
	        	var uri, index, op_status;
	        	var oNodeTable;
	        	
				bInAnalysis = true;
				
				//iterate through node inventory table 
				//if node is in inventory state, then only send abort command
				oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
	            		
	        	if(oNodeTable)
	        		nodes = oNodeTable.fnGetData();
	        	
	        	if(nodes.length > 0)
	        	{
	        		var breturn=true;
	        		for(var i=0; i < nodes.length; i++)
        			{
        				var opstatus = nodes[i].op_status;
        				if(opstatus === "done")
        				{
        					breturn = false;
        					break;
        				}
        			}
        			
        			if(breturn)
	        			return;
	        	}
	        	
	        	showAnalysisSplash();
	        	
			var nodesprocessed=0;
	        	//add each node table send analysis command
        		for(var i=0; i < nodes.length; i++)
        		{
        			var list = nodes[i].node_uri.split("/");
					var nodeid = list[4];
					op_status = nodes[i].op_status;
					
					if(op_status === "done")
					{
						var inst = $('#hpsum-otu-node-'+ nodeid +'-installable').data('plugin_hpsumInstallables');
						if(inst == undefined)
						continue;
			 			var componentsList = inst.getComponents();
			 			
			 			var item = {node_id: nodeid};
			 			
			 			oNodeTable.fnUpdate('analyze_inprogress', i, 6);
						nodesprocessed++;
			 
						NodePresenter.analysis(item, componentsList, {
								node_id: nodeid,
                    			success : function(data) {
                        			analyzeSuccess(data, this.node_id);
                        		},
                    			error : function(errorInfo) {
                        			analyzeError(errorInfo);
                    			}
                		});
					}
				}
					if(nodesprocessed == 0) {
						closeAnalysisSplash();
						disableAnalyzeButton(STEP_REVIEW);
						return;
					}
				
				var NodesDoneCount=0;
		        
		        var progressTimer = setInterval(function () {
		        	
		        	oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
	            		
	        		if(oNodeTable)
	        			nodes = oNodeTable.fnGetData();
	        		
		        	//start inventory for each baseline
            		for(var i=0; i < nodes.length; i++)
            		{
            			var uri = nodes[i].node_uri;
            			var vals = uri.split("/");
            			var nodeid = vals[4];
            			var index = i;
            			var op_status = nodes[i].op_status;
            			
            			//if current operation status is started, then only start the inventory, otherwise no need to start inventory
            			if(op_status === "analyze_inprogress") {
	            				
				        	rest.getURI(uri + "/getstatus", {
		                			row: index,
		                			node_id: nodeid,
		                			success : function(data) {
		                				
		                				if(data.hapi.node_status.node_state === "ANALYSIS")
		                				{
		                					
		                				}
		                				else if(data.hapi.node_status.node_state === "UAN")
		                				{
		                					
		                					oNodeTable.fnUpdate('done', this.row, 6);
		                					
		                					NodesDoneCount++;
		                				}
		                				else if(data.hapi.node_status.node_state === "ERROR")
		                				{
		                					
		                					oNodeTable.fnUpdate('done', this.row, 6);
		                					
		                					NodesDoneCount++;
		            					}
		            					else if(data.hapi.node_status.node_state === "PENDING_FW_UPDATE")
		                				{
		                					
		                					oNodeTable.fnUpdate('done', this.row, 6);
		                					
		                					NodesDoneCount++;
		            					}
		            				},
		                			error : function(errorInfo) {
		                    			
		                			}
		            			});
		            		}
		            	}
		            	
		            	if(NodesDoneCount >= nodes.length) {
		            		//stop the timer
	            			clearInterval(progressTimer);
							progressTimer = null;
	            			
	            			//show install review for all the nodes
					        initInstallReview(bdeploy);
						    
					        closeAnalysisSplash();
							
					    }
						
		        }, 3000);
			}
			
			function analyzeSuccess(data, nodeid) {
				
			}
			
			function analyzeError(error) {
				$(SPLASH_SPINNER).hide();
				$(SPLASH_DIALOG).dialog('destroy');
			}
			
			function enableAbortButton(step) {
				$('#step' + step + 'Abort').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
			}
			
			function disableAbortButton(step) {
				$('#step' + step + 'Abort').removeClass("hp-button hp-secondary").addClass("hp-button hp-secondary hp-disabled");
			}
			
			function enableNextButton(step) {
				if ($(".ignorewarnings")[0]) {
					$(".ignorewarnings").attr("nextclass", "hp-button hp-primary");
					$(".ignorewarnings").attr("nextid", '#step' + step + 'Next');
				}
				$('#step' + step + 'Next').removeClass("hp-button hp-primary hp-secondary hp-disabled");
				if ($(".ignorewarnings")[0] && !$(".ignorewarnings").is(':checked')) {
					$('#step' + step + 'Next').addClass("hp-button hp-secondary hp-disabled");
				} else {
					$('#step' + step + 'Next').addClass("hp-button hp-primary");
				}
			}
			
			function disableNextButton(step) {
				if ($(".ignorewarnings")[0]) {
					$(".ignorewarnings").attr("nextclass", "hp-button hp-secondary hp-disabled");
					$(".ignorewarnings").attr("nextid", '#step' + step + 'Next');
				}
				$('#step' + step + 'Next').removeClass("hp-button hp-primary hp-secondary hp-disabled");
				$('#step' + step + 'Next').addClass("hp-button hp-secondary hp-disabled");
			}
			
			function enableResetButton(step) {
				$('#step' + step + 'Reset').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
			}
			
			function disableResetButton(step) {
				$('#step' + step + 'Reset').addClass("hp-button hp-secondary hp-disabled");
			}
			
			function enableBackButton(step) {
				$('#step' + step + 'Prev').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
			}
			
			function disableBackButton(step) {
				$('#step' + step + 'Prev').removeClass("hp-button hp-secondary").addClass("hp-button hp-secondary hp-disabled");
			}
			
			function enableAnalyzeButton(step) {
				$('#step' + step + 'Analyze').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
				
				//Disable Deploy button if analyze button is enabled and vice versa
				//disableNextButton(step);
				// enableNextButton(step);
			}
			
			function disableAnalyzeButton(step) {
				$('#step' + step + 'Analyze').addClass("hp-button hp-secondary hp-disabled");
				
				//enable Deploy button if analyze button is disabled and vice versa
				//before enabling Deploy button, make sure no failed dependency components are selected.. TODO
				//enableNextButton(step);
			}
						
			function enableRebootButton(step) {
				$('#step' + step + 'Reboot').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
			}
			
			function disableRebootButton(step) {
				$('#step' + step + 'Reboot').removeClass("hp-button hp-secondary").addClass("hp-button hp-secondary hp-disabled");
			}
			
			function hideAllButtons(step) {
				var parent = $('#step' + step + 'commands');
				
				//Only show the Abort and Reset buttons and hide all other buttons
				parent.find('.hp-button').each(function() {				    
				    if(!($(this).attr('id').match(/abort/i) || $(this).attr('id').match(/reset/i)))
				        $(this).hide();				    
				});
			}
			
			function showAllButtons(step) {
				var parent = $('#step' + step + 'commands');
				
                parent.find('.hp-button').each(function() {
                    $(this).show();
                });
			}
			
			function showDeployButton(step) {
				$('#step' + step + 'commands').show();
				enableNextButton(step);
				enableResetButton(step);
				$('#step' + step + 'Prev').hide();
				$('#step' + step + 'Analyze').hide();
			}
			
			function showWizardStep(step) {
				$('#step' + step).show();
			}
			
			function hideWizardStep(step) {
				$('#step' + step).hide();
			}
            
			function validateStep(i) {
                switch (i) {
                    case 1:  /*alert('This is validated by index'); */return true; 
                    default:
                        return true;
                }
            }
	
			function validateByTitle(title) {
				switch (title) {
	                case 'test':  /*alert('This is validated by title');*/ return true;
					default:
	                       return true;
                }
            }
            
            function showActionDialog() {
                
            	//show action dialog
            	actiondialog = new DialogView();
                actiondialog.init({contents: actionDialogContents,
                    ok: function (elem) {
                    },
                    cancel: function () {
					}
                });

                actiondialog.setMessage({summary: localizer.getString("hpsum.oneTouchUpdate.selectModeTypeDeployment"),
                    status: "ok",
                    details: localizer.getString("hpsum.oneTouchUpdate.moreDetails"),
                    actions: ""/*[linkTargetBuilder.makeLink('Edit device',
                      '/device/item1', 'edit', 'device')]*/
                }, true);
				$('#hpsum-action-ok-button',actionDialogContents).unbind('click').bind('click', onOkButton);
				$('#hpsum-action-cancel-button',actionDialogContents).unbind('click').bind('click', onCancelButton);
            }
			
			function onOkButton(){
			
				modeValue = $('input[name="mode-option"]:checked').val();
				//nodeValue = $('input[name="node-option"]:checked').val();
				nodeValue = $('input[name="node-option"]').val();

				var validBaseline = getBaselineData(nodeValue);
				var isValid = true;
				
				isValid = validateIPdetails(nodeValue);
				bInProgress = false;
				if(validBaseline && isValid){
					if(modeValue === "non-interactive-mode") {
						autoConfDialog = new DialogView();
                        autoConfDialog.init({contents: autoConfDialogContents,
							ok: function(elem){
								
								if (isGuidedUpdateWithBaselines == true){
									guidedUpdateWithBaselines ();
								}
								else {
									startOneTouchUpdate();
								}
							},
							cancel: function () {
								initReset();
							}
						});
					} else {
						if (isGuidedUpdateWithBaselines == true){
							guidedUpdateWithBaselines ();
						}
						else {
							startOneTouchUpdate();
						}
					}
					actiondialog.cancel();
				}
			}
			
			function onCancelButton() {
				var guimode = session.getProperty("gui_mode");
				 
				if(guimode !== "offline_automatic" &&
					guimode !== "offline_interactive" && guimode !== "express")
				{
					router.go('/welcome', 'canceled guided update');
				}
			}
            
            function indexLocation(data) {
            	
            	var i, uri;
            	
            	var oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
            	
            	//iterate through baselines and add them into baselines wizard table
            	for(i = 0; i < data.hapi.output_data.baselines.baseline.length; i += 1)
	        	{
	        		var item = [{status: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>', 
        			baseline_name: data.hapi.output_data.baselines.baseline[i].baseline_name,
        			baseline_status: localizer.getString("hpsum.oneTouchUpdate.baselineAdded"),
        			baseline_progress: '<div id="baseline-progress' + i + '" style="height:15px"></div>',
        			baseline_details: '',
        			baseline_uri: data.hapi.output_data.baselines.baseline[i].baseline_uri,
        			op_status: "started"}];
        			
        			//add baseline into baseline inventory table of step1 of wizard	    
					oTable.fnAddData(item);
					
					$('#baseline-progress' + i).hpProgressBar(0);
				}
				
				baselineIterator -= baselineIterator;
			}
            
            function onaddLocationSuccess(location, data, isExpressLocation) {
            	var canBeProceeded = false;
            	if(data.hapi.hcode != 0) {
            		onaddLocationError(location, data.hapi.hmessage);
            		return;
            	}
				
				var isBundleInvProgress = false;
				var location_id = data.hapi.command.output_data.location_id;
                //check whether any bundle under the location inventory is going on and then perform inventory on the location
				var uri = "/Session/" + session.getToken()  + "/Baseline/location/" + location_id + "/index";
				rest.getURI(uri, {
					success : function(data) {
						if (data.hapi.output_data.hasOwnProperty("baselines")) {
							var baselines = [];
							baselines = data.hapi.output_data.baselines.baseline;
							//Check the state of the baselines and set the isBundleInvProgress flag to true.
							for(var ind=0; ind < baselines.length; ind++) {
								var baselineInfo = baselines[ind];
								if (baselineInfo != undefined && baselineInfo.hasOwnProperty("baseline_uri") && baselineInfo.baseline_state != 'inventory_completed') {
									isBundleInvProgress = true;
								}
							}
						}
						if(!isBundleInvProgress)
						{
							//process the output and request for inventory of location
							var uri = "/Session/" + session.getToken() + "/Baseline/location/" + location_id + "/inventory";
							
							rest.getURI(uri, 
							{
								success : function(dataLocSuccess) 
								{
									//using timer here as sometimes index command will not provide any output if inventory is issued before
									//inventory command take some time to get the result
									//so checking until we get something out of index command  	
									var uri = "/Session/" + session.getToken()  + "/Baseline/location/" + location_id + "/getstatus";
									var timerGetstatus = setInterval(function() 
									{
										rest.getURI(uri.replace("inventory", "getstatus"),
										{
											success: function(data) { 
												if (data.hapi.location_state == "inventory_completed") 
												{
													canBeProceeded = true;
													clearInterval(timerGetstatus);
													if (data.hapi.total_no_of_bundle > 1){
														var error = localizer.getString("hpsum.oneTouchUpdate.moreBundles") + location + localizer.getString("hpsum.oneTouchUpdate.onlyOneAllowed");
														onaddLocationError(localizer.getString("hpsum.oneTouchUpdate.addBaseline"), error);
														canBeProceeded = false;
													}
													if (canBeProceeded == true) 
													{
														rest.getURI(uri.replace("getstatus", "index"), 
														{
															success: function(dataIndex) {
																if(dataIndex.hapi.output_data.baselines.baseline.length > 0) {
																	indexLocation(dataIndex);
																	clearInterval(timerGetstatus);
																}
																else
																{
																	clearInterval(timerGetstatus);
																	onaddLocationError(localizer.getString("hpsum.oneTouchUpdate.additionalPackage"), (localizer.getString("hpsum.oneTouchUpdate.noCompFound")+ " " +location));
																	if(isExpressLocation == false)
																	{
																		enableResetButton(STEP_INVENTORY);
																	}
																}
																//otherwise also check whether inventory is completed or still in progress
															},
															error: function(error) {
																clearInterval(timerGetstatus);
																handleExpressExit();
															}
														}); 
													}
												}
											},
											error: function(data) {
												onaddLocationError(location, localizer.getString("hpsum.oneTouchUpdate.failedToAddBaseline"));
												clearInterval(timerGetstatus);
												canBeProceeded = true;
											}
										});
									}, 15000);
								},
								error : function(errorInfo) {
									onaddBaselineError(location_id, errorInfo);
									handleExpressExit(data);
								}
							});
						}
						else
						{
							if(data.hapi.output_data.baselines.baseline.length > 0) {
								indexLocation(data);
							}
						}
					},
					error : function(data) {
					}
				});
			}
            
            function onaddLocationError(location_id, error) {
            	//handle error condition
            	var oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
								
			    oTable.fnClearTable();
			    
			    var item = [{status: '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', 
    			baseline_name: location_id,
    			baseline_status: localizer.getString("hpsum.oneTouchUpdate.failedToAddBaseline"),
    			baseline_progress: '',
    			baseline_details: error,
    			baseline_uri: location_id,
    			op_status: 'error'}];

				//add baseline into baseline inventory table of step1 of wizard	    
				oTable.fnAddData(item);
            	var data = { hapi: {
						message: error
						}};				
				handleExpressExit(data);
            }
            
            function onaddNodeSuccess(node_name, node_type, data) {
            	
            	//process the output and request for inventory of location
            	var oTable = $(INVENTORY_NODE_TABLE).dataTable();
								
			    var item = [{status: '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', 
                			node_name: node_name,
                			node_status: localizer.getString("hpsum.oneTouchUpdate.addedNode"),
                			node_progress: '<div id="node-progress-' + data.hapi.node_id + '" style="height:15px"></div>',
                			node_details: '',
                			node_uri: "/Session/" + session.getToken() + "/node/" + data.hapi.node_id,
                			op_status: "started",
                			progress: 0,
                			node_type: node_type}];
				
				//add node into node inventory table of step1 of wizard	    
				oTable.fnAddData(item);
				
				$('#node-progress-' + data.hapi.node_id).hpProgressBar(0);
					NodePresenter.setNodeForAdvOptions({node_name: node_name, node_id: data.hapi.node_id});
				
				nodeIterator -= nodeIterator;
			}
            
            function onaddNodeError(node_name, error) {
            	//handle error condition
            	var oTable = $(INVENTORY_NODE_TABLE).dataTable();
								
			    var item = [{status: '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', 
                			node_name: node_name,
                			node_status: localizer.getString("hpsum.oneTouchUpdate.failedToAddNode"),
                			node_progress: '',
                			node_details: localizer.getString("hpsum.common.error"),
                			node_uri: node_name,
                			op_status: 'error',
                			progress: 0}];

				//add node into node inventory table of step1 of wizard	    
				oTable.fnAddData(item);
				handleExpressExit();
            }
            
            function startOneTouchUpdate() {
            	
		var error_condition = false; 
            	if(bInProgress == true)
            		return;
            	
            	bStartDeploy = false;
            		
            	//get the selected mode, node option, baselines, nodes
            	var nodes = [], baselines = [];
            	            	
            	baselineIterator=0, nodeIterator=0;
            	
            	//Flag is set to indicate one touch update is in progress
            	bInProgress = true;
            	//Initialize the wizard steps
            	showWizardStep(STEP_INVENTORY);
            	hideWizardStep(STEP_REVIEW);
            	hideWizardStep(STEP_DEPLOY);
            	
            	//Disable next button by default till inventory is done
            	disableNextButton(STEP_INVENTORY);
            	//disable abort button, enable when inventory is in progress
            	disableAbortButton(STEP_INVENTORY);
            	//disable reset button, enable after inventory is completed
            	disableResetButton(STEP_INVENTORY);
            	
            	$('#hpsum-otu-advance-action').removeClass('hp-disabled');
            	
            	bBaselineInventoryDone = false; //update this to true after all baselines inventory is done
            	
            	var guimode = session.getProperty("gui_mode");
            	//guimode is not defined
				
				var l_expLoc = session.getProperty("express_location");
				var isExpressLocation = false;
				if (typeof(l_expLoc) == "undefined"){
					isExpressLocation = false;
				}
				else {
					isExpressLocation = true;
				}
				if(modeValue != undefined)
				{
					if(modeValue === "interactive-mode")
	            	{
	            		bModeInteractive = true;
	            		bModeNonInteractive = false;
	            		
	            		showAllButtons(STEP_INVENTORY);
	            	}
	            	else if(modeValue === "non-interactive-mode")
	            	{
	            		bModeInteractive = false;
	            		bModeNonInteractive = true;
	            		
	            		hideAllButtons(STEP_INVENTORY);
	            	}
				}
				else if(guimode && modeValue === undefined) 
            	{ 
            		//add default localhost into the list
            		nodes.push({
                        node: "localhost",
                        descr: '',
                        uri: "",
                        uname:"",
                        pwd:""
                    });
                    
                    //add default baseline into the list
            		baselines.push({
                        baseline: "default",
                        descr: 'default',
                        uri: "default",
						name:"default"
                   	});
                    
					if(guimode === "offline_automatic" || guimode === "express")
					{
						nodeValue = "one";
						bModeNonInteractive = true;
						bModeInteractive = false;
						
						hideAllButtons(STEP_INVENTORY);
					}
					else if (guimode === "offline_interactive")
					{
						bModeNonInteractive = false;
						bModeInteractive = true;
						showAllButtons(STEP_INVENTORY);
					}
				}
	            
	            if(bLoadMulti)
	            {
	            	if(nodeValue === "one") {
	            		//add localhost into the nodes list
	            		nodes = [];
	            		nodes.push({
	                        node: "localhost",
	                        descr: '',
	                        uri: "",
	                        uname:"",
	                        pwd:""
	                    });
	                    
	                    //add default baseline
	                    baselines = [];
	                    baselines.push({
	                        baseline: "default",
	                        descr: 'default',
	                        uri: "default",
							name:"default"
	                   	});
	            	}
		            else 
		            {
		        		var oBaselineTable = $(BASELINES_TABLE).dataTable();
		        	 	var oNodeTable = $(NODES_TABLE).dataTable();
		        	 	
		        	 	if(oNodeTable)
		        	 		nodes = oNodeTable.fnGetData();
		        	 	if(oBaselineTable)
		        	 		baselines = oBaselineTable.fnGetData();
		        	 }
	        	}
	        	
	        	var oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
            	oTable.fnClearTable();
            	
            	oTable = $(INVENTORY_NODE_TABLE).dataTable();
            	oTable.fnClearTable();
            	
            	//add all the baselines and node
                var ind;
                for(ind=0; ind < baselines.length; ind++) 
                {
                	var uri = baselines[ind].uri;
                	//if the baseline is not already added, then only add it, otherwise just add it to the table and check the status and issue inventory
                	if(uri === "default")
                	{
	                	baselineIterator++;
						if (isExpressLocation == true){
							uri = l_expLoc;
						}
	                	rest.postObject("Session/" + session.getToken() + "/Baseline/add", 
									{
									 hapi: { uri: uri, locationtype: 'local' }
									},  "", 
	            		         {
	            		         	location: uri,
	                    			success : function(data) {
										onaddLocationSuccess(this.location, data, isExpressLocation);
	                    		 	},
	                    			error : function(errorInfo) {
	                        			onaddLocationError(baselines[ind].baseline, errorInfo);
	                    			}
	                			}, {});
	                }
	                else 
	                {
	                	var item = [{status: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>', 
	        			baseline_name: baselines[ind].baseline,
	        			baseline_status: localizer.getString("hpsum.oneTouchUpdate.baselineAdded"),
	        			baseline_progress: '<div id="baseline-progress' + ind + '" style="height:15px"></div>',
	        			baseline_details: '',
	        			baseline_uri: baselines[ind].uri,
	        			op_status: "started"}];
	        			
	        			var oTmpTable = $(INVENTORY_BASELINE_TABLE).dataTable();
	        			
	        			//add baseline into baseline inventory table of step1 of wizard	    
						oTmpTable.fnAddData(item);
						
						$('#baseline-progress' + ind).hpProgressBar(0);
	                }
                }
                
                //add nodes
                for(ind=0; ind < nodes.length; ind++) 
                {
                	nodeIterator++;
                	var nodename = nodes[ind].node;
                	var nodetype = nodes[ind].descr;
                	var uri = nodes[ind].uri;
                	var item;
                	
                	//for localhost or default node
                	if(uri === "")
                	{
						if(nodeValue == "three")
						{
							item = {ip:nodes[ind].node, name: nodes[ind].node, type:nodes[ind].type, username:nodes[ind].uname, password:nodes[ind].pwd};
						}
						else
						{
                		item = {ip:nodes[ind].node, name: nodes[ind].node, type:'unknown', use_current_credentials: true};
						}
                	}
                	else
                	{
                		//node already added in the node screen
                		item = {ip:nodes[ind].node, name: nodes[ind].node};
                	}
                	setTimeout(function(){			
		                	rest.postObject("Session/" + session.getToken() + "/node/add", 
									{
									 hapi:item
									},  "", 
			        		        {
			        		        	node_name: nodename,
			        		        	node_type: nodetype,
			                			success : function(data) {
			                    			onaddNodeSuccess(this.node_name, this.node_type, data);
			                		 	},
			                			error : function(errorInfo) {
			                    			onaddNodeError(this.node_name, errorInfo);
			                			}
			            			}, {});
					},250);
               	} 
                var baselinesAdded = [], nodesAdded = [] , baselinesList = [];
                var remaining = 100;
                var bBaselinesDoneCount=0;
                var bNodesDoneCount=0,  baselineCount = 0;
                //check the progress of inventory operation every 2 secs
                //progressTimer = setInterval(checkProgress(), 2000);
				var oBaselineTable = $(INVENTORY_BASELINE_TABLE).dataTable();
				if(oBaselineTable)
	            			baselines = oBaselineTable.fnGetData();
					for(var i=0; i < baselines.length; i++)
					{
						var uri = baselines[i].baseline_uri;
						var	sub = uri.search("/location/");
						baselinesList[baselineCount++] = uri.substr(sub);
					}
                progressTimer = setInterval(function () {
                	
                	if(bModeNonInteractive)
                		hideAllButtons(STEP_INVENTORY);
                		
                	if(baselineIterator === 0 && bBaselineInventoryDone === false)
	            	{
	            		var oBaselineTable = $(INVENTORY_BASELINE_TABLE).dataTable();
	            		var uri, index, sub, op_status;
	            		
	            		if(remaining > 10)
		                	remaining -= 10;
	            		
	            		if(oBaselineTable)
	            			baselinesAdded = oBaselineTable.fnGetData();
	            		//start inventory for each baseline
	            		for(var i=0; i < baselinesAdded.length; i++)
	            		{
	            			uri = baselinesAdded[i].baseline_uri;
	            			index = i;
	            			op_status = baselinesAdded[i].op_status;
							
	            			//if currest operation status is started, then only start the inventory, otherwise no need to start inventory
	            			if(op_status === "started") {
	            				
	            				if(oBaselineTable){
				                	oBaselineTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', index, 0);
				                	oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), index, 2);
				                	oBaselineTable.fnUpdate('inprogress', index, 6);
				                	$('#baseline-progress' + index).hpProgressBar(1);
				                }
				                
		            			rest.getURI(baselinesAdded[i].baseline_uri + "/inventory", {
		            				row: index,
	                    			success : function(data) {
	                    				
	                    				var oTmpTable = $(INVENTORY_BASELINE_TABLE).dataTable();
	                    				//update status
	                    				if(oTmpTable){
						                	oTmpTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
						                	oTmpTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
						                	oTmpTable.fnUpdate('inprogress', this.row, 6);
						                }
						                
						                //update progress
						                $('#baseline-progress' + this.row).hpProgressBar(1);
						            },
	                    			error : function(errorInfo) {
	                        			//checkBaselineInventoryError(uri, index, errorInfo);
	                        			handleExpressExit();
	                    			}
		                		});
		                	}
		                	else if(op_status === "inprogress") {
		                		
		                		rest.getURI(uri + "/getstatus", {
		                			row: index,
                    				success : function(data) {
                    					//get the row index for the applicable baseline
	                    				if(data.hapi.baseline_state === "inventory_in_progress" || data.hapi.baseline_state === "manifest_component_processing")
	                    				{
	                    					var currprogress = (data.hapi.baseline_state_detail.current_progress/data.hapi.baseline_state_detail.total_no_component) * 100;
	                    					$('#baseline-progress' + this.row).hpProgressBar(currprogress);
						                	
	                    					oBaselineTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
	                    					oBaselineTable.fnUpdate( localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
	                    					var detail = data.hapi.baseline_state_detail.detail + " (" + data.hapi.baseline_state_detail.current_progress + "/" + data.hapi.baseline_state_detail.total_no_component + ")";
	                    					oBaselineTable.fnUpdate(detail, this.row, 4);
	                    					oBaselineTable.fnUpdate('inprogress', this.row, 6);
	                    				}
   	                 					else if(data.hapi.baseline_state === "inventory_completed")
	                    				{	
											var i = 0,j = 0,k = 0;
	                    					$('#baseline-progress' + this.row).hpProgressBar(100);
											var uri_new = '/location/' + data.hapi.location_id + '/bundle/' + data.hapi.baseline_id;
											for(i = 0; i < baselinesList.length ; i++)
											{
												if( baselinesList[i] == uri_new )
												{
													for(j = i, k = i+1; k <= baselineCount ; j++,k++)
													{
														baselinesList[j] = baselinesList[k];
													}
													baselineCount--;
												}
											}
											
	                    					oBaselineTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
	                    					oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryCompleted"), this.row, 2);
	                    					oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.totalComponents") + ' ' + data.hapi.baseline_state_detail.total_no_component, this.row, 4);
	                    					oBaselineTable.fnUpdate('done', this.row, 6);
	                    					
	                    					bBaselinesDoneCount++;
	                    				}
										else if(data.hapi.baseline_state === "inventory_Failed") {
	               		
																							
											var detail = '</br><a id="hpsum-startover-failed-inventory">' + localizer.getString("hpsum.common.startOver") + '</a>';
											var details =  data.hapi.baseline_state_detail.detail + detail;
											oBaselineTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
	                    					oBaselineTable.fnUpdate( localizer.getString("hpsum.baseline.show.inventoryFailed"), this.row, 2);	                    					
	                    					oBaselineTable.fnUpdate(details, this.row, 4);
	                    					oBaselineTable.fnUpdate('Failed', this.row, 6);
											enableAbortButton(STEP_INVENTORY);
											enableResetButton(STEP_INVENTORY);
										}
	                    				else if(data.hapi.baseline_state === "inventory_needed")
                    					{
                    						oBaselineTable.fnUpdate('started', this.row, 6);
                    					}
                    				},
                    				error : function(errorInfo) {
                    					handleExpressExit();
                        			}
                				});
		                		
		                	}
		                }
						if((bBaselinesDoneCount >= baselinesAdded.length) && (!baselineCount) )
	            			bBaselineInventoryDone = true;
	            	}
					$('#hpsum-startover-failed-inventory').click(function(){initReset();});            	
	            	//check if all the nodes are added successfully, we can carry on with the inventory operation
	            	//This can be started after completing the baseline inventory
	            	if(nodeIterator === 0 && bBaselineInventoryDone)
	            	{
	            		var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
	            		
	            		var uri, index, op_status, node_id;
	            		
	            		if(oNodeTable)
	            			nodesAdded = oNodeTable.fnGetData();
	            		//start inventory for each baseline
	            		for(var i=0; i < nodesAdded.length; i++)
	            		{
	            			uri = nodesAdded[i].node_uri;
	            			var vals = uri.split("/");
	            			node_id = vals[4];
	            			index = i;
	            			op_status = nodesAdded[i].op_status;
	            			var currprogress = nodesAdded[i].progress;
	            			//if current operation status is started, then only start the inventory, otherwise no need to start inventory
	            			if(op_status === "started") {
	            				//get the available baselines and pass it to node inventory
	            				var itemBaselines = {baselines: {baseline:[]}};
	            				for(var j=0; j< baselinesAdded.length; j++)
	            				{
	            					var baselineid, paths;
	            					paths = baselinesAdded[j].baseline_uri.split("/");
	            					baselineid = paths[5] + "/" + paths[7];
	            					itemBaselines.baselines.baseline.push(baselineid);
	            				}
	            				
	            				oNodeTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', index, 0);
	            				oNodeTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryInProgress"), index, 2);
			                	$('#node-progress-'+ node_id).hpProgressBar(1);
			                	oNodeTable.fnUpdate('inprogress', index, 6);
			                	
			                	rest.postObject(uri + "/inventory", 
												{ hapi:itemBaselines },
												"", 
					            		         { uri: nodesAdded[i].node_uri,
					            		           nodeid: node_id,
					            		           row: index,
		                    			success : function(data) {
		                    	
		                    				enableAbortButton(STEP_INVENTORY);
		                    							
		                    				var oTable = $(INVENTORY_NODE_TABLE).dataTable();
		                    				
		                    				//update status
		                    				if(oTable){
							                	oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
							                	oTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryInProgress"), this.row, 2);
							                	oTable.fnUpdate('inprogress', this.row, 6);
							                }
							                
							                //move progress bar
							                $('#node-progress-'+ this.nodeid).hpProgressBar(1);
							                oTable.fnUpdate(1, this.row, 7);
							                
							                if(data.hapi.hcode != 0) {
							                	oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
							                	oTable.fnUpdate(data.hapi.hmessage, this.row, 4);
							                	oTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryFailed"), this.row, 2);
							                	
							                	oTable.fnUpdate('done_error', this.row, 6);
							                	$('#node-progress-' + this.nodeid).hpProgressBar(100);
							                	oTable.fnUpdate(100, this.row, 7);
							                	
							                	bNodesDoneCount++;
							                }
								             
							            	//Not required. Will remove later after verifying    
		                        			//checkNodeInventorySuccess(uri, index, data);
		                    		 	},
		                    			error : function(errorInfo) {
		                        			checkNodeInventoryError(this.uri, this.row, errorInfo);
								handleExpressExit();
		                    			}
		                			}, {});
                			}
                			else if (op_status === "inprogress") {
                				
                				rest.getURI(uri + "/getstatus", {
                					uri: nodesAdded[i].node_uri,
					            	nodeid: node_id,
					            	row: index,
					            	progress: currprogress,
	                    			success : function(data) {
	                    				
	                    				//get the row index for the applicable node
	                    				var oTable = $(INVENTORY_NODE_TABLE).dataTable();
	                    				
	                    				oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
	                    				
	                    				if(data.hapi.node_status.node_state === "INVENTORY")
	                    				{
	                    					if(this.progress < 50) 
	                    					{
		                    					$('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(this.progress+2);
		                    					oTable.fnUpdate(this.progress+2, this.row, 7);
		                    				}
		                    				oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
						                	oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
						                	oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
						                	oTable.fnUpdate('inprogress', this.row, 6);
	                    				}
	                    				else if(data.hapi.node_status.node_state === "SELFINVENTORY")
	                    				{
	                    					if(this.progress < 95) 
	                    					{
		                    					$('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(this.progress+2);
		                    					oTable.fnUpdate(this.progress+2, this.row, 7);
		                    				}
		                    				oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
		                    				oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
						                	oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
						                	oTable.fnUpdate('inprogress', this.row, 6);
	                    				}
	                    				else if(data.hapi.node_status.node_state === "UAN")
	                    				{
	                    					$('#node-progress-'+ data.hapi.node_status.node_id).hpProgressBar(100);
						                	oTable.fnUpdate(100, this.row, 7);
						                	
	                    					oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
	                    					oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryCompleted"), this.row, 2);
											if(bModeInteractive)
												oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
											else
												oTable.fnUpdate('', this.row, 4);
										
											oTable.fnUpdate('done', this.row, 6);
											bNodesDoneCount++;
											//getupdatelist to check the number of components											
											NodePresenter.getUpdateList(data.hapi.node_status.node_id, {                        
												success: function(data) {
													var compcount=0;
													for(var i=0; i< data.hapi.baselines.baseline.length; i++)
													{
														if (data.hapi.baselines.baseline[i].hasOwnProperty("components"))
														{
															compcount += data.hapi.baselines.baseline[i].components.component.length;														
														}
													}
													if(compcount == 0)
														error_condition = true;
												},
												error: function(data) {
													handleExpressExit();
												}
											});
		            					}
	                    				else if(data.hapi.node_status.node_state === "ERROR")
	                    				{
	                    					$('#node-progress-'+ data.hapi.node_status.node_id).hpProgressBar(100);
						                	oTable.fnUpdate(100, this.row, 7);
						                	
	                    					oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
	                    					oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryError"), this.row, 2);
	                    					oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
	                    					oTable.fnUpdate('done_error', this.row, 6);
	                    					error_condition = true;
	                    					bNodesDoneCount++;
                                            disableNextButton(STEP_INVENTORY);
	                    				}
	                    				else if(data.hapi.node_status.node_state === "PENDING_FW_UPDATE")
	                    				{
	                    					$('#node-progress-'+ data.hapi.node_status.node_id).hpProgressBar(100);
						                	oTable.fnUpdate(100, this.row, 7);
						                	
	                    					oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
	                    					oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryError"), this.row, 2);
	                    					oTable.fnUpdate(localizer.getString("hpsum.integrityilo.activateOnNodeScreen"), this.row, 4);
	                    					oTable.fnUpdate('done_error', this.row, 6);
	                    					
	                    					bNodesDoneCount++;
	                    				}
		                    		},
	                    			error : function(errorInfo) {
	                    					handleExpressExit();
	                        		}
	                			});
                			}
                			else if (op_status === "abort_error" || op_status === "abort_success") {
                				$('#node-progress-'+ node_id).hpProgressBar(100);
                				oNodeTable.fnUpdate(100, index, 7);
                				bNodesDoneCount++;
                			}
		                }
	            		
	            		if(bNodesDoneCount >= nodesAdded.length) {
	            			//stop the timer once everything is done
	            			clearInterval(progressTimer);
                            //clear the notification created for warning phase
                            clearNotifications();
                            
	            			disableAbortButton(0);
	            			
                            
                            if (abortButtonPressed) {
                                // Clear this indicator so that if startOneTouchUpdate gets called again,
                                // it won't think the abort button was pressed for the current iteration.
                                abortButtonPressed = false;
                            }
                            // The process was not aborted so get ready for the next step.
                            else  {
	            			    enableNextButton(STEP_INVENTORY);
	            			    enableResetButton(STEP_INVENTORY);
								//Enable Actions
								$('#hpsum-otu-actions').show();
								if(error_condition == true)
								{
									disableRebootButton(STEP_DEPLOY);
									disableNextButton(STEP_INVENTORY);
									handleExpressExit();
								}
                                //go to deploy step
                                if(bModeNonInteractive && error_condition == false) {					
								
									$("#step0Next").click();					
                                }

                            }
                        }
	            	}
		            	
	            	}, 3000);
                  
            }
            function guidedUpdateWithBaselines() {
            	
		var error_condition = false; 
            	if(bInProgress == true)
            		return;
            	
            	bStartDeploy = false;
            		
            	//get the selected mode, node option, baselines, nodes
            	var nodes = [], baselines = [];
            	            	
            	baselineIterator=0, nodeIterator=0;
            	
            	//Flag is set to indicate one touch update is in progress
            	bInProgress = true;
            	//Initialize the wizard steps
            	showWizardStep(STEP_INVENTORY);
            	hideWizardStep(STEP_REVIEW);
            	hideWizardStep(STEP_DEPLOY);
            	
            	//Disable next button by default till inventory is done
            	disableNextButton(STEP_INVENTORY);
            	//disable abort button, enable when inventory is in progress
            	disableAbortButton(STEP_INVENTORY);
            	//disable reset button, enable after inventory is completed
            	disableResetButton(STEP_INVENTORY);
            	
            	var isExpressLocation = false;
				if (typeof(l_expLoc) == "undefined"){
					isExpressLocation = false;
				}
				else {
					isExpressLocation = true;
				}
            	bBaselineInventoryDone = false; //update this to true after all baselines inventory is done
            	
            	var guimode = session.getProperty("gui_mode");
            	//guimode is not defined
				//var modeValue = $('input[name=mode-option]:checked').val();
				
				if(modeValue != undefined)
				{
					if(modeValue === "interactive-mode")
	            	{
	            		bModeInteractive = true;
	            		bModeNonInteractive = false;
	            		
	            		showAllButtons(STEP_INVENTORY);
	            	}
	            	else if(modeValue === "non-interactive-mode")
	            	{
	            		bModeInteractive = false;
	            		bModeNonInteractive = true;
	            		
	            		hideAllButtons(STEP_INVENTORY);
	            	}
				}
				else if(guimode && modeValue === undefined) 
            	{ 
            		//add default localhost into the list
            		nodes.push({
                        node: "localhost",
                        descr: '',
                        uri: "",
                        uname:"",
                        pwd:""
                    });
                    
                    //add default baseline into the list
            		baselines.push({
                        baseline: "default",
                        descr: 'default',
                        uri: "default",
						name:"default"
                   	});
                    
					if(guimode === "offline_automatic" || guimode === "express")
					{
						bModeNonInteractive = true;
						bModeInteractive = false;
						
						hideAllButtons(STEP_INVENTORY);
					}
					else if (guimode === "offline_interactive")
					{
						bModeNonInteractive = false;
						bModeInteractive = true;
						showAllButtons(STEP_INVENTORY);
					}
				}
	            
	            if(bLoadMulti)
	            {
	            	//add default baseline
					var baselineassigned = false;
					baselines = [];
					if (newHotFix != null && newHotFix != ""){
						baselineassigned = true;
						baselines.push({
						baseline: newHotFix.name,
						descr:'',
						uri: newHotFix.uri,
						name:''
						});
					}
					if(newBaseline != null && newBaseline != ''){
						baselineassigned = true;
						baselines.push({
						baseline: newBaseline.name,
						descr:'',
						uri: newBaseline.uri,
						name:''
						});
					}
					if(!baselineassigned)
					{
						baselines.push({
							baseline: "default",
							descr: 'default',
							uri: "default",
							name:"default"
						});
					}
	            	if(nodeValue === "one") {
	            		//add localhost into the nodes list
	            		nodes = [];
	            		nodes.push({
	                        node: "localhost",
	                        descr: '',
	                        uri: "",
	                        uname:"",
	                        pwd:""
	                    });
	            	}
					else if(nodeValue === "two") {
						nodes = [];
						var selectedNodeData = [];
						for(var idx = 0; idx < allNodes.length; idx++) {            			
							if(allNodes[idx].node_id === selectedNode)
								selectedNodeData = allNodes[idx];
						}
						nodes.push({
							node:selectedNodeData.node,
							descr:selectedNodeData.descr,
							uri:selectedNodeData.uri,
							uname:"",
							pwd:""
						});
					}
					else if(nodeValue === "three") {
						nodes = [];
						var inst = $('#hpsum-newnode-ipdetails').data('plugin_hpsumAddNodeDetails');
						var nodedata = inst.getNodeDetails();
						var inst_credentials = $('#hpsum-newnode-credentials').data('plugin_hpsumAddNodeDetails');
						var credentials = inst_credentials.getCredentialDetails();
						var nodename = $("#hpsum-node-name").val();
						nodes.push({
							node:nodename,
							descr:nodedata.nodeType,
							uri:"",
							use_current_credentials:credentials.useCurrentCredentials,
							use_sudo : credentials.useSudoCredentials,
							su_username : credentials.linuxSuUser,
							su_password : credentials.linuxSuPwd,
							uname:credentials.adminUser,
							pwd:credentials.adminPwd
						});
					}
		            else 
		            {
		        		var oBaselineTable = $(BASELINES_TABLE).dataTable();
		        	 	var oNodeTable = $(NODES_TABLE).dataTable();
		        	 	
		        	 	if(oNodeTable)
		        	 		nodes = oNodeTable.fnGetData();
		        	 	if(oBaselineTable)
		        	 		baselines = oBaselineTable.fnGetData();
		        	 }
	        	}
	        	
	        	var oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
            	oTable.fnClearTable();
            	
            	oTable = $(INVENTORY_NODE_TABLE).dataTable();
            	oTable.fnClearTable();
            	
				//add all the baselines and node
                var ind;
                for(ind=0; ind < baselines.length; ind++) 
                {
                	var uri = baselines[ind].uri;
                	//if the baseline is not already added, then only add it, otherwise just add it to the table and check the status and issue inventory
                	if(uri === "default")
                	{
	                	baselineIterator++;
						if (isExpressLocation == true){
							uri = l_expLoc;
						}
	                	rest.postObject("Session/" + session.getToken() + "/Baseline/add", 
									{
									 hapi: { uri: uri, locationtype: 'local' }
									},  "", 
	            		         {
	            		         	location: uri,
	                    			success : function(data) {
										onaddLocationSuccess(this.location, data, isExpressLocation);
	                    		 	},
	                    			error : function(errorInfo) {
	                        			onaddLocationError(baselines[ind].baseline, errorInfo);
	                    			}
	                			}, {});
	                }
	                else 
	                {
	                	var item = [{status: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>', 
	        			baseline_name: baselines[ind].baseline,
	        			baseline_status: localizer.getString("hpsum.oneTouchUpdate.baselineAdded"),
	        			baseline_progress: '<div id="baseline-progress' + ind + '" style="height:15px"></div>',
	        			baseline_details: '',
	        			baseline_uri: baselines[ind].uri,
	        			op_status: "started"}];
	        			
	        			var oTmpTable = $(INVENTORY_BASELINE_TABLE).dataTable();
	        			
	        			//add baseline into baseline inventory table of step1 of wizard	    
						oTmpTable.fnAddData(item);
						
						$('#baseline-progress' + ind).hpProgressBar(0);
	                }
                }
               
                //add nodes
                for(ind=0; ind < nodes.length; ind++) 
                {
                	nodeIterator++;
                	var nodename = nodes[ind].node;
                	var nodetype = nodes[ind].descr;
                	var uri = nodes[ind].uri;
                	var item;
                
                	//for localhost or default node
                	if(uri === "")
                	{
						if(nodeValue ==="one")
							item = {
								ip:nodes[ind].node, 
								name: nodes[ind].node, 
								type:'unknown', 
								use_current_credentials: true
							};
						if(nodeValue === "three")
							item = {
								ip : nodename, 
								name : nodename, 
								type : nodetype, 
								use_current_credentials : nodes[ind].use_current_credentials,
								username : nodes[ind].uname, 
								password : nodes[ind].pwd,
								use_sudo : nodes[ind].use_sudo,
								su_username : nodes[ind].su_username,
								su_password : nodes[ind].su_password
							};
					}
                	else
                	{
                		//node already added in the node screen
                		item = {ip:nodes[ind].node, name: nodes[ind].node};
                	}

                	setTimeout(function(){			
		                	rest.postObject("Session/" + session.getToken() + "/node/add", 
									{
									 hapi:item
									},  "", 
			        		        {
			        		        	node_name: nodename,
			        		        	node_type: nodetype,
			                			success : function(data) {
			                    			onaddNodeSuccess(this.node_name, this.node_type, data);
			                		 	},
			                			error : function(errorInfo) {
			                    			onaddNodeError(this.node_name, errorInfo);
			                			}
			            			}, {});
					},250);
               	} 
                var baselinesAdded = [], nodesAdded = [] , baselinesList = [];
                var remaining = 100;
                var bBaselinesDoneCount=0;
                var bNodesDoneCount=0,  baselineCount = 0;
                //check the progress of inventory operation every 2 secs
                //progressTimer = setInterval(checkProgress(), 2000);
				nodeadded = false;
				var oBaselineTable = $(INVENTORY_BASELINE_TABLE).dataTable();
				if(oBaselineTable)
	            			baselines = oBaselineTable.fnGetData();
					for(var i=0; i < baselines.length; i++)
					{
						var uri = baselines[i].baseline_uri;
						var	sub = uri.search("/location/");
						baselinesList[baselineCount++] = uri.substr(sub);
					}

					var timer = setInterval(function () {
						var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
	            		if(oNodeTable)
	            			nodesAdded = oNodeTable.fnGetData();
						var uri = nodesAdded[0].node_uri;
	            		var vals = uri.split("/");
	            		var node_id = vals[4];
						var nodeItem = {node_id : node_id};
						NodePresenter.getNodeStatus(nodeItem, {
							success : function(data) {
								if(data.hapi.node_status !== "undefined") {
									if(!data.hapi.node_status.node_phase.match(/initialize/i)){
										clearInterval(timer);
										nodeadded = true;
										//ilotimer = 0;
										//presenter.refreshIndexResults();
									}
								}
							},
							error : function(errorInfo) {
								clearInterval(timer);
							}
						});
					}, 3000);
                progressTimer = setInterval(function () {
                	
                	if(bModeNonInteractive)
                		hideAllButtons(STEP_INVENTORY);
                	
					if(baselineIterator === 0 && bBaselineInventoryDone === false)
	            	{
	            		var oBaselineTable = $(INVENTORY_BASELINE_TABLE).dataTable();
	            		var uri, index, sub, op_status;
	            		
	            		if(remaining > 10)
		                	remaining -= 10;
	            		
	            		if(oBaselineTable)
	            			baselinesAdded = oBaselineTable.fnGetData();
	            		//start inventory for each baseline
	            		for(var i=0; i < baselinesAdded.length; i++)
	            		{
	            			uri = baselinesAdded[i].baseline_uri;
	            			index = i;
	            			op_status = baselinesAdded[i].op_status;
							
	            			//if currest operation status is started, then only start the inventory, otherwise no need to start inventory
	            			if(op_status === "started") {
	            				
	            				if(oBaselineTable){
				                	oBaselineTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', index, 0);
				                	oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), index, 2);
				                	oBaselineTable.fnUpdate('inprogress', index, 6);
				                	$('#baseline-progress' + index).hpProgressBar(1);
				                }
				                
		            			rest.getURI(baselinesAdded[i].baseline_uri + "/inventory", {
		            				row: index,
	                    			success : function(data) {
	                    				
	                    				var oTmpTable = $(INVENTORY_BASELINE_TABLE).dataTable();
	                    				//update status
	                    				if(oTmpTable){
						                	oTmpTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
						                	oTmpTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
						                	oTmpTable.fnUpdate('inprogress', this.row, 6);
						                }
						                
						                //update progress
						                $('#baseline-progress' + this.row).hpProgressBar(1);
						            },
	                    			error : function(errorInfo) {
	                        			//checkBaselineInventoryError(uri, index, errorInfo);
	                        			handleExpressExit();
	                    			}
		                		});
		                	}
		                	else if(op_status === "inprogress") {
		                		
		                		rest.getURI(uri + "/getstatus", {
		                			row: index,
                    				success : function(data) {
                    					//get the row index for the applicable baseline
	                    				if(data.hapi.baseline_state === "inventory_in_progress" || data.hapi.baseline_state === "manifest_component_processing")
	                    				{
	                    					var currprogress = (data.hapi.baseline_state_detail.current_progress/data.hapi.baseline_state_detail.total_no_component) * 100;
	                    					$('#baseline-progress' + this.row).hpProgressBar(currprogress);
						                	
	                    					oBaselineTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
	                    					oBaselineTable.fnUpdate( localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
	                    					var detail = data.hapi.baseline_state_detail.detail + " (" + data.hapi.baseline_state_detail.current_progress + "/" + data.hapi.baseline_state_detail.total_no_component + ")";
	                    					oBaselineTable.fnUpdate(detail, this.row, 4);
	                    					oBaselineTable.fnUpdate('inprogress', this.row, 6);
	                    				}
   	                 					else if(data.hapi.baseline_state === "inventory_completed")
	                    				{	
											var i = 0,j = 0,k = 0;
	                    					$('#baseline-progress' + this.row).hpProgressBar(100);
											var uri_new = '/location/' + data.hapi.location_id + '/bundle/' + data.hapi.baseline_id;
											for(i = 0; i < baselinesList.length ; i++)
											{
												if( baselinesList[i] == uri_new )
												{
													for(j = i, k = i+1; k <= baselineCount ; j++,k++)
													{
														baselinesList[j] = baselinesList[k];
													}
													baselineCount--;
												}
											}
											
	                    					oBaselineTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
	                    					oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryCompleted"), this.row, 2);
	                    					oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.totalComponents") + ' ' + data.hapi.baseline_state_detail.total_no_component, this.row, 4);
	                    					oBaselineTable.fnUpdate('done', this.row, 6);
	                    					
	                    					bBaselinesDoneCount++;
	                    				}
										else if(data.hapi.baseline_state === "inventory_Failed") {
	               		
																							
											var detail = '</br><a id="hpsum-startover-failed-inventory">' + localizer.getString("hpsum.common.startOver") + '</a>';
											var details =  data.hapi.baseline_state_detail.detail + detail;
											oBaselineTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
	                    					oBaselineTable.fnUpdate( localizer.getString("hpsum.baseline.show.inventoryFailed"), this.row, 2);	                    					
	                    					oBaselineTable.fnUpdate(details, this.row, 4);
	                    					oBaselineTable.fnUpdate('Failed', this.row, 6);
											enableAbortButton(STEP_INVENTORY);
											enableResetButton(STEP_INVENTORY);
										}
	                    				else if(data.hapi.baseline_state === "inventory_needed")
                    					{
                    						oBaselineTable.fnUpdate('started', this.row, 6);
                    					}
                    				},
                    				error : function(errorInfo) {
                    					handleExpressExit();
                        			}
                				});
		                		
		                	}
		                }
						if((bBaselinesDoneCount >= baselinesAdded.length) && (!baselineCount) )
	            			bBaselineInventoryDone = true;
	            	}
					$('#hpsum-startover-failed-inventory').click(function(){initReset();});  
	            	//check if all the nodes are added successfully, we can carry on with the inventory operation
	            	//This can be started after completing the baseline inventory
	            	//if(nodeIterator === 0 && bBaselineInventoryDone)
					if (nodeIterator === 0 && nodeadded && bBaselineInventoryDone )
	            	{
	            		var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
						var oBaselineTable = $(INVENTORY_BASELINE_TABLE).dataTable();
	            		var itemBaselines = {baselines: {baseline:[]}};
	            		var uri, index, op_status, node_id;

	            		if(oBaselineTable)
	            			baselinesAdded = oBaselineTable.fnGetData();
	            		
	            		if(oNodeTable)
	            			nodesAdded = oNodeTable.fnGetData();
							
						for(var j=0; j< baselinesAdded.length; j++)
						{
							var baselineid, paths;
							paths = baselinesAdded[j].baseline_uri.split("/");
							baselineid = paths[5] + "/" + paths[7];
							itemBaselines.baselines.baseline.push(baselineid);
						}
	            		//start inventory for each baseline
	            		for(var i=0; i < nodesAdded.length; i++)
	            		{
	            			uri = nodesAdded[i].node_uri;
	            			var vals = uri.split("/");
	            			node_id = vals[4];
	            			index = i;
	            			op_status = nodesAdded[i].op_status;
	            			var currprogress = nodesAdded[i].progress;
							
	            			//if current operation status is started, then only start the inventory, otherwise no need to start inventory
	            			if(op_status === "started") {
	            				
								//get the available baselines and pass it to node inventory
	            				// if (newHotFix != null && newHotFix != ""){
                                // itemBaselines.baselines.baseline.push(newHotFix.id);
								// }
								// if (newBaseline != null && newBaseline != ""){
                                // itemBaselines.baselines.baseline.push(newBaseline.id);
								// }
	            				oNodeTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', index, 0);
	            				oNodeTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryInProgress"), index, 2);
			                	$('#node-progress-'+ node_id).hpProgressBar(1);
			                	oNodeTable.fnUpdate('inprogress', index, 6);
			                	
			                	rest.postObject(uri + "/inventory", 
												{ hapi:itemBaselines },
												"", 
					            		         { uri: nodesAdded[i].node_uri,
					            		           nodeid: node_id,
					            		           row: index,
		                    			success : function(data) {
		                    	
		                    				enableAbortButton(STEP_INVENTORY);
		                    							
		                    				var oTable = $(INVENTORY_NODE_TABLE).dataTable();
		                    				
		                    				//update status
		                    				if(oTable){
							                	oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
							                	oTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryInProgress"), this.row, 2);
							                	oTable.fnUpdate('inprogress', this.row, 6);
							                }
							                
							                //move progress bar
							                $('#node-progress-'+ this.nodeid).hpProgressBar(1);
							                oTable.fnUpdate(1, this.row, 7);
							                
							                if(data.hapi.hcode != 0) {
							                	oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
							                	oTable.fnUpdate(data.hapi.hmessage, this.row, 4);
							                	oTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryFailed"), this.row, 2);
							                	
							                	oTable.fnUpdate('done_error', this.row, 6);
							                	$('#node-progress-' + this.nodeid).hpProgressBar(100);
							                	oTable.fnUpdate(100, this.row, 7);
							                	error_condition= true;
							                	bNodesDoneCount++;
							                }
								             
							            	//Not required. Will remove later after verifying    
		                        			//checkNodeInventorySuccess(uri, index, data);
		                    		 	},
		                    			error : function(errorInfo) {
		                        			checkNodeInventoryError(this.uri, this.row, errorInfo);
		                    			}
		                			}, {});
                			}
                			else if (op_status === "inprogress") {   
                				
                				rest.getURI(uri + "/getstatus", {
                					uri: nodesAdded[i].node_uri,
					            	nodeid: node_id,
					            	row: index,
					            	progress: currprogress,
	                    			success : function(data) {
	                    				
	                    				//get the row index for the applicable node
	                    				var oTable = $(INVENTORY_NODE_TABLE).dataTable();
	                    				
	                    				oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
	                    				
	                    				if(data.hapi.node_status.node_state === "INVENTORY")
	                    				{
	                    					if(this.progress < 50) 
	                    					{
		                    					$('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(this.progress+2);
		                    					oTable.fnUpdate(this.progress+2, this.row, 7);
		                    				}
		                    				oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
						                	oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
						                	oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
						                	oTable.fnUpdate('inprogress', this.row, 6);
	                    				}
	                    				else if(data.hapi.node_status.node_state === "SELFINVENTORY")
	                    				{
	                    					if(this.progress < 95) 
	                    					{
		                    					$('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(this.progress+2);
		                    					oTable.fnUpdate(this.progress+2, this.row, 7);
		                    				}
		                    				oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
		                    				oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
						                	oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
						                	oTable.fnUpdate('inprogress', this.row, 6);
	                    				}
	                    				else if(data.hapi.node_status.node_state === "UAN")
	                    				{
	                    					$('#node-progress-'+ data.hapi.node_status.node_id).hpProgressBar(100);
						                	oTable.fnUpdate(100, this.row, 7);
						                	
	                    					oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
	                    					oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryCompleted"), this.row, 2);
											if(bModeInteractive)
												oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
											else
												oTable.fnUpdate('', this.row, 4);

											oTable.fnUpdate('done', this.row, 6);
											bNodesDoneCount++;
											//getupdatelist to check the number of components
											NodePresenter.getUpdateList(data.hapi.node_status.node_id, {
												success: function(data) {
													var compcount=0;
													for(var i=0; i< data.hapi.baselines.baseline.length; i++)
													{
														if (data.hapi.baselines.baseline[i].hasOwnProperty("components"))
														{
															compcount += data.hapi.baselines.baseline[i].components.component.length;														
														}
													}
													if(compcount == 0)
														error_condition = true;
												},
												error: function(data) {}
											});
                                        }
	                    				else if(data.hapi.node_status.node_state === "ERROR")
	                    				{
	                    					$('#node-progress-'+ data.hapi.node_status.node_id).hpProgressBar(100);
						                	oTable.fnUpdate(100, this.row, 7);
						                	
	                    					oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
	                    					oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryError"), this.row, 2);
	                    					oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
	                    					oTable.fnUpdate('done_error', this.row, 6);
	                    					error_condition = true;
	                    					bNodesDoneCount++;
	                    				}
	                    				else if(data.hapi.node_status.node_state === "PENDING_FW_UPDATE")
	                    				{
	                    					$('#node-progress-'+ data.hapi.node_status.node_id).hpProgressBar(100);
						                	oTable.fnUpdate(100, this.row, 7);
						                	
	                    					oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
	                    					oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryError"), this.row, 2);
	                    					oTable.fnUpdate(localizer.getString("hpsum.integrityilo.activateOnNodeScreen"), this.row, 4);
	                    					oTable.fnUpdate('done_error', this.row, 6);
	                    					
	                    					bNodesDoneCount++;
	                    				}
		                    		},
	                    			error : function(errorInfo) {
	                        		}
	                			});
                			}
                			else if (op_status === "abort_error" || op_status === "abort_success") {
                				$('#node-progress-'+ node_id).hpProgressBar(100);
                				oNodeTable.fnUpdate(100, index, 7);
                				bNodesDoneCount++;
                			}
		                }
	            		
	            		if(bNodesDoneCount >= nodesAdded.length) {
	            			//stop the timer once everything is done
	            			clearInterval(progressTimer);
                            clearNotifications();
	            			
	            			disableAbortButton(0);
	            			
                            
                            if (abortButtonPressed) {
                                // Clear this indicator so that if startOneTouchUpdate gets called again,
                                // it won't think the abort button was pressed for the current iteration.
                                abortButtonPressed = false;
                            }
                            // The process was not aborted so get ready for the next step.
                            else  {
	            			    enableNextButton(STEP_INVENTORY);
	            			    enableResetButton(STEP_INVENTORY);
								//Enable Actions
								$('#hpsum-otu-actions').show();
								if(error_condition == true)
								{
									disableRebootButton(STEP_DEPLOY);
									disableNextButton(STEP_INVENTORY);
								}
                                //go to deploy step
                                if(bModeNonInteractive && error_condition == false) {					
								
									$("#step0Next").click();					
                                }

                            }
                        }
	            	}
		            	
	            	}, 3000);
                  
            }
			
            function onItemUpdateSuccess()
            {

            }

            function onItemUpdateError()
            {
                
            }

			function onSelectionCompleted() {
				if (bInAnalysis) {
					var componentCount = 0;
					var failedComponentCount = 0;
					for (var idx = 0; idx < nodeChanges.length; idx++) {
						componentCount += nodeChanges[idx].component_length;
						failedComponentCount += nodeChanges[idx].failed_dependency_cnt;
					}
						
					if (componentCount > 0 && failedComponentCount == 0) 
						enableNextButton(STEP_REVIEW);
					else 
						disableNextButton(STEP_REVIEW);
					disableAnalyzeButton(STEP_REVIEW);	
					
					bInAnalysis = false;
				}				
			}
			
            function onSelectionChanged(id, value, componentList){
                if (componentList.component.length > 0 && componentList.failed_dependency == 0) {
                       enableNextButton(STEP_REVIEW);
				}	
				if(value == true){
				selectionChange = true;
								   
                if(componentList.component.length == 0) {
					disableNextButton(STEP_REVIEW);
					}
				else{
					enableNextButton(STEP_REVIEW);
				}
				
				}
				else{
                   
                    if(componentList.component.length <= 0 || componentList.failed_dependency > 0){                      
                       bStartDeploy = false;					  
					   disableNextButton(STEP_REVIEW);
                    }
				}
				
				for (var idx = 0; idx < nodeChanges.length; idx++) {
						if (nodeChanges[idx].node_id == id){
							nodeChanges[idx].component_length = componentList.component.length;
							nodeChanges[idx].failed_dependency_cnt = componentList.failed_dependency;
						}
						if (nodeChanges[idx].failed_dependency_cnt > 0)
							deployToDo = false;
				}
					
				if(componentList.component.length > 0 && componentList.failed_dependency == 0) {
					// enableNextButton(STEP_REVIEW);
					if(bStartDeploy) {
						showWizardStep(STEP_DEPLOY);
						hideWizardStep(STEP_REVIEW);
						$("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
						$("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
						$("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
						initDeploy();
					}
				} 
			}
            function onPopulateInstallSet()
			{
			if(deployToDo) {
									initDeploy();
			}
			}
			
            function initInstallReview(bdeploy) {
            	var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
	            		
        		var nodes = [];
        		var uri, index, op_status;
        		var bNodesDoneCount=0;
        		
        		bStartDeploy = bdeploy;
        		
				//disable deploy button by default. Enable only if some components are ready for installation
        		disableNextButton(STEP_REVIEW);
        		//disable analyze button by default. Enable only if component selection or force option changed
        		disableAnalyzeButton(STEP_REVIEW);
			showWizardStep(STEP_REVIEW);
			hideWizardStep(STEP_INVENTORY);
			hideWizardStep(STEP_DEPLOY);
				
			nodeChanges = [];
				
        		$('#all-installables').empty();
        		
        		if(oNodeTable)
        			nodes = oNodeTable.fnGetData();
	            //add each node and its installable components
        		for(var i=0; i < nodes.length; i++)
        		{
        			var list = nodes[i].node_uri.split("/");
					var nodeid = list[4];
					var op_status = nodes[i].op_status;
					var nodetype = nodes[i].node_type;
					
					nodeChanges = nodeChanges.concat({
									node_id: nodeid,
									component_length : 0,
									failed_dependency_cnt : 0
									});
									
					//if node inventory is not successful or user aborted then done show it in review
					if(op_status != 'done')
						continue;
					
					var gnodeInd=0;
					for(gnodeInd=0; gnodeInd < gnodeNodeSettings.length; gnodeInd++)
					{
						if(gnodeNodeSettings[gnodeInd].node_id == nodeid) {
							$('#hpsum-warning-messages').hpsumWarnings(gnodeNodeSettings[gnodeInd].item, true);
						}
					}
					
					$('.ignorewarnings').on('change', function(){
						var id = $(this).attr("nextid");
						$(id).removeClass("hp-button hp-primary hp-secondary hp-disabled");
						if ($(this).is(':checked')) {
							$(id).addClass($(this).attr("nextclass"));
						} else {
							$(id).addClass("hp-button hp-secondary hp-disabled");
						}
						
						var options = {hapi: {}};
						options.hapi.ignore_warnings = $(".ignorewarnings").is(':checked');
						var nodeItem = { node_id: gnodeNodeSettings[0].node_id };
						NodePresenter.setattribute(nodeItem, options, {
									   success : function(){},
									   error : function() {}
						});
					});
					
        			//add collapsible for each node 
					//add table for each node to show all the applicable components
					$('#all-installables').append('<div class="hp-collapsible" id="hpsum-otu-node-' + nodeid + '-installset"><label><b>' + nodes[i].node_name + ' ' + localizer.getString("hpsum.oneTouchUpdate.applicableComponents") + '</b></label><div>');
					
					$('#hpsum-otu-node-' + nodeid + '-installset').append('<div id="hpsum-otu-node-' + nodeid + '-installable"></div>');
					var node_Item = { node_id: nodeid, type: nodetype };
					var options = {
						command:'init',
						nodeItem:node_Item,
						onSelectionChanged:onSelectionChanged,
						onSelectionCompleted:onSelectionCompleted,
						onPopulateInstallSet:onPopulateInstallSet
					};
					
					//call Installables plug-in 
					$('#hpsum-otu-node-' + nodeid + '-installable').hpsumInstallables(options);
					
					$('#hpsum-otu-node-' + nodeid + '-installset').hpCollapsible();
					$('#hpsum-otu-node-' + nodeid + '-installset').hpCollapsible("expand");
				}
			}
				
			
				/*
			 *  initNodeSettings() : Initialize node settings for each node
			 *  Calls getdata to retrieve settings 
			 */
			function initNodeSettings() {
				
				var dataDeferred = $.Deferred();
				var optionsDeferred = $.Deferred();
				
				$('#all-installables').empty();
				
				var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
	            		
        		var nodes = [];
        		
        		if(oNodeTable)
        			nodes = oNodeTable.fnGetData();
        			
        		if(gnodeNodeSettings.length <= 0)
        		{
        		    //get setting for each node 
	        		for(var i=0; i < nodes.length; i++)
	        		{
	        			var list = nodes[i].node_uri.split("/");
						var nodeid = list[4];
						var op_status = nodes[i].op_status;
						var nodetype = nodes[i].node_type;
						
						//if node inventory is not successful or user aborted then done show it in review
						if(op_status != 'done')
							continue;
						
						var nodeItem = { node_id: nodeid };
						
						var nodeSetting = { node_id: nodeid, nodename: ''};
						
						gnodeNodeSettings.push(nodeSetting);
						
						//getdata for the node
						NodePresenter.getNodeData(nodeItem, {
								nodeid: nodeid,
								success : function(data) {
									
									if(gnodeNodeSettings.length <= 0){
										dataDeferred.resolve();
										return;
									}
										
									var gnodeInd=0;
									for(gnodeInd=0; gnodeInd < gnodeNodeSettings.length; gnodeInd++)
									{
										if(gnodeNodeSettings[gnodeInd].node_id == this.nodeid)
											break;
									}
									
									gnodeNodeSettings[gnodeInd].nodename = data.hapi.name;
									
									dataDeferred.resolve();
									
								},
								error : function(errorInfo) {
									dataDeferred.resolve();
									
								}
						});
						
						//getattributes for the node
						NodePresenter.otheroption(nodeItem, {
								nodeid: nodeid,
								success : function(data) {
									
									if(gnodeNodeSettings.length <= 0){
										optionsDeferred.resolve();
										return;
									}
										
									var gnodeInd=0;
									for(gnodeInd=0; gnodeInd < gnodeNodeSettings.length; gnodeInd++)
									{
										if(gnodeNodeSettings[gnodeInd].node_id == this.nodeid)
											break;
									}
									gnodeNodeSettings[gnodeInd].item = data.hapi;
									if (gnodeNodeSettings[gnodeInd].item.warnings && gnodeNodeSettings[gnodeInd].item.warnings.length > 0) {
										gnodeWarnings = gnodeNodeSettings[gnodeInd].item.warnings.join("<br />").replace(/\n/g, "\n<br />");
									}
									
									optionsDeferred.resolve();
								},
								error : function(errorInfo) {
									optionsDeferred.resolve();
								}
						});
					}
				}
				else
				{
					//getnodedata and otheroption rest calls are already done previously, hence no need call these calls again
					dataDeferred.resolve();
					optionsDeferred.resolve();
				}
				
				$.when(dataDeferred, optionsDeferred).done(function(){
	    				//dont show install review and go directly to deploy if non-interactive mode
	                    if(bModeNonInteractive) {
	                    	$("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
	                        $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
	                        $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
	                        showWizardStep(STEP_DEPLOY);
			            	hideWizardStep(STEP_REVIEW);
			            	hideWizardStep(STEP_INVENTORY);
			            	//need to omit the failed_dependency components
							omitfaileddep();
	            		}
	        			else {
	        				//show review screen with applicable components to user
	                		initInstallReview(false);
	                	}
				});
			}
			
			//Have to do OMITCOMPONENT for the components having failed_dependency and then go for deploy
			function omitfaileddep()
			{
				var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
				var nodes = [];
				if(oNodeTable)
					nodes = oNodeTable.fnGetData();
				for(var nodecount=0; nodecount < nodes.length; nodecount++)
				{
					var list = nodes[nodecount].node_uri.split("/");
					var nodeid = list[4];
					var nodeItem = { node_id: nodeid };
					NodePresenter.getUpdateList(nodeid, {
						success: function(data) {
							var failedcount=0;
							for(var blcount=0; blcount< data.hapi.baselines.baseline.length; blcount++)
							{
								if (data.hapi.baselines.baseline[blcount].hasOwnProperty("components"))
                                {
									var comps = data.hapi.baselines.baseline[blcount].components.component;
									for (var compcount = 0; compcount < comps.length; compcount++)
									{
										var comp = comps[compcount];
										if (comp.has_failed_dependencies === true)															
											failedcount++;
									}
								}
							}
							if(failedcount > 0)
							{
								var faileddep = {
									hapi: {
										failed_dependency_handling : "OMITCOMPONENT"
									}		
								};		
								NodePresenter.setattribute(nodeItem, faileddep, {
									success : function(data) {							
									},
									error : function(data) {
									},									
								});													
							}		
						},
						error: function(data) {
						}
					});		
					setTimer(nodes);
				}
			}

			function setTimer(nodes)
			{
				var timer = setTimeout(function() {
					var uri = nodes[0].node_uri;
					rest.getURI(uri + '/getstatus', {
						success : function(data) {
							if(data.hapi.node_status.node_state === "ANALYSIS")
							{
								//Keep waiting till node state is UAN
								setTimer(nodes);
							}
							else if(data.hapi.node_status.node_state === "UAN")
							{
								clearTimeout(timer);
								timer = '';
								initDeploy();
							}
							else if(data.hapi.node_status.node_state === "ERROR")
							{	
								clearTimeout(timer);
								timer = '';
							}
						},
						error : function(errorInfo) {
							clearTimeout(timer);
							timer = '';
						}
					});	
				}, 3000);	
			}
			
			function logOffSession(data, handlers) {

				var closeHandlers = { 
					success:function()
					{
						session.eraseAll();
						if (handlers && handlers.success) {
							handlers.success({});
						}
						window.document.write("HPSUM Engine is Shutdown. Please restart the engine to Login.");						
						closeBrowser();	
					},
					error:function(){
						Log.error("Error shutting down the engine");
					}
				};
	
				var shutdownData = { hapi: {
					force: 'false'
				}};
				session.shutDown(shutdownData, closeHandlers);
				Log.info("initiated shutdown");
							
			}			
			/*
			* closeBrowser() - Closes browser (tab)
			*/
			function closeBrowser() 
			{			
				window.open('', '_self', ''); 
				window.close();
			}
			
			function shutdownService(data) 
			{			
				var timeOut = setTimeout(function(){logOffSession(data)},10000);				
			}
			
			function handleExpressExit(data)
			{
				var guimode = session.getProperty("gui_mode");
				if(guimode === "express" ) {
					shutdownService(data);
				}
			}
			
				
				function recalculateInstallReview() {
				
					var nodes = [];
					var oNodeTable;
					var NodesDoneCount=0;
					
					bInAnalysis = true;
					
					showAnalysisSplash();
				
					var progressTimer = setInterval(function () {
						
						oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
							
						if(oNodeTable)
							nodes = oNodeTable.fnGetData();
						
						//start inventory for each baseline
						for(var i=0; i < nodes.length; i++)
						{
							var uri = nodes[i].node_uri;
							var vals = uri.split("/");
							var nodeid = vals[4];
							var index = i;
							var op_status = nodes[i].op_status;
							
							//check whether the current node status is UAN before calling getupdatelist.. need to make sure node is not still in analysis phase		
							rest.getURI(uri + "/getstatus", {
									row: index,
									node_id: nodeid,
									success : function(data) {
										
										if(data.hapi.node_status.node_state === "ANALYSIS")
										{
											
										}
										else if(data.hapi.node_status.node_state === "UAN")
										{
											NodesDoneCount++;
										}
										else if(data.hapi.node_status.node_state === "ERROR")
										{
											NodesDoneCount++;
										}
										else if(data.hapi.node_status.node_state === "PENDING_FW_UPDATE")
										{
											NodesDoneCount++;
										}
									},
									error : function(errorInfo) {
										
									}
							});
								
						}
							
						if(NodesDoneCount >= nodes.length) {
							
							//stop the timer
							clearInterval(progressTimer);
							
							//show install review for all the nodes
							initInstallReview(false);
							
							closeAnalysisSplash();
						}
							
					}, 3000);
					
				}
            
 function initDeploy()
             {
				  $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
				
            	var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
	            
        		var nodes = [];
        		var uri, index, op_status;
        		        		        		
        		var oTable = $(INSTALLPROGRESS_TABLE).dataTable();
				
				showWizardStep(STEP_DEPLOY);
				hideWizardStep(STEP_REVIEW);
				hideWizardStep(STEP_INVENTORY);
        		
        		if(bModeNonInteractive)
        		{
        			hideAllButtons(STEP_DEPLOY);
        		}
        		else
        		{
        			showAllButtons(STEP_DEPLOY);
        			disableBackButton(STEP_DEPLOY);
        		}
				var guimode = session.getProperty("gui_mode");
        		if (guimode === "offline_interactive")
                {
                    disableResetButton(STEP_DEPLOY);
                }
        		
        		disableRebootButton(STEP_DEPLOY);
        		
        		oTable.fnClearTable();
        		
        		//clear if any static or previous install results
        		$("#all-installresults").empty();
        		
        		if(oNodeTable)
        			nodes = oNodeTable.fnGetData();
        			
	            //start deploy for each node
	            //later this needs to be enhanced to pass selected components and other install options to the deploy command
	            for(var i=0; i < nodes.length; i++)
        		{
											
        			var list = nodes[i].node_uri.split("/");
					var nodeid = list[4];
					
					//if node is in error state, then dont add it for deploy
					//if node inventory is not successful or user aborted then dont show it in review
					if(nodes[i].op_status != "done")
						continue;
					
        			//add node into the install progress table
        			var item = [{status: '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', 
                			node_name: nodes[i].node_name,
                			node_status: localizer.getString("hpsum.oneTouchUpdate.deploymentInProgress"),
                			node_progress: '<div id="install-progress-' + nodeid + '" style="height:15px"></div>',
                			node_details: '',
                			node_uri: nodes[i].node_uri,
                			op_status: "inprogress", //"started",
                			node_id: nodeid,
                			progress: 0}];
				  	  
					//add node into node inventory table of step1 of wizard	    
					oTable.fnAddData(item);
					
					$("#install-progress-" + nodeid).hpProgressBar(5);
        			
        			var index = i;
        			var uri = nodes[i].node_uri;
        			
        			//start deploy
        			rest.getURI(nodes[i].node_uri + "/deploy", 
    							{
    								row: index,
    				                node_id: nodeid,  
	                    			success : function(data) {
	                    				deployToDo = false;
						               enableAbortButton(STEP_DEPLOY);
									   /* Disable the Actions Drop Down Menu when the Deployment is in progress */
									   $('#hpsum-otu-actions').addClass('hp-disabled');
									   
						                
	                        		},
	                    			error : function(errorInfo) {
									deployToDo = false;
	                        			handleExpressExit();
										
	                    			}
	                    		});
		        }
		        
		        var NodesDoneCount=0;
		        if (gnodeWarnings.length > 0) {
					notificationsView.add({
						status: NOTIFY_STATUSES["warning"],
						summary: localizer.getString("hpsum.oneTouchUpdate.warningsSummary"),
						details: gnodeWarnings
					});
				}
				
		        var progressTimer = setInterval(function () {
		        	
		        	var nodesAdded;
		        	var oProgressTable = $(INSTALLPROGRESS_TABLE).dataTable();
	            		
	        		if(oProgressTable)
	        			nodesAdded = oProgressTable.fnGetData();
		        	
		        	//start inventory for each baseline
            		for(var i=0; i < nodesAdded.length; i++)
            		{
            			var uri = nodesAdded[i].node_uri;
            			var vals = uri.split("/");
            			var nodeid = vals[4];
            			var index = i;
            			var op_status = nodesAdded[i].op_status;
            			var currprogress = nodesAdded[i].progress;
            			//if current operation status is started, then only start the inventory, otherwise no need to start inventory
            			if(op_status === "inprogress") {
	            				
				        	rest.getURI(uri + "/getstatus", {
		                			row: index,
		                			node_id: nodeid,
		                			progress: currprogress,
		                			success : function(data) {
		                				
		                				if(data.hapi.node_status.node_state === "INSTALL")
		                				{
		                					if(this.progress < 95) 
	                    					{
	                    						$('#install-progress-' + this.node_id).hpProgressBar(this.progress+2);
		                    					oProgressTable.fnUpdate(this.progress+2, this.row, 8);
		                    				}
		                    				
						                	oProgressTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deploymentInProgress"), this.row, 2);
						                	oProgressTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
						                	oProgressTable.fnUpdate('inprogress', this.row, 6);
		                				}
		                				else if(data.hapi.node_status.node_state === "INSTALLDONE")
		                				{
											$('#install-progress-' + this.node_id).hpProgressBar(100);
											oProgressTable.fnUpdate(100, this.row, 8);
											//Error if the node return code is < 0 means -1/-2/-3
											if (data.hapi.node_status.return_code < 0) {
												oProgressTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
												oProgressTable.fnUpdate(localizer.getString("hpsum.node.installDoneWithErrors"), this.row, 2);
											} else {																          
												oProgressTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
												oProgressTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deploymentCompleted"), this.row, 2);
											}
											
											oProgressTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
											oProgressTable.fnUpdate('done', this.row, 6);	                					
		                					NodesDoneCount++;
		                				}
		                				else if(data.hapi.node_status.node_state === "ERROR")
		                				{
		                					$('#install-progress-' + this.node_id).hpProgressBar(100);
		                					oProgressTable.fnUpdate(100, this.row, 8);
						                	
		                					oProgressTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
		                					oProgressTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deploymentError"), this.row, 2);
		                					oProgressTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
		                					oProgressTable.fnUpdate('done', this.row, 6);
		                					
		                					NodesDoneCount++;
		            					}
		            					else
		            					{
		            						//for any other state, consider as done with error
		            						$('#install-progress-' + this.node_id).hpProgressBar(100);
		                					oProgressTable.fnUpdate(100, this.row, 8);
						                	
		                					oProgressTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
		                					oProgressTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deploymentError"), this.row, 2);
		                					oProgressTable.fnUpdate('', this.row, 4);
		                					oProgressTable.fnUpdate('done', this.row, 6);
		                					
		                					NodesDoneCount++;	
		            					}
		            			 	},
		                			error : function(errorInfo) {
		                			}
		            			});
		            		}
		            	}
		            	
		            	if(NodesDoneCount >= nodesAdded.length) {
		            		
		            		//stop the timer
	            			clearInterval(progressTimer);
	            			
	            			$('#hpsum-otu-advance-action').addClass('hp-disabled');
	            			
	            			showAllButtons(STEP_DEPLOY);
	            			enableBackButton(STEP_DEPLOY);
		                			                	
		                	disableAbortButton(STEP_DEPLOY);
		                	enableRebootButton(STEP_DEPLOY);
							/* Enable the Actions Drop Down Menu when the deployment has been completed */
							$('#hpsum-otu-actions').removeClass('hp-disabled');
		                	
							var guimode = session.getProperty("gui_mode");
                            if (guimode === "offline_interactive")
                            {
                                disableResetButton(STEP_DEPLOY);
								$('#hpsum-offline-exit').addClass('hp-disabled');
                            }
		                	//show deploy results for all the nodes
					        for(var i=0; i < nodesAdded.length; i++)
			        		{
			        			initDeployResults(nodesAdded[i].node_id, nodesAdded[i].node_name);
			        		}
					        
							//if offline automatic mode, then reboot the server
							var guimode = session.getProperty("gui_mode");
							if(guimode === "offline_automatic" ) {
								// Just shut down HP SUM and let the boot environment take care of rebooting the server
								var handlers = { success:function() {
									var newWindow = window.open('', '_self', '');
									newWindow.close();
								}, 
									error: function(){
											   var newWindow = window.open('', '_self', '');
											   newWindow.close();
											   Log.error("Failed to shutdown HP Smart Update Manager");
										   }
								};

								var shutdownData = { hapi: {
									force: 'false'
								}};
								session.shutDown(shutdownData, handlers);
							}
							handleExpressExit();
		            	}
            			
		        }, 3000);
		      }  
		    
            function onCompGetLogsSuccess(data) {
            	showComponentDialog(data);
            }
            
            function onCompGetLogsError(error) {
            }
            
            function showComponentDialog(data) {
            	
            	//show component dialog
            	var dialog = new DialogView();
                dialog.init({contents: componentLogDialogContents,
                    ok: function (elem) {
                        return true;
                    },
                    cancel: function () {
                    }
                });
                
                if(data.hapi.components.component[0].hasOwnProperty('failed_deps'))
                {
                    $('#component_title').html(localizer.getString("hpsum.oneTouchUpdate.componentDetails"));
	                if(data.hapi.components.component.length > 0)
	                {
	                	$('#hpsum-comp-fail-dep').show();
	                	$('#hpsum-comp-inst-notes').hide();
		                $('#hpsum-component-id').html(data.hapi.components.component[0].component_id);
						
						
		                initFailedDependencyTable('#hpsum-component-failed-dep');
		                
		                var oFailedDepTable = $('#hpsum-component-failed-dep').dataTable();
		                
		                if(oFailedDepTable) {
							oFailedDepTable.fnClearTable();
		                	for(var i=0; i < data.hapi.components.component[0].failed_deps.length; i++)
		                	{
		                		var item =  [
		                						{
		                							failed_dependency: data.hapi.components.component[0].failed_deps[i]
				                				}
				                			];
		                		oFailedDepTable.fnAddData(item);
		                	}
		                }
		                
		                //this is for textarea
		                //$('#hpsum-component-failed-dep').val(data.hapi.components.component[0].failed_deps);
		                
						if(data.hapi.components.component[0].hasOwnProperty('device_info') && data.hapi.components.component[0].device_info.hasOwnProperty('devices'))
						{
							$('#hpsum-device-list-div').empty();
							
							$('#hpsum-device-list').show();
							
							for(var devInd=0; devInd < data.hapi.components.component[0].device_info.devices.device.length; devInd++)
							{
								var device = data.hapi.components.component[0].device_info.devices.device[devInd];
								
								//replace white spaces with - as element id should not have white spaces
								var headertableid = 'hpsum-devices-header-table-' +  device.device_id.replace(/\s+/g, '-').replace(/\./g, '_');
								$('#hpsum-device-list-div').append('<table id="' + headertableid + '"><thead><tr><td></td><td></td><td></td></tr></thead></table>');
								
								initDevicesHeaderTable('#' + headertableid);
								
								var headerTable = $('#' + headertableid).dataTable();
								
								var item = [{deviceid: device.device_id, 
						                	productid: device.product_id 
				                			}];
						                			
								headerTable.fnAddData(item);
								
								//replace white spaces with - as element id should not have white spaces
								var rowtableid = 'hpsum-devices-rows-table-' +  device.device_id.replace(/\s+/g, '-').replace(/\./g, '_'); 
								$('#hpsum-device-list-div').append('<table class="hp-selectable" id="' + rowtableid + '"><thead><tr><td>' + localizer.getString("hpsum.common.type") + '</td><td>' + localizer.getString("hpsum.common.statusStr") + '</td><td>' + localizer.getString("hpsum.node.activeVersion") + '</td><td>' + localizer.getString("hpsum.node.availableVersion") + '</td></tr></thead></table>');
								
								initDevicesRowTable('#' + rowtableid);
								
								var rowTable = $('#' + rowtableid).dataTable();
								
								for(var fwInd=0; fwInd < device.fw_item.length; fwInd++)
								{
									var fwitem = device.fw_item[fwInd];
									
									var rowitem = [{type: fwitem.type, 
							                	fw_item_status: fwitem.fw_item_status,
							                	active_version: fwitem.active_version,
							                	version: fwitem.version 
					                			}];
							                			
									rowTable.fnAddData(rowitem);
								}
								
								$('#' + rowtableid + " tbody tr").click( function( e ) {
			                   		
									var data = rowTable.fnGetData( this );
									
									//toggle row selection	
							        $(this).toggleClass('hp-selected');
							    });
							}
						}
						else
						{
							$('#hpsum-device-list-div').empty();
							$('#hpsum-device-list').hide();
						}
		            }
		       	}
		       	else{
		       		
		       		//reset the component id and log text before showing
		       		$('#hpsum-component-id').html('');
		       		$('#hpsum-component-installation-notes').val('');
		       		
                    $('#component_title').html(localizer.getString("hpsum.oneTouchUpdate.deploymentLog"));
	                if(data.hapi.components.component.length > 0)
	                {
	                	$('#hpsum-comp-inst-notes').show();
	                	$('#hpsum-comp-fail-dep').hide();
	                	$('#hpsum-device-list').hide();
		                $('#hpsum-component-id').html(data.hapi.components.component[0].component_id);
		                $('#hpsum-component-installation-notes').val(data.hapi.components.component[0].component_log);
		            }
		       	}
	            
            }
            
            function initDeployResults(node_id, node_name)
            {
            	var nodes = [];
        		var uri, index, op_status;
        		var bNodesDoneCount=0;
				$('.hpsumInstallables').hpsumInstallables('destroy');
        		
        		var uri = "/Session/" + session.getToken() + "/node/" + node_id;
        		
        		var tableid = 'hpsum-otu-install-results-table-' + node_id;
        		$("#all-installresults").empty();
        		$('#all-installresults').append('<div class="hp-collapsible" id="hpsum-otu-node-' + node_id + '-installresult"><label>' + node_name + ' - ' + localizer.getString('hpsum.oneTouchUpdate.deploymentResults') + '</label><div>');
        		
				
				$('#hpsum-otu-node-' + node_id + '-installresult').hpsumInstallResults();
                $('#hpsum-otu-node-' + node_id + '-installresult').hpsumInstallResults('viewLogHandler', { success:function(data){ 
                                                                                    onCompGetLogsSuccess(data); 
                                                                                },
                                                                            error:function(data){ 
                                                                                    onCompGetLogsError(data); 
                                                                                } 
                                                                         } );
                                                                         
                $('#hpsum-otu-node-' + node_id + '-installresult').hpsumInstallResults("setNodeId",node_id);
                $('#hpsum-otu-node-' + node_id + '-installresult').hpsumInstallResults("populateTable");
            }
            
            //Reset functionality
            function initReset() {
            	var oTable;
            	//clear all the tables
            	oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
            	oTable.fnClearTable();
				$('.hpsumInstallables').hpsumInstallables('destroy');
            	
            	oTable = $(INVENTORY_NODE_TABLE).dataTable();
            	oTable.fnClearTable();
            	
            	oTable = $(INSTALLPROGRESS_TABLE).dataTable();
            	oTable.fnClearTable();
            	
            	//Initialize the wizard steps
            	showWizardStep(STEP_INVENTORY);
            	hideWizardStep(STEP_REVIEW);
            	hideWizardStep(STEP_DEPLOY);
				
				//re-initialize bread crumbs
				$("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step-selected");
				$("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
				$("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step");
            	
            	bInProgress = false;
                abortButtonPressed = false;
            	
            	loadBaselines();
            	loadNodes();
            	
            	//disable Actions menu in the beginning
				$('#hpsum-otu-actions').hide();
		
		//reset global gnodeNodeSettings array
				gnodeNodeSettings = [];
            	
				window.location.reload(); 
            }
            
            function onNodeOptionChange(){
            	
            	var data = [];
            	
            	if($(this).length <= 0)
            		return;
            	
            	if($(this)[0].id === "node-localhost" && $(this)[0].checked === true) {
            		$('#hpsum-otu-action-node').hide();
            		$('#hpsum-otu-action-baseline').hide();
            	}
            	else if($(this)[0].id === "node-multiple" && $(this)[0].checked === true) {
            		
            		$('#hpsum-otu-action-node').show();
            		$('#hpsum-otu-action-baseline').show();
            	}
        		else if($(this)[0].id === "non-interactive-mode" && $(this)[0].checked === true) {
        			$(".optional-div").hide();
        		}
        		else if($(this)[0].id === "interactive-mode" && $(this)[0].checked === true) {
        			$(".optional-div").show();
        		}
            }
            
            function onModeChange(){
            	
            	if($(this).length <= 0)
            		return;
            	
            	var nodeOption = $('input[name=node-option]:checked').val();
            	
            	if($(this)[0].id === "interactive-mode" && $(this)[0].checked === true) {
            		
            		if(nodeOption === "node-localhost") {
                		$('#hpsum-otu-action-node').hide();
                		$('#hpsum-otu-action-baseline').hide();
                	}
                	else {
                		$('#hpsum-otu-action-node').show();
                		$('#hpsum-otu-action-baseline').show();
                	}
					
				}
            	else if($(this)[0].id === "non-interactive-mode" && $(this)[0].checked === true) {
            		if(nodeOption === "node-localhost") {
                		$('#hpsum-otu-action-node').hide();
                		$('#hpsum-otu-action-baseline').hide();
                	}
                	else {
                		$('#hpsum-otu-action-node').show();
                		$('#hpsum-otu-action-baseline').show();
                	}
            	}
        	}
			
			function selectComponents() {
				if($('#chkboxheader').attr('checked')) 
				{
					$('.chkboxcomp').attr('checked', true);
				}
                else {
					$('.chkboxcomp').attr('checked', false);
				}
			}
            
            function changeLocation(location) {
                
            }
            
            function toggleExpansion(row) {
                if (row.hasClass('hp-expanded')) {
                    $('> td > .hp-collapser', row).removeClass('hp-active');
                    row.removeClass('hp-expanded');
                    row.next().hide();
                } else {
                    $('> td > .hp-collapser', row).addClass('hp-active');
                    row.addClass('hp-expanded');
                    if ($('.hp-plot', row.next()).children().length === 0) {
                        //initStatistics(row.next());
                    }
                    row.next().show();
                }
            }
            
            //Initializes baseline and node inventory tables
            function initInventoryTables() {
            	//Sample data added here to example for table data
				var data = [{status: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>', 
                			baseline_name: 'HP Service Pack for Proliant 2012',
                			baseline_status: 'Processing baseline inventory',
                			baseline_progress: '<div id="baseline-progress"></div>',
                			baseline_details: 'Total 499 components found',
                			baseline_uri: '/Session/session1/Baseline/location/bl1/bundle/bp00001',
                			op_status: 'started'}];
				    
				var oTab = $(INVENTORY_BASELINE_TABLE).dataTable({
				    oLanguage: {
				        sEmptyTable: localizer.getString('hpsum.node.noItemsFound')
				    },
				    bPaginate: false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    //aaData: data,
				    aoColumns : [
				        {mDataProp: 'status', sClass: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>'},
				        {mDataProp: 'baseline_name'},
				        {mDataProp: 'baseline_status'},
				        {mDataProp: 'baseline_progress', sClass: '<div id="baseline-progress"></div>'},
				        {mDataProp: 'baseline_details'},
				        {mDataProp: 'baseline_uri', "bVisible": false},
				        {mDataProp: 'op_status', "bVisible": false}],
				    aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
				    }
				    });//.rowReordering().addClass('hp-reorderable');
				 
				$(INVENTORY_BASELINE_TABLE + ' tbody tr').first().addClass('hp-selected');
								
				//Sample data added here to show node inventory progress
                var dataNode = [{status: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>', 
                			node_name: '127.0.0.1',
                			node_status: 'Inventory in progress',
                			node_progress: '<div id="node-progress"></div>',
                			node_details: 'Success or error',
                			node_uri: '/node/',
                			op_status: 'started',
                			progress: 10,
                			node_type: 'windows'}];
				    
				var oTab = $(INVENTORY_NODE_TABLE).dataTable({
				    oLanguage: {
				        sEmptyTable: localizer.getString('hpsum.node.noItemsFound')
				    },
				    bPaginate: false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    //aaData: dataNode,
				    aoColumns : [
				        {mDataProp: 'status', sClass: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>'},
				        {mDataProp: 'node_name'},
				        {mDataProp: 'node_status'},
				        {mDataProp: 'node_progress', sClass: '<div id="node-progress"></div>'},
				        {mDataProp: 'node_details'},
				        {mDataProp: 'node_uri', "bVisible": false},
				        {mDataProp: 'op_status', "bVisible": false},
				        {mDataProp: 'progress', "bVisible": false},
				        {mDataProp: 'node_type', "bVisible": false}],
				    aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
				    }
				    });
				 
				$(INVENTORY_NODE_TABLE + ' tbody tr').first().addClass('hp-selected');
            }
            
            //Initialize component device info row table 
            function initFailedDependencyTable(tableid) {
            	
            	var oTab = $(tableid).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : false,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
				    	{mDataProp: 'failed_dependency'}
				        ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
			 
				$(tableid + ' tbody tr').first().addClass('hp-selected');
			}
            
            //Initialize component device info row table 
            function initDevicesHeaderTable(tableid) {
            	
            	var oTab = $(tableid).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : false,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
				    	{mDataProp: 'deviceid'},
				    	{mDataProp: 'productid'}
				        ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
			 
				$(tableid + ' tbody tr').first().addClass('hp-selected');
			}
			
			//Initialize component device info row table 
            function initDevicesRowTable(tableid) {
            	
            	var oTab = $(tableid).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : false,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
				    	{mDataProp: 'type'},
				    	{mDataProp: 'fw_item_status'},
				    	{mDataProp: 'active_version'},
				    	{mDataProp: 'version'}
				        ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
			 
				$(tableid + ' tbody tr').first().addClass('hp-selected');
			}
            
            function initDeployProgressTable() {
            	
            	var data = [{status: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>',
            				node_name: '127.0.0.1',
            				node_status: 'Deployment in progress 3/25', 
                			node_progress: '<div id="install-progress"></div>',
                			node_details: 'Deployment in progress 3/25',
                			node_uri: 'node/localhost',
                			op_status: 'started',
                			node_id: 'N127h0h0h1',
                			progress: 0}];
				    
				var oTab = $(INSTALLPROGRESS_TABLE).dataTable({
					bPaginate : false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    //aaData: data,
				    aoColumns : [
				        {mDataProp: 'status', sClass: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>'},
				        {mDataProp: 'node_name'},
				        {mDataProp: 'node_status'},
				        {mDataProp: 'node_progress', sClass: '<div id="install-progress"></div>'},
				        {mDataProp: 'node_details'},
				        {mDataProp: 'node_uri', "bVisible": false},
				        {mDataProp: 'op_status', "bVisible": false},
				        {mDataProp: 'node_id', "bVisible": false},
				        {mDataProp: 'progress', "bVisible": false}],
				    aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
				    }
				    });
			 
				$(INSTALLPROGRESS_TABLE + ' tbody tr').first().addClass('hp-selected');
            	
            }
            
            function initDeployResultsTable(tableid) {
            	
            	var oTab = $(tableid).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString("hpsum.node.noApplicableComponentsFound"),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bRetrieve : true,
				    bDestroy : true,
				    bFilter : true,
				    bSort : true,
				    bAutoWidth : false,
				    bInfo : false,
				    //aaData: data,
				    aoColumns : [
				        {mDataProp: 'status', sClass: '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>'},
				        {mDataProp: 'component_id'},
				        {mDataProp: 'name'},
				        {mDataProp: 'installation_result'},
				        {mDataProp: 'view_log', "bVisible": false},
				        {mDataProp: 'node_uri', "bVisible": false},
				        {mDataProp: 'op_status', "bVisible": false}],
				    aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
				    }
				    });
			 
				$(tableid + ' tbody tr').first().addClass('hp-selected');
            	
            	$(tableid + " tbody tr").click( function( e ) {
					var data = oTab.fnGetData( this );
        		});
            }
            function getBaselineData(nodeValue){
				var BASELINE_DIV;
				if(nodeValue === "one")
					BASELINE_DIV = "#hpsum-localhost";
				else if(nodeValue === "two")
					BASELINE_DIV ="#hpsum-existing-node";
				else if(nodeValue === "three")
					BASELINE_DIV = "#hpsum-newnode-baseline";

				var inst = $(BASELINE_DIV).data('plugin_hpsumAddNodeDetails');
				var baseline_options = inst.getSelectedBaseline();
				if(baseline_options)
				{
                    newHotFix = baseline_options.newHotFix;
                    newBaseline = baseline_options.newBaseline;
					
					if(newHotFix != null || newBaseline != null)
					{
						isGuidedUpdateWithBaselines = true;
						//$('#hpsum-otu-inventory-baseline-collapse').hide();						
					}
					else
						isGuidedUpdateWithBaselines = false;
						
					return true;
				}
				else{
					return false;
				}
			}
			function validateIP(){
				var isIPValid;
				var ip = $("#hpsum-node-name").val();
				var status;
				
				if(ip == ''){
					status = localizer.getString('hpsum.node.required');
					isIPValid = false;
				}
				else if(ip.toLowerCase() == 'localhost')
            		isIPValid = true;
            		//ipv4 match
            	else if(ip == '0.0.0.0' | ip == '255.255.255.255'){
            		status = localizer.getString('hpsum.node.ipCannotBe') + ' ' + ip;
            		isIPValid = false;
            	}
				else{
					var patt = /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
					if(ip.match(patt))
						isIPValid = true;
					else{
						patt = /^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))?$/;
						if(ip.match(patt))
							isIPValid = true;
						else {
							status = localizer.getString('hpsum.node.notValidIpOrDns');
							isIPValid = false;
						}
					}
				}
				
				if(!isIPValid){
					$("#hpsum-node-name-err").show();
					$("#hpsum-node-name").addClass("hp-error");
					$("#hpsum-node-name-err").addClass("hp-error");
					$("#hpsum-node-name-err").html(status);
				}
				
				return isIPValid;
			}
			function validateIPdetails(value) {
				
				var isValid = true;
				if(value === "three" && validateIP()){
					var NODE_DIV = "#hpsum-newnode-credentials";
					var inst = $(NODE_DIV).data('plugin_hpsumAddNodeDetails');
				
					isValid = inst.validateCredentials();
				}
				else if(value === "one")
					isValid = true;
				else if(value === "two" && selectedNode != ''){
					isValid = true;
				}
				else{
					isValid = false;
					$("#hpsum-existing-node-err").html("Required");
					$("#hpsum-existing-node-err").show();
				}
				
				return isValid;
			}

			function nodeOptions(value){
				var DIV_ID;
				var nodeItem = [];
				
          		if(value && value.target)
            		value = value.target.value;
            	if(value == "one"){
					$("#hpsum-existing-node-div").hide();
					$("#hpsum-newnode").hide();
					$("#hpsum-localhost").show();
					DIV_ID = "#hpsum-localhost";
					if(currNodes !== undefined)
					nodeItem = {node_id : currNodes[0].id};
            	}
            	if(value == "two"){
					$("#hpsum-localhost").hide();
					$("#hpsum-newnode").hide();
					$("#hpsum-existing-node-div").show();
					DIV_ID = "#hpsum-existing-node";					
					var selectdata = '<select id=hpsum-node-names-list class= hp-select>';
					selectdata += '<option value="">Select node</option>';
            		for(var i = 0; i < allNodes.length; ++i) { 
						if(!allNodes[i].node_phase.match(/unknown/i)){
							var node_name = allNodes[i].node;
							var node_id = allNodes[i].node_id;
							if(node_name !== "localhost")
								selectdata += '<option value="' + node_id + '">' + node_name + '</option>';
						}
            		}
            		selectdata += '</select>';
					selectdata += '<label id="hpsum-existing-node-err" class="hp-error" style="display: none;"></label>';
					$("#hpsum-existing-node-err").hide();
            		$('#hpsum-node-names').html(selectdata);
					$('#hpsum-node-names-list').selectBox({autowidth: false});
            		selectedNode = $('#hpsum-node-names-list').val();
					nodeItem = {node_id : selectedNode};
					$('#hpsum-node-names-list').change(function(){
            			selectedNode = $('#hpsum-node-names-list').val();
						$("#hpsum-existing-node-err").hide();
						nodeItem = {node_id : selectedNode};
						if(selectedNode != '')
						{
							NodePresenter.getNodeData(nodeItem, {
								success : function(data) {
									var options = {
										command : 'loadBaselineData',
										args : data.hapi
									};
									$(DIV_ID).hpsumAddNodeDetails(options);
								},
								error:function()
								{}
							});
						}
						else
						{
							var data = {
								baselines:[]
							};
							var options = {
								command : 'loadBaselineData',
								args : data
							};
							$(DIV_ID).hpsumAddNodeDetails(options);
						}
            		});
            	}
				if(value == "three"){
					$("#hpsum-existing-node-div").hide();
					$("#hpsum-localhost").hide();
					$("#hpsum-newnode").show();
					$("#hpsum-node-name").show();
					$("#hpsum-node-name").removeClass("hp-error");
					$("#hpsum-node-name-err").hide();
					$("#hpsum-node-name-err").removeClass("hp-error");
					DIV_ID = "#hpsum-newnode-baseline";
					
            	}
            	
				if(value != "three" && nodeItem.node_id != ''){
					NodePresenter.getNodeData(nodeItem, {
						success : function(data) {
							
							var item = {
								isGuidedUpdate : true,
								data : data.hapi
							};
							//The command 'loadBaselines' is created by merging both the functions
							//"getAllBaselines" and "loadBaselinedata" to handle asynchronous ajax call by 
							//using JQuery deferred object
							var options = {
								command : 'loadBaselines',
								args : item
							};
							$(DIV_ID).hpsumAddNodeDetails(options);
						},
						error:function()
						{}
					});
				}
            }
            /**
             * @public
             */
            this.pause = function () {
            	//$('.hpsumInstallables').hpsumInstallables('destroy');
            };
            
            this.resume = function () {
                if(bInProgress == false)
                {
                	//load baselines list. This is used to display in action dialog baselines table 
                	loadBaselines();
                
                	//load nodes list. This is used to display in action dialog nodes table
                	loadNodes();
                	
                	//disable Actions menu in the beginning
					$('#hpsum-otu-actions').hide();
					
			//reset global gnodeNodeSettings array
					gnodeNodeSettings = [];
                
					showActionDialog();
					
					bStartDeploy = false;
					$('#hpsum-otu-inventory-baseline-collapse').show();
					$('#hpsum-otu-action-title-message').text(localizer.getString("hpsum.oneTouchUpdate.baselineNodeInvTitle"));
				}
					else
					{	
						if(window.bRefreshReview == true && $('#hpsum-step2')[0].className == "hpsum-bread-crumbs-step-selected")
						{
							recalculateInstallReview();
							window.bRefreshReview = false;
						}
					}
					/*var nodeValue = $('input[name="node-option"]:checked').val();
					nodeOptions(nodeValue);*/
            };
            
			function getBaseline(string, handlers, count, start){
            	var results=[];
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(baselines, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results, start: 0, total: results.length});
        	}
            function getHotfixes(string, handlers, count, start){
          		  	var results=[];
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(hotfixes, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results, start: 0, total: results.length});
          	}
          
           function getBaselinesSuccess(searchResults)
            {
					baselines = $.grep(searchResults, function (option, index ) {
        				return !(option.name.match(new RegExp('^Additional', 'i')));
        			});
        			hotfixes = $.grep(searchResults, function (option, index) {
        				return (option.name.match(new RegExp('^Additional', 'i')));
           			});
            	
            }
            
            function getBaselinesError(msg)
            {
            	
            }
			
			function enableDisableButton(enable)
			{
				if(enable){
					var parent = $('#hpsum-action-ok');
					var okBtn = $('#hpsum-action-ok', parent);
					$(okBtn).removeAttr("disabled");
					$(okBtn).attr("enable", "enable");
				}
				else{
					var parent = $('#hpsum-action-ok');
					var okBtn = $('#hpsum-action-ok', parent);
					$(okBtn).removeAttr("enable");
					$(okBtn).attr("disabled", "disabled");
				}
			}
			
            this.init = function () {
                window.bRefreshReview = false;
            	$(DELTA_BASE).hpSelect();
                document.title = localizer.getString("hpsum.oneTouchUpdate.title") ;
				$('#hpsum-otu-action-title-message').text(localizer.getString("hpsum.oneTouchUpdate.baselineNodeInvTitle"));
				$('#hpsum-otu-inventory-baseline-collapse').show();
                
            	$('.hp-details-actions').hpDropMenu();
				
				$('#hpsum-otu-action-node').hide();
				$('#hpsum-otu-action-baseline').hide();
				
				//Disable Actions until the Inventory finishes
				$('#hpsum-otu-actions').hide();
				
				actionDialogContents = $(ACTION_DIALOG).detach().show();
				autoConfDialogContents = $(AUTOMATIC_UPDATE_CONFIRM).detach().show();
				
				//Initialize wizard tables
				initInventoryTables();
                initDeployProgressTable();
                
                //load baselines list. This is used to display in action dialog baselines table 
                loadBaselines();
                //load nodes list. This is used to display in action dialog nodes table
                loadNodes();
                
                //Initialize action dialog tables
                initActionNodeTable();
				initActionBaselineTable();
				
				$(ADD_BASELINES, actionDialogContents).click(onAddBaselines);
            	$(ADD_NODES, actionDialogContents).click(onAddNodes);
            	
				var setting = {
				    ctrls: $("#wizard section"), //Structure for Steps
				        deployButtonTitle: localizer.getString("hpsum.node.doDeploy"),
		                nextButtonTitle: localizer.getString("hpsum.common.next"), 
		                nextButtonCss: 'hp-button hp-primary',
		                callBack: btnNextClicked, 
		                previousButtonTitle: localizer.getString("hpsum.common.back"), 
						callBackPrev: btnPrevClicked,
						previousButtonCss: 'hp-button hp-secondary',
						finishButtonTitle: localizer.getString("hpsum.oneTouchUpdate.reboot"), 
						callFinish: btnFinishClicked,
						finishButtonCss: 'hp-button hp-primary',
						abortButtonTitle: localizer.getString("hpsum.common.abort"),
						callAbort: btnAbortClicked,
						abortButtonCss: 'hp-button hp-secondary',
						resetButtonTitle: localizer.getString("hpsum.common.startOver"),
						callReset: btnResetClicked,
						resetButtonCss: 'hp-button hp-secondary',
						analyzeButtonTitle: localizer.getString("hpsum.oneTouchUpdate.analyze"), 
						callAnalyze: btnAnalyzeClicked,
						analyzeButtonCss: 'hp-button hp-secondary',
						validateWizardStep: validateStep,
		                validateWizardByTitle: validateByTitle,
		                initStep: '0'
		    	};
		        				
				showWizardScreen(setting);
				
				//////////////////////////////////////////////////////////////////////////////////////
				//The following lines are commented for HPSUM 6.0.0 as we are not supporting multiple nodes/baselines options
				//This code avoid showing of Nodes and Baseliens tables for selection
				//These lines can be uncommented in future release when we need multiple nodes/baselines support in Guided update
				//$('input:radio[name=node-option]', actionDialogContents).click(onNodeOptionChange);
                //$('input:radio[name=mode-option]', actionDialogContents).click(onModeChange);
                //////////////////////////////////////////////////////////////////////////////////////
				
				//if offline interactive or automatic, then no need to show action dialog
				//one touch update shall happen with default values for local host and default working directory
				//get the property from guimode cookie
				var guimode = session.getProperty("gui_mode");
				 
				if(guimode === "offline_automatic" ||
					guimode === "offline_interactive" || guimode === "express")
				{
					
					if(guimode === "offline_automatic" || guimode === "express")
                      {
						$('#hp-exit-control').hide();
						hideAllButtons(STEP_INVENTORY);				
                      }
                      else if(guimode === "offline_interactive")
					  {
						  var handlers = { success:function() {
							  var newWindow = window.open('', '_self', '');
							  newWindow.close();
						  }, 
							  error: function() {
										 var newWindow = window.open('', '_self', '');
										 newWindow.close();
										 Log.error("Failed to shutdown HP Smart Update Manager");
									 }
						  };
						  $("#hpsum-offline-exit").click(function() {
							  var shutdownData = { hapi: {
								  force: 'false'
							  }};
							  session.shutDown(shutdownData, handlers);
						  });
					  }

					startOneTouchUpdate();
				}
				else
				{
                   //We will not show exit button in online Local guide update
                    $('#hp-exit-control').hide();
					showActionDialog();
				}	
            	
            	$(".hp-collapsible").hpCollapsible();
                $(".hp-collapsible").hpCollapsible("expand");
                
                $('#chkboxheader').on('click', selectComponents);
                
                $(VIEW + ' .hp-status').hpStatus();
                $(VIEW).on('click', 'td > .hp-collapser', function (ev) {
                    toggleExpansion($(this).parents('tr').first());
                });
                
                componentLogDialogContents = $(COMPONENT_DIALOG).detach().show();
				$('input[name="node-option"]').click(nodeOptions);
				$("#hpsum-existing-node-div").hide();
				$("#hpsum-newnode").hide();
				$("hpsum-node-name").hide();
				$("#hpsum-localhost").hpsumAddNodeDetails('init');
				$("#hpsum-existing-node").hpsumAddNodeDetails('init');
				$("#hpsum-newnode").hpsumAddNodeDetails('init');
				$("#hpsum-newnode-baseline").hpsumAddNodeDetails('init'); 
				$("#hpsum-newnode-ipdetails").hpsumAddNodeDetails('init'); 
				$("#hpsum-newnode-credentials").hpsumAddNodeDetails('init');
				var item = {
					enableAssignBaselineCheckbox : true,
					showAssignedBaselines : true,
					baselineLabel : localizer.getString('hpsum.node.addBaselineOptionalGU')
				};
				var options = {
					command : 'addBaseline',
					args : item
				};
				$("#hpsum-localhost").hpsumAddNodeDetails(options);
				$("#hpsum-existing-node").hpsumAddNodeDetails(options);
				var nodeDetails = {
                                      enableAssociateNodes:false,
                                  };
				options = {
                    command:'addNodeDetails',
                    args: nodeDetails
                }; 
				$("#hpsum-node-name").bind('keydown',function() {
					$("#hpsum-node-name").removeClass("hp-error");
					$("#hpsum-node-name-err").removeClass("hp-error");
					$("#hpsum-node-name-err").hide();
				});
				$("#hpsum-newnode-ipdetails").hpsumAddNodeDetails(options);
				item = {
					enableAssignBaselineCheckbox : false,
					showAssignedBaselines : false,
					baselineLabel : localizer.getString('hpsum.node.addBaselineOptionalGU')
				};
				options = {
					command : 'addBaseline',
					args : item
				};
				$("#hpsum-newnode-baseline").hpsumAddNodeDetails(options); 
				$("#hpsum-newnode-credentials").hpsumAddNodeDetails('addCredentials');  
				  
                //Notification area added 
                notificationsView.init({context: $(VIEW),
                    allLocation: '#/node/show/activity',
                    resource: NodePresenter.resource()});
			};

            function clearNotifications() {
                if (notificationsCleared === false) {
                    notificationsView.remove({
                        status: status,
                        summary: summary,
                        details: details
                    });
                    notificationsView.clear();
                    notificationsCleared=true;
                }
            }
        }

        return new OneTouchUpdateView();
    }());
    
    return OneTouchUpdateView;
});