// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter', 
    'hp/core/UrlFragment',
    'hp/core/Router',
    'hp/core/LinkTargetBuilder',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
    'jquery',
    'lib/jquery.dataTables',
    'hpsum/view/node/jquery.hpsumWarnings', 
    'hp/lib/jquery.hpGridPanels'],
function(presenter, urlFragment,router, linkTargetBuilder, noneHtml, localizer) { "use strict";

    var ServerShowOverviewView = (function() {
      
        var ROOT = '#tour-server-show-overview';
        var PANELS = '.hp-grid-panels',
        	DESCRIPTION = '#hpsum-server-description',
        	TYPE ='#hpsum-server-type',
        	BASELINE='#hpsum-server-bundle',
        	LOCATION='#hpsum-server-location',
        	NPAR='#hpsum-server-npar',
        	NPAR_DETAIL = '#hpsum-npar-detail',
        	ILO = '#hpsum-server-ilo',
        	OA = '#hpsum-server-oa',
        	SYSROM ='#hpsum-server-sysrom',
        	OS = '#hpsum-server-os',
        	CPU	= '#hpsum-server-cpu',
        	MEMORY ='#hpsum-server-memory',
            GROUP = '#hpsum-server-group',
            SPINNER = '#hpsum-node-add-spinner',
            INSTALL_LOGS = '#hpsum-server-install-log',
			EDIT_GENERAL = '#hpsum-server-general-edit';
      
        /**
         * Constructor
         */
        function ServerShowOverviewView() {
          
            var noItem,
            	thisNode = null;
            
            function onItemChange(item) {
            	item = item.hapi;
            	thisNode = item; 
                noItem.remove();
                
        		item.type = item.type.toLowerCase();
        		var uitype = presenter.getUINodeType(item.type);
        		$(ROOT).closest('section').show();
        		
        		if(!router.location().match(uitype)) {
        		    if(router.location().indexOf("/node") == 0)
        		    	router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')), "server show overview");
        		    else {
        		    	$(ROOT).closest('section').hide();
        		      	return;
        		    }
                }
                
                $(NPAR_DETAIL).hide();
                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();
				
				$(EDIT_GENERAL).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
				if(item.node_state.match(/inventory/i) || item.node_state.match(/installhold/i) || item.node_state.match(/pendingfwupdate/i) ||
                   item.node_state.match(/activatependingfwupdate/i) || item.node_state.match(/scheduled/i) || item.node_state.match(/Install$/i) || 
				   item.node_state.match(/activate_pending/i)){
					$(EDIT_GENERAL).addClass('hp-disabled');
					$('.hp-disabled').css("color", "grey").bind('click.disable-link', function(e) {
						e.preventDefault();
						return false;
					});	
				}
				
                if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i))
                {
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        			 presenter.startNodeStatus(item);
        		}
        		else {
        			$(SPINNER).hide();
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');
        			$(DESCRIPTION).text(item.description);
        			if(item.hasOwnProperty('rom_version')) {
        				$(LOCATION).text(item.serialnumber);
        				$(OS).text(item.os);
        				$(SYSROM).text(item.rom_version);
        				$(CPU).text(item.vendor + ' ' +item.architecture);
						var mem = item.memory;
        				if (mem >= 1024)
						{
						   mem = (mem/1024).toFixed(2);
						   if (mem >=1024)
						   {
						     mem = (mem/1024).toFixed(3);
							 mem = mem + "GB";
						   }
						   else 
						   mem = mem + "MB";
						}
						else 
						mem = mem + "KB";
						$(MEMORY).text(mem);
        				$(TYPE).text(item.server_type);
        			}
        			else {
        				$(LOCATION).text('');
        				$(OS).text(item.type.match(/hpux/i) ? "HP-UX" : item.type);
        				$(SYSROM).text('');
        				$(CPU).text('');
        				$(MEMORY).text('');
                        $(GROUP).text('');
        				$(TYPE).text('');
        			}
        			if(item.hasOwnProperty('npartition_id')) {
        			    $(NPAR_DETAIL).show();
        				$(NPAR).text(item.npartition_id);
					} else {
        				$(NPAR).text('');
					}
					
        			if(item.hasOwnProperty('ilo_address')) {
        				$(ILO).text(item.ilo_address);
						$(ILO).parent().show();
					} else {
        				$(ILO).text('');
						$(ILO).parent().hide();
					}
        			if(item.hasOwnProperty('oa_address')) {
        				$(OA).text(item.oa_address);
						$(OA).parent().show();
					} else {
        				$(OA).text('');
						$(OA).parent().hide();
					}
        			var fwBaseline =presenter.getBaselineOrPkg(item.baselines);
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));        				
        			showStorageInfo(item);
        			showConnectionInfo(item);
                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();
        		}
                $(PANELS).hpGridPanels('reset');
				$(GROUP).text('');
				if( item.group_name.length == 0) {
					$(GROUP).text('none');
				}
				else {
				
					for(var iter=0 ; iter<item.group_name.length ; iter++)
					{
						var group_uri = '#/group/show/overview/r/session/'+ item.node_session + '/node/group/' + item.groups[iter]+'/getdata';
						
						//Code changes for placement. The code needs some spacing before the individual groups are appended.
						var uri = '<a href="'+group_uri+'">' +item.group_name[iter].group_name+ '</a>' ;
						if(iter == 0) {
							$(GROUP).append(uri);
						}
						else
						{
							$(GROUP).append('&nbsp;&nbsp;' + uri);
						}
							
					}
				}
			
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
				$('#hpsum-warning-messages').hpsumWarnings(item, false);
            }
            function showStorageInfo(item){
            	$("#hpsum-server-storage-table > tbody > tr").remove();
            	$("#hpsum-server-storage-table_filter").remove();
            	$("#hpsum-server-storage-table_processing").remove();
            	var storageTable = initStorageTable();
				storageTable.fnClearTable();
            	if(item.devices === undefined)
            		return;
            	if(item.devices.storage_devices === undefined)
            		return;
            	if(item.devices.storage_devices.controllers === undefined)
            		return;					
            	if(item.devices.storage_devices.controllers.length === 0)
            		return;

            	var i;
            	
            	for (i=0; i<item.devices.storage_devices.controllers.length; i++){
            		var j;
                    if(item.devices.storage_devices.controllers[i].hasOwnProperty("drives"))
                    {
            		    for(j=0; j<item.devices.storage_devices.controllers[i].drives.length; j++)
            		    {
            			    var tableItem = [{
            						    controller:item.devices.storage_devices.controllers[i].marketing_name,
            						    location:item.devices.storage_devices.controllers[i].drives[j].type,
            						    description: item.devices.storage_devices.controllers[i].drives[j].additional_description,
            						    disk_firmware_version : item.devices.storage_devices.controllers[i].drives[j].firmware_version,
            						    controller_firmware_version : item.devices.storage_devices.controllers[i].firmware_version
            					    }];
            			    storageTable.fnAddData(tableItem);	
            		    }
          		    }
            	}

				
            		
            }
            
            function showConnectionInfo(item){
            	$("#hpsum-server-conn-table > tbody > tr").remove();
            	$("#hpsum-server-conn-table_filter").remove();
            	$("#hpsum-server-conn-table_processing").remove();
            	var connectionTable = initConnectionTable();
				 connectionTable.fnClearTable();
            	if(item.devices === undefined)
            		return;
            	if(item.devices.fchba_devices === undefined && item.devices.nic_devices === undefined)
            		return;
            	if((item.devices.fchba_devices.fchba && item.devices.fchba_devices.fchba.length === 0) &&  (item.devices.nic_devices && item.devices.nic_devices.length === 0))
            		return;
				if(item.devices.fchba_devices.length != 0)
            		{
            			var i;
            			for (i=0; i< item.devices.fchba_devices.fchba.length; i++){
            				if (!item.devices.fchba_devices.fchba[i].type && !item.devices.fchba_devices.fchba[i].additional_description) {
								continue;
							}
							var tableItem = [{
            						type:item.devices.fchba_devices.fchba[i].type,
            						description: item.devices.fchba_devices.fchba[i].additional_description,
            						firmware_version : item.devices.fchba_devices.fchba[i].firmware_version,
            						driver_version : item.devices.fchba_devices.fchba[i].driver_version
            					}];
            					connectionTable.fnAddData(tableItem);
            			}
            			
            		}
            	if(item.devices.nic_devices.length != 0)
            	{
            			var i;
            			for (i=0; i< item.devices.nic_devices.nic.length; i++){
            				if (!item.devices.nic_devices.nic[i].type && !item.devices.nic_devices.nic[i].additional_description) {
								continue;
							}
            				var tableItem = [{
            						type:item.devices.nic_devices.nic[i].type,
            						description: item.devices.nic_devices.nic[i].additional_description,
            						firmware_version : item.devices.nic_devices.nic[i].firmware_version,
            						driver_version : item.devices.nic_devices.nic[i].driver_version
            					}];
            					connectionTable.fnAddData(tableItem);
            			}
            			
									
            	}
            		
            }
            
			function initStorageTable(){
				return $('#hpsum-server-storage-table').dataTable({
				  		oLanguage: {
				  		    sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
				  		    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : true,
				    bAutoWidth : true,
				    bInfo : false,
				    bRetrieve : false,
				    bDestroy : true,
				    	aoColumns : [
				        	{mDataProp: 'controller'},
				        	{mDataProp: 'location'},
				        	{mDataProp: 'description'},
				        	{mDataProp: 'disk_firmware_version'},
				        	{mDataProp: 'controller_firmware_version'}
				        	],
				    aaSorting: [[ 0, "asc" ]],
				    });
			}
			
			function initConnectionTable() {
				return $('#hpsum-server-conn-table').dataTable({
				  		oLanguage: {
				  		    sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
				  		    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : true,
				    bAutoWidth : true,
				    bInfo : false,
				    bRetrieve : false,
				    bDestroy : true,
				    	aoColumns : [
				        	{mDataProp: 'type'},
				        	{mDataProp: 'description'},
				        	{mDataProp: 'driver_version'},
				        	{mDataProp: 'firmware_version'}
				        	],
				    aaSorting: [[ 0, "asc" ]],
				    });
				
			}
            
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
                if ($(ROOT).hasClass('hp-show-init')) {
                    $(ROOT).removeClass('hp-show-init');
                } else {
                    $(ROOT).addClass('hp-show-changing');
                    $('#tour-server-bundle-item').addClass('hp-show-changing');
                }
            }
          
            /**
             * @public
             */
            this.resume = function() {
                $(PANELS).hpGridPanels('reset');
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
                
            };
            
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                
            };
             
            this.init = function() {
            	if(!presenter.initialized())
            		presenter.init();			    
                noItem = $(noneHtml);
                $(PANELS).hpGridPanels();
                this.resume();
            };
        }

        return new ServerShowOverviewView();
    }());
    
    return ServerShowOverviewView;
});
