// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter', 
    'hp/core/UrlFragment',
    'hp/core/Router',
    'hp/core/LinkTargetBuilder',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
	'hp/model/Session',
    'jquery',
    'hp/lib/jquery.hpGridPanels'],
function(presenter, urlFragment,router, linkTargetBuilder, noneHtml, localizer, session) { "use strict";

    var VcOverviewView = (function() {
      
        var ROOT = '#hpsum-vc-show-overview';
        var PANELS = '.hp-grid-panels',
        	DESCRIPTION = '#hpsum-vc-description',
        	TYPE ='#hpsum-vc-type',
        	BASELINE='#hpsum-vc-bundle',
        	VCDOMAIN='#hpsum-vc-domain',
        	OA = '#hpsum-vc-oa',
			ASSOC_DEVICES = '#hpsum-vc-assocdevices',
        	NO_ASSOC_DEVICES ='#hpsum-vc-no-devices',
        	INSTALLEDROM ='#hpsum-vc-installed-rom',
        	HEALTHSTATUS = '#hpsum-vc-health-status',
        	MATRIXENABLED = '#hpsum-vc-matrix-enabled',
        	MATRIXVERSION = '#hpsum-vc-matrix-version',
			ROLLBACKSUPPORTED = '#hpsum-vc-rollback-supported',
			ROLLBACKVERSION = '#hpsum-vc-rollback-version',
			GROUP = '#hpsum-server-group',
        	SPINNER = '#hpsum-node-add-spinner',
            INSTALL_LOGS = '#hpsum-vc-install-log',
			EDIT_GENERAL = '#hpsum-vc-general-edit';
      
        /**
         * Constructor
         */
        function VcOverviewView() {
          
            var noItem;
            var timer= null;
            var thisNode=null;
            
            function onItemChange(item) {
            	item = item.hapi;
            	thisNode =item;
                noItem.remove();
        		item.type = item.type.toLowerCase();
        		$(ROOT).closest('section').css("display", "block");
        		
                if(!item.type.match(/virtual_connect/i)) {
                    if(router.location().indexOf("/node") == 0)             
                        router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')), "vc show overview");
                    else {
                        $(ROOT).closest('section').css("display", "none");
                        return;
                    }
                }

                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();
				
				$(EDIT_GENERAL).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
				if(item.node_state.match(/inventory/i) || item.node_state.match(/installhold/i) || item.node_state.match(/pendingfwupdate/i) ||
                   item.node_state.match(/activatependingfwupdate/i) || item.node_state.match(/scheduled/i) || item.node_state.match(/Install$/i) || 
				   item.node_state.match(/activate_pending/i)){
					$(EDIT_GENERAL).addClass('hp-disabled');
					$('.hp-disabled').css("color", "grey").bind('click.disable-link', function(e) {
						e.preventDefault();
						return false;
					});	
				}
				
        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        			 presenter.startNodeStatus(item);
        		}
        		else {
        			$(SPINNER).hide();
					$(NO_ASSOC_DEVICES).hide();
					$(ASSOC_DEVICES).hide();
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');     			
        			$(DESCRIPTION).text(item.description);
        			if(item.hasOwnProperty('vc_domain'))
        				$(VCDOMAIN).text(item.vc_domain);
        			else 
        				$(VCDOMAIN).text('');
        			if(item.hasOwnProperty('vc_installed_version')){
						$(NO_ASSOC_DEVICES).hide();
						$(ASSOC_DEVICES).show();
        				$(INSTALLEDROM).text(item.vc_installed_version);
        				$(HEALTHSTATUS).text(item.health_status);
						$(ROLLBACKSUPPORTED).text(item.rollback_supported);
						$(ROLLBACKVERSION).text(item.rollback_version);
						if(item.assoc_node_id){
							var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/' + item.assoc_node_id + '/getdata';
							$(OA).html ('<a href="' + assoc_node_url + '">' + item.oa_address+ '</a>');
						}
        				else{
							$(OA).text(item.oa_address);
        				}
        			}
        			else{
        				$(INSTALLEDROM).text('');
        				$(HEALTHSTATUS).text('');
						$(ROLLBACKSUPPORTED).text('');
						$(ROLLBACKVERSION).text('');
						$(NO_ASSOC_DEVICES).show();
        				$(ASSOC_DEVICES).hide();
        			}
        			showVCModules(item);
        			if(item.alt_name == undefined)
        				$(TYPE).text(item.type);
        			else
        				$(TYPE).text(item.alt_name);
        			
					$(GROUP).text('');
					if( item.group_name.length == 0) {
						$(GROUP).text('none');
					}
					else {
				
						for(var iter=0 ; iter<item.group_name.length ; iter++)
						{
							var group_uri = '#/group/show/overview/r/session/'+ item.node_session + '/node/group/' + item.groups[iter]+'/getdata';
							
							//Code changes for placement. The code needs some spacing before the individual groups are appended.
							var uri = '<a href="'+group_uri+'">' +item.group_name[iter].group_name+ '</a>' ;
							if(iter == 0) {
								$(GROUP).append(uri);
							}
							else
							{
								$(GROUP).append('&nbsp;&nbsp;' + uri);
							}
								
						}
					}
        			var fwBaseline =presenter.getBaselineOrPkg(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  

                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();

        		}
                $(PANELS).hpGridPanels('reset');
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }
            
            function showVCModules(item){
            	if(item.devices === undefined)
            		return;
            	if(item.devices.device === undefined)
            		return;
            		
                $("#hpsum-vc-modules-table > tbody > tr").remove();
                $("#hpsum-vc-modules-table_filter").remove();
                $("#hpsum-vc-modules-table_processing").remove();
                var modulesTable = initModulesTable();
                modulesTable.fnClearTable();
            		 
            	var i;
            	for ( i=0; i<item.devices.device.length; i++){
            		var tableItem = [{
            						devicenumber: item.devices.device[i].devicenumber,
            						enclosure: item.devices.device[i].enclosure,
            						type: item.devices.device[i].product_id,
            						active_version : item.devices.device[i].fw_item.active_version,
            						version: item.devices.device[i].fw_item.version,
            						health_status : item.devices.device[i].fw_item.health_status
            					}];
            		modulesTable.fnAddData(tableItem);
            	}
            }
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
                if ($(ROOT).hasClass('hp-show-init')) {
                    $(ROOT).removeClass('hp-show-init');
                } else {
                    $(ROOT).addClass('hp-show-changing');
                    $('#tour-server-bundle-item').addClass('hp-show-changing');
                }
            }
            
            function initModulesTable() {
                return $('#hpsum-vc-modules-table').dataTable({
                        oLanguage: {
                            sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
                            sSearch: localizer.getString('hpsum.common.search')
                               },
                    bPaginate : false,
                    bProcessing : true,
                    bFilter : true,
                    bSort : true,
                    bAutoWidth : true,
                    bInfo : false,
                    bRetrieve : false,
                    bDestroy : true,
                        aoColumns : [
                            {mDataProp: 'devicenumber'},
                            {mDataProp: 'enclosure'},
                            {mDataProp: 'type'},
                            {mDataProp: 'active_version'},
                            {mDataProp: 'version'},
                            {mDataProp: 'health_status'}
                            ],
                    aaSorting: [[ 0, "asc" ]],
                    });                
            }
          
            /**
             * @public
             */
            this.resume = function() {
                $(ROOT).closest('section').css("display", "block");
                $(PANELS).hpGridPanels('reset');
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
                
            };
            
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                
            };
             
            this.init = function() {
            	if(!presenter.initialized())
            		presenter.init();
                noItem = $(noneHtml);
                $(PANELS).hpGridPanels();
                this.resume();
            };
        }

        return VcOverviewView;
    }());
    
    return new VcOverviewView;
});
