// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define([
	'hp/model/Session',
	'hpsum/presenter/baseline/BaselinePresenter',
  	'hpsum/presenter/node/NodePresenter',
  	'hpsum/presenter/group/GroupPresenter',
  	'hp/core/Localizer',
	'jquery',
  	'hp/lib/jquery.hpSelect'],
function(session, BaselinePresenter, NodePresenter, GroupPresenter, localizer) { "use strict";

    var WelcomeView = (function() {
    	
    	var UNSUPPORTED_BROWSER = '#hpsum-unsupported-browser';
      
        /**
         * Constructor
         */
        function WelcomeView() {
        	
        	/**
             * @private
             */
          
          	function addDefaultBaseline(){
          		//add working directory as default location to add baseline
                var item = {location: "default",
                			locationType: 'local'
                			};
                BaselinePresenter.addDefaultBaseline(item, {
                    			success : function(data) {
                        			//baseline added successfully
                        			if (0 == data.hapi.hcode) {
                        				BaselinePresenter.inventoryDefaultBaseline(data, {
                        					success : function(status){
                        					},
                        					error : function(errormsg){
                        					}
                        				});
                        			}
                    		 	},
                    			error : function(errorInfo) {
                        			//baseline failed to add
                    			}
                });
          	}
          	
          	function addLocalHost(){
          		//add localhost as default node
                var item = {ip:'localhost', name: 'localhost', type:'unknown', use_current_credentials: true};
            	NodePresenter.addItem(item, null, {
                    			success : function(data) {
                        			//localhost node added successfully
                        			//Add a Default group
                        			//addDefaultGroup(data.hapi.node_id);// removed as part of HFS requirement 
                    		 	},
                    			error : function(errorInfo) {
                        			//localhost failed to add
                    			}
                });
          	}
          
          	
          	//Parse the navigator object's userAgent string and return the browser type & version
          	function getBrowser() {
				    var ua = navigator.userAgent.toLowerCase();
				
				    var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
				        /(webkit)[ \/]([\w.]+)/.exec( ua ) ||
				        /(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
				        /(msie) ([\w.]+)/.exec( ua ) ||
				        ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
				        [];
				        
				        //Workaround for ie11, identify the layout engine 'Trident'
				        if(ua.match(/trident/i)) {
				            match [ 1 ] = 'msie';
				        }
				
				    return {
				        browser: match[ 1 ] || "",
				        version: match[ 2 ] || "0"
				    };
			}
			
			function isBrowserSupported(browserObj) {
				if(browserObj.browser == 'msie' || browserObj.browser == 'mozilla' || browserObj.browser == 'chrome') {
					return true;
				} else {
					return false;
				}
			}
			
			function isPlatformLinux() {
			    if(navigator.platform.match(/linux/i)) {
			        return true;
			    } else {
			        return false;
			    }
			}
				
			function isBrowserVerSupported(browserObj) {			
				if (browserObj.browser == 'msie' && parseInt(browserObj.version) < 9) {
					return false;
				} else if (browserObj.browser == 'mozilla' && parseInt(browserObj.version) < 18 && !isPlatformLinux()) {
					return false;
				} else if (browserObj.browser == 'mozilla' && parseInt(browserObj.version) < 17 && isPlatformLinux()) {
                    return false;
                } else if (browserObj.browser == 'chrome' && parseInt(browserObj.version) < 24) {
					return false;
				} else {
					return true;
				}
			}
			
			function updateUserSessionDetails()
			{
				var sessionDataHandlers = {
		                success : function(data) {
		                    
		                    //if hcode is 0 then session is alive and set session cookies
		                    if(data.hapi.hcode == 0) {
		                  	   	//save user name in the session cookie
		                    	session.saveUser(data.hapi.username)

                          session.saveSesionLanguage(data.hapi.language);
		                    	
		                    	//save login time in the session cookie
		                    	var loggedinTime = Date.parseISOString(data.hapi.timeLoggedIn);
		                    	session.saveLoginTime(loggedinTime.toISOString());
		                    }
		                    else
		                    {
		                    	//if session is expired or any other error, then goto login page
		                    	session.eraseAll();
		                    	document.location.href = "/#/login";
		                    }
		                },
		                error : function(jqXHR) {
		                	//getsessiondata failed, so goto login page
		                    session.eraseAll();
		                    document.location.href = "/#/login";
		                }
		       	};
		       	
				//get session data and set user and login details for the session
				session.getSessionData(sessionDataHandlers);
			}
                      	
            /**
             * @public
             */
            this.pause = function () {
            };
            
            this.resume = function () {
            	$('#hp-main-menu-control').trigger('click');
                $('#hp-overlay').removeClass('hp-active');
			document.title = localizer.getString('hpsum.title' ) + hpsumShortVersionStr;
            };
            
            this.init = function () {
                //document.title = 'Welcome';
                //$('.hp-button.hp-primary').focus();
                
                var browserObj = getBrowser();
                
                if(!isBrowserSupported(browserObj)){
                	$(UNSUPPORTED_BROWSER).removeClass('hp-disabled');
                	$(UNSUPPORTED_BROWSER).html('<h2></h2><div class=\"hp-notify hp-notify-warning hp-active\" style=\"background-color:#fffdd7\"><p><b>'+ localizer.getString('hpsum.common.unsupportedBrowser') +'</b></p></div>')                	
                } else if (!isBrowserVerSupported(browserObj)){
                	$(UNSUPPORTED_BROWSER).removeClass('hp-disabled');
                	$(UNSUPPORTED_BROWSER).html('<h2></h2><div class=\"hp-notify hp-notify-warning hp-active\" style=\"background-color:#fffdd7\"><p><b>'+ localizer.getString('hpsum.common.unsupportedBrowserVersion') +'</b></p></div>')                	
                } else if (screen.width < 1024 || screen.height < 768) {
                    $(UNSUPPORTED_BROWSER).removeClass('hp-disabled');
                    $(UNSUPPORTED_BROWSER).html('<h2></h2><div class=\"hp-notify hp-notify-warning hp-active\" style=\"background-color:#fffdd7\"><p><b>'+ localizer.getString('hpsum.common.minimumResolutionWarning') +'</b></p></div>')
                }
                
                //update logged in user name and logged in time in the user session pane
                updateUserSessionDetails();
                addDefaultBaseline();
                             
                //find out if already nodes exists for the session.
                NodePresenter.getAllNodes({
                    			success : function(data) {
                              var localhostfound = false;
                              for( var i = 0 ; i < data.hapi.output_data.nodes.node.length ; i++)
                              {
                                  if(data.hapi.output_data.nodes.node[i].node_id  === "N1localhost")
                                  {
                                     localhostfound = true;
                                     break;
                                  }
                              }
                        			if(!localhostfound)
                        				 addLocalHost();
                    		 	},
                    			error : function(errorInfo) {
                        			//localhost failed to add
                    			}
                });
                
                this.resume();  
            };
        }

        return WelcomeView;
    }());   
    return new WelcomeView();
});
