﻿//Wizard functionality for HPSUM One Touch Update
//Initial version
var showWizardScreen = function (settings) {
    var steps = settings.ctrls;
    var count = steps.size();
    var initStep = settings.initStep;
    if (initStep == null || initStep == false) {
        initStep = 0;
    }
    var arrPos = [];
    steps.each(function (i) {
        $(this).attr("id", "step" + i);
        $(this).wrapInner('<div class="wizardContent" />');
        $(this).append("<br>");
        $(this).append("<p id='step" + i + "commands'></p>");
        
        if (i == 0) {
            createNextButton(i, $(this).attr("title"));
            createAbortButton(i);
            createResetButton(i);
            $("#step" + i).hide();                  
        }
        else if (i == count - 1) {
            $("#step" + i).hide();
            //createPrevButton(i);
            createResetButton(i);
            createAbortButton(i);
			createFinishButton(i);
		}
        else {
             if (i > initStep)
            createPrevButton(i);
			$("#step" + i).hide();
			//createAnalyzeButton(i);
            createNextButton(i, $(this).attr("title"));
            createResetButton(i);
        }
    });
    //To start with a particular step
    $("#step" + initStep).fadeIn(2500);

    function createNextButton(i, title) {

        var stepName = "step" + i;
        if(i == 1)
        	$("#" + stepName + "commands").append("<a id='" + stepName + "Next' class='" + settings.nextButtonCss + "' style='margin:5px'>"+ settings.deployButtonTitle + "</a>");
        else
	    	$("#" + stepName + "commands").append("<a id='" + stepName + "Next' class='" + settings.nextButtonCss + "' style='margin:5px'>" + settings.nextButtonTitle + "</a>");
	    	
	    	//$("#" + stepName + "commands").append("<input id='" + stepName + "Next' class='" + settings.nextButtonCss + "' type='button' value='" + settings.nextButtonTitle + "'>");
	    	
        $("#" + stepName + "Next").bind("click", function (e) {
        	
        	if($("#" + stepName + "Next").hasClass("hp-disabled"))
	        {
	            e.preventDefault();
	            return;    
	        }        

            if (title == undefined || (title != undefined && settings.validateWizardByTitle(title))) {
                if (settings.validateWizardStep(i)) {
                    var nextStep = settings.callBack(i);
                    if(nextStep == -1 || nextStep == 0)
                    	return;
                    	
                    $("#" + stepName).hide();
                    if (nextStep == null || nextStep == false) {
                        $("#step" + (i + 1)).fadeIn(2500);  //Default is next li will be displayed on Next Click
                    }
                    else {
                        $("#step" + nextStep).fadeIn(2500); //Jump Wizard to go to particular index
                    }
                    arrPos.push(i);
                    //$("#step" + (i + 1)).slideDown(1500);
                }
            }
        });

    }

    function createPrevButton(i) {
        var stepName = "step" + i;
        
        if(i==2)
            $("#" + stepName + "commands").append("<a id='" + stepName + "Prev' class='" + settings.previousButtonCss + "' style='margin:5px'>" + settings.resetButtonTitle + "</a>");
        else
        	$("#" + stepName + "commands").append("<a id='" + stepName + "Prev' class='" + settings.previousButtonCss + "' style='margin:5px'>" + settings.previousButtonTitle + "</a>");
        
        $("#" + stepName + "Prev").bind("click", function (e) {
			var nextStep = settings.callBackPrev(i);
            $("#" + stepName).hide();
            //$("#step" + (i - 1)).show();
            if(i==2 && nextStep == 0)
            {
            	arrPos.pop();
            	$("#step" + arrPos.pop()).show();
            }
            else
            {
            	$("#step" + arrPos.pop()).show();
            }
            //selectStep(i - 1);
        });
    }

    function createFinishButton(i) {

        var stepName = "step" + i;
        //$("#" + stepName + "commands").append("<a id='" + stepName + "Next' class='" + settings.nextButtonCss + "'> Finish </a>");
        $("#" + stepName + "commands").append("<a id='" + stepName + "Reboot" + "' class='" + settings.finishButtonCss + "' style='margin:5px'>" + settings.finishButtonTitle  + "</a>");
        
        //by default reboot button is disabled for now as REST call is not yet implemented in engine        
        $("#" + stepName + "Reboot").addClass("hp-button hp-secondary hp-disabled");
                
        $("#" + stepName + "Reboot").bind("click", function (e) {
        	
        	var nextStep = settings.callFinish(i);
        });
    }
    
    function createAbortButton(i) {

        var stepName = "step" + i;
        
        $("#" + stepName + "commands").append("<a id='" + stepName + "Abort' class='" + settings.abortButtonCss + "' style='margin:5px'>" + settings.abortButtonTitle + "</a>");

		//by default abort button is disabled for now as REST call is not yet implemented in engine        
        //$("#" + stepName + settings.abortButtonTitle).addClass("hp-button hp-secondary hp-disabled");
        	    	
        $("#" + stepName + settings.abortButtonTitle).bind("click", function (e) {
            
        	if($("#" + stepName + settings.abortButtonTitle).hasClass("hp-disabled"))
	        {
	            e.preventDefault();
	            return;    
	        }
        	//call abort callback function
        	settings.callAbort(i);
        });

    }
    
    function createResetButton(i) {
        var stepName = "step" + i;
        
        $("#" + stepName + "commands").append("<a id='" + stepName + "Reset' class='" + settings.resetButtonCss + "' style='margin:5px'>" + settings.resetButtonTitle + "</a>");
        
        $("#" + stepName + "Reset").bind("click", function (e) {
			var nextStep = settings.callReset(i);
        });
    }
    
    function createAnalyzeButton(i) {
        var stepName = "step" + i;
        
        $("#" + stepName + "commands").append("<a id='" + stepName + settings.analyzeButtonTitle + "' class='" + settings.analyzeButtonCss + "' style='margin:5px'>" + settings.analyzeButtonTitle + "</a>");
        
        $("#" + stepName + settings.analyzeButtonTitle).bind("click", function (e) {

           if($("#" + stepName + settings.analyzeButtonTitle).hasClass("hp-disabled"))
            {
                e.preventDefault();
                return;    
            }
            
			var nextStep = settings.callAnalyze(i);
        });
    }
    
    //steps.show();
}
var wizSettings = function () {
    return { ctrls: null, nextButtonTitle: 'Go >', nextButtonCss: 'next', previousButtonTitle: 'Back', callBack: null, validateWizardStep: true, validateWizardByTitle: true, initStep: false };
}
