#!/bin/bash
#######################################
# Migration tool script 
# HP Smart Update Manager
######################################

OS=$(`echo uname` | tr '[a-z]' '[A-Z]')
ARCH=$(`echo uname -m` | tr '[a-z]' '[A-Z]')

HPUX=`uname | grep "HP-UX"`

delay ()
{
   echo "Pausing  for $1 seconds"
   sleep $1
}


if [ ! -z "${HPUX}" ]; then
    echo "Migration tool is not supported on HPUX"
elif [ "$OS" == "LINUX" ]; then
	if [ "$ARCH" == "X86_64" ]; then
            if [ -a ./x64/hpsum_migration_x64 ]; then
                ./x64/hpsum_migration_x64
            else
                echo "Could not find migration tool at : x64/hpsum_migration_x64"
                delay 10
                exit 1
            fi
    else 
	    if [ -a  ./x86/hpsum_bin_x86 ]; then
	         ./x86/hpsum_migration_x86
	    else
	        echo "Could not find migration tool at : x86/hpsum_bin_x86"
	        delay 10
  	        exit 1
	    fi
    fi
else
	echo "HPSUM migration is not supported on $OS"
fi

delay 10
exit 0
