# ": mkhpspec.pl,v 1.6 2010/04/22 22:03:26 jtkirshe Exp  
Name:		hp-igb
Version:	5.3.5.42
Release:	1
Group:		System/Kernel
Vendor:		Intel Corporation
URL:		http://support.intel.com/support/go/igb.htm
Packager:	Hewlett-Packard Company
License:	GPL
Source0:	%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-build
Summary:	HP NC Series Intel igb Driver for Linux

%define debug_package %{nil}

%if "%{_host_vendor}" == "suse"
%if %{!?KVER:1}%{?KVER:0}
%ifarch x86_64
%define flav default smp kdump xen
%else
%define flav default smp bigsmp pae kdump xen xenpae
%endif
%endif

%if %{!?KVER:0}%{?KVER:1}
%define flav %(echo %{KVER} | awk -F"-" '{print $3}')
%endif
%endif

%if "%{_host_vendor}" == "redhat"
%if %{!?KVER:1}%{?KVER:0}
%define flav ""
%endif
%if %{!?KVER:0}%{?KVER:1}
%define flav %(echo %{KVER} | awk -F"el5" '{print $2}')
%if "%{flav}" == ""
%define flav default
%endif
%endif
%endif

%if "%{_host_vendor}" == "suse"
BuildRequires: kernel-source kernel-syms
%define install_mod_dir updates
%define kernel_source /usr/src/linux-obj/%{_target_cpu}
%{suse_kernel_module_package -x %flav}
%else
BuildRequires: %kernel_module_package_buildreqs
%define install_mod_dir extra/%{name}
%{kernel_module_package %flav}
%endif

%description
Intel(R) Gigabit Ethernet Linux Driver for HP ProLiant systems

%package KMP
Summary: HP NC Series Intel igb Driver for Linux
Group: System/Kernel

%description KMP
Intel(R) Gigabit Ethernet Linux Driver for HP ProLiant systems

%package doc
Summary: Documentation for the %{name} kernel module
Group: System/Kernel
%if "%{_host_vendor}" == "redhat"
Requires: %{name}-kmod = %{version}-%{release}
%else
Requires: %{name}-kmp
%endif

%description doc
Documentation for the HP NC Series Intel igb Driver for Linux

%prep
%setup
set -- *
mkdir source
mv "$@" source/
mkdir obj

%build
export EXTRA_CFLAGS='-DVERSION="%version"'

%if %{!?KVER:0}%{?KVER:1}
%define flavors %{flav}
%else
%define flavors %{flavors_to_build}
%endif

for flavor in %{flavors}; do
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	make -C $PWD/obj/$flavor/src KSRC=%{kernel_source $flavor}
done
gzip < source/igb.7 > source/igb.7.gz

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=%install_mod_dir

%if %{!?KVER:0}%{?KVER:1}
%define flavors %{flav}
%else
%define flavors %{flavors_to_build}
%endif

for flavor in %{flavors}; do
	make -C $PWD/obj/$flavor/src KSRC=%{kernel_source $flavor} install
done
install -D -m 644 source/igb.7.gz $RPM_BUILD_ROOT/%{_mandir}/man7/igb.7.gz
install -D -m 644 source/igb.conf $RPM_BUILD_ROOT/etc/depmod.d/igb.conf

%postun doc
if [ -f %{_mandir}/man7/igb.7.gz ]; then
	exit 0
fi

%clean
rm -rf %{buildroot}

%files doc
%defattr(-, root, root)
%{_mandir}/man7/igb.7.gz
/etc/depmod.d/igb.conf
%doc source/COPYING source/README

%changelog
* Tue Oct 6 2009 - Intel Corporatino <linuxnics@mailbox.intel.com>>%{version}-%{release}
- Initial package

